/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteProcessUtil;
import com.intellij.util.PathMapper;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCommandLineStateUtil {
    private static final String PY_STUFF_TO_RUN = "PY_STUFF_TO_RUN";

    private PyCommandLineStateUtil() {
    }

    public static void remap(@NotNull PyRemoteSdkCredentials data, @NotNull GeneralCommandLine commandLine, @NotNull PathMapper pathMapper) {
        if (data == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(2);
        }
        PyCommandLineStateUtil.remap(data.getInterpreterPath(), commandLine, pathMapper);
    }

    public static void remap(@NotNull String interpreterPath, @NotNull GeneralCommandLine commandLine, @NotNull PathMapper pathMapper) {
        if (interpreterPath == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(3);
        }
        if (commandLine == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(4);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(5);
        }
        PyCommandLineStateUtil.remapParams(interpreterPath, commandLine, pathMapper);
        PyCommandLineStateUtil.remapEnvPaths(commandLine.getEnvironment(), pathMapper, interpreterPath, "PYTHONPATH");
        PyCommandLineStateUtil.remapEnvPaths(commandLine.getEnvironment(), pathMapper, interpreterPath, "IDE_PROJECT_ROOTS");
        PyCommandLineStateUtil.remapEnvStuffPaths(commandLine.getEnvironment(), pathMapper, interpreterPath, PY_STUFF_TO_RUN);
    }

    private static void remapParams(@NotNull String interpreterPath, @NotNull GeneralCommandLine commandLine, @NotNull PathMapper pathMapper) {
        if (interpreterPath == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(7);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(8);
        }
        ParamsGroup paramsGroup = commandLine.getParametersList().getParamsGroup("Script");
        PyCommandLineStateUtil.remapParameters(interpreterPath, pathMapper, paramsGroup, commandLine.getWorkDirectory());
    }

    public static void remapParameters(@NotNull String interpreterPath, @NotNull PathMapper pathMapper, @Nullable ParamsGroup paramsGroup, @Nullable File workDirectory) {
        if (interpreterPath == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(9);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(10);
        }
        if (paramsGroup != null) {
            if (paramsGroup.getParameters().size() > 0) {
                PyCommandLineStateUtil.makeParamAbsoluteIfRelative(paramsGroup, 0, workDirectory);
            }
            int i = 0;
            for (String param : paramsGroup.getParameters()) {
                if (pathMapper.canReplaceLocal(param)) {
                    paramsGroup.getParametersList().set(i, RemoteFile.detectSystemByPath((String)interpreterPath).createRemoteFile(pathMapper.convertToRemote(param)).getPath());
                }
                ++i;
            }
        }
    }

    private static void makeParamAbsoluteIfRelative(@NotNull ParamsGroup paramsGroup, int paramIndex, @Nullable File workDirectory) {
        File paramFile;
        String param;
        if (paramsGroup == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(11);
        }
        if (!new File(param = (String)paramsGroup.getParameters().get(paramIndex)).isAbsolute() && workDirectory != null && (paramFile = new File(workDirectory, param)).exists()) {
            paramsGroup.getParametersList().set(paramIndex, paramFile.getPath());
        }
    }

    private static void remapEnvPaths(@NotNull Map<String, String> env, @NotNull PathMapper pathMapper, @NotNull String interpreterPath, @NotNull String envKey) {
        if (env == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(12);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(13);
        }
        if (interpreterPath == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(14);
        }
        if (envKey == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(15);
        }
        if (env.isEmpty()) {
            return;
        }
        String envPaths = env.get(envKey);
        if (envPaths != null) {
            env.put(envKey, RemoteProcessUtil.remapPathsList((String)envPaths, (PathMapper)pathMapper, (String)interpreterPath));
        }
    }

    private static void remapEnvStuffPaths(@NotNull Map<String, String> env, @NotNull PathMapper pathMapper, @NotNull String interpreterPath, @NotNull String envKey) {
        String envPaths;
        if (env == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(16);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(17);
        }
        if (interpreterPath == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(18);
        }
        if (envKey == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(19);
        }
        if ((envPaths = env.get(envKey)) != null) {
            env.put(envKey, PyCommandLineStateUtil.remapStuffPathsList(envPaths, pathMapper, interpreterPath));
        }
    }

    @NotNull
    public static String remapStuffPathsList(@NotNull String pathsValue, @NotNull PathMapper pathMapper, @NotNull String interpreterPath) {
        if (pathsValue == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(20);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(21);
        }
        if (interpreterPath == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(22);
        }
        boolean isWin = RemoteFile.isWindowsPath((String)interpreterPath);
        ArrayList paths = Lists.newArrayList((Object[])pathsValue.split(Pattern.quote("|")));
        ArrayList<String> mappedPaths = new ArrayList<String>();
        for (String path : paths) {
            mappedPaths.add(new RemoteFile(pathMapper.convertToRemote(path), isWin).getPath());
        }
        String string = Joiner.on((char)'|').join(mappedPaths);
        if (string == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramsGroup";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envKey";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsValue";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyCommandLineStateUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyCommandLineStateUtil";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "remapStuffPathsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "remap";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remapParams";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "remapParameters";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "makeParamAbsoluteIfRelative";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "remapEnvPaths";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "remapEnvStuffPaths";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "remapStuffPathsList";
                break;
            }
            case 23: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

