/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010.\u001a\u00020*H\u0002J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0007H\u0016J\n\u00101\u001a\u0004\u0018\u000100H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0012\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u000e\u0010#\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0014\u0010'\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0012\u00a8\u00062"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddNewCondaEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/util/UserDataHolder;)V", "condaPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "defaultBaseDir", "getDefaultBaseDir", "()Ljava/lang/String;", "envName", "getEnvName", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "languageLevelsField", "Ljavax/swing/JComboBox;", "makeSharedField", "Lcom/intellij/ui/components/JBCheckBox;", "value", "getNewProjectPath", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "pathField", "projectBasePath", "Lorg/jetbrains/annotations/SystemIndependent;", "getProjectBasePath", "selectedLanguageLevel", "getSelectedLanguageLevel", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getOrCreateSdk", "updatePathField", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "validateAnacondaPath", "intellij.python.community.impl"})
public final class PyAddNewCondaEnvPanel
extends PyAddNewEnvPanel {
    @NotNull
    private final String envName = "Conda";
    @NotNull
    private final Icon icon;
    private final JComboBox<String> languageLevelsField;
    private final TextFieldWithBrowseButton condaPathField;
    private final TextFieldWithBrowseButton pathField;
    private final JBCheckBox makeSharedField;
    @Nullable
    private String newProjectPath;
    private final Project project;
    private final Module module;
    private final List<Sdk> existingSdks;

    @Override
    @NotNull
    public String getEnvName() {
        return this.envName;
    }

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.new.environment", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PyBundle.message(\"python\u2026el.name.new.environment\")");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String value) {
        this.newProjectPath = value;
        this.updatePathField();
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.listOfNotNull((Object[])new ValidationInfo[]{this.validateAnacondaPath(), PyAddSdkPanel.Companion.validateEnvironmentDirectoryLocation(this.pathField)});
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        String string = this.condaPathField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"condaPathField.text");
        String condaPath = string;
        Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>(this, condaPath, this.project, PyBundle.message("python.sdk.creating.conda.environment.title", new Object[0]), false){
            final /* synthetic */ PyAddNewCondaEnvPanel this$0;
            final /* synthetic */ String $condaPath;

            @NotNull
            protected String compute(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                String string = PyCondaPackageManagerImpl.createVirtualEnv(this.$condaPath, PyAddNewCondaEnvPanel.access$getPathField$p(this.this$0).getText(), PyAddNewCondaEnvPanel.access$getSelectedLanguageLevel$p(this.this$0));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PyCondaPackageManagerImp\u2026t, selectedLanguageLevel)");
                return string;
            }
            {
                this.this$0 = $outer;
                this.$condaPath = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        };
        boolean shared = this.makeSharedField.isSelected();
        String associatedPath = !shared ? this.getProjectBasePath() : null;
        Sdk sdk = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)((Task.WithResult)task2), this.existingSdks, null, associatedPath, null);
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        if (!shared) {
            PySdkExtKt.associateWithModule(sdk2, this.module, this.getNewProjectPath());
        }
        PyCondaPackageService.getInstance().PREFERRED_CONDA_PATH = condaPath;
        return sdk2;
    }

    @Override
    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        DocumentAdapter documentListener2 = new DocumentAdapter(listener2){
            final /* synthetic */ Runnable $listener;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.run();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        };
        JTextField jTextField = this.pathField.getTextField();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"pathField.textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)documentListener2);
        JTextField jTextField2 = this.condaPathField.getTextField();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField2, (String)"condaPathField.textField");
        jTextField2.getDocument().addDocumentListener((DocumentListener)documentListener2);
    }

    private final void updatePathField() {
        String string;
        String baseDir;
        String string2 = this.getDefaultBaseDir();
        if (string2 == null) {
            string2 = baseDir = SystemProperties.getUserHome() + "/.conda/envs";
        }
        if ((string = this.getProjectBasePath()) == null) {
            string = "untitled";
        }
        String string3 = PathUtil.getFileName((String)string);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PathUtil.getFileName(pro\u2026ctBasePath ?: \"untitled\")");
        String dirName = string3;
        this.pathField.setText(FileUtil.toSystemDependentName((String)(baseDir + '/' + dirName)));
    }

    private final ValidationInfo validateAnacondaPath() {
        String string;
        String string2 = this.condaPathField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"condaPathField.text");
        String text2 = string2;
        File file = new File(text2);
        if (StringUtil.isEmptyOrSpaces((String)text2)) {
            string = "Conda executable path is empty";
        } else if (!file.exists()) {
            string = "Conda executable not found";
        } else if (!file.isFile() || !file.canExecute()) {
            string = "Conda executable path is not an executable file";
        } else {
            return null;
        }
        String message = string;
        return new ValidationInfo(message);
    }

    private final String getDefaultBaseDir() {
        String string = this.condaPathField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"condaPathField.text");
        String conda = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(conda);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026ath(conda) ?: return null");
        VirtualFile condaFile = virtualFile;
        VirtualFile virtualFile2 = condaFile.getParent();
        return virtualFile2 != null && (virtualFile2 = virtualFile2.getParent()) != null && (virtualFile2 = virtualFile2.findChild("envs")) != null ? virtualFile2.getPath() : null;
    }

    private final String getProjectBasePath() {
        String string;
        String string2 = this.getNewProjectPath();
        if (string2 == null) {
            Module module = this.module;
            string2 = string = module != null ? BasePySdkExtKt.getBasePath(module) : null;
        }
        if (string2 == null) {
            Project project = this.project;
            string = project != null ? project.getBasePath() : null;
        }
        return string;
    }

    private final String getSelectedLanguageLevel() {
        String string = this.languageLevelsField.getItemAt(this.languageLevelsField.getSelectedIndex());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"languageLevelsField.getI\u2026evelsField.selectedIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public PyAddNewCondaEnvPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, @NotNull UserDataHolder context) {
        Object[] objectArray;
        ComboBox $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Object object;
        String path;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks;
        this.envName = "Conda";
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Anaconda");
        this.icon = icon;
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        Object object2 = this;
        boolean bl = false;
        boolean bl2 = false;
        Object $this$apply = textFieldWithBrowseButton;
        boolean bl3 = false;
        String string = PyCondaPackageService.getInstance().PREFERRED_CONDA_PATH;
        if (string == null) {
            string = PyCondaPackageService.getSystemCondaExecutable();
        }
        String string2 = path = string;
        if (string2 != null) {
            Iterator iterator = string2;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = iterator;
            boolean bl6 = false;
            $this$apply.setText(it);
        }
        $this$apply.addBrowseFolderListener(PyBundle.message("python.sdk.select.conda.path.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor());
        JTextField jTextField = $this$apply.getTextField();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){
            final /* synthetic */ PyAddNewCondaEnvPanel this$0;
            {
                this.this$0 = pyAddNewCondaEnvPanel;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                PyAddNewCondaEnvPanel.access$updatePathField(this.this$0);
            }
        });
        ((PyAddNewCondaEnvPanel)object2).condaPathField = object = textFieldWithBrowseButton;
        textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        object2 = this;
        bl = false;
        bl2 = false;
        $this$apply = textFieldWithBrowseButton;
        boolean bl7 = false;
        $this$apply.addBrowseFolderListener(PyBundle.message("python.sdk.select.location.for.conda.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        ((PyAddNewCondaEnvPanel)object2).pathField = object = textFieldWithBrowseButton;
        this.makeSharedField = new JBCheckBox(PyBundle.message("available.to.all.projects", new Object[0]));
        this.newProjectPath = newProjectPath;
        this.setLayout(new BorderLayout());
        List<LanguageLevel> list = LanguageLevel.SUPPORTED_LEVELS;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"LanguageLevel.SUPPORTED_LEVELS");
        Iterable $this$filter$iv = CollectionsKt.asReversedMutable(list);
        boolean $i$f$filter = false;
        $this$apply = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LanguageLevel it = (LanguageLevel)((Object)element$iv$iv);
            boolean bl8 = false;
            if (!(it != LanguageLevel.PYTHON39)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LanguageLevel it = (LanguageLevel)((Object)item$iv$iv);
            object2 = destination$iv$iv;
            boolean bl9 = false;
            object = it.toString();
            object2.add(object);
        }
        List supportedLanguageLevels = (List)destination$iv$iv;
        $this$map$iv = supportedLanguageLevels;
        object2 = this;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray2 = thisCollection$iv.toArray(new String[0]);
        if (objectArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray3 = objectArray = objectArray2;
        $this$toTypedArray$iv = new ComboBox(objectArray3);
        bl2 = false;
        boolean bl10 = false;
        ComboBox $this$apply2 = $this$toTypedArray$iv;
        boolean bl11 = false;
        $this$apply2.setSelectedItem($this$apply2.getItemCount() > 0 ? (String)$this$apply2.getItemAt(0) : null);
        object = $this$toTypedArray$iv;
        ((PyAddNewCondaEnvPanel)object2).languageLevelsField = (JComboBox)object;
        if (PyCondaSdkCustomizer.Companion.getInstance().getSharedEnvironmentsByDefault()) {
            this.makeSharedField.setSelected(true);
        }
        this.updatePathField();
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent(PyBundle.message("sdk.create.venv.conda.dialog.label.location", new Object[0]), (JComponent)this.pathField).addLabeledComponent(PyBundle.message("sdk.create.venv.conda.dialog.label.python.version", new Object[0]), (JComponent)this.languageLevelsField).addLabeledComponent(PyBundle.message("python.sdk.conda.path", new Object[0]), (JComponent)this.condaPathField).addComponent((JComponent)this.makeSharedField);
        Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026omponent(makeSharedField)");
        JPanel formPanel = formBuilder.getPanel();
        this.add((Component)formPanel, "North");
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getPathField$p(PyAddNewCondaEnvPanel $this) {
        return $this.pathField;
    }

    public static final /* synthetic */ String access$getSelectedLanguageLevel$p(PyAddNewCondaEnvPanel $this) {
        return $this.getSelectedLanguageLevel();
    }

    public static final /* synthetic */ void access$updatePathField(PyAddNewCondaEnvPanel $this) {
        $this.updatePathField();
    }
}

