/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.packaging.IndicatedProcessOutputListener;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.flavors.CondaEnvironmentsList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007H\u0002\u001a\u001e\u0010\u000e\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a\u001c\u0010\u000e\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a\u001c\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a\"\u0010\u0011\u001a\u00020\u0012*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0002\u00a8\u0006\u0013"}, d2={"findCondaExecutable", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "listCondaEnvironments", "", "readCondaEnv", "", "condaExecutable", "run", "Lcom/intellij/execution/process/ProcessOutput;", "executable", "arguments", "env", "runConda", "runCondaPython", "condaPythonExecutable", "checkExitCode", "", "intellij.python.sdk"})
public final class PyCondaRunKt {
    @NotNull
    public static final ProcessOutput runConda(@NotNull String condaExecutable, @NotNull List<String> arguments) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)condaExecutable, (String)"condaExecutable");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        return PyCondaRunKt.run(condaExecutable, arguments, PyCondaRunKt.readCondaEnv(condaExecutable));
    }

    @NotNull
    public static final ProcessOutput runConda(@Nullable Sdk sdk, @NotNull List<String> arguments) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        String condaExecutable = PyCondaRunKt.findCondaExecutable(sdk);
        Map<String, String> environment = sdk != null ? PySdkUtil.activateVirtualEnv(sdk) : PyCondaRunKt.readCondaEnv(condaExecutable);
        return PyCondaRunKt.run(condaExecutable, arguments, environment);
    }

    @NotNull
    public static final ProcessOutput runCondaPython(@NotNull String condaPythonExecutable, @NotNull List<String> arguments) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)condaPythonExecutable, (String)"condaPythonExecutable");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        return PyCondaRunKt.run(condaPythonExecutable, arguments, PySdkUtil.activateVirtualEnv(condaPythonExecutable));
    }

    private static final ProcessOutput run(String executable, List<String> arguments, Map<String, String> env) {
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{executable}).withParameters(arguments).withEnvironment(env);
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"GeneralCommandLine(execu\u2026nts).withEnvironment(env)");
        GeneralCommandLine commandLine = generalCommandLine;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(commandLine);
        boolean bl = false;
        boolean bl2 = false;
        CapturingProcessHandler $this$apply = capturingProcessHandler;
        boolean bl3 = false;
        $this$apply.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(indicator));
        CapturingProcessHandler handler = capturingProcessHandler;
        capturingProcessHandler = handler.runProcessWithProgressIndicator(indicator);
        bl = false;
        bl2 = false;
        $this$apply = capturingProcessHandler;
        boolean bl4 = false;
        if ($this$apply.isCancelled()) {
            throw (Throwable)new RunCanceledByUserException();
        }
        PyCondaRunKt.checkExitCode((ProcessOutput)$this$apply, executable, arguments);
        CapturingProcessHandler capturingProcessHandler2 = capturingProcessHandler;
        Intrinsics.checkExpressionValueIsNotNull((Object)capturingProcessHandler2, (String)"handler.runProcessWithPr\u2026xecutable, arguments)\n  }");
        return capturingProcessHandler2;
    }

    private static final Map<String, String> readCondaEnv(String condaExecutable) {
        Map<String, String> map2;
        String string = PyCondaPackageService.getCondaBasePython(condaExecutable);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            map2 = PySdkUtil.activateVirtualEnv(it);
        } else {
            map2 = null;
        }
        return map2;
    }

    private static final String findCondaExecutable(Sdk sdk) throws ExecutionException {
        Sdk sdk2 = sdk;
        String string = PyCondaPackageService.getCondaExecutable(sdk2 != null ? sdk2.getHomePath() : null);
        if (string == null) {
            throw (Throwable)new ExecutionException("Cannot find conda executable");
        }
        return string;
    }

    private static final void checkExitCode(@NotNull ProcessOutput $this$checkExitCode, String executable, List<String> arguments) throws PyExecutionException {
        if ($this$checkExitCode.getExitCode() != 0) {
            String message = StringUtil.isEmptyOrSpaces((String)$this$checkExitCode.getStdout()) && StringUtil.isEmptyOrSpaces((String)$this$checkExitCode.getStderr()) ? "Permission denied" : "Non-zero exit code";
            throw (Throwable)((Object)new PyExecutionException(message, executable, arguments, $this$checkExitCode));
        }
    }

    @NotNull
    public static final List<String> listCondaEnvironments(@Nullable Sdk sdk) throws ExecutionException, JsonSyntaxException {
        ProcessOutput output = PyCondaRunKt.runConda(sdk, (List<String>)CollectionsKt.listOf((Object[])new String[]{"env", "list", "--json"}));
        String string = output.getStdout();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.stdout");
        String text2 = string;
        CondaEnvironmentsList envList = (CondaEnvironmentsList)new Gson().fromJson(text2, CondaEnvironmentsList.class);
        return envList.getEnvs();
    }
}

