/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript.schemaGenerators;

import com.intellij.configurationScript.IntellijConfigurationJsonSchemaProviderFactoryKt;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a&\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\\\u0010\r\u001a\u00020\u000e2Q\u0010\u000f\u001aM\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0002\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u0013\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u000e0\u0010H\u0080\b\u001aq\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u0016\u001a\u00020\u00032K\u0010\u000f\u001aG\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0082\b\u00a2\u0006\u0002\u0010\u0019\u001a\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0006H\u0000\u00a8\u0006\u001c"}, d2={"generateTypeDefinitionId", "", "propertyName", "", "getTypeDescription", "type", "Lcom/intellij/execution/configurations/ConfigurationType;", "typePropertyName", "idToPropertyName", "string", "configurationType", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "processConfigurationTypes", "", "processor", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "", "factories", "processFactories", "typeDefinitionId", "factoryPropertyName", "factoryDefinitionId", "([Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function3;)V", "rcFactoryIdToPropertyName", "rcTypeIdToPropertyName", "intellij.configurationScript"})
public final class RunConfigurationJsonSchemaGeneratorKt {
    public static final void processConfigurationTypes(@NotNull Function3<? super ConfigurationType, ? super CharSequence, ? super ConfigurationFactory[], Unit> processor) {
        int $i$f$processConfigurationTypes = 0;
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        ExtensionPointName extensionPointName = ConfigurationType.CONFIGURATION_TYPE_EP;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ConfigurationType.CONFIGURATION_TYPE_EP");
        Iterator iterator = extensionPointName.getExtensionList().iterator();
        while (iterator.hasNext()) {
            CharSequence propertyName;
            ConfigurationType type;
            ConfigurationType configurationType = type = (ConfigurationType)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationType, (String)"type");
            if (RunConfigurationJsonSchemaGeneratorKt.rcTypeIdToPropertyName(configurationType) == null) {
                continue;
            }
            ConfigurationFactory[] factories = type.getConfigurationFactories();
            Intrinsics.checkExpressionValueIsNotNull((Object)factories, (String)"factories");
            ConfigurationFactory[] configurationFactoryArray = factories;
            boolean bl = false;
            if (configurationFactoryArray.length == 0) {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration type \"" + type.getDisplayName() + "\" is not valid: factory list is empty");
                continue;
            }
            processor.invoke((Object)type, (Object)propertyName, (Object)factories);
        }
    }

    private static final void processFactories(ConfigurationFactory[] factories, CharSequence typeDefinitionId, Function3<? super CharSequence, ? super CharSequence, ? super ConfigurationFactory, Unit> processor) {
        int $i$f$processFactories = 0;
        for (ConfigurationFactory factory : factories) {
            CharSequence factoryPropertyName;
            if (RunConfigurationJsonSchemaGeneratorKt.rcFactoryIdToPropertyName(factory) == null) {
                continue;
            }
            String factoryDefinitionId = typeDefinitionId + '-' + factoryPropertyName + "Factory";
            processor.invoke((Object)factoryPropertyName, (Object)factoryDefinitionId, (Object)factory);
        }
    }

    @Nullable
    public static final CharSequence rcTypeIdToPropertyName(@NotNull ConfigurationType configurationType) {
        Intrinsics.checkParameterIsNotNull((Object)configurationType, (String)"configurationType");
        String string = configurationType.getTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configurationType.tag");
        CharSequence charSequence = RunConfigurationJsonSchemaGeneratorKt.idToPropertyName(string, configurationType, null);
        if (charSequence == null) {
            return null;
        }
        CharSequence result = charSequence;
        if (StringUtil.equals((CharSequence)result, (CharSequence)"templates")) {
            IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration type \"" + configurationType.getDisplayName() + "\" has forbidden id");
        }
        return result;
    }

    @Nullable
    public static final CharSequence rcFactoryIdToPropertyName(@NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        String string = factory.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"factory.id");
        return RunConfigurationJsonSchemaGeneratorKt.idToPropertyName(string, null, factory);
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence idToPropertyName(String string, ConfigurationType configurationType, ConfigurationFactory factory) {
        char c;
        char c2;
        StringBuilder stringBuilder;
        char ch22;
        if (Intrinsics.areEqual((Object)string, (Object)"JetRunConfigurationType")) {
            return "kotlin";
        }
        String result = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)"Type"), (CharSequence)"RunConfiguration"), (CharSequence)"Configuration");
        CharSequence charSequence = result;
        boolean bl = false;
        if (charSequence.length() == 0) {
            if (factory == null) {
                Logger logger = IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG();
                StringBuilder stringBuilder2 = new StringBuilder().append("Configuration type \"");
                ConfigurationType configurationType2 = configurationType;
                if (configurationType2 == null) {
                    Intrinsics.throwNpe();
                }
                logger.error(stringBuilder2.append(configurationType2.getDisplayName()).append("\" is not valid: id is empty").toString());
            } else {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration factory \"" + factory.getName() + "\" is not valid: id is empty");
            }
            return null;
        }
        StringBuilder builder = null;
        int i = 0;
        boolean isAllUpperCased = true;
        while (i < result.length()) {
            char c3;
            ch22 = result.charAt(i);
            if (ch22 == '.' || ch22 == ' ' || ch22 == '-' || ch22 == '_') {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(result, 0, i);
                }
                if (++i == result.length()) break;
                c3 = result.charAt(i);
                stringBuilder = builder;
                c2 = '\u0000';
                c = Character.toUpperCase(c3);
                stringBuilder.append(c);
                ++i;
                continue;
            }
            if (ch22 == '#') {
                ++i;
                continue;
            }
            if (ch22 == '\"' || ch22 == '\'' || ch22 == '\n' || ch22 == '\r' || ch22 == '\t' || ch22 == '\b' || ch22 == '/' || ch22 == '\\') {
                if (factory == null) {
                    Logger logger = IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG();
                    StringBuilder stringBuilder3 = new StringBuilder().append("Configuration type \"");
                    ConfigurationType configurationType3 = configurationType;
                    if (configurationType3 == null) {
                        Intrinsics.throwNpe();
                    }
                    logger.error(stringBuilder3.append(configurationType3.getId()).append("\" is not valid: contains invalid symbol \"").append(ch22).append('\"').toString());
                } else {
                    IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration factory \"" + factory.getName() + "\" is not valid: contains invalid symbol \"" + ch22 + '\"');
                }
                return null;
            }
            if (i == 0) {
                c3 = ch22;
                c2 = '\u0000';
                if (Character.isUpperCase(c3)) {
                    if (builder == null) {
                        builder = new StringBuilder();
                        builder.append(result, 0, i);
                    }
                    c3 = ch22;
                    stringBuilder = builder;
                    c2 = '\u0000';
                    c = Character.toLowerCase(c3);
                    stringBuilder.append(c);
                } else {
                    isAllUpperCased = false;
                }
            } else if (builder != null) {
                builder.append(ch22);
            }
            c3 = ch22;
            c2 = '\u0000';
            if (!Character.isUpperCase(c3)) {
                isAllUpperCased = false;
            }
            ++i;
        }
        if (isAllUpperCased) {
            if (builder == null) {
                String ch22 = result;
                boolean bl2 = false;
                String string2 = ch22;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                return string3;
            }
            ch22 = '\u0000';
            int n = ((CharSequence)builder).length();
            while (ch22 < n) {
                void i2;
                c2 = builder.charAt((int)i2);
                c = i2++;
                stringBuilder = builder;
                boolean bl3 = false;
                char c3 = Character.toLowerCase(c2);
                stringBuilder.setCharAt(c, c3);
            }
            return builder;
        }
        StringBuilder stringBuilder4 = builder;
        return stringBuilder4 != null ? (CharSequence)stringBuilder4 : (CharSequence)result;
    }

    private static final String generateTypeDefinitionId(CharSequence propertyName) {
        char c = propertyName.charAt(0);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        char c2 = Character.toUpperCase(c);
        CharSequence charSequence = propertyName;
        n = 1;
        stringBuilder = stringBuilder.append(c2);
        int n2 = charSequence.length();
        boolean bl = false;
        String string = ((Object)charSequence.subSequence(n, n2)).toString();
        return stringBuilder.append(string).append("Type").toString();
    }

    private static final String getTypeDescription(ConfigurationType type, CharSequence typePropertyName) {
        String description = type.getConfigurationTypeDescription();
        return StringUtil.equals((CharSequence)typePropertyName, (CharSequence)description) ? null : description;
    }

    public static final /* synthetic */ String access$generateTypeDefinitionId(CharSequence propertyName) {
        return RunConfigurationJsonSchemaGeneratorKt.generateTypeDefinitionId(propertyName);
    }

    public static final /* synthetic */ String access$getTypeDescription(ConfigurationType type, CharSequence typePropertyName) {
        return RunConfigurationJsonSchemaGeneratorKt.getTypeDescription(type, typePropertyName);
    }

    public static final /* synthetic */ void access$processFactories(ConfigurationFactory[] factories, CharSequence typeDefinitionId, Function3 processor) {
        RunConfigurationJsonSchemaGeneratorKt.processFactories(factories, typeDefinitionId, (Function3<? super CharSequence, ? super CharSequence, ? super ConfigurationFactory, Unit>)processor);
    }
}

