/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.bundles.BundleFactory;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.preferences.TextMateTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTextAttributesAdapter;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.plist.CompositePlistReader;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;

public class TextMateServiceImpl
extends TextMateService {
    private boolean ourBuiltinBundlesDisabled;
    private final AtomicBoolean myInitialized = new AtomicBoolean(false);
    private final THashMap<CharSequence, TextMateTextAttributesAdapter> myCustomHighlightingColors = new THashMap();
    private final THashMap<String, CharSequence> myExtensionsMapping = new THashMap();
    private final PlistReader myPlistReader = new CompositePlistReader();
    private final BundleFactory myBundleFactory = new BundleFactory(this.myPlistReader);
    private final TextMateSyntaxTable mySyntaxTable = new TextMateSyntaxTable();
    private final SnippetsRegistry mySnippetsRegistry = new SnippetsRegistry();
    private final PreferencesRegistry myPreferencesRegistry = new PreferencesRegistry();
    private final ShellVariablesRegistry myShellVariablesRegistry = new ShellVariablesRegistry();
    @NonNls
    public static final String PREINSTALLED_BUNDLES_PATH = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{PathManager.getCommunityHomePath(), "plugins", "textmate", "lib", "bundles"}));
    @NonNls
    public static final String INSTALLED_BUNDLES_PATH = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{PathManager.getPluginsPath(), "textmate", "lib", "bundles"}));
    private final Interner<CharSequence> myInterner = Interner.createWeakInterner();

    public TextMateServiceImpl() {
        Application application = ApplicationManager.getApplication();
        Runnable checkCancelled = application != null && !application.isUnitTestMode() ? ProgressManager::checkCanceled : null;
        SyntaxMatchUtils.setCheckCancelledCallback((Runnable)checkCancelled);
    }

    @Override
    public void reloadEnabledBundles() {
        this.registerBundles(true);
    }

    private void registerBundles(boolean fireEvents) {
        THashMap oldExtensionsMapping = this.myExtensionsMapping.clone();
        this.unregisterAllBundles();
        TextMateSettings settings = TextMateSettings.getInstance();
        if (settings == null) {
            return;
        }
        if (!this.ourBuiltinBundlesDisabled) {
            TextMateServiceImpl.loadBuiltinBundles(settings);
        }
        THashMap newExtensionsMapping = new THashMap();
        for (BundleConfigBean bundleConfigBean : settings.getBundles()) {
            boolean result;
            if (!bundleConfigBean.isEnabled() || (result = this.registerBundle(LocalFileSystem.getInstance().findFileByPath(bundleConfigBean.getPath()), (THashMap<String, CharSequence>)newExtensionsMapping))) continue;
            Notifications.Bus.notify((Notification)new Notification("TextMate Bundles", TextMateBundle.message("textmate.bundle.load.error", new Object[0]), TextMateBundle.message("textmate.cant.register.bundle", bundleConfigBean.getName()), NotificationType.ERROR, null));
        }
        if (!oldExtensionsMapping.equals((Object)newExtensionsMapping)) {
            Runnable update = () -> {
                this.myExtensionsMapping.clear();
                this.myExtensionsMapping.putAll((Map)newExtensionsMapping);
                this.myExtensionsMapping.trimToSize();
            };
            if (fireEvents) {
                TextMateServiceImpl.fireFileTypesChangedEvent(update);
            } else {
                update.run();
            }
        }
        this.mySyntaxTable.compact();
        this.myCustomHighlightingColors.trimToSize();
    }

    private static void fireFileTypesChangedEvent(@NotNull Runnable update) {
        if (update == null) {
            TextMateServiceImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
            fileTypeManager.fireBeforeFileTypesChanged();
            update.run();
            fileTypeManager.fireFileTypesChanged();
        }), ModalityState.NON_MODAL);
    }

    private static void loadBuiltinBundles(TextMateSettings settings) {
        File[] files;
        File bundles = new File(INSTALLED_BUNDLES_PATH);
        if (!bundles.exists() || !bundles.isDirectory()) {
            bundles = new File(PREINSTALLED_BUNDLES_PATH);
        }
        if ((files = bundles.listFiles()) == null) {
            LOG.warn("Missing builtin bundles, checked: \n" + INSTALLED_BUNDLES_PATH + "\n" + PREINSTALLED_BUNDLES_PATH);
            return;
        }
        TextMateSettings.TextMateSettingsState state = settings.getState();
        state = state == null ? new TextMateSettings.TextMateSettingsState() : state;
        ArrayList<BundleConfigBean> newBundles = new ArrayList<BundleConfigBean>(state.getBundles());
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            String path = FileUtil.toSystemIndependentName((String)file.getPath());
            BundleConfigBean existing = (BundleConfigBean)ContainerUtil.find(state.getBundles(), bundle -> bundle.getPath().equals(path));
            if (existing != null) continue;
            newBundles.add(new BundleConfigBean(file.getName(), path, true));
        }
        state.setBundles(newBundles);
        settings.loadState(state);
    }

    private void unregisterAllBundles() {
        this.myExtensionsMapping.clear();
        this.myPreferencesRegistry.clear();
        this.myCustomHighlightingColors.clear();
        this.mySyntaxTable.clear();
        this.mySnippetsRegistry.clear();
        this.myShellVariablesRegistry.clear();
    }

    @Override
    @NotNull
    public Map<CharSequence, TextMateTextAttributesAdapter> getCustomHighlightingColors() {
        this.ensureInitialized();
        THashMap<CharSequence, TextMateTextAttributesAdapter> tHashMap = this.myCustomHighlightingColors;
        if (tHashMap == null) {
            TextMateServiceImpl.$$$reportNull$$$0(1);
        }
        return tHashMap;
    }

    @Override
    @Nullable
    public TextMateShellVariable getVariable(@NotNull String name, @NotNull EditorEx editor) {
        if (name == null) {
            TextMateServiceImpl.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            TextMateServiceImpl.$$$reportNull$$$0(3);
        }
        this.ensureInitialized();
        return this.myShellVariablesRegistry.getVariableValue(name, TextMateEditorUtils.getCurrentScopeSelector(editor));
    }

    @Override
    @NotNull
    public SnippetsRegistry getSnippetsRegistry() {
        this.ensureInitialized();
        SnippetsRegistry snippetsRegistry = this.mySnippetsRegistry;
        if (snippetsRegistry == null) {
            TextMateServiceImpl.$$$reportNull$$$0(4);
        }
        return snippetsRegistry;
    }

    @Override
    @NotNull
    public PreferencesRegistry getPreferencesRegistry() {
        this.ensureInitialized();
        PreferencesRegistry preferencesRegistry = this.myPreferencesRegistry;
        if (preferencesRegistry == null) {
            TextMateServiceImpl.$$$reportNull$$$0(5);
        }
        return preferencesRegistry;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            TextMateServiceImpl.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((CharSequence)fileName)) {
            return null;
        }
        this.ensureInitialized();
        Ref result = Ref.create();
        TextMateEditorUtils.processExtensions(fileName, (Processor<? super CharSequence>)((Processor)extension -> {
            result.set((Object)this.getLanguageDescriptorByExtension((CharSequence)extension));
            return result.isNull();
        }));
        return (TextMateLanguageDescriptor)result.get();
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByExtension(@Nullable CharSequence extension) {
        if (StringUtil.isEmpty((CharSequence)extension)) {
            return null;
        }
        this.ensureInitialized();
        CharSequence scopeName = (CharSequence)this.myExtensionsMapping.get((Object)extension.toString());
        return !StringUtil.isEmpty((CharSequence)scopeName) ? new TextMateLanguageDescriptor(scopeName, this.mySyntaxTable.getSyntax(scopeName)) : null;
    }

    @Override
    @Nullable
    public Bundle createBundle(@Nullable VirtualFile directory) {
        String path;
        if (directory != null && directory.isInLocalFileSystem() && (path = directory.getCanonicalPath()) != null) {
            try {
                return this.myBundleFactory.fromDirectory(new File(path));
            }
            catch (IOException e) {
                LOG.debug("Couldn't load bundle from " + path, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private void ensureInitialized() {
        if (this.myInitialized.compareAndSet(false, true)) {
            this.registerBundles(false);
        }
    }

    private boolean registerBundle(@Nullable VirtualFile directory, @NotNull THashMap<String, CharSequence> extensionsMapping) {
        Bundle bundle;
        if (extensionsMapping == null) {
            TextMateServiceImpl.$$$reportNull$$$0(7);
        }
        if ((bundle = this.createBundle(directory)) != null) {
            this.registerLanguageSupport(bundle, extensionsMapping);
            this.registerPreferences(bundle);
            this.registerSnippets(bundle);
            return true;
        }
        return false;
    }

    private void registerSnippets(@NotNull Bundle bundle) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(8);
        }
        for (File snippetFile : bundle.getSnippetFiles()) {
            try {
                TextMateSnippet snippet = PreferencesReadUtil.loadSnippet((File)snippetFile, (Plist)this.myPlistReader.read(snippetFile), this.myInterner);
                if (snippet == null) continue;
                this.mySnippetsRegistry.register(snippet);
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + snippetFile.getPath());
            }
        }
    }

    private void registerPreferences(@NotNull Bundle bundle) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(9);
        }
        for (File preferenceFile : bundle.getPreferenceFiles()) {
            try {
                for (Map.Entry settingsPair : bundle.loadPreferenceFile(preferenceFile, this.myPlistReader)) {
                    if (settingsPair == null) continue;
                    CharSequence scopeName = (CharSequence)this.myInterner.intern((Object)((CharSequence)settingsPair.getKey()));
                    this.myPreferencesRegistry.fillFromPList(scopeName, (Plist)settingsPair.getValue());
                    this.myShellVariablesRegistry.fillVariablesFromPlist(scopeName, (Plist)settingsPair.getValue());
                    this.readCustomHighlightingColors(scopeName, (Plist)settingsPair.getValue());
                }
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + preferenceFile.getPath());
            }
        }
    }

    private void readCustomHighlightingColors(@NotNull CharSequence scopeName, @NotNull Plist preferencesPList) {
        TextMateTextAttributes textAttributes;
        if (scopeName == null) {
            TextMateServiceImpl.$$$reportNull$$$0(10);
        }
        if (preferencesPList == null) {
            TextMateServiceImpl.$$$reportNull$$$0(11);
        }
        if ((textAttributes = TextMateTextAttributes.fromPlist((Plist)preferencesPList)) != null) {
            this.myCustomHighlightingColors.put((Object)scopeName, (Object)new TextMateTextAttributesAdapter(scopeName, textAttributes));
        }
    }

    private void registerLanguageSupport(@NotNull Bundle bundle, @NotNull THashMap<String, CharSequence> extensionsMapping) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(12);
        }
        if (extensionsMapping == null) {
            TextMateServiceImpl.$$$reportNull$$$0(13);
        }
        for (File grammarFile : bundle.getGrammarFiles()) {
            try {
                Plist plist = this.myPlistReader.read(grammarFile);
                CharSequence rootScopeName = this.mySyntaxTable.loadSyntax(plist, this.myInterner);
                Collection extensions = bundle.getExtensions(grammarFile, plist);
                for (String extension : extensions) {
                    extensionsMapping.put((Object)extension, (Object)rootScopeName);
                }
            }
            catch (IOException e) {
                LOG.warn("Can't load textmate language file: " + grammarFile.getPath());
            }
        }
    }

    public void disableBuiltinBundles(Disposable disposable) {
        this.ourBuiltinBundlesDisabled = true;
        TextMateService.getInstance().reloadEnabledBundles();
        this.myInitialized.set(true);
        Disposer.register((Disposable)disposable, () -> {
            this.ourBuiltinBundlesDisabled = false;
            this.unregisterAllBundles();
            this.myInitialized.set(false);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/TextMateServiceImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsMapping";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferencesPList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/TextMateServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomHighlightingColors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnippetsRegistry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferencesRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fireFileTypesChangedEvent";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDescriptorByFileName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerBundle";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerSnippets";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerPreferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readCustomHighlightingColors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerLanguageSupport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

