/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.create;

import com.intellij.application.options.CodeStyle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.util.List;
import org.editorconfig.configmanagement.create.CreateEditorConfigDialog;
import org.editorconfig.configmanagement.export.EditorConfigSettingsWriter;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateEditorConfigAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(CreateEditorConfigAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        CreateEditorConfigDialog dialog;
        Project project;
        if (e == null) {
            CreateEditorConfigAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) != null && (dialog = new CreateEditorConfigDialog(project)).showAndGet() && (view = this.getIdeView(e)) != null) {
            CodeStyleSettings settings = CodeStyle.getSettings((Project)project);
            PsiDirectory dir = view.getOrChooseDirectory();
            if (dir != null) {
                VirtualFile dirVFile = dir.getVirtualFile();
                File outputFile = CreateEditorConfigAction.getOutputFile(dirVFile);
                if (!outputFile.exists()) {
                    VirtualFile target = (VirtualFile)ApplicationManager.getApplication().runWriteAction(() -> this.export(dirVFile, outputFile, project, settings, dialog.isRoot(), dialog.isCommentProperties(), dialog.getLanguages(), dialog.getPropertyKinds()));
                    if (target != null) {
                        OpenFileAction.openFile((VirtualFile)target, (Project)project);
                        PsiFile psiFile = CreateEditorConfigAction.getPsiFile(project, target);
                        if (psiFile != null) {
                            view.selectElement((PsiElement)psiFile);
                        }
                    }
                } else {
                    Messages.showErrorDialog((Project)project, (String)EditorConfigBundle.message("notification.message.another.editorconfig.file.already.exists.in.0", dirVFile.getPath()), (String)EditorConfigBundle.message("dialog.title.new.editorconfig.file"));
                }
            }
        }
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile file) {
        Document document;
        if (project == null) {
            CreateEditorConfigAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CreateEditorConfigAction.$$$reportNull$$$0(2);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(file)) != null) {
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateEditorConfigAction.$$$reportNull$$$0(3);
        }
        Presentation presentation = e.getPresentation();
        if (PlatformUtils.isRider()) {
            presentation.setVisible(false);
            return;
        }
        IdeView view = this.getIdeView(e);
        if (view != null) {
            presentation.setVisible(CreateEditorConfigAction.isAvailableFor(view.getDirectories()));
        }
        presentation.setIcon(AllIcons.Nodes.Editorconfig);
    }

    private static boolean isAvailableFor(PsiDirectory @NotNull [] dirs) {
        if (dirs == null) {
            CreateEditorConfigAction.$$$reportNull$$$0(4);
        }
        for (PsiDirectory dir : dirs) {
            if (!dir.getVirtualFile().getFileSystem().isReadOnly()) continue;
            return false;
        }
        return dirs.length > 0;
    }

    public boolean isDumbAware() {
        return true;
    }

    @Nullable
    protected IdeView getIdeView(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateEditorConfigAction.$$$reportNull$$$0(5);
        }
        return (IdeView)e.getData(LangDataKeys.IDE_VIEW);
    }

    @NotNull
    private static File getOutputFile(@NotNull VirtualFile dir) {
        if (dir == null) {
            CreateEditorConfigAction.$$$reportNull$$$0(6);
        }
        return new File(dir.getPath() + File.separator + ".editorconfig");
    }

    @Nullable
    private VirtualFile export(@NotNull VirtualFile outputDir, @NotNull File outputFile, @NotNull Project project, @NotNull CodeStyleSettings settings, boolean isRoot, boolean commentOutProperties, @NotNull List<Language> languages, EditorConfigPropertyKind ... propertyKinds) {
        VirtualFile virtualFile;
        block14: {
            if (outputDir == null) {
                CreateEditorConfigAction.$$$reportNull$$$0(7);
            }
            if (outputFile == null) {
                CreateEditorConfigAction.$$$reportNull$$$0(8);
            }
            if (project == null) {
                CreateEditorConfigAction.$$$reportNull$$$0(9);
            }
            if (settings == null) {
                CreateEditorConfigAction.$$$reportNull$$$0(10);
            }
            if (languages == null) {
                CreateEditorConfigAction.$$$reportNull$$$0(11);
            }
            if (propertyKinds == null) {
                CreateEditorConfigAction.$$$reportNull$$$0(12);
            }
            VirtualFile target = outputDir.createChildData((Object)this, outputFile.getName());
            EditorConfigSettingsWriter settingsWriter = new EditorConfigSettingsWriter(project, target.getOutputStream((Object)this), settings, isRoot, commentOutProperties).forLanguages(languages).forPropertyKinds(propertyKinds);
            try {
                settingsWriter.writeSettings();
                virtualFile = target;
                if (settingsWriter == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (settingsWriter != null) {
                        try {
                            settingsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    CreateEditorConfigAction.notifyFailed(e);
                    return null;
                }
            }
            settingsWriter.close();
        }
        return virtualFile;
    }

    private static void notifyFailed(@NotNull Exception e) {
        if (e == null) {
            CreateEditorConfigAction.$$$reportNull$$$0(13);
        }
        LOG.warn((Throwable)e);
        Notifications.Bus.notify((Notification)new Notification("editorconfig", EditorConfigBundle.message("notification.title.editorconfig.creation.failed"), e.getMessage(), NotificationType.ERROR));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKinds";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/create/CreateEditorConfigAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdeView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getOutputFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "export";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyFailed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

