/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import dk.brics.automaton.Automaton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.core.EditorConfigAutomatonBuilder;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPattern;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0086\u0004\u001a\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0004\u001a\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0004\u001a\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0086\u0004\u001a\u0015\u0010\f\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0004\u001a\u0015\u0010\f\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0004\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isEquivalentTo", "", "Lorg/editorconfig/language/psi/EditorConfigHeader;", "other", "isSubcaseOf", "general", "Lorg/editorconfig/language/psi/EditorConfigPattern;", "generalAutomaton", "Ldk/brics/automaton/Automaton;", "matches", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "string", "", "intellij.editorconfig"})
public final class EditorConfigGlobUtilsKt {
    private static final Logger Log;

    public static final boolean isSubcaseOf(@NotNull EditorConfigHeader $this$isSubcaseOf, @NotNull EditorConfigHeader general) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isSubcaseOf, (String)"$this$isSubcaseOf");
        Intrinsics.checkParameterIsNotNull((Object)general, (String)"general");
        if (!$this$isSubcaseOf.isValidGlob()) {
            return false;
        }
        if (!general.isValidGlob()) {
            return false;
        }
        Automaton subcaseAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton($this$isSubcaseOf);
        Automaton generalAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(general);
        return subcaseAutomaton.subsetOf(generalAutomaton);
    }

    public static final boolean isEquivalentTo(@NotNull EditorConfigHeader $this$isEquivalentTo, @NotNull EditorConfigHeader other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isEquivalentTo, (String)"$this$isEquivalentTo");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (!$this$isEquivalentTo.getHeader().isValidGlob()) {
            return false;
        }
        if (!other.getHeader().isValidGlob()) {
            return false;
        }
        Automaton thisAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton($this$isEquivalentTo);
        Automaton otherAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(other);
        return Intrinsics.areEqual((Object)thisAutomaton, (Object)otherAutomaton);
    }

    public static final boolean isSubcaseOf(@NotNull EditorConfigPattern $this$isSubcaseOf, @NotNull EditorConfigPattern general) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isSubcaseOf, (String)"$this$isSubcaseOf");
        Intrinsics.checkParameterIsNotNull((Object)general, (String)"general");
        if (!general.getHeader().isValidGlob()) {
            return false;
        }
        Automaton generalAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedPatternAutomaton(general);
        return EditorConfigGlobUtilsKt.isSubcaseOf($this$isSubcaseOf, generalAutomaton);
    }

    public static final boolean isSubcaseOf(@NotNull EditorConfigPattern $this$isSubcaseOf, @NotNull Automaton generalAutomaton) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isSubcaseOf, (String)"$this$isSubcaseOf");
        Intrinsics.checkParameterIsNotNull((Object)generalAutomaton, (String)"generalAutomaton");
        if (!$this$isSubcaseOf.getHeader().isValidGlob()) {
            return false;
        }
        Automaton subcaseAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedPatternAutomaton($this$isSubcaseOf);
        return subcaseAutomaton.subsetOf(generalAutomaton);
    }

    public static final boolean matches(@NotNull EditorConfigHeader $this$matches, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)$this$matches, (String)"$this$matches");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Log.assertTrue($this$matches.getHeader().isValidGlob());
        EditorConfigHeader editorConfigHeader = $this$matches.getSection().getHeader();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorConfigHeader, (String)"section.header");
        return EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderRunAutomaton(editorConfigHeader).run(string);
    }

    public static final boolean matches(@NotNull EditorConfigHeader $this$matches, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)$this$matches, (String)"$this$matches");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Log.assertTrue($this$matches.getHeader().isValidGlob());
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        return EditorConfigGlobUtilsKt.matches($this$matches, string);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConfigHeader.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        Log = logger;
    }
}

