/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShowDiffAction
extends AbstractVcsAction {
    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        if (vcsContext == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(1);
        }
        AbstractShowDiffAction.updateDiffAction(presentation, vcsContext);
    }

    protected static void updateDiffAction(@NotNull Presentation presentation, @NotNull VcsContext vcsContext) {
        if (presentation == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(2);
        }
        if (vcsContext == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(3);
        }
        presentation.setEnabled(AbstractShowDiffAction.isEnabled(vcsContext, true));
        presentation.setVisible(AbstractShowDiffAction.isVisible(vcsContext));
    }

    protected static boolean isVisible(@NotNull VcsContext vcsContext) {
        Project project;
        if (vcsContext == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(4);
        }
        return (project = vcsContext.getProject()) != null && AbstractShowDiffAction.hasDiffProviders(project);
    }

    private static boolean hasDiffProviders(@NotNull Project project) {
        if (project == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(5);
        }
        return Stream.of(ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss()).map(AbstractVcs::getDiffProvider).anyMatch(Objects::nonNull);
    }

    protected static boolean isEnabled(@NotNull VcsContext vcsContext, boolean disableIfRunning) {
        Project project;
        if (vcsContext == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(6);
        }
        if ((project = vcsContext.getProject()) == null) {
            return false;
        }
        if (!AbstractShowDiffAction.isVisible(vcsContext)) {
            return false;
        }
        VirtualFile file = (VirtualFile)UtilKt.getIfSingle((Stream)vcsContext.getSelectedFilesStream());
        if (file == null || file.isDirectory()) {
            return false;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        if (disableIfRunning && BackgroundableActionLock.isLocked(project, new Object[]{VcsBackgroundableActions.COMPARE_WITH, filePath})) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project);
        if (vcs == null || vcs.getDiffProvider() == null) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)filePath);
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        if (vcsContext == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(7);
        }
        Project project = Objects.requireNonNull(vcsContext.getProject());
        String actionName = StringUtil.removeEllipsisSuffix((String)UIUtil.removeMnemonic((String)vcsContext.getActionName()));
        if (!ChangeListManager.getInstance((Project)project).isFreezedWithNotification(VcsBundle.message((String)"error.cant.perform.operation.now", (Object[])new Object[]{actionName}))) {
            VirtualFile file = vcsContext.getSelectedFiles()[0];
            AbstractVcs vcs = Objects.requireNonNull(ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project));
            DiffProvider provider = Objects.requireNonNull(vcs.getDiffProvider());
            Editor editor = vcsContext.getEditor();
            this.getExecutor(provider, file, project, editor).showDiff();
        }
    }

    @NotNull
    protected abstract DiffActionExecutor getExecutor(@NotNull DiffProvider var1, @NotNull VirtualFile var2, @NotNull Project var3, @Nullable Editor var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/AbstractShowDiffAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDiffAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDiffProviders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

