/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vcs.changes.FictiveBackgroundable;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.Waiter;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CallbackData {
    private static final Logger LOG = Logger.getInstance(CallbackData.class);
    @NotNull
    private final Runnable myCallback;
    @NotNull
    private final Runnable myWrapperStarter;

    CallbackData(@NotNull Runnable callback2, @NotNull Runnable wrapperStarter) {
        if (callback2 == null) {
            CallbackData.$$$reportNull$$$0(0);
        }
        if (wrapperStarter == null) {
            CallbackData.$$$reportNull$$$0(1);
        }
        this.myCallback = callback2;
        this.myWrapperStarter = wrapperStarter;
    }

    @NotNull
    public Runnable getCallback() {
        Runnable runnable = this.myCallback;
        if (runnable == null) {
            CallbackData.$$$reportNull$$$0(2);
        }
        return runnable;
    }

    @NotNull
    public Runnable getWrapperStarter() {
        Runnable runnable = this.myWrapperStarter;
        if (runnable == null) {
            CallbackData.$$$reportNull$$$0(3);
        }
        return runnable;
    }

    @NotNull
    public static CallbackData create(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, @Nullable String title2, @Nullable ModalityState state) {
        if (project == null) {
            CallbackData.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            CallbackData.$$$reportNull$$$0(5);
        }
        if (afterUpdate == null) {
            CallbackData.$$$reportNull$$$0(6);
        }
        return mode.isSilent() ? CallbackData.createSilent(project, mode, afterUpdate) : CallbackData.createInteractive(project, mode, afterUpdate, title2, state);
    }

    @NotNull
    private static CallbackData createSilent(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate) {
        if (project == null) {
            CallbackData.$$$reportNull$$$0(7);
        }
        if (mode == null) {
            CallbackData.$$$reportNull$$$0(8);
        }
        if (afterUpdate == null) {
            CallbackData.$$$reportNull$$$0(9);
        }
        Consumer<Runnable> callbackCaller = mode.isCallbackOnAwt() ? arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0) : arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
        Runnable callback2 = () -> {
            CallbackData.logUpdateFinished(project, mode);
            if (!project.isDisposed()) {
                afterUpdate.run();
            }
        };
        return new CallbackData(() -> callbackCaller.accept(callback2), EmptyRunnable.INSTANCE);
    }

    @NotNull
    private static CallbackData createInteractive(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, String title2, @Nullable ModalityState state) {
        if (project == null) {
            CallbackData.$$$reportNull$$$0(10);
        }
        if (mode == null) {
            CallbackData.$$$reportNull$$$0(11);
        }
        if (afterUpdate == null) {
            CallbackData.$$$reportNull$$$0(12);
        }
        Object task2 = mode.isSynchronous() ? new Waiter(project, afterUpdate, title2, mode.isCancellable()) : new FictiveBackgroundable(project, afterUpdate, title2, mode.isCancellable(), state);
        Runnable callback2 = () -> CallbackData.lambda$createInteractive$2(project, mode, (Task)task2);
        return new CallbackData(callback2, () -> CallbackData.lambda$createInteractive$3((Task)task2));
    }

    private static void setDone(@NotNull Task task2) {
        if (task2 == null) {
            CallbackData.$$$reportNull$$$0(13);
        }
        if (task2 instanceof Waiter) {
            ((Waiter)task2).done();
        } else if (task2 instanceof FictiveBackgroundable) {
            ((FictiveBackgroundable)task2).done();
        } else {
            throw new IllegalArgumentException("Unknown task type " + task2.getClass());
        }
    }

    private static void logUpdateFinished(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode) {
        if (project == null) {
            CallbackData.$$$reportNull$$$0(14);
        }
        if (mode == null) {
            CallbackData.$$$reportNull$$$0(15);
        }
        LOG.debug(mode + " changes update finished for project " + project.getName());
    }

    private static /* synthetic */ void lambda$createInteractive$3(Task task2) {
        ProgressManager.getInstance().run(task2);
    }

    private static /* synthetic */ void lambda$createInteractive$2(Project project, InvokeAfterUpdateMode mode, Task task2) {
        CallbackData.logUpdateFinished(project, mode);
        CallbackData.setDone(task2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapperStarter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/CallbackData";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterUpdate";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/CallbackData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallback";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperStarter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSilent";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createInteractive";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDone";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "logUpdateFinished";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

