/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInputStream;
import org.jetbrains.annotations.NotNull;

public class ByteArraySequence
implements ByteSequence {
    private final byte[] myBytes;
    private final int myOffset;
    private final int myLen;

    public ByteArraySequence(byte @NotNull [] bytes) {
        if (bytes == null) {
            ByteArraySequence.$$$reportNull$$$0(0);
        }
        this(bytes, 0, bytes.length);
    }

    public ByteArraySequence(byte @NotNull [] bytes, int offset, int len) {
        if (bytes == null) {
            ByteArraySequence.$$$reportNull$$$0(1);
        }
        this.myBytes = bytes;
        this.myOffset = offset;
        this.myLen = len;
        if (offset < 0 || offset > bytes.length || offset + len > bytes.length || len < 0) {
            throw new IllegalArgumentException("Offset is out of range: " + offset + "; bytes.length: " + bytes.length + "; len: " + len);
        }
    }

    public byte @NotNull [] getBytes() {
        if (this.myBytes == null) {
            ByteArraySequence.$$$reportNull$$$0(2);
        }
        return this.myBytes;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLength() {
        return this.myLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArraySequence sequence = (ByteArraySequence)o;
        int len = this.myLen;
        if (len != sequence.myLen) {
            return false;
        }
        byte[] thisBytes = this.myBytes;
        byte[] thatBytes = sequence.myBytes;
        int i = 0;
        int j = this.myOffset;
        int k = sequence.myOffset;
        while (i < len) {
            if (thisBytes[j] != thatBytes[k]) {
                return false;
            }
            ++i;
            ++j;
            ++k;
        }
        return true;
    }

    public int hashCode() {
        int len = this.myLen;
        byte[] thisBytes = this.myBytes;
        int result = 1;
        int i = 0;
        int j = this.myOffset;
        while (i < len) {
            result = result * 31 + thisBytes[j];
            ++i;
            ++j;
        }
        return result;
    }

    @Override
    public int length() {
        return this.getLength();
    }

    @Override
    public byte byteAt(int index) {
        return this.myBytes[this.myOffset + index];
    }

    @Override
    @NotNull
    public ByteSequence subSequence(int start, int end) {
        return new ByteArraySequence(this.myBytes, this.myOffset + start, end - start);
    }

    @Override
    public byte @NotNull [] toBytes() {
        byte[] bytes = new byte[this.length()];
        System.arraycopy(this.myBytes, this.myOffset, bytes, 0, this.length());
        if (bytes == null) {
            ByteArraySequence.$$$reportNull$$$0(3);
        }
        return bytes;
    }

    @NotNull
    public DataInputStream toInputStream() {
        return new DataInputStream(new UnsyncByteArrayInputStream(this.myBytes, this.myOffset, this.length()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/ByteArraySequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/ByteArraySequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

