/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import gnu.trove.TIntFunction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.locks.StampedLock;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class ConcurrentBitSet {
    private static final Unsafe UNSAFE = AtomicFieldUpdater.getUnsafe();
    private static final int base = UNSAFE.arrayBaseOffset(int[].class);
    private static final int shift;
    private volatile int[] array;
    private final StampedLock lock;
    private static final int ADDRESS_BITS_PER_WORD = 5;
    static final int BITS_PER_WORD = 32;
    private static final AtomicFieldUpdater<ConcurrentBitSet, int[]> ARRAY_UPDATER;

    public ConcurrentBitSet() {
        this.lock = new StampedLock();
        this.clear();
    }

    private static int arrayIndex(int bitIndex) {
        return bitIndex >> 5;
    }

    private static int wordMaskForIndex(int bitIndex) {
        return 1 << bitIndex;
    }

    public boolean flip(int bitIndex) {
        int wordMaskForIndex = ConcurrentBitSet.wordMaskForIndex(bitIndex);
        long prevWord = this.changeWord(bitIndex, word -> word ^ wordMaskForIndex);
        return (prevWord & (long)wordMaskForIndex) == 0L;
    }

    public boolean set(int bitIndex) {
        int mask = ConcurrentBitSet.wordMaskForIndex(bitIndex);
        long prevWord = this.changeWord(bitIndex, word -> word | mask);
        return (prevWord & (long)mask) != 0L;
    }

    private static long checkedByteOffset(int i, int[] array) {
        if (i < 0 || i >= array.length) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return ConcurrentBitSet.byteOffset(i);
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int changeWord(int bitIndex, @NotNull TIntFunction change) {
        if (change == null) {
            ConcurrentBitSet.$$$reportNull$$$0(0);
        }
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        long stamp = this.lock.writeLock();
        try {
            int newWord;
            int word;
            int i = ConcurrentBitSet.arrayIndex(bitIndex);
            int[] array = this.growArrayTo(i);
            long offset = ConcurrentBitSet.checkedByteOffset(i, array);
            while (!UNSAFE.compareAndSwapInt(array, offset, word = ConcurrentBitSet.getVolatile(array, i), newWord = change.execute(word))) {
            }
            int n = word;
            return n;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private static int getVolatile(int[] array, int i) {
        return UNSAFE.getIntVolatile(array, ConcurrentBitSet.checkedByteOffset(i, array));
    }

    private int[] growArrayTo(int arrayIndex) {
        int[] newArray;
        int[] array;
        do {
            if (arrayIndex >= (array = this.array).length) continue;
            return array;
        } while (!ARRAY_UPDATER.compareAndSet(this, array, newArray = ArrayUtil.realloc(array, Math.max(array.length * 2, arrayIndex + 1))));
        return newArray;
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public boolean clear(int bitIndex) {
        int wordMaskForIndex = ConcurrentBitSet.wordMaskForIndex(bitIndex);
        int prevWord = this.changeWord(bitIndex, word -> word & ~wordMaskForIndex);
        return (prevWord & wordMaskForIndex) != 0;
    }

    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.array = new int[32];
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public boolean get(int bitIndex) {
        return (this.getWord(bitIndex) & ConcurrentBitSet.wordMaskForIndex(bitIndex)) != 0;
    }

    int getWord(int bitIndex) {
        int word;
        long stamp;
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int arrayIndex = ConcurrentBitSet.arrayIndex(bitIndex);
        do {
            stamp = this.lock.tryOptimisticRead();
            int[] array = this.array;
            int n = word = arrayIndex < array.length ? ConcurrentBitSet.getVolatile(array, arrayIndex) : 0;
        } while (!this.lock.validate(stamp));
        return word;
    }

    public int nextSetBit(int fromIndex) {
        int result;
        long stamp;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + fromIndex);
        }
        int i = ConcurrentBitSet.arrayIndex(fromIndex);
        block0: do {
            int wordIndex;
            result = -1;
            stamp = this.lock.tryOptimisticRead();
            int[] array = this.array;
            if (i >= array.length) continue;
            int w = ConcurrentBitSet.getVolatile(array, i);
            int nextBitsInWord = w & -ConcurrentBitSet.wordMaskForIndex(fromIndex);
            if (nextBitsInWord != 0) {
                wordIndex = Integer.numberOfTrailingZeros(nextBitsInWord);
                result = i * 32 + wordIndex;
                continue;
            }
            ++i;
            while (i < array.length) {
                w = ConcurrentBitSet.getVolatile(array, i);
                if (w != 0) {
                    wordIndex = Integer.numberOfTrailingZeros(w);
                    result = i * 32 + wordIndex;
                    continue block0;
                }
                ++i;
            }
        } while (!this.lock.validate(stamp));
        return result;
    }

    public int nextClearBit(int fromIndex) {
        int result;
        long stamp;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int i = ConcurrentBitSet.arrayIndex(fromIndex);
        block0: do {
            int wordIndex;
            stamp = this.lock.tryOptimisticRead();
            int[] array = this.array;
            result = array.length * 32;
            if (i >= array.length) {
                result = fromIndex;
                continue;
            }
            int w = ~ConcurrentBitSet.getVolatile(array, i);
            int nextBitsInWord = w & -ConcurrentBitSet.wordMaskForIndex(fromIndex);
            if (nextBitsInWord != 0) {
                wordIndex = Integer.numberOfTrailingZeros(nextBitsInWord);
                result = i * 32 + wordIndex;
                continue;
            }
            ++i;
            while (i < array.length) {
                w = ~ConcurrentBitSet.getVolatile(array, i);
                if (w != 0) {
                    wordIndex = Integer.numberOfTrailingZeros(w);
                    result = i * 32 + wordIndex;
                    continue block0;
                }
                ++i;
            }
        } while (!this.lock.validate(stamp));
        return result;
    }

    public int size() {
        return this.array.length * 32;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        int i = this.nextSetBit(0);
        while (i >= 0) {
            int endOfRun = this.nextClearBit(i);
            if (endOfRun - i > 1) {
                if (b.length() != 1) {
                    b.append(", ");
                }
                b.append(i).append("...").append(endOfRun - 1);
                i = endOfRun;
            } else {
                do {
                    if (b.length() != 1) {
                        b.append(", ");
                    }
                    b.append(i);
                } while (++i < endOfRun);
            }
            i = this.nextSetBit(i + 1);
        }
        b.append('}');
        return b.toString();
    }

    public int @NotNull [] toIntArray() {
        int[] nArray = (int[])this.array.clone();
        if (nArray == null) {
            ConcurrentBitSet.$$$reportNull$$$0(1);
        }
        return nArray;
    }

    public void writeTo(@NotNull File file) throws IOException {
        if (file == null) {
            ConcurrentBitSet.$$$reportNull$$$0(2);
        }
        try (DataOutputStream bitSetStorage = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            int[] words;
            for (int word : words = this.toIntArray()) {
                bitSetStorage.writeInt(word);
            }
        }
    }

    @NotNull
    public static ConcurrentBitSet readFrom(@NotNull File file) throws IOException {
        if (file == null) {
            ConcurrentBitSet.$$$reportNull$$$0(3);
        }
        if (!file.exists()) {
            return new ConcurrentBitSet();
        }
        DataInputStream bitSetStorage = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        long length = file.length();
        int[] words = new int[(int)(length / 8L)];
        for (int i = 0; i < words.length; ++i) {
            words[i] = bitSetStorage.readInt();
        }
        ConcurrentBitSet concurrentBitSet = new ConcurrentBitSet(words);
        ConcurrentBitSet concurrentBitSet2 = concurrentBitSet;
        if (concurrentBitSet2 == null) {
            ConcurrentBitSet.$$$reportNull$$$0(4);
        }
        return concurrentBitSet2;
        finally {
            bitSetStorage.close();
        }
    }

    private ConcurrentBitSet(int @NotNull [] words) {
        if (words == null) {
            ConcurrentBitSet.$$$reportNull$$$0(5);
        }
        this.lock = new StampedLock();
        this.array = words;
    }

    static {
        int scale = UNSAFE.arrayIndexScale(int[].class);
        if (!BitUtil.isPowerOfTwo(scale)) {
            throw new Error("data type scale not a power of two, got: " + scale);
        }
        shift = 31 - Integer.numberOfLeadingZeros(scale);
        ARRAY_UPDATER = AtomicFieldUpdater.forFieldOfType(ConcurrentBitSet.class, int[].class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentBitSet";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentBitSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "changeWord";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

