/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    private static final boolean DEBUG_REGISTRATION = false;
    private final ComponentManager componentManager;
    private final Map<String, ExtensionPointImpl<?>> extensionPoints;
    private final Map<String, Throwable> epTraces;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(0);
        }
        this.extensionPoints = new ConcurrentHashMap();
        this.epTraces = null;
        this.componentManager = componentManager;
    }

    public final void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        HashSet<String> processedEPs = new HashSet<String>(this.extensionPoints.size());
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.getName());
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.extensionPoints.values()) {
            if (processedEPs.contains(point.getName())) continue;
            point.notifyAreaReplaced(this);
        }
    }

    public void registerExtensionPoints(@NotNull PluginDescriptor pluginDescriptor, @NotNull List<Element> extensionPointElements) {
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(1);
        }
        if (extensionPointElements == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(2);
        }
        for (Element element : extensionPointElements) {
            this.registerExtensionPoint(pluginDescriptor, element);
        }
    }

    private void registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionPointElement) {
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(3);
        }
        if (extensionPointElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(4);
        }
        String pointName = this.getExtensionPointName(extensionPointElement, pluginDescriptor);
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw this.componentManager.createError("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw this.componentManager.createError("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
        }
        boolean dynamic = Boolean.parseBoolean(extensionPointElement.getAttributeValue("dynamic"));
        String className = interfaceClassName == null ? beanClassName : interfaceClassName;
        this.doRegisterExtensionPoint(pointName, className, pluginDescriptor, interfaceClassName != null, dynamic);
    }

    @NotNull
    private String getExtensionPointName(@NotNull Element extensionPointElement, @NotNull PluginDescriptor pluginDescriptor) {
        String pointName;
        if (extensionPointElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(5);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(6);
        }
        if ((pointName = extensionPointElement.getAttributeValue("qualifiedName")) == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw this.componentManager.createError("'name' attribute not specified for extension point in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
            }
            assert (pluginDescriptor.getPluginId() != null);
            pointName = pluginDescriptor.getPluginId().getIdString() + '.' + name;
        }
        String string = pointName;
        if (string == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public void registerExtension(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement, String extensionNs) {
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(8);
        }
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(9);
        }
        String epName = ExtensionsAreaImpl.extractPointName(extensionElement, extensionNs);
        this.registerExtension(this.getExtensionPoint(epName), pluginDescriptor, extensionElement);
    }

    @Override
    public void registerExtension(@NotNull ExtensionPoint<?> extensionPoint, @NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement) {
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(10);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(11);
        }
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(12);
        }
        ((ExtensionPointImpl)extensionPoint).createAndRegisterAdapter(extensionElement, pluginDescriptor, this.componentManager);
    }

    public boolean unregisterExtensions(@NotNull String extensionPointName, @NotNull PluginDescriptor loadedPluginDescriptor, @NotNull List<Element> elements, @NotNull List<Runnable> priorityListenerCallbacks, @NotNull List<Runnable> listenerCallbacks) {
        ExtensionPointImpl<?> point;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(13);
        }
        if (loadedPluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(14);
        }
        if (elements == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(15);
        }
        if (priorityListenerCallbacks == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(16);
        }
        if (listenerCallbacks == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(17);
        }
        if ((point = this.extensionPoints.get(extensionPointName)) == null) {
            return false;
        }
        point.unregisterExtensions(this.componentManager, loadedPluginDescriptor, elements, priorityListenerCallbacks, listenerCallbacks);
        return true;
    }

    public void resetExtensionPoints(@NotNull List<ExtensionPointImpl<?>> rawExtensionPoints) {
        if (rawExtensionPoints == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(18);
        }
        for (ExtensionPointImpl<?> point : rawExtensionPoints) {
            ExtensionPointImpl<?> extensionPoint = this.extensionPoints.get(point.getName());
            if (extensionPoint == null) continue;
            extensionPoint.reset();
        }
    }

    public void clearUserCache() {
        this.extensionPoints.values().forEach(ExtensionPointImpl::clearUserCache);
    }

    public void unregisterExtensionPoints(@NotNull List<ExtensionPointImpl<?>> rawExtensionPoints) {
        if (rawExtensionPoints == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(19);
        }
        for (ExtensionPointImpl<?> point : rawExtensionPoints) {
            this.extensionPoints.remove(point.getName());
        }
    }

    @NotNull
    public static String extractPointName(@NotNull Element extensionElement, @Nullable String ns) {
        String epName;
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(20);
        }
        if ((epName = extensionElement.getAttributeValue("point")) == null) {
            if (ns == null) {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            } else {
                epName = ns + '.' + extensionElement.getName();
            }
        }
        String string = epName;
        if (string == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(22);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(23);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(24);
        }
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
    }

    public void registerExtensionPoint(@NotNull BaseExtensionPointName<?> extensionPoint, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, @NotNull Disposable parentDisposable) {
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(25);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(26);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(27);
        }
        if (parentDisposable == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(28);
        }
        String extensionPointName = extensionPoint.getName();
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
        Disposer.register((Disposable)parentDisposable, () -> this.unregisterExtensionPoint(extensionPointName));
    }

    void doRegisterExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(29);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(30);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(31);
        }
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("FakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, false);
    }

    public <T> ExtensionPointImpl<T> registerPoint(@NotNull String name, @NotNull Class<T> extensionClass, @NotNull PluginDescriptor pluginDescriptor) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(32);
        }
        if (extensionClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(33);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(34);
        }
        return this.doRegisterExtensionPoint(name, extensionClass.getName(), pluginDescriptor, extensionClass.isInterface() || (extensionClass.getModifiers() & 0x400) != 0, false);
    }

    @NotNull
    private <T> ExtensionPointImpl<T> doRegisterExtensionPoint(@NotNull String name, @NotNull String extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(35);
        }
        if (extensionClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(36);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(37);
        }
        ExtensionPointImpl point = isInterface ? new InterfaceExtensionPoint(name, extensionClass, pluginDescriptor, dynamic) : new BeanExtensionPoint(name, extensionClass, pluginDescriptor, dynamic);
        point.setComponentManager(this.componentManager);
        this.registerExtensionPoint(point);
        ExtensionPointImpl extensionPointImpl = point;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(38);
        }
        return extensionPointImpl;
    }

    public <T> ExtensionPointImpl<T> registerFakeBeanPoint(@NotNull String name, @NotNull PluginDescriptor pluginDescriptor) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(39);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(40);
        }
        return this.doRegisterExtensionPoint(name, Object.class.getName(), pluginDescriptor, false, false);
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(41);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(42);
        }
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        PluginId id1 = ((ExtensionPointImpl)this.getExtensionPoint(pointName)).getPluginDescriptor().getPluginId();
        PluginId id2 = pluginDescriptor.getPluginId();
        String message = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        throw this.componentManager.createError(message, pluginDescriptor.getPluginId());
    }

    private void registerExtensionPoint(@NotNull ExtensionPointImpl<?> point) {
        if (point == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(43);
        }
        String name = point.getName();
        this.checkThatPointNotDuplicated(name, point.getPluginDescriptor());
        this.extensionPoints.put(name, point);
    }

    @ApiStatus.Internal
    public void registerExtensionPoints(@NotNull List<? extends ExtensionPointImpl<?>> points, boolean clonePoint) {
        if (points == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(44);
        }
        ComponentManager componentManager = this.componentManager;
        Map<String, ExtensionPointImpl<?>> map = this.extensionPoints;
        for (ExtensionPointImpl<?> point : points) {
            ExtensionPointImpl<?> old;
            if (clonePoint) {
                point = point.cloneFor(componentManager);
            } else {
                point.setComponentManager(componentManager);
            }
            if ((old = map.put(point.getName(), point)) == null) continue;
            map.put(point.getName(), old);
            throw componentManager.createError("Duplicate registration for EP '" + point.getName() + "': first in " + old.getPluginDescriptor() + ", second in " + point.getPluginDescriptor(), point.getPluginDescriptor().getPluginId());
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl<?> extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(45);
        }
        if ((extensionPoint = this.extensionPoints.get(extensionPointName)) == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.componentManager);
        }
        ExtensionPointImpl<?> extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(46);
        }
        return extensionPointImpl;
    }

    public void registerExtensions(@NotNull Map<String, List<Element>> extensions, @NotNull PluginDescriptor pluginDescriptor, @Nullable List<Runnable> listenerCallbacks) {
        if (extensions == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(47);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(48);
        }
        extensions.forEach((name, list) -> {
            ExtensionPointImpl<?> point = this.extensionPoints.get(name);
            if (point != null) {
                point.registerExtensions((List<Element>)list, pluginDescriptor, this.componentManager, listenerCallbacks);
            }
        });
    }

    public boolean registerExtensions(@NotNull String pointName, @NotNull List<Element> extensions, @NotNull PluginDescriptor pluginDescriptor, @Nullable List<Runnable> listenerCallbacks) {
        ExtensionPointImpl<?> point;
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(49);
        }
        if (extensions == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(50);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(51);
        }
        if ((point = this.extensionPoints.get(pointName)) == null) {
            return false;
        }
        point.registerExtensions(extensions, pluginDescriptor, this.componentManager, listenerCallbacks);
        return true;
    }

    @Nullable
    public <T> ExtensionPointImpl<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(52);
        }
        return this.extensionPoints.get(extensionPointName);
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(53);
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(54);
        }
        return extensionPoint;
    }

    public void processExtensionPoints(@NotNull Consumer<ExtensionPointImpl<?>> consumer) {
        if (consumer == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(55);
        }
        this.extensionPoints.values().forEach(consumer);
    }

    @Override
    @NotNull
    public List<ExtensionPoint<?>> getExtensionPoints() {
        List<ExtensionPoint<?>> list = Collections.unmodifiableList(new ArrayList(this.extensionPoints.values()));
        if (list == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(56);
        }
        return list;
    }

    @ApiStatus.Internal
    @Nullable
    public <T> T findExtensionByClass(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(57);
        }
        if (aClass.getName().equals("com.intellij.execution.executors.DefaultDebugExecutor")) {
            return this.extensionPoints.get("com.intellij.executor").findExtension(aClass, false, ThreeState.YES);
        }
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            if (!(point instanceof InterfaceExtensionPoint)) continue;
            try {
                T extension;
                Class<T> extensionClass = point.getExtensionClass();
                if (!extensionClass.isAssignableFrom(aClass) || (extension = point.findExtension(aClass, false, ThreeState.YES)) == null) continue;
                return extension;
            }
            catch (Throwable e) {
                LOG.warn("error during findExtensionPointByClass", e);
            }
        }
        return null;
    }

    @Override
    public void unregisterExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl<?> extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(58);
        }
        if ((extensionPoint = this.extensionPoints.get(extensionPointName)) != null) {
            extensionPoint.reset();
            this.extensionPoints.remove(extensionPointName);
        }
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(59);
        }
        return this.extensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(60);
        }
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return this.componentManager.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 21: 
            case 38: 
            case 46: 
            case 54: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 21: 
            case 38: 
            case 46: 
            case 54: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElement";
                break;
            }
            case 7: 
            case 21: 
            case 38: 
            case 46: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 9: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 10: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 13: 
            case 22: 
            case 29: 
            case 45: 
            case 52: 
            case 53: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPluginDescriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityListenerCallbacks";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerCallbacks";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawExtensionPoints";
                break;
            }
            case 23: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointBeanClass";
                break;
            }
            case 24: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 32: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 41: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPointName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPointName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "doRegisterExtensionPoint";
                break;
            }
            case 46: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 3: 
            case 4: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointName";
                break;
            }
            case 7: 
            case 21: 
            case 38: 
            case 46: 
            case 54: 
            case 56: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resetExtensionPoints";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoints";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "extractPointName";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtensionPoint";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "registerPoint";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "registerFakeBeanPoint";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkThatPointNotDuplicated";
                break;
            }
            case 45: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPoint";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointIfRegistered";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "processExtensionPoints";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByClass";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoint";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "hasExtensionPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 21: 
            case 38: 
            case 46: 
            case 54: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

