/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupport;
import com.intellij.credentialStore.gpg.Pgp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/credentialStore/PgpKeyEncryptionSupport;", "Lcom/intellij/credentialStore/EncryptionSupport;", "encryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "(Lcom/intellij/credentialStore/EncryptionSpec;)V", "decrypt", "", "data", "encrypt", "intellij.platform.credentialStore"})
final class PgpKeyEncryptionSupport
implements EncryptionSupport {
    private final EncryptionSpec encryptionSpec;

    @Override
    @NotNull
    public byte[] encrypt(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Pgp pgp2 = new Pgp(null, 1, null);
        String string = this.encryptionSpec.getPgpKeyId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return pgp2.encrypt(data, string);
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return new Pgp(null, 1, null).decrypt(data);
    }

    public PgpKeyEncryptionSupport(@NotNull EncryptionSpec encryptionSpec) {
        Intrinsics.checkParameterIsNotNull((Object)encryptionSpec, (String)"encryptionSpec");
        this.encryptionSpec = encryptionSpec;
    }
}

