/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.util.Url;
import com.intellij.util.Urls;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;
import org.jetbrains.plugins.github.authentication.GHOAuthService;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthCallbackHandler;", "Lorg/jetbrains/ide/RestService;", "()V", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "isHostTrusted", "", "sendRedirect", "", "url", "Lcom/intellij/util/Url;", "Companion", "intellij.vcs.github"})
public final class GHOAuthCallbackHandler
extends RestService {
    private static final String SERVICE_NAME = "github/oauth";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected String getServiceName() {
        return SERVICE_NAME;
    }

    protected boolean isHostTrusted(@NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        return true;
    }

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!GHOAuthCallbackHandler.Companion.isAuthorizationCodeUrl(urlDecoder)) {
            return "Invalid Request";
        }
        String string = GHOAuthCallbackHandler.Companion.getAuthorizationCode(urlDecoder);
        if (string == null) {
            return "Invalid Request";
        }
        String code = string;
        boolean isCodeAccepted = GHOAuthService.Companion.getInstance().acceptCode(code);
        this.sendRedirect(request, context, isCodeAccepted ? GHOAuthService.Companion.getSUCCESS_URL() : GHOAuthService.Companion.getERROR_URL());
        return null;
    }

    private final void sendRedirect(FullHttpRequest request, ChannelHandlerContext context, Url url) {
        HttpHeaders headers = new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.LOCATION, (Object)url.toExternalForm());
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.FOUND;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.FOUND");
        Channel channel = context.channel();
        Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"context.channel()");
        Responses.send((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)headers);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u0004\u0018\u00010\u0004*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthCallbackHandler$Companion;", "", "()V", "SERVICE_NAME", "", "authorizationCodeUrl", "Lcom/intellij/util/Url;", "getAuthorizationCodeUrl", "()Lcom/intellij/util/Url;", "port", "", "getPort", "()I", "authorizationCode", "Lio/netty/handler/codec/http/QueryStringDecoder;", "getAuthorizationCode", "(Lio/netty/handler/codec/http/QueryStringDecoder;)Ljava/lang/String;", "isAuthorizationCodeUrl", "", "(Lio/netty/handler/codec/http/QueryStringDecoder;)Z", "intellij.vcs.github"})
    public static final class Companion {
        private final int getPort() {
            return BuiltInServerManager.Companion.getInstance().getPort();
        }

        @NotNull
        public final Url getAuthorizationCodeUrl() {
            return Urls.newFromEncoded((String)("http://localhost:" + Companion.getPort() + "/api/github/oauth/authorization_code"));
        }

        private final boolean isAuthorizationCodeUrl(@NotNull QueryStringDecoder $this$isAuthorizationCodeUrl) {
            return Intrinsics.areEqual((Object)$this$isAuthorizationCodeUrl.path(), (Object)Companion.getAuthorizationCodeUrl().getPath());
        }

        private final String getAuthorizationCode(@NotNull QueryStringDecoder $this$authorizationCode) {
            List list2 = (List)$this$authorizationCode.parameters().get("code");
            return list2 != null ? (String)CollectionsKt.firstOrNull((List)list2) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

