/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.LogEventsKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.Disposable;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u000fH\u0002J:\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00042\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u001aH\u0002J\b\u00100\u001a\u00020\u001aH\u0016R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "Lcom/intellij/openapi/Disposable;", "recorderId", "", "sessionId", "build", "bucket", "recorderVersion", "writer", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;)V", "lastEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "lastEventCreatedTime", "", "lastEventTime", "logExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getLogExecutor", "()Ljava/util/concurrent/ExecutorService;", "statisticsPersistenceComponent", "Lcom/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent;", "kotlin.jvm.PlatformType", "cleanup", "", "dispose", "flush", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "getActiveLogFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "log", "event", "createdTime", "logAsync", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "data", "", "", "isState", "", "logLastEvent", "rollOver", "intellij.platform.statistics"})
public class StatisticsFileEventLogger
implements StatisticsEventLogger,
Disposable {
    @NotNull
    private final ExecutorService logExecutor;
    private LogEvent lastEvent;
    private long lastEventTime;
    private long lastEventCreatedTime;
    private final UsageStatisticsPersistenceComponent statisticsPersistenceComponent;
    private final String recorderId;
    private final String sessionId;
    private final String build;
    private final String bucket;
    private final String recorderVersion;
    private final StatisticsEventLogWriter writer;

    @NotNull
    protected final ExecutorService getLogExecutor() {
        return this.logExecutor;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> logAsync(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Map<String, ? extends Object> data, boolean isState) {
        CompletableFuture<Object> completableFuture;
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        long eventTime = System.currentTimeMillis();
        group.validateEventId$intellij_platform_statistics(eventId);
        try {
            CompletableFuture<Void> completableFuture2 = CompletableFuture.runAsync(new Runnable(this, eventId, data, group, eventTime, isState){
                final /* synthetic */ StatisticsFileEventLogger this$0;
                final /* synthetic */ String $eventId;
                final /* synthetic */ Map $data;
                final /* synthetic */ EventLogGroup $group;
                final /* synthetic */ long $eventTime;
                final /* synthetic */ boolean $isState;

                public final void run() {
                    EventContext context = EventContext.create(this.$eventId, this.$data);
                    SensitiveDataValidator sensitiveDataValidator = SensitiveDataValidator.getInstance(StatisticsFileEventLogger.access$getRecorderId$p(this.this$0));
                    Intrinsics.checkExpressionValueIsNotNull((Object)sensitiveDataValidator, (String)"SensitiveDataValidator.getInstance(recorderId)");
                    SensitiveDataValidator validator = sensitiveDataValidator;
                    String validatedEventId = validator.guaranteeCorrectEventId(this.$group, context);
                    Map<String, Object> validatedEventData = validator.guaranteeCorrectEventData(this.$group, context);
                    long creationTime = System.currentTimeMillis();
                    String string = StatisticsFileEventLogger.access$getSessionId$p(this.this$0);
                    String string2 = StatisticsFileEventLogger.access$getBuild$p(this.this$0);
                    String string3 = StatisticsFileEventLogger.access$getBucket$p(this.this$0);
                    String string4 = this.$group.getId();
                    String string5 = String.valueOf(this.$group.getVersion());
                    String string6 = StatisticsFileEventLogger.access$getRecorderVersion$p(this.this$0);
                    String string7 = validatedEventId;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"validatedEventId");
                    LogEvent event = LogEventsKt.newLogEvent((String)string, (String)string2, (String)string3, (long)this.$eventTime, (String)string4, (String)string5, (String)string6, (String)string7, (boolean)this.$isState);
                    Map<String, Object> map = validatedEventData;
                    Intrinsics.checkExpressionValueIsNotNull(map, (String)"validatedEventData");
                    Map<String, Object> map2 = map;
                    boolean bl = false;
                    for (Map.Entry<String, Object> datum : map2.entrySet()) {
                        LogEventAction logEventAction = event.getEvent();
                        String string8 = datum.getKey();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"datum.key");
                        Object object = datum.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"datum.value");
                        logEventAction.addData(string8, object);
                    }
                    StatisticsFileEventLogger.access$log(this.this$0, event, creationTime);
                }
                {
                    this.this$0 = statisticsFileEventLogger;
                    this.$eventId = string;
                    this.$data = map;
                    this.$group = eventLogGroup;
                    this.$eventTime = l;
                    this.$isState = bl;
                }
            }, this.logExecutor);
            Intrinsics.checkExpressionValueIsNotNull(completableFuture2, (String)"CompletableFuture.runAsy\u2026me)\n      }, logExecutor)");
            completableFuture = completableFuture2;
        }
        catch (RejectedExecutionException e) {
            CompletableFuture<Object> completableFuture3 = CompletableFuture.completedFuture(null);
            Intrinsics.checkExpressionValueIsNotNull(completableFuture3, (String)"CompletableFuture.completedFuture(null)");
            completableFuture = completableFuture3;
        }
        return completableFuture;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void log(LogEvent event, long createdTime) {
        if (this.lastEvent != null && event.getTime() - this.lastEventTime <= (long)10000) {
            LogEvent logEvent = this.lastEvent;
            if (logEvent == null) {
                Intrinsics.throwNpe();
            }
            if (logEvent.shouldMerge(event)) {
                this.lastEventTime = event.getTime();
                LogEvent logEvent2 = this.lastEvent;
                if (logEvent2 == null) {
                    Intrinsics.throwNpe();
                }
                logEvent2.getEvent().increment();
                return;
            }
        }
        this.logLastEvent();
        this.lastEvent = event;
        this.lastEventTime = event.getTime();
        this.lastEventCreatedTime = createdTime;
    }

    private final void logLastEvent() {
        LogEvent logEvent = this.lastEvent;
        if (logEvent != null) {
            LogEvent logEvent2 = logEvent;
            boolean bl = false;
            boolean bl2 = false;
            LogEvent it = logEvent2;
            boolean bl3 = false;
            if (it.getEvent().isEventGroup()) {
                it.getEvent().addData("last", (Object)this.lastEventTime);
            }
            it.getEvent().addData("created", (Object)this.lastEventCreatedTime);
            long systemEventId = this.statisticsPersistenceComponent.getEventId(this.recorderId);
            it.getEvent().addData("system_event_id", (Object)systemEventId);
            this.statisticsPersistenceComponent.setEventId(this.recorderId, ++systemEventId);
            this.writer.log(it);
        }
        this.lastEvent = null;
    }

    @Override
    @Nullable
    public EventLogFile getActiveLogFile() {
        return this.writer.getActiveFile();
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return this.writer.getLogFilesProvider();
    }

    @Override
    public void cleanup() {
        this.writer.cleanup();
    }

    @Override
    public void rollOver() {
        this.writer.rollOver();
    }

    public void dispose() {
        this.flush();
        this.logExecutor.shutdown();
    }

    @NotNull
    public final CompletableFuture<Void> flush() {
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(new Runnable(this){
            final /* synthetic */ StatisticsFileEventLogger this$0;

            public final void run() {
                StatisticsFileEventLogger.access$logLastEvent(this.this$0);
            }
            {
                this.this$0 = statisticsFileEventLogger;
            }
        }, this.logExecutor);
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.runAsy\u2026ent()\n    }, logExecutor)");
        return completableFuture;
    }

    public StatisticsFileEventLogger(@NotNull String recorderId, @NotNull String sessionId, @NotNull String build2, @NotNull String bucket, @NotNull String recorderVersion, @NotNull StatisticsEventLogWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull((Object)build2, (String)"build");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        Intrinsics.checkParameterIsNotNull((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this.recorderId = recorderId;
        this.sessionId = sessionId;
        this.build = build2;
        this.bucket = bucket;
        this.recorderVersion = recorderVersion;
        this.writer = writer;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)("StatisticsFileEventLogger: " + this.sessionId));
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"SequentialTaskExecutor.c\u2026EventLogger: $sessionId\")");
        this.logExecutor = executorService;
        this.statisticsPersistenceComponent = UsageStatisticsPersistenceComponent.getInstance();
    }

    @Override
    @NotNull
    public CompletableFuture<Void> logAsync(@NotNull EventLogGroup group, @NotNull String eventId, boolean isState) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        return StatisticsEventLogger.DefaultImpls.logAsync(this, group, eventId, isState);
    }

    @Override
    @Deprecated(message="Use StatisticsEventLogger.logAsync()", replaceWith=@ReplaceWith(imports={}, expression="logAsync(group, eventId, isState)"))
    public void log(@NotNull EventLogGroup group, @NotNull String eventId, boolean isState) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        StatisticsEventLogger.DefaultImpls.log(this, group, eventId, isState);
    }

    @Override
    @Deprecated(message="Use StatisticsEventLogger.logAsync", replaceWith=@ReplaceWith(imports={}, expression="logAsync(group, eventId, data, isState)"))
    public void log(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Map<String, ? extends Object> data, boolean isState) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        StatisticsEventLogger.DefaultImpls.log(this, group, eventId, data, isState);
    }

    public static final /* synthetic */ String access$getRecorderId$p(StatisticsFileEventLogger $this) {
        return $this.recorderId;
    }

    public static final /* synthetic */ String access$getSessionId$p(StatisticsFileEventLogger $this) {
        return $this.sessionId;
    }

    public static final /* synthetic */ String access$getBuild$p(StatisticsFileEventLogger $this) {
        return $this.build;
    }

    public static final /* synthetic */ String access$getBucket$p(StatisticsFileEventLogger $this) {
        return $this.bucket;
    }

    public static final /* synthetic */ String access$getRecorderVersion$p(StatisticsFileEventLogger $this) {
        return $this.recorderVersion;
    }

    public static final /* synthetic */ void access$log(StatisticsFileEventLogger $this, LogEvent event, long createdTime) {
        $this.log(event, createdTime);
    }

    public static final /* synthetic */ void access$logLastEvent(StatisticsFileEventLogger $this) {
        $this.logLastEvent();
    }
}

