/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.redmine;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.redmine.RedmineRepository;
import com.intellij.tasks.redmine.model.RedmineIssue;
import com.intellij.tasks.redmine.model.RedmineProject;
import icons.TasksCoreIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedmineTask
extends Task {
    private final RedmineIssue myIssue;
    private final RedmineRepository myRepository;
    private final RedmineProject myProject;

    public RedmineTask(@NotNull RedmineRepository repository, @NotNull RedmineIssue issue) {
        if (repository == null) {
            RedmineTask.$$$reportNull$$$0(0);
        }
        if (issue == null) {
            RedmineTask.$$$reportNull$$$0(1);
        }
        this.myIssue = issue;
        this.myRepository = repository;
        RedmineProject project = null;
        for (RedmineProject p : repository.getProjects()) {
            if (issue.getProject() == null || p.getId() != issue.getProject().getId()) continue;
            project = p;
            break;
        }
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        String string = String.valueOf(this.myIssue.getId());
        if (string == null) {
            RedmineTask.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = this.myIssue.getSubject();
        if (string == null) {
            RedmineTask.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.myIssue.getDescription();
    }

    public Comment @NotNull [] getComments() {
        if (Comment.EMPTY_ARRAY == null) {
            RedmineTask.$$$reportNull$$$0(4);
        }
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksCoreIcons.Redmine;
        if (icon == null) {
            RedmineTask.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = TaskType.BUG;
        if (taskType == null) {
            RedmineTask.$$$reportNull$$$0(6);
        }
        return taskType;
    }

    @Nullable
    public Date getUpdated() {
        return this.myIssue.getUpdated();
    }

    @Nullable
    public Date getCreated() {
        return this.myIssue.getCreated();
    }

    public boolean isClosed() {
        String name = this.myIssue.getStatus().getName();
        return name.equals("Closed") || name.equals("Resolved");
    }

    public boolean isIssue() {
        return true;
    }

    @Nullable
    public String getIssueUrl() {
        return this.myRepository.getRestApiUrl("issues", this.getId());
    }

    @NotNull
    public String getNumber() {
        String string = this.getId();
        if (string == null) {
            RedmineTask.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public String getProject() {
        return this.myProject == null ? null : this.myProject.getIdentifier();
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/redmine/RedmineTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/redmine/RedmineTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

