/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.speller.dictionary.transformation;

import com.intellij.grazie.speller.dictionary.Dictionary;
import com.intellij.grazie.speller.dictionary.transformation.WordTransformation;
import com.intellij.grazie.speller.lists.WordList;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/speller/dictionary/transformation/TransformingDictionary;", "Lcom/intellij/grazie/speller/dictionary/Dictionary;", "list", "Lcom/intellij/grazie/speller/lists/WordList;", "transformation", "Lcom/intellij/grazie/speller/dictionary/transformation/WordTransformation;", "(Lcom/intellij/grazie/speller/lists/WordList;Lcom/intellij/grazie/speller/dictionary/transformation/WordTransformation;)V", "contains", "", "word", "", "isAlien", "suggest", "", "distance", "", "spellchecker"})
public final class TransformingDictionary
implements Dictionary {
    private final WordList list;
    private final WordTransformation transformation;

    @Override
    public boolean contains(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        return this.list.contains(word) || this.list.contains(this.transformation.transform(word));
    }

    @Override
    @NotNull
    public Set<String> suggest(@NotNull String word, int distance) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        return SequencesKt.toSet(this.list.suggest(word, distance));
    }

    @Override
    public boolean isAlien(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        return this.list.isAlien(word) && this.list.isAlien(this.transformation.transform(word));
    }

    public TransformingDictionary(@NotNull WordList list, @NotNull WordTransformation transformation) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)transformation, (String)"transformation");
        this.list = list;
        this.transformation = transformation;
    }
}

