/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser;

import org.apache.velocity.exception.ExtendedParseException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.util.StringUtils;

public class TemplateParseException
extends ParseException
implements ExtendedParseException {
    private static final long serialVersionUID = -3146323135623083918L;
    private final String templateName;

    public TemplateParseException(Token token, int[][] nArray, String[] stringArray, String string) {
        super(token, nArray, stringArray);
        this.templateName = string;
    }

    public TemplateParseException(Token token, int[][] nArray, String[] stringArray) {
        super(token, nArray, stringArray);
        this.templateName = "*unset*";
    }

    public TemplateParseException() {
        this.templateName = "*unset*";
    }

    public TemplateParseException(String string) {
        super(string);
        this.templateName = "*unset*";
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public int getLineNumber() {
        if (this.currentToken != null && this.currentToken.next != null) {
            return this.currentToken.next.beginLine;
        }
        return -1;
    }

    @Override
    public int getColumnNumber() {
        if (this.currentToken != null && this.currentToken.next != null) {
            return this.currentToken.next.beginColumn;
        }
        return -1;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            StringBuilder stringBuilder = new StringBuilder(super.getMessage());
            this.appendTemplateInfo(stringBuilder);
            return stringBuilder.toString();
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int[] nArray : this.expectedTokenSequences) {
            if (n < nArray.length) {
                n = nArray.length;
            }
            for (int i = 0; i < nArray.length; ++i) {
                stringBuilder.append(this.tokenImage[nArray[i]]).append(" ");
            }
            if (nArray[nArray.length - 1] != 0) {
                stringBuilder.append("...");
            }
            stringBuilder.append(this.eol).append("    ");
        }
        Object object = new StringBuilder("Encountered \"");
        Token token = this.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                ((StringBuilder)object).append(" ");
            }
            if (token.kind == 0) {
                ((StringBuilder)object).append(this.tokenImage[0]);
                break;
            }
            ((StringBuilder)object).append(this.add_escapes(token.image));
            token = token.next;
        }
        ((StringBuilder)object).append("\" at ");
        this.appendTemplateInfo((StringBuilder)object);
        if (this.expectedTokenSequences.length == 1) {
            ((StringBuilder)object).append("Was expecting:").append(this.eol).append("    ");
        } else {
            ((StringBuilder)object).append("Was expecting one of:").append(this.eol).append("    ");
        }
        ((StringBuilder)object).append(stringBuilder.toString());
        return ((StringBuilder)object).toString();
    }

    protected void appendTemplateInfo(StringBuilder stringBuilder) {
        stringBuilder.append(StringUtils.formatFileString(this.getTemplateName(), this.getLineNumber(), this.getColumnNumber()));
        stringBuilder.append(this.eol);
    }
}

