/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.core.startup.Main;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

final class TimableEventQueue
extends EventQueue
implements Runnable {
    private static final Logger LOG = Logger.getLogger(TimableEventQueue.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("Timeable Event Queue Watch Dog", 1, true);
    private static final int QUANTUM = Integer.getInteger("org.netbeans.core.TimeableEventQueue.quantum", 5000);
    private static final int PAUSE = Integer.getInteger("org.netbeans.core.TimeableEventQueue.pause", 60000);
    private final RequestProcessor.Task TIMEOUT = RP.create((Runnable)this);
    private volatile Map<Thread, StackTraceElement[]> stack;
    private volatile long ignoreTill;
    private volatile long start;

    public TimableEventQueue() {
        this.TIMEOUT.setPriority(1);
    }

    static void initialize() {
        try {
            Mutex.EVENT.writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    Thread.currentThread().setContextClassLoader(Main.getModuleSystem().getManager().getClassLoader());
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(new TimableEventQueue());
                    LOG.fine("Initialization done");
                    return null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(AWTEvent aWTEvent) {
        try {
            this.tick();
            super.dispatchEvent(aWTEvent);
        }
        finally {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEvent(AWTEvent aWTEvent) {
        try {
            this.tick();
            super.postEvent(aWTEvent);
        }
        finally {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void push(EventQueue eventQueue) {
        try {
            this.tick();
            super.push(eventQueue);
        }
        finally {
            this.done();
        }
    }

    private void done() {
        this.stack = null;
        this.TIMEOUT.cancel();
        long l = System.currentTimeMillis() - this.start;
        if (l > 50L) {
            LOG.log(Level.FINE, "done, timer stopped, took {0}", l);
        } else {
            LOG.log(Level.FINEST, "done, timer stopped, took {0}", l);
        }
    }

    private void tick() {
        this.stack = null;
        this.start = System.currentTimeMillis();
        if (this.start >= this.ignoreTill) {
            LOG.log(Level.FINEST, "tick, schedule a timer at {0}", this.start);
            this.TIMEOUT.schedule(QUANTUM);
        }
    }

    public void run() {
        this.stack = Thread.getAllStackTraces();
        LOG.log(Level.FINER, "timer running");
        for (int i = 0; i < 10; ++i) {
            if (Thread.interrupted()) {
                LOG.log(Level.FINER, "timer cancelled");
                return;
            }
            Thread.yield();
            System.gc();
            System.runFinalization();
        }
        Map<Thread, StackTraceElement[]> map = this.stack;
        if (map == null) {
            LOG.log(Level.FINER, "timer cancelled");
            return;
        }
        long l = System.currentTimeMillis();
        this.ignoreTill = l + (long)PAUSE;
        long l2 = l - this.start;
        LogRecord logRecord = new LogRecord(Level.INFO, "LOG_EventQueueBlocked");
        logRecord.setParameters(new Object[]{l2});
        EQException eQException = new EQException(map);
        logRecord.setThrown(eQException);
        logRecord.setResourceBundleName("org.netbeans.core.Bundle");
        logRecord.setResourceBundle(ResourceBundle.getBundle("org.netbeans.core.Bundle"));
        LOG.log(logRecord);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EQException
    extends Exception {
        private volatile Map<Thread, StackTraceElement[]> stack;

        public EQException(Map<Thread, StackTraceElement[]> map) {
            this.stack = map;
            for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                if (entry.getKey().getName().indexOf("AWT-EventQueue") < 0) continue;
                this.setStackTrace(entry.getValue());
                break;
            }
        }

        @Override
        public String getMessage() {
            return EQException.threadDump("AWT Event Queue Thread Blocked", this.stack);
        }

        private static void appendThread(StringBuilder stringBuilder, String string, Thread thread, Map<Thread, StackTraceElement[]> map) {
            stringBuilder.append(string).append("Thread ").append(thread.getName()).append('\n');
            string = string.concat("  ");
            StackTraceElement[] stackTraceElementArray = map.get(thread);
            if (stackTraceElementArray != null) {
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    stringBuilder.append(string).append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName()).append(':').append(stackTraceElement.getLineNumber()).append('\n');
                }
            } else {
                stringBuilder.append(string).append("no stacktrace info");
            }
        }

        private static void appendGroup(StringBuilder stringBuilder, String string, ThreadGroup threadGroup, Map<Thread, StackTraceElement[]> map) {
            stringBuilder.append(string).append("Group ").append(threadGroup.getName()).append('\n');
            string = string.concat("  ");
            int n = threadGroup.activeGroupCount();
            ThreadGroup[] threadGroupArray = new ThreadGroup[n];
            threadGroup.enumerate(threadGroupArray, false);
            for (ThreadGroup threadGroup2 : threadGroupArray) {
                if (threadGroup2 == null) continue;
                EQException.appendGroup(stringBuilder, string, threadGroup2, map);
            }
            int n2 = threadGroup.activeCount();
            Thread[] threadArray = new Thread[n2];
            threadGroup.enumerate(threadArray, false);
            for (Thread thread : threadArray) {
                if (thread == null) continue;
                EQException.appendThread(stringBuilder, string, thread, map);
            }
        }

        private static String threadDump(String string, Map<Thread, StackTraceElement[]> map) {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string).append('\n');
            EQException.appendGroup(stringBuilder, "", threadGroup, map);
            stringBuilder.append('\n').append("---");
            return stringBuilder.toString();
        }
    }
}

