/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerStatement;
import com.datical.liquibase.ext.storedlogic.trigger.change.DisableTriggerChange;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.SqlParser;
import liquibase.util.StringClauses;

public class CreateTriggerGenerator
extends AbstractSqlGenerator<CreateTriggerStatement> {
    @Override
    public int getPriority() {
        return 101;
    }

    @Override
    public ValidationErrors validate(CreateTriggerStatement createTriggerStatement, Database database, SqlGeneratorChain object) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkRequiredField("triggerName", createTriggerStatement.getTriggerName());
        ((ValidationErrors)object).checkRequiredField("triggerBody", createTriggerStatement.getTriggerBody());
        ((ValidationErrors)object).checkDisallowedField("catalogName", createTriggerStatement.getCatalogName(), database, MSSQLDatabase.class);
        return object;
    }

    @Override
    public boolean supports(CreateTriggerStatement createTriggerStatement, Database database) {
        return createTriggerStatement instanceof CreateTriggerStatement;
    }

    @Override
    public Sql[] generateSql(CreateTriggerStatement createTriggerStatement, Database database, SqlGeneratorChain object) {
        Object object2;
        object = ";";
        if (database instanceof OracleDatabase) {
            object = "\n/";
        } else if (database instanceof AbstractDb2Database) {
            object = "";
        }
        Object object3 = createTriggerStatement.getSchemaName();
        if (object3 == null && database instanceof PostgresDatabase) {
            object3 = database.getDefaultSchemaName();
        }
        object3 = CreateProcedureGenerator.removeTrailingDelimiter(CreateProcedureGenerator.addSchemaToText(createTriggerStatement.getTriggerBody(), (String)object3, "ON", database), (String)object);
        if (this.needAppendSchemaName(database)) {
            object3 = CreateProcedureGenerator.addSchemaToText((String)object3, createTriggerStatement.getSchemaName(), "TRIGGER", database);
        }
        ArrayList<Sql> arrayList = new ArrayList<Sql>();
        if (createTriggerStatement.getReplaceIfExists() != null && createTriggerStatement.getReplaceIfExists().booleanValue()) {
            object2 = database.escapeObjectName(createTriggerStatement.getTriggerName(), Trigger.class);
            object2 = createTriggerStatement.getSchemaName() == null ? "[dbo].".concat(String.valueOf(object2)) : database.escapeObjectName(createTriggerStatement.getSchemaName(), Schema.class) + "." + (String)object2;
            if (createTriggerStatement.getTableName() == null) {
                arrayList.add(new UnparsedSql("if (select count(*) from sys.triggers where parent_class_desc='DATABASE' and name='" + database.escapeStringForDatabase(createTriggerStatement.getTriggerName()) + "') = 0 exec ('CREATE TRIGGER " + database.escapeObjectName(createTriggerStatement.getTriggerName(), Trigger.class) + " on DATABASE FOR DROP_TABLE as begin select ''STUB'' END')", new DatabaseObject[0]));
            } else {
                arrayList.add(new UnparsedSql("if object_id('" + (String)object2 + "', 'tr') is null exec ('CREATE TRIGGER " + database.escapeObjectName(createTriggerStatement.getTriggerName(), Trigger.class) + " on " + database.escapeObjectName(createTriggerStatement.getCatalogName(), createTriggerStatement.getSchemaName(), createTriggerStatement.getTableName(), Table.class) + " after insert as begin select ''STUB'' END')", new DatabaseObject[0]));
            }
            object3 = SqlParser.parse((String)object3, true, true);
            object2 = ((StringClauses)object3).getClauseIterator();
            Object object4 = "START";
            while (object4 != null && !object4.toString().equalsIgnoreCase("create") && !object4.toString().equalsIgnoreCase("alter") && ((StringClauses.ClauseIterator)object2).hasNext()) {
                object4 = ((StringClauses.ClauseIterator)object2).nextNonWhitespace();
            }
            ((StringClauses.ClauseIterator)object2).replace("ALTER");
            object3 = ((StringClauses)object3).toString();
        }
        arrayList.add(new UnparsedSql((String)object3, (String)object, new DatabaseObject[0]));
        if (createTriggerStatement.getDisabled() != null && createTriggerStatement.getDisabled().booleanValue()) {
            object2 = new DisableTriggerChange();
            ((DisableTriggerChange)object2).setCatalogName(createTriggerStatement.getCatalogName());
            ((DisableTriggerChange)object2).setSchemaName(createTriggerStatement.getSchemaName());
            ((DisableTriggerChange)object2).setTriggerName(createTriggerStatement.getTriggerName());
            ((DisableTriggerChange)object2).setTableName(createTriggerStatement.getTableName());
            ((DisableTriggerChange)object2).setScope(createTriggerStatement.getScope());
            arrayList.addAll(Arrays.asList(SqlGeneratorFactory.getInstance().generateSql(((DisableTriggerChange)object2).generateStatements(database), database)));
        }
        CreateProcedureGenerator.surroundWithSchemaSets(arrayList, createTriggerStatement.getSchemaName(), database);
        ArrayList<Sql> arrayList2 = arrayList;
        return arrayList2.toArray(new Sql[arrayList2.size()]);
    }

    private boolean needAppendSchemaName(Database database) {
        return !(database instanceof PostgresDatabase);
    }
}

