/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.codec;

import com.cloudhopper.commons.util.codec.URLCodec;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class URLDecoder
implements Appendable,
Flushable,
Closeable {
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    protected final Appendable out;
    protected final Charset charset;
    protected final CharBuffer singleCharBuffer = CharBuffer.allocate(1);
    protected final CharsetDecoder cd;
    protected final ByteBuffer bb;
    protected final CharBuffer cb;

    public URLDecoder(Appendable out) {
        this(out, 1024, URLCodec.UTF_8);
    }

    public URLDecoder(Appendable out, int bufferSize) {
        this(out, bufferSize, URLCodec.UTF_8);
    }

    public URLDecoder(Appendable out, int bufferSize, Charset charset) {
        this.out = out;
        this.charset = charset;
        this.cd = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.bb = ByteBuffer.allocate(bufferSize);
        this.cb = CharBuffer.allocate((int)Math.ceil((float)bufferSize * this.cd.maxCharsPerByte()));
    }

    @Override
    public Appendable append(CharSequence in) throws IOException {
        if (in == null) {
            return this;
        }
        int len = in.length();
        for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            if (c == '+') {
                this.bb.put((byte)32);
            } else if (c == '%') {
                int x = Character.digit(in.charAt(++i), 16);
                int y = Character.digit(in.charAt(++i), 16);
                if (x == -1 || y == -1) {
                    throw new IOException("Invalid URL encoding");
                }
                this.bb.put((byte)((x << 4) + y));
            } else {
                this.bb.put((byte)c);
            }
            if (this.bb.hasRemaining()) continue;
            this.flush(false);
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.singleCharBuffer.put(0, c);
        return this.append(this.singleCharBuffer);
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        return this.append(csq.subSequence(start, end));
    }

    protected void flush(boolean endOfInput) throws IOException {
        this.bb.flip();
        CoderResult cr = this.cd.decode(this.bb, this.cb, endOfInput);
        if (!cr.isUnderflow()) {
            throw new IOException("Unexpected: " + cr);
        }
        this.cb.flip();
        this.out.append(this.cb);
        this.cb.clear();
        this.bb.clear();
        if (endOfInput) {
            cr = this.cd.flush(this.cb);
            if (!cr.isUnderflow()) {
                throw new IOException("Unexpected: " + cr);
            }
            this.cb.flip();
            this.out.append(this.cb);
            this.cb.clear();
            this.cd.reset();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

