/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class AdmProtocolDecoder
extends BaseProtocolDecoder {
    public static final int CMD_RESPONSE_SIZE = 132;
    public static final int MSG_IMEI = 3;
    public static final int MSG_PHOTO = 10;
    public static final int MSG_ADM5 = 1;

    public AdmProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodeData(Channel channel, SocketAddress remoteAddress, ByteBuf buf, int type) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        if (BitUtil.to(type, 2) == 0) {
            int i;
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("versionFw", buf.readUnsignedByte());
            position.set("index", buf.readUnsignedShortLE());
            int status = buf.readUnsignedShortLE();
            position.set("status", status);
            position.setValid(!BitUtil.check(status, 5));
            position.setLatitude(buf.readFloatLE());
            position.setLongitude(buf.readFloatLE());
            position.setCourse((double)buf.readUnsignedShortLE() * 0.1);
            position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShortLE() * 0.1));
            position.set("acceleration", (double)buf.readUnsignedByte() * 0.1);
            position.setAltitude(buf.readShortLE());
            position.set("hdop", (double)buf.readUnsignedByte() * 0.1);
            position.set("sat", buf.readUnsignedByte() & 0xF);
            position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
            position.set("power", (double)buf.readUnsignedShortLE() * 0.001);
            position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
            if (BitUtil.check(type, 2)) {
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                short out = buf.readUnsignedByte();
                for (int i2 = 0; i2 <= 3; ++i2) {
                    position.set("out" + (i2 + 1), BitUtil.check(out, i2) ? 1 : 0);
                }
                buf.readUnsignedByte();
            }
            if (BitUtil.check(type, 3)) {
                for (i = 1; i <= 6; ++i) {
                    position.set("adc" + i, (double)buf.readUnsignedShortLE() * 0.001);
                }
            }
            if (BitUtil.check(type, 4)) {
                for (i = 1; i <= 2; ++i) {
                    position.set("count" + i, buf.readUnsignedIntLE());
                }
            }
            if (BitUtil.check(type, 5)) {
                for (i = 1; i <= 3; ++i) {
                    buf.readUnsignedShortLE();
                }
                for (i = 1; i <= 3; ++i) {
                    position.set("temp" + i, buf.readUnsignedByte());
                }
            }
            if (BitUtil.check(type, 6)) {
                int endIndex = buf.readerIndex() + buf.readUnsignedByte();
                block16: while (buf.readerIndex() < endIndex) {
                    long value;
                    short mask = buf.readUnsignedByte();
                    switch (BitUtil.from(mask, 6)) {
                        case 3: {
                            value = buf.readLongLE();
                            break;
                        }
                        case 2: {
                            value = buf.readUnsignedIntLE();
                            break;
                        }
                        case 1: {
                            value = buf.readUnsignedShortLE();
                            break;
                        }
                        default: {
                            value = buf.readUnsignedByte();
                        }
                    }
                    int index = BitUtil.to(mask, 6);
                    switch (index) {
                        case 1: {
                            position.set("temp1", value);
                            continue block16;
                        }
                        case 2: {
                            position.set("humidity", value);
                            continue block16;
                        }
                        case 3: {
                            position.set("illumination", value);
                            continue block16;
                        }
                        case 4: {
                            position.set("battery", value);
                            continue block16;
                        }
                    }
                    position.set("can" + index, value);
                }
            }
            if (BitUtil.check(type, 7)) {
                position.set("odometer", buf.readUnsignedIntLE());
            }
            return position;
        }
        return null;
    }

    private Position parseCommandResponse(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        int responseTextLength = buf.bytesBefore((byte)0);
        if (responseTextLength < 0) {
            responseTextLength = 129;
        }
        position.set("result", buf.readSlice(responseTextLength).toString(StandardCharsets.UTF_8));
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedShortLE();
        short size = buf.readUnsignedByte();
        if (size != 132) {
            short type = buf.readUnsignedByte();
            if (type != 3) {
                return this.decodeData(channel, remoteAddress, buf, type);
            }
        } else {
            return this.parseCommandResponse(channel, remoteAddress, buf);
        }
        this.getDeviceSession(channel, remoteAddress, buf.readSlice(15).toString(StandardCharsets.UTF_8));
        return null;
    }
}

