/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class EnforaProtocolEncoder
extends StringProtocolEncoder {
    public EnforaProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(String content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeShort(content.length() + 6);
        buf.writeShort(0);
        buf.writeByte(4);
        buf.writeByte(0);
        buf.writeBytes(content.getBytes(StandardCharsets.US_ASCII));
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.encodeContent(command.getString("data"));
            }
            case "engineStop": {
                return this.encodeContent("AT$IOGP3=1");
            }
            case "engineResume": {
                return this.encodeContent("AT$IOGP3=0");
            }
        }
        return null;
    }
}

