/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class KhdProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 177;
    public static final int MSG_CONFIRMATION = 33;
    public static final int MSG_ON_DEMAND = 129;
    public static final int MSG_POSITION_UPLOAD = 128;
    public static final int MSG_POSITION_REUPLOAD = 142;
    public static final int MSG_ALARM = 130;
    public static final int MSG_ADMIN_NUMBER = 131;
    public static final int MSG_SEND_TEXT = 132;
    public static final int MSG_REPLY = 133;
    public static final int MSG_SMS_ALARM_SWITCH = 134;
    public static final int MSG_PERIPHERAL = 163;

    public KhdProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String readSerialNumber(ByteBuf buf) {
        short b1 = buf.readUnsignedByte();
        int b2 = buf.readUnsignedByte() - 128;
        int b3 = buf.readUnsignedByte() - 128;
        short b4 = buf.readUnsignedByte();
        return String.format("%02d%02d%02d%02d", b1, b2, b3, (int)b4);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        if (type == 177 || type == 131 || type == 132 || type == 134 || type == 142) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(41);
            response.writeByte(41);
            response.writeByte(33);
            response.writeShort(5);
            response.writeByte((int)buf.getByte(buf.writerIndex() - 2));
            response.writeByte((int)type);
            response.writeByte(buf.writerIndex() > 9 ? (int)buf.getByte(9) : 0);
            response.writeByte(Checksum.xor(response.nioBuffer()));
            response.writeByte(13);
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        }
        if (type == 129 || type == 128 || type == 142 || type == 130 || type == 133 || type == 163) {
            Position position = new Position(this.getProtocolName());
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.readSerialNumber(buf));
            if (deviceSession == null) {
                return null;
            }
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
            position.setTime(dateBuilder.getDate());
            position.setLatitude(BcdUtil.readCoordinate(buf));
            position.setLongitude(BcdUtil.readCoordinate(buf));
            position.setSpeed(UnitsConverter.knotsFromKph(BcdUtil.readInteger(buf, 4)));
            position.setCourse(BcdUtil.readInteger(buf, 4));
            position.setValid((buf.readUnsignedByte() & 0x80) != 0);
            if (type != 130) {
                position.set("odometer", buf.readUnsignedMedium());
                position.set("status", buf.readUnsignedInt());
                position.set("hdop", buf.readUnsignedByte());
                position.set("vdop", buf.readUnsignedByte());
                position.set("sat", buf.readUnsignedByte());
                buf.skipBytes(5);
                if (type == 163) {
                    buf.readUnsignedShort();
                    short dataType = buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    switch (dataType) {
                        case 1: {
                            position.set("fuel", buf.readUnsignedByte() * 100 + buf.readUnsignedByte());
                            break;
                        }
                        case 2: {
                            position.set("temp1", buf.readUnsignedByte() * 100 + buf.readUnsignedByte());
                            break;
                        }
                    }
                }
            }
            return position;
        }
        return null;
    }
}

