/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.TimeZone;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;

public class MeiligaoProtocolEncoder
extends BaseProtocolEncoder {
    public MeiligaoProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(long deviceId, int type, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(64);
        buf.writeByte(64);
        buf.writeShort(13 + content.readableBytes() + 2 + 2);
        buf.writeBytes(DataConverter.parseHex((this.getUniqueId(deviceId) + "FFFFFFFFFFFFFF").substring(0, 14)));
        buf.writeShort(type);
        buf.writeBytes(content);
        buf.writeShort(Checksum.crc16(Checksum.CRC16_CCITT_FALSE, buf.nioBuffer()));
        buf.writeByte(13);
        buf.writeByte(10);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        ByteBuf content = Unpooled.buffer();
        switch (command.getType()) {
            case "positionSingle": {
                return this.encodeContent(command.getDeviceId(), 16641, content);
            }
            case "positionPeriodic": {
                content.writeShort(command.getInteger("frequency") / 10);
                return this.encodeContent(command.getDeviceId(), 16642, content);
            }
            case "engineStop": {
                content.writeByte(1);
                return this.encodeContent(command.getDeviceId(), 16661, content);
            }
            case "engineResume": {
                content.writeByte(0);
                return this.encodeContent(command.getDeviceId(), 16661, content);
            }
            case "movementAlarm": {
                content.writeShort(command.getInteger("radius"));
                return this.encodeContent(command.getDeviceId(), 16646, content);
            }
            case "setTimezone": {
                int offset = TimeZone.getTimeZone(command.getString("timezone")).getRawOffset() / 60000;
                content.writeBytes(String.valueOf(offset).getBytes(StandardCharsets.US_ASCII));
                return this.encodeContent(command.getDeviceId(), 16690, content);
            }
            case "requestPhoto": {
                return this.encodeContent(command.getDeviceId(), 16721, content);
            }
            case "rebootDevice": {
                return this.encodeContent(command.getDeviceId(), 18690, content);
            }
        }
        return null;
    }
}

