(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/httpd/server#httpd::proto
    (##structure
     std/actor/proto#!protocol::t
     'std/net/httpd/server#httpd
     '()
     (hash-copy std/actor/xdr#+xdr-default-type-registry+)))
  (define std/net/httpd/server#httpd.register::t
    (make-struct-type
     'std/net/httpd/server#httpd.register::t
     '#f
     '3
     'httpd.register
     '((final: . #t))
     '#f
     '(host path handler)))
  (define std/net/httpd/server#httpd.register?
    (make-struct-predicate std/net/httpd/server#httpd.register::t))
  (define std/net/httpd/server#make-httpd.register
    (lambda _$args153431_
      (apply make-struct-instance
             std/net/httpd/server#httpd.register::t
             _$args153431_)))
  (define std/net/httpd/server#httpd.register-host
    (make-struct-field-accessor std/net/httpd/server#httpd.register::t '0))
  (define std/net/httpd/server#httpd.register-path
    (make-struct-field-accessor std/net/httpd/server#httpd.register::t '1))
  (define std/net/httpd/server#httpd.register-handler
    (make-struct-field-accessor std/net/httpd/server#httpd.register::t '2))
  (define std/net/httpd/server#httpd.register-host-set!
    (make-struct-field-mutator std/net/httpd/server#httpd.register::t '0))
  (define std/net/httpd/server#httpd.register-path-set!
    (make-struct-field-mutator std/net/httpd/server#httpd.register::t '1))
  (define std/net/httpd/server#httpd.register-handler-set!
    (make-struct-field-mutator std/net/httpd/server#httpd.register::t '2))
  (define std/net/httpd/server#xdr-httpd.register-read
    (lambda (_buffer153429_)
      (std/actor/xdr#xdr-read-struct
       std/net/httpd/server#httpd.register::t
       _buffer153429_)))
  (define std/net/httpd/server#xdr-httpd.register-write
    (lambda (_obj153426_ _buffer153427_)
      (std/actor/xdr#xdr-write-struct _obj153426_ _buffer153427_)))
  (define std/net/httpd/server#httpd.register::xdr
    (##structure
     std/actor/xdr#XDR::t
     std/net/httpd/server#xdr-httpd.register-read
     std/net/httpd/server#xdr-httpd.register-write))
  (table-set!
   (##direct-structure-ref
    std/net/httpd/server#httpd::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/net/httpd/server#httpd.register::t
   std/net/httpd/server#httpd.register::xdr)
  (define std/net/httpd/server#httpd.join::t
    (make-struct-type
     'std/net/httpd/server#httpd.join::t
     '#f
     '1
     'httpd.join
     '((final: . #t))
     '#f
     '(thread)))
  (define std/net/httpd/server#httpd.join?
    (make-struct-predicate std/net/httpd/server#httpd.join::t))
  (define std/net/httpd/server#make-httpd.join
    (lambda _$args153423_
      (apply make-struct-instance
             std/net/httpd/server#httpd.join::t
             _$args153423_)))
  (define std/net/httpd/server#httpd.join-thread
    (make-struct-field-accessor std/net/httpd/server#httpd.join::t '0))
  (define std/net/httpd/server#httpd.join-thread-set!
    (make-struct-field-mutator std/net/httpd/server#httpd.join::t '0))
  (define std/net/httpd/server#xdr-httpd.join-read
    (lambda (_buffer153421_)
      (std/actor/xdr#xdr-read-struct
       std/net/httpd/server#httpd.join::t
       _buffer153421_)))
  (define std/net/httpd/server#xdr-httpd.join-write
    (lambda (_obj153418_ _buffer153419_)
      (std/actor/xdr#xdr-write-struct _obj153418_ _buffer153419_)))
  (define std/net/httpd/server#httpd.join::xdr
    (##structure
     std/actor/xdr#XDR::t
     std/net/httpd/server#xdr-httpd.join-read
     std/net/httpd/server#xdr-httpd.join-write))
  (table-set!
   (##direct-structure-ref
    std/net/httpd/server#httpd::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/net/httpd/server#httpd.join::t
   std/net/httpd/server#httpd.join::xdr)
  (define std/net/httpd/server#httpd.shutdown::t
    (make-struct-type
     'std/net/httpd/server#httpd.shutdown::t
     '#f
     '0
     'httpd.shutdown
     '((final: . #t))
     '#f
     '()))
  (define std/net/httpd/server#httpd.shutdown?
    (make-struct-predicate std/net/httpd/server#httpd.shutdown::t))
  (define std/net/httpd/server#make-httpd.shutdown
    (lambda _$args153415_
      (apply make-struct-instance
             std/net/httpd/server#httpd.shutdown::t
             _$args153415_)))
  (define std/net/httpd/server#xdr-httpd.shutdown-read
    (lambda (_buffer153413_)
      (std/actor/xdr#xdr-read-struct
       std/net/httpd/server#httpd.shutdown::t
       _buffer153413_)))
  (define std/net/httpd/server#xdr-httpd.shutdown-write
    (lambda (_obj153408_ _buffer153410_)
      (std/actor/xdr#xdr-write-struct _obj153408_ _buffer153410_)))
  (define std/net/httpd/server#httpd.shutdown::xdr
    (##structure
     std/actor/xdr#XDR::t
     std/net/httpd/server#xdr-httpd.shutdown-read
     std/net/httpd/server#xdr-httpd.shutdown-write))
  (table-set!
   (##direct-structure-ref
    std/net/httpd/server#httpd::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/net/httpd/server#httpd.shutdown::t
   std/net/httpd/server#httpd.shutdown::xdr)
  (define std/net/httpd/server#current-http-server (make-parameter '#f))
  (define std/net/httpd/server#start-http-server!__%
    (lambda (_g153621_
             _mux153366153371_
             _backlog153367153373_
             _sockopts153368153375_
             .
             _addresses153377_)
      (let* ((_mux153379_
              (if (eq? _mux153366153371_ absent-value)
                  (let ((__obj153620
                         (make-object
                          std/net/httpd/mux#default-http-mux::t
                          '2)))
                    (std/net/httpd/mux#default-http-mux:::init!__0 __obj153620)
                    __obj153620)
                  _mux153366153371_))
             (_backlog153381_
              (if (eq? _backlog153367153373_ absent-value)
                  '10
                  _backlog153367153373_))
             (_sockopts153383_
              (if (eq? _sockopts153368153375_ absent-value)
                  (cons std/os/_socket#SO_REUSEADDR '())
                  _sockopts153368153375_)))
        (std/logger#start-logger!__0)
        (let* ((_sas153385_
                (map std/os/socket#socket-address _addresses153377_))
               (_socks153391_
                (map (lambda (_g153386153388_)
                       (std/net/socket/api#ssocket-listen__%
                        _g153386153388_
                        _backlog153381_
                        _sockopts153383_))
                     _sas153385_)))
          (gerbil/gambit/threads#spawn/group
           'http-server
           std/net/httpd/server#http-server
           _socks153391_
           _sas153385_
           _mux153379_)))))
  (define std/net/httpd/server#start-http-server!__@
    (lambda (_keys153365153397_ . _args153399_)
      (apply std/net/httpd/server#start-http-server!__%
             _keys153365153397_
             (table-ref _keys153365153397_ 'mux: absent-value)
             (table-ref _keys153365153397_ 'backlog: absent-value)
             (table-ref _keys153365153397_ 'sockopts: absent-value)
             _args153399_)))
  (define std/net/httpd/server#start-http-server!
    (lambda _args153369153405_
      (apply keyword-dispatch
             '#(backlog: mux: #f sockopts:)
             std/net/httpd/server#start-http-server!__@
             _args153369153405_)))
  (define std/net/httpd/server#stop-http-server!
    (lambda (_httpd153358_)
      (let ((_tgroup153360_ (thread-thread-group _httpd153358_)))
        (with-unwind-protect
         (lambda ()
           (std/actor/message#send-message__0
            _httpd153358_
            (##structure
             std/actor/proto#!event::t
             (##structure std/net/httpd/server#httpd.shutdown::t)))
           (thread-join! _httpd153358_))
         (lambda () (std/misc/threads#thread-group-kill! _tgroup153360_))))))
  (define std/net/httpd/server#http-register-handler__%
    (lambda (_httpd153334_ _path153335_ _handler153336_ _host153337_)
      (if (string? _path153335_)
          (if (procedure? _handler153336_)
              (let ((_token153339_ (##structure std/actor/proto#!token::t))
                    (_dest153341_ _httpd153334_))
                (std/actor/message#send-message__%
                 _dest153341_
                 (##structure
                  std/actor/proto#!call::t
                  (##structure
                   std/net/httpd/server#httpd.register::t
                   _host153337_
                   _path153335_
                   _handler153336_)
                  _token153339_)
                 '#f
                 '#t)
                (std/actor/proto#!!call-recv _token153339_ _dest153341_))
              (error '"Bad handler; expected procedure" _handler153336_))
          (error '"Bad path; expected string" _path153335_))))
  (define std/net/httpd/server#http-register-handler__0
    (lambda (_httpd153347_ _path153348_ _handler153349_)
      (let ((_host153351_ '#f))
        (std/net/httpd/server#http-register-handler__%
         _httpd153347_
         _path153348_
         _handler153349_
         _host153351_))))
  (define std/net/httpd/server#http-register-handler
    (lambda _g153623_
      (let ((_g153622_ (length _g153623_)))
        (cond ((##fx= _g153622_ 3)
               (apply std/net/httpd/server#http-register-handler__0 _g153623_))
              ((##fx= _g153622_ 4)
               (apply std/net/httpd/server#http-register-handler__% _g153623_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/httpd/server#http-register-handler
                _g153623_))))))
  (define std/net/httpd/server#http-server
    (lambda (_socks153107_ _sas153108_ _mux153109_)
      (letrec* ((_get-handler153111_
                 (checked-bound-method-ref _mux153109_ 'get-handler))
                (_put-handler!153112_
                 (checked-bound-method-ref _mux153109_ 'put-handler!))
                (_acceptors153113_
                 (map (lambda (_sock153330_ _sa153331_)
                        (gerbil/gambit/threads#spawn/name
                         'http-server-accept
                         std/net/httpd/server#http-server-accept
                         _get-handler153111_
                         _sock153330_
                         (std/os/_socket#sockaddr_family _sa153331_)))
                      _socks153107_
                      _sas153108_))
                (_shutdown!153114_
                 (lambda ()
                   (for-each std/net/socket/api#ssocket-close _socks153107_)))
                (_monitor153115_
                 (lambda (_thread153321_)
                   (letrec ((_join153323_
                             (lambda (_server153325_ _thread153326_)
                               (with-exception-catcher
                                void
                                (lambda () (thread-join! _thread153326_)))
                               (std/actor/message#send-message__0
                                _server153325_
                                (##structure
                                 std/actor/proto#!event::t
                                 (##structure
                                  std/net/httpd/server#httpd.join::t
                                  _thread153326_))))))
                     (gerbil/gambit/threads#spawn/name
                      'http-server-monitor
                      _join153323_
                      (current-thread)
                      _thread153321_))))
                (_loop153116_
                 (lambda ()
                   (let _loop153128153130_ ()
                     (let ((_next153134_ (thread-mailbox-next)))
                       ((lambda (_$message153137_)
                          (let* ((_$message153139153149_ _$message153137_)
                                 (_else153141153157_
                                  (lambda () (_loop153128153130_)))
                                 (_K153143153298_
                                  (lambda (_$options153160_
                                           _$dest153162_
                                           _$source153164_
                                           _$value153166_)
                                    (let* ((_$value153185153205_
                                            _$value153166_)
                                           (_else153190153213_
                                            (lambda () (_loop153128153130_))))
                                      (let ((_K153198153272_
                                             (lambda (_k153267_
                                                      _handler153268_
                                                      _path153269_
                                                      _host153270_)
                                               (thread-mailbox-extract-and-rewind)
                                               (_put-handler!153112_
                                                _host153270_
                                                _path153269_
                                                _handler153268_)
                                               (std/actor/message#send-message__%
                                                _$source153164_
                                                (##structure
                                                 std/actor/proto#!value::t
                                                 '#!void
                                                 _k153267_)
                                                '#f
                                                '#f)
                                               (_loop153116_)))
                                            (_K153196153258_
                                             (lambda ()
                                               (thread-mailbox-extract-and-rewind)
                                               '#!void))
                                            (_K153193153242_
                                             (lambda (_thread153228_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g153229153231_)
                                                  (if ((lambda (_$obj153234_)
                                                         (uncaught-exception?
                                                          _$obj153234_))
                                                       _g153229153231_)
                                                      (let ((_e153237_
                                                             _g153229153231_))
                                                        (std/logger#log-error
                                                         '"acceptor error"
                                                         (uncaught-exception-reason
                                                          _e153237_)))
                                                      (if '#t
                                                          (let ((_e153239_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _g153229153231_))
                    (std/logger#log-error '"acceptor error" _e153239_))
                  (raise _g153229153231_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                (lambda ()
                                                  (thread-join! _thread153228_)
                                                  (std/logger#warning
                                                   '"acceptor thread ~a exited unexpectedly"
                                                   (thread-name
                                                    _thread153228_))))
                                               (_loop153116_)))
                                            (_K153192153219_
                                             (lambda (_bogus153217_)
                                               (thread-mailbox-extract-and-rewind)
                                               (std/logger#warning
                                                '"unexpected message ~a"
                                                _bogus153217_)
                                               (_loop153116_))))
                                        (let ((_try-match153187153264_
                                               (lambda ()
                                                 (if (##structure-direct-instance-of?
                                                      _$value153185153205_
                                                      'std/actor/proto#!event::t)
                                                     (let ((_e153197153261_
                                                            (##vector-ref
                                                             _$value153185153205_
                                                             '1)))
                                                       (if (##structure-direct-instance-of?
                                                            _e153197153261_
                                                            'std/net/httpd/server#httpd.shutdown::t)
                                                           (_K153196153258_)
                                                           (if (##structure-direct-instance-of?
                                                                _e153197153261_
                                                                'std/net/httpd/server#httpd.join::t)
                                                               (let* ((_e153195153248_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                               (##vector-ref _e153197153261_ '1))
                              (_thread153251_ _e153195153248_))
                         (_K153193153242_ _thread153251_))
                       (let ((_bogus153222_ _$value153185153205_))
                         (_K153192153219_ _bogus153222_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (let ((_bogus153222_
                                                            _$value153185153205_))
                                                       (_K153192153219_
                                                        _bogus153222_))))))
                                          (if (##structure-direct-instance-of?
                                               _$value153185153205_
                                               'std/actor/proto#!call::t)
                                              (let ((_e153199153275_
                                                     (##vector-ref
                                                      _$value153185153205_
                                                      '1)))
                                                (if (##structure-direct-instance-of?
                                                     _e153199153275_
                                                     'std/net/httpd/server#httpd.register::t)
                                                    (let* ((_e153201153278_
                                                            (##vector-ref
                                                             _e153199153275_
                                                             '1))
                                                           (_e153202153283_
                                                            (##vector-ref
                                                             _e153199153275_
                                                             '2))
                                                           (_e153203153288_
                                                            (##vector-ref
                                                             _e153199153275_
                                                             '3))
                                                           (_e153200153293_
                                                            (##vector-ref
                                                             _$value153185153205_
                                                             '2)))
                                                      (let ((_host153281_
                                                             _e153201153278_)
                                                            (_path153286_
                                                             _e153202153283_)
                                                            (_handler153291_
                                                             _e153203153288_)
                                                            (_k153296_
                                                             _e153200153293_))
                                                        (_K153198153272_
                                                         _k153296_
                                                         _handler153291_
                                                         _path153286_
                                                         _host153281_)))
                                                    (let ((_bogus153222_
                                                           _$value153185153205_))
                                                      (_K153192153219_
                                                       _bogus153222_))))
                                              (_try-match153187153264_))))))))
                            (if (##structure-direct-instance-of?
                                 _$message153139153149_
                                 'std/actor/message#message::t)
                                (let* ((_e153144153301_
                                        (##vector-ref
                                         _$message153139153149_
                                         '1))
                                       (_$value153304_ _e153144153301_)
                                       (_e153145153306_
                                        (##vector-ref
                                         _$message153139153149_
                                         '2))
                                       (_$source153309_ _e153145153306_)
                                       (_e153146153311_
                                        (##vector-ref
                                         _$message153139153149_
                                         '3))
                                       (_$dest153314_ _e153146153311_)
                                       (_e153147153316_
                                        (##vector-ref
                                         _$message153139153149_
                                         '4))
                                       (_$options153319_ _e153147153316_))
                                  (_K153143153298_
                                   _$options153319_
                                   _$dest153314_
                                   _$source153309_
                                   _$value153304_))
                                (_loop153128153130_))))
                        _next153134_))))))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g153117153120_)
              (if '#t
                  (let ((_e153123_ _g153117153120_))
                    (std/logger#log-error '"unhandled exception" _e153123_)
                    (raise _e153123_))
                  (raise _g153117153120_)))
            (lambda ()
              (for-each _monitor153115_ _acceptors153113_)
              (call-with-parameters
               (lambda () (_loop153116_))
               std/net/httpd/server#current-http-server
               (current-thread)))))
         (lambda () (_shutdown!153114_))))))
  (define std/net/httpd/server#http-server-accept
    (lambda (_get-handler153084_ _sock153085_ _safamily153086_)
      (letrec* ((_cliaddr153088_
                 (std/os/socket#make-socket-address _safamily153086_))
                (_loop153089_
                 (lambda ()
                   (let ((_clisock153105_
                          (std/net/socket/api#ssocket-accept__1
                           _sock153085_
                           _cliaddr153088_)))
                     (gerbil/gambit/threads#spawn/name
                      'http-request-handler
                      std/net/httpd/handler#http-request-handler
                      _get-handler153084_
                      _clisock153105_
                      (std/os/socket#socket-address->address _cliaddr153088_))
                     (_loop153089_)))))
        (let _again153091_ ()
          (with-exception-catcher
           (lambda (_g153093153095_)
             (if ((lambda (_$obj153098_) (os-exception? _$obj153098_))
                  _g153093153095_)
                 (let ((_e153101_ _g153093153095_))
                   (std/logger#log-error
                    '"error accepting connection"
                    _e153101_)
                   (_again153091_))
                 (raise _g153093153095_)))
           (lambda () (_loop153089_))))))))
