import pytest
from routersploit.core.exploit.utils import iter_modules


directory = "./routersploit/modules/exploits/"


@pytest.mark.parametrize("module", iter_modules(directory))
def test_exploit_trash_response(trash_target, module):
    exploit = module()
    exploit.target = trash_target.host
    exploit.port = trash_target.port

    assert exploit.check() in [True, False, None]


@pytest.mark.parametrize("module", iter_modules(directory))
def test_exploit_empty_response(empty_target, module):
    exploit = module()
    exploit.target = empty_target.host
    exploit.port = empty_target.port

    assert exploit.check() in [True, False, None]


@pytest.mark.parametrize("module", iter_modules(directory))
def test_exploit_not_found_response(not_found_target, module):
    exploit = module()
    exploit.target = not_found_target.host
    exploit.port = not_found_target.port

    assert exploit.check() in [True, False, None]


@pytest.mark.parametrize("module", iter_modules(directory))
def test_exploit_error_response(error_target, module):
    exploit = module()
    exploit.target = error_target.host
    exploit.port = error_target.port

    assert exploit.check() in [True, False, None]


@pytest.mark.parametrize("module", iter_modules(directory))
def test_exploit_redirect_response(redirect_target, module):
    exploit = module()
    exploit.target = redirect_target.host
    exploit.port = redirect_target.port

    assert exploit.check() in [True, False, None]


@pytest.mark.parametrize("module", iter_modules(directory))
def test_exploit_timeout_response(timeout_target, module):
    exploit = module()
    exploit.target = timeout_target.host
    exploit.port = timeout_target.port

    assert exploit.check() in [True, False, None]
