"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var chroma_js_1 = __importDefault(require("chroma-js"));
var d3_color_1 = require("d3-color");
exports.defaultColor = { r: 255, g: 0, b: 0, opacity: 1 };
exports.transparentColor = { r: 0, g: 0, b: 0, opacity: 0 };
exports.defaultD3Color = d3_color_1.rgb(exports.defaultColor.r, exports.defaultColor.g, exports.defaultColor.b, exports.defaultColor.opacity);
function stringToRGB(cssColorSpecifier, opacity) {
    if (cssColorSpecifier === 'transparent') {
        return exports.transparentColor;
    }
    var color = getColor(cssColorSpecifier);
    if (opacity === undefined) {
        return color;
    }
    var opacityOverride = typeof opacity === 'number' ? opacity : opacity(color.opacity);
    if (isNaN(opacityOverride)) {
        return color;
    }
    return __assign(__assign({}, color), { opacity: opacityOverride });
}
exports.stringToRGB = stringToRGB;
function getColor(cssColorSpecifier) {
    if (cssColorSpecifier === void 0) { cssColorSpecifier = ''; }
    var _a;
    var color;
    var endRegEx = /,\s*0+(\.0*)?\s*\)$/;
    if (/^(rgba|hsla)\(/i.test(cssColorSpecifier) && endRegEx.test(cssColorSpecifier)) {
        color = __assign(__assign({}, d3_color_1.rgb(cssColorSpecifier.replace(endRegEx, ',1)'))), { opacity: 0 });
    }
    else {
        color = d3_color_1.rgb(cssColorSpecifier);
    }
    return _a = validateColor(color), (_a !== null && _a !== void 0 ? _a : exports.defaultColor);
}
function validateColor(color) {
    var r = color.r, g = color.g, b = color.b, opacity = color.opacity;
    if (isNaN(r) || isNaN(g) || isNaN(b) || isNaN(opacity)) {
        return null;
    }
    return color;
}
exports.validateColor = validateColor;
function argsToRGB(r, g, b, opacity) {
    var _a;
    return _a = validateColor(d3_color_1.rgb(r, g, b, opacity)), (_a !== null && _a !== void 0 ? _a : exports.defaultD3Color);
}
exports.argsToRGB = argsToRGB;
function argsToRGBString(r, g, b, opacity) {
    return argsToRGB(r, g, b, opacity).toString();
}
exports.argsToRGBString = argsToRGBString;
function RGBtoString(rgb) {
    var r = rgb.r, g = rgb.g, b = rgb.b, opacity = rgb.opacity;
    return argsToRGBString(r, g, b, opacity);
}
exports.RGBtoString = RGBtoString;
function RGBATupleToString(rgba) {
    if (rgba.length === 4) {
        return "rgba(" + rgba[0] + ", " + rgba[1] + ", " + rgba[2] + ", " + rgba[3] + ")";
    }
    return "rgb(" + rgba[0] + ", " + rgba[1] + ", " + rgba[2] + ")";
}
exports.RGBATupleToString = RGBATupleToString;
function RGBAToHex(rgba) {
    return chroma_js_1.default(rgba).hex();
}
exports.RGBAToHex = RGBAToHex;
function HexToRGB(hex) {
    return chroma_js_1.default(hex).rgba();
}
exports.HexToRGB = HexToRGB;
//# sourceMappingURL=color_library_wrappers.js.map