"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var accessor_1 = require("../../../utils/accessor");
var geometry_1 = require("../../../utils/geometry");
var series_1 = require("../utils/series");
var specs_1 = require("../utils/specs");
exports.Y0_ACCESSOR_POSTFIX = ' - lower';
exports.Y1_ACCESSOR_POSTFIX = ' - upper';
function getHighligthedValues(tooltipValues, defaultValue) {
    var seriesTooltipValues = new Map();
    tooltipValues.forEach(function (_a) {
        var value = _a.value, seriesIdentifier = _a.seriesIdentifier, valueAccessor = _a.valueAccessor;
        var _b;
        var seriesValue = defaultValue || value;
        var current = (_b = seriesTooltipValues.get(seriesIdentifier.key), (_b !== null && _b !== void 0 ? _b : new Map()));
        if (defaultValue) {
            if (!current.has(geometry_1.BandedAccessorType.Y0)) {
                current.set(geometry_1.BandedAccessorType.Y0, defaultValue);
            }
            if (!current.has(geometry_1.BandedAccessorType.Y1)) {
                current.set(geometry_1.BandedAccessorType.Y1, defaultValue);
            }
        }
        if (valueAccessor != null && (valueAccessor === geometry_1.BandedAccessorType.Y0 || valueAccessor === geometry_1.BandedAccessorType.Y1)) {
            current.set(valueAccessor, seriesValue);
        }
        seriesTooltipValues.set(seriesIdentifier.key, current);
    });
    return seriesTooltipValues;
}
exports.getHighligthedValues = getHighligthedValues;
function formatTooltip(_a, spec, isHeader, isHighlighted, hasSingleSeries, axisSpec) {
    var color = _a.color, _b = _a.value, x = _b.x, y = _b.y, mark = _b.mark, accessor = _b.accessor, seriesIdentifier = _a.seriesIdentifier;
    var label = series_1.getSeriesName(seriesIdentifier, hasSingleSeries, true, spec);
    if (specs_1.isBandedSpec(spec.y0Accessors) && (specs_1.isAreaSeriesSpec(spec) || specs_1.isBarSeriesSpec(spec))) {
        var _c = spec.y0AccessorFormat, y0AccessorFormat = _c === void 0 ? exports.Y0_ACCESSOR_POSTFIX : _c, _d = spec.y1AccessorFormat, y1AccessorFormat = _d === void 0 ? exports.Y1_ACCESSOR_POSTFIX : _d;
        var formatter = accessor === geometry_1.BandedAccessorType.Y0 ? y0AccessorFormat : y1AccessorFormat;
        label = accessor_1.getAccessorFormatLabel(formatter, label);
    }
    var isFiltered = spec.filterSeriesInTooltip !== undefined ? spec.filterSeriesInTooltip(seriesIdentifier) : true;
    var isVisible = label === '' ? false : isFiltered;
    var value = isHeader ? x : y;
    var tickFormatOptions = spec.timeZone ? { timeZone: spec.timeZone } : undefined;
    return {
        seriesIdentifier: seriesIdentifier,
        valueAccessor: accessor,
        label: label,
        value: axisSpec ? axisSpec.tickFormat(value, tickFormatOptions) : emptyFormatter(value),
        markValue: isHeader || mark === null ? null : mark,
        color: color,
        isHighlighted: isHeader ? false : isHighlighted,
        isVisible: isVisible,
    };
}
exports.formatTooltip = formatTooltip;
function emptyFormatter(value) {
    return value;
}
//# sourceMappingURL=tooltip.js.map