"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function getSpecsFromStore(specs, chartType, specType) {
    return Object.keys(specs)
        .filter(function (specId) {
        var currentSpec = specs[specId];
        var sameChartType = currentSpec.chartType === chartType;
        var sameSpecType = specType ? currentSpec.specType === specType : true;
        return sameChartType && sameSpecType;
    })
        .map(function (specId) { return specs[specId]; });
}
exports.getSpecsFromStore = getSpecsFromStore;
function isClicking(prevClick, lastClick) {
    if (prevClick === null && lastClick !== null) {
        return true;
    }
    if (prevClick !== null && lastClick !== null && prevClick.time !== lastClick.time) {
        return true;
    }
    return false;
}
exports.isClicking = isClicking;
//# sourceMappingURL=utils.js.map