'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _constants = require('../constants');

var _array = require('./array');

var filterNested = function filterNested(nodes) {
  var l = nodes.length;
  var i = void 0;
  var j = void 0;
  for (i = 0; i < l; i += 1) {
    for (j = 0; j < l; j += 1) {
      if (i !== j) {
        if (nodes[i].contains(nodes[j])) {
          return filterNested(nodes.filter(function (x) {
            return x !== nodes[j];
          }));
        }
      }
    }
  }
  return nodes;
};

var getTopParent = function getTopParent(node) {
  return node.parentNode ? getTopParent(node.parentNode) : node;
};

var getAllAffectedNodes = function getAllAffectedNodes(node) {
  var group = node.getAttribute(_constants.FOCUS_GROUP);
  if (group) {
    return filterNested((0, _array.toArray)(getTopParent(node).querySelectorAll('[' + _constants.FOCUS_GROUP + '="' + group + '"]:not([' + _constants.FOCUS_DISABLED + '="disabled"])')));
  }
  return [node];
};

exports.default = getAllAffectedNodes;