function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useMemo } from 'react';
import { Route, Router, Switch } from 'react-router-dom';
import useObservable from 'react-use/lib/useObservable';
import { AppStatus } from '../types';
import { AppContainer } from './app_container';
import { ScopedHistory } from '../scoped_history';
export var AppRouter = function AppRouter(_ref) {
  var history = _ref.history,
      mounters = _ref.mounters,
      setAppLeaveHandler = _ref.setAppLeaveHandler,
      appStatuses$ = _ref.appStatuses$,
      setIsMounting = _ref.setIsMounting;
  var appStatuses = useObservable(appStatuses$, new Map());
  var createScopedHistory = useMemo(function () {
    return function (appPath) {
      return new ScopedHistory(history, appPath);
    };
  }, [history]);
  return /*#__PURE__*/React.createElement(Router, {
    history: history
  }, /*#__PURE__*/React.createElement(Switch, null, _toConsumableArray(mounters) // legacy apps can have multiple sub-apps registered with the same route
  // which needs additional logic that is handled in the catch-all route below
  .filter(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        _ = _ref3[0],
        mounter = _ref3[1];

    return !mounter.legacy;
  }).map(function (_ref4) {
    var _ref5 = _slicedToArray(_ref4, 2),
        appId = _ref5[0],
        mounter = _ref5[1];

    return /*#__PURE__*/React.createElement(Route, {
      key: mounter.appRoute,
      path: mounter.appRoute,
      exact: mounter.exactRoute,
      render: function render(_ref6) {
        var _appStatuses$get;

        var url = _ref6.match.url;
        return /*#__PURE__*/React.createElement(AppContainer, _extends({
          appPath: url,
          appStatus: (_appStatuses$get = appStatuses.get(appId)) !== null && _appStatuses$get !== void 0 ? _appStatuses$get : AppStatus.inaccessible,
          createScopedHistory: createScopedHistory
        }, {
          appId: appId,
          mounter: mounter,
          setAppLeaveHandler: setAppLeaveHandler,
          setIsMounting: setIsMounting
        }));
      }
    });
  }), /*#__PURE__*/React.createElement(Route, {
    path: "/app/:appId",
    render: function render(_ref7) {
      var _filter$, _appStatuses$get2;

      var _ref7$match = _ref7.match,
          appId = _ref7$match.params.appId,
          url = _ref7$match.url;

      // Find the mounter including legacy mounters with subapps:
      var _ref8 = mounters.has(appId) ? [appId, mounters.get(appId)] : (_filter$ = _toConsumableArray(mounters).filter(function (_ref10) {
        var _ref11 = _slicedToArray(_ref10, 1),
            key = _ref11[0];

        return key.split(':')[0] === appId;
      })[0]) !== null && _filter$ !== void 0 ? _filter$ : [],
          _ref9 = _slicedToArray(_ref8, 2),
          id = _ref9[0],
          mounter = _ref9[1];

      return /*#__PURE__*/React.createElement(AppContainer, _extends({
        appPath: url,
        appId: id,
        appStatus: (_appStatuses$get2 = appStatuses.get(id)) !== null && _appStatuses$get2 !== void 0 ? _appStatuses$get2 : AppStatus.inaccessible,
        createScopedHistory: createScopedHistory
      }, {
        mounter: mounter,
        setAppLeaveHandler: setAppLeaveHandler,
        setIsMounting: setIsMounting
      }));
    }
  })));
};