function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { EuiIcon, EuiContextMenuPanel, EuiContextMenuItem, EuiPopover } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
export var ConsoleMenu = /*#__PURE__*/function (_Component) {
  _inherits(ConsoleMenu, _Component);

  var _super = _createSuper(ConsoleMenu);

  function ConsoleMenu(props) {
    var _this;

    _classCallCheck(this, ConsoleMenu);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "mouseEnter", function () {
      if (_this.state.isPopoverOpen) return;

      _this.props.getCurl().then(function (text) {
        _this.setState({
          curlCode: text
        });
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onButtonClick", function () {
      _this.setState(function (prevState) {
        return {
          isPopoverOpen: !prevState.isPopoverOpen
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closePopover", function () {
      _this.setState({
        isPopoverOpen: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "openDocs", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var documentation;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _this.closePopover();

              _context.next = 3;
              return _this.props.getDocumentation();

            case 3:
              documentation = _context.sent;

              if (documentation) {
                _context.next = 6;
                break;
              }

              return _context.abrupt("return");

            case 6:
              window.open(documentation, '_blank');

            case 7:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(_assertThisInitialized(_this), "autoIndent", function (event) {
      _this.closePopover();

      _this.props.autoIndent(event);
    });

    _this.state = {
      curlCode: '',
      isPopoverOpen: false
    };
    return _this;
  }

  _createClass(ConsoleMenu, [{
    key: "copyAsCurl",
    value: function copyAsCurl() {
      this.copyText(this.state.curlCode);
      var addNotification = this.props.addNotification;

      if (addNotification) {
        addNotification({
          title: i18n.translate('console.consoleMenu.copyAsCurlMessage', {
            defaultMessage: 'Request copied as cURL'
          })
        });
      }
    }
  }, {
    key: "copyText",
    value: function copyText(text) {
      var textField = document.createElement('textarea');
      textField.innerText = text;
      document.body.appendChild(textField);
      textField.select();
      document.execCommand('copy');
      textField.remove();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var button = /*#__PURE__*/React.createElement("button", {
        className: "euiButtonIcon--primary",
        onClick: this.onButtonClick,
        "data-test-subj": "toggleConsoleMenu",
        "aria-label": i18n.translate('console.requestOptionsButtonAriaLabel', {
          defaultMessage: 'Request options'
        })
      }, /*#__PURE__*/React.createElement(EuiIcon, {
        type: "wrench"
      }));
      var items = [/*#__PURE__*/React.createElement(EuiContextMenuItem, {
        key: "Copy as cURL",
        id: "ConCopyAsCurl",
        disabled: !document.queryCommandSupported('copy'),
        onClick: function onClick() {
          _this2.closePopover();

          _this2.copyAsCurl();
        }
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "console.requestOptions.copyAsUrlButtonLabel",
        defaultMessage: "Copy as cURL"
      })), /*#__PURE__*/React.createElement(EuiContextMenuItem, {
        key: "Open documentation",
        "data-test-subj": "consoleMenuOpenDocs",
        onClick: function onClick() {
          _this2.openDocs();
        }
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "console.requestOptions.openDocumentationButtonLabel",
        defaultMessage: "Open documentation"
      })), /*#__PURE__*/React.createElement(EuiContextMenuItem, {
        "data-test-subj": "consoleMenuAutoIndent",
        key: "Auto indent",
        onClick: this.autoIndent
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "console.requestOptions.autoIndentButtonLabel",
        defaultMessage: "Auto indent"
      }))];
      return /*#__PURE__*/React.createElement("span", {
        onMouseEnter: this.mouseEnter
      }, /*#__PURE__*/React.createElement(EuiPopover, {
        id: "contextMenu",
        button: button,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        panelPaddingSize: "none",
        anchorPosition: "downLeft"
      }, /*#__PURE__*/React.createElement(EuiContextMenuPanel, {
        items: items
      })));
    }
  }]);

  return ConsoleMenu;
}(Component);