/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactDOM from 'react-dom';
import { I18nProvider } from '@kbn/i18n/react';
import { EuiWrappingPopover } from '@elastic/eui';
import { OptionsMenu } from './options';
var isOpen = false;
var container = document.createElement('div');

var onClose = function onClose() {
  ReactDOM.unmountComponentAtNode(container);
  isOpen = false;
};

export function showOptionsPopover(_ref) {
  var anchorElement = _ref.anchorElement,
      useMargins = _ref.useMargins,
      onUseMarginsChange = _ref.onUseMarginsChange,
      hidePanelTitles = _ref.hidePanelTitles,
      onHidePanelTitlesChange = _ref.onHidePanelTitlesChange;

  if (isOpen) {
    onClose();
    return;
  }

  isOpen = true;
  document.body.appendChild(container);
  var element = /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(EuiWrappingPopover, {
    id: "popover",
    button: anchorElement,
    isOpen: true,
    closePopover: onClose
  }, /*#__PURE__*/React.createElement(OptionsMenu, {
    useMargins: useMargins,
    onUseMarginsChange: onUseMarginsChange,
    hidePanelTitles: hidePanelTitles,
    onHidePanelTitlesChange: onHidePanelTitlesChange
  })));
  ReactDOM.render(element, container);
}