function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { set } from '@elastic/safer-lodash-set';
import { FormattedData } from '../../../../../plugins/inspector/public';
import { createFilter } from './create_filter';
/**
 * @deprecated
 *
 * Do not use this function.
 *
 * @todo This function is used only by Courier. Courier will
 *   soon be removed, and this function will be deleted, too. If Courier is not removed,
 *   move this function inside Courier.
 *
 * ---
 *
 * This function builds tabular data from the response and attaches it to the
 * inspector. It will only be called when the data view in the inspector is opened.
 */

export function buildTabularInspectorData(_x, _x2) {
  return _buildTabularInspectorData.apply(this, arguments);
}

function _buildTabularInspectorData() {
  _buildTabularInspectorData = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(table, _ref) {
    var queryFilter, deserializeFieldFormat, aggConfigs, rows, columns;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            queryFilter = _ref.queryFilter, deserializeFieldFormat = _ref.deserializeFieldFormat;
            aggConfigs = table.columns.map(function (column) {
              return column.aggConfig;
            });
            rows = table.rows.map(function (row) {
              return table.columns.reduce(function (prev, cur, colIndex) {
                var value = row[cur.id];
                var format = cur.aggConfig.toSerializedFieldFormat();

                if (Object.keys(format).length < 1) {
                  // If no format exists, fall back to string as a default
                  format = {
                    id: 'string'
                  };
                }

                var fieldFormatter = deserializeFieldFormat(format);
                prev["col-".concat(colIndex, "-").concat(cur.aggConfig.id)] = new FormattedData(value, fieldFormatter.convert(value));
                return prev;
              }, {});
            });
            columns = table.columns.map(function (col, colIndex) {
              var field = col.aggConfig.getField();
              var isCellContentFilterable = col.aggConfig.isFilterable() && (!field || field.filterable);
              return {
                name: col.name,
                field: "col-".concat(colIndex, "-").concat(col.aggConfig.id),
                filter: isCellContentFilterable && function (value) {
                  var rowIndex = rows.findIndex(function (row) {
                    return row["col-".concat(colIndex, "-").concat(col.aggConfig.id)].raw === value.raw;
                  });
                  var filter = createFilter(aggConfigs, table, colIndex, rowIndex, value.raw);

                  if (filter) {
                    queryFilter.addFilters(filter);
                  }
                },
                filterOut: isCellContentFilterable && function (value) {
                  var rowIndex = rows.findIndex(function (row) {
                    return row["col-".concat(colIndex, "-").concat(col.aggConfig.id)].raw === value.raw;
                  });
                  var filter = createFilter(aggConfigs, table, colIndex, rowIndex, value.raw);

                  if (filter) {
                    var notOther = value.raw !== '__other__';
                    var notMissing = value.raw !== '__missing__';

                    if (Array.isArray(filter)) {
                      filter.forEach(function (f) {
                        return set(f, 'meta.negate', notOther && notMissing);
                      });
                    } else {
                      set(filter, 'meta.negate', notOther && notMissing);
                    }

                    queryFilter.addFilters(filter);
                  }
                }
              };
            });
            return _context.abrupt("return", {
              columns: columns,
              rows: rows
            });

          case 5:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _buildTabularInspectorData.apply(this, arguments);
}