function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { getAngularModule, getServices } from '../../kibana_services'; // @ts-ignore

import { getRootBreadcrumbs } from '../helpers/breadcrumbs';
import html from './doc.html';
import { Doc } from '../components/doc/doc';

var _getServices = getServices(),
    timefilter = _getServices.timefilter;

var app = getAngularModule();
app.directive('discoverDoc', function (reactDirective) {
  return reactDirective(Doc, [['id', {
    watchDepth: 'value'
  }], ['index', {
    watchDepth: 'value'
  }], ['indexPatternId', {
    watchDepth: 'reference'
  }], ['indexPatternService', {
    watchDepth: 'reference'
  }], ['esClient', {
    watchDepth: 'reference'
  }]], {
    restrict: 'E'
  });
});
app.config(function ($routeProvider) {
  $routeProvider.when('/doc/:indexPattern/:index/:type', {
    redirectTo: '/doc/:indexPattern/:index'
  }) // the new route, es 7 deprecated types, es 8 removed them
  .when('/doc/:indexPattern/:index', {
    // have to be written as function expression, because it's not compiled in dev mode
    // eslint-disable-next-line object-shorthand
    controller: function controller($scope, $route, es) {
      timefilter.disableAutoRefreshSelector();
      timefilter.disableTimeRangeSelector();
      $scope.esClient = es;
      $scope.id = $route.current.params.id;
      $scope.index = $route.current.params.index;
      $scope.indexPatternId = $route.current.params.indexPattern;
      $scope.indexPatternService = getServices().indexPatterns;
    },
    template: html,
    k7Breadcrumbs: function k7Breadcrumbs($route) {
      return [].concat(_toConsumableArray(getRootBreadcrumbs()), [{
        text: "".concat($route.current.params.index, "#").concat($route.current.params.id)
      }]);
    }
  });
});