/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiBetaBadge, EuiSpacer, EuiTitle, EuiText, EuiCode, EuiLink } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { useKibana } from '../../../../../../../plugins/kibana_react/public';
export var Header = function Header(_ref) {
  var prompt = _ref.prompt,
      indexPatternName = _ref.indexPatternName,
      _ref$isBeta = _ref.isBeta,
      isBeta = _ref$isBeta === void 0 ? false : _ref$isBeta,
      docLinks = _ref.docLinks;
  var changeTitle = useKibana().services.chrome.docTitle.change;
  var createIndexPatternHeader = i18n.translate('indexPatternManagement.createIndexPatternHeader', {
    defaultMessage: 'Create {indexPatternName}',
    values: {
      indexPatternName: indexPatternName
    }
  });
  changeTitle(createIndexPatternHeader);
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiTitle, null, /*#__PURE__*/React.createElement("h1", null, createIndexPatternHeader, isBeta ? /*#__PURE__*/React.createElement(React.Fragment, null, ' ', /*#__PURE__*/React.createElement(EuiBetaBadge, {
    label: i18n.translate('indexPatternManagement.createIndexPattern.betaLabel', {
      defaultMessage: 'Beta'
    })
  })) : null)), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.description",
    defaultMessage: "An index pattern can match a single source, for example, {single}, or {multiple} data sources, {star}.",
    values: {
      multiple: /*#__PURE__*/React.createElement("strong", null, "multiple"),
      single: /*#__PURE__*/React.createElement(EuiCode, null, "filebeat-4-3-22"),
      star: /*#__PURE__*/React.createElement(EuiCode, null, "filebeat-*")
    }
  }), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(EuiLink, {
    href: docLinks.links.indexPatterns.introduction,
    target: "_blank",
    external: true
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.documentation",
    defaultMessage: "Read documentation"
  })))), prompt ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), prompt) : null);
};