function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { FormattedMessage } from '@kbn/i18n/react';
import PropTypes from 'prop-types';
import { i18n } from '@kbn/i18n';
import { EuiBadge, EuiButtonEmpty, EuiContextMenuPanel, EuiContextMenuItem, EuiFlexGroup, EuiFlexItem, EuiLoadingSpinner, EuiPopover, EuiTextColor, EuiToolTip } from '@elastic/eui';
import { RequestStatus } from '../../../../common/adapters';
export var RequestSelector = /*#__PURE__*/function (_Component) {
  _inherits(RequestSelector, _Component);

  var _super = _createSuper(RequestSelector);

  function RequestSelector() {
    var _this;

    _classCallCheck(this, RequestSelector);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isPopoverOpen: false
    });

    _defineProperty(_assertThisInitialized(_this), "togglePopover", function () {
      _this.setState(function (prevState) {
        return {
          isPopoverOpen: !prevState.isPopoverOpen
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closePopover", function () {
      _this.setState({
        isPopoverOpen: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "renderRequestDropdownItem", function (request, index) {
      var hasFailed = request.status === RequestStatus.ERROR;
      var inProgress = request.status === RequestStatus.PENDING;
      return /*#__PURE__*/React.createElement(EuiContextMenuItem, {
        key: index,
        icon: request === _this.props.selectedRequest ? 'check' : 'empty',
        onClick: function onClick() {
          _this.props.onRequestChanged(request);

          _this.closePopover();
        },
        toolTipContent: request.description,
        toolTipPosition: "left",
        "data-test-subj": "inspectorRequestChooser".concat(request.name)
      }, /*#__PURE__*/React.createElement(EuiTextColor, {
        color: hasFailed ? 'danger' : 'default'
      }, request.name, hasFailed && /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inspector.requests.failedLabel",
        defaultMessage: " (failed)"
      }), inProgress && /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
        size: "s",
        "aria-label": i18n.translate('inspector.requests.requestInProgressAriaLabel', {
          defaultMessage: 'Request in progress'
        }),
        className: "insRequestSelector__menuSpinner"
      })));
    });

    return _this;
  }

  _createClass(RequestSelector, [{
    key: "renderRequestDropdown",
    value: function renderRequestDropdown() {
      var button = /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        iconType: "arrowDown",
        iconSide: "right",
        size: "s",
        onClick: this.togglePopover,
        "data-test-subj": "inspectorRequestChooser"
      }, this.props.selectedRequest.name);
      return /*#__PURE__*/React.createElement(EuiPopover, {
        id: "inspectorRequestChooser",
        button: button,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        panelPaddingSize: "none",
        anchorPosition: "downLeft",
        repositionOnScroll: true
      }, /*#__PURE__*/React.createElement(EuiContextMenuPanel, {
        items: this.props.requests.map(this.renderRequestDropdownItem),
        "data-test-subj": "inspectorRequestChooserMenuPanel"
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          selectedRequest = _this$props.selectedRequest,
          requests = _this$props.requests;
      return /*#__PURE__*/React.createElement(EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement("strong", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inspector.requests.requestLabel",
        defaultMessage: "Request:"
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: true
      }, requests.length <= 1 && /*#__PURE__*/React.createElement("div", {
        className: "insRequestSelector__singleRequest",
        "data-test-subj": "inspectorRequestName"
      }, selectedRequest.name), requests.length > 1 && this.renderRequestDropdown()), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, selectedRequest.status !== RequestStatus.PENDING && /*#__PURE__*/React.createElement(EuiToolTip, {
        position: "left",
        title: selectedRequest.status === RequestStatus.OK ? /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inspector.requests.requestSucceededTooltipTitle",
          defaultMessage: "Request succeeded"
        }) : /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inspector.requests.requestFailedTooltipTitle",
          defaultMessage: "Request failed"
        }),
        content: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inspector.requests.requestTooltipDescription",
          defaultMessage: "The total time the request took."
        })
      }, /*#__PURE__*/React.createElement(EuiBadge, {
        color: selectedRequest.status === RequestStatus.OK ? 'secondary' : 'danger',
        iconType: selectedRequest.status === RequestStatus.OK ? 'check' : 'cross'
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inspector.requests.requestTimeLabel",
        defaultMessage: "{requestTime}ms",
        values: {
          requestTime: selectedRequest.time
        }
      }))), selectedRequest.status === RequestStatus.PENDING && /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
        size: "m",
        "aria-label": i18n.translate('inspector.requests.requestInProgressAriaLabel', {
          defaultMessage: 'Request in progress'
        })
      })));
    }
  }]);

  return RequestSelector;
}(Component);

_defineProperty(RequestSelector, "propTypes", {
  requests: PropTypes.array.isRequired,
  selectedRequest: PropTypes.object.isRequired,
  onRequestChanged: PropTypes.func
});