function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { orderBy } from 'lodash';
import React from 'react';
import { EuiFieldSearch, EuiFlexGroup, EuiFlexItem, EuiKeyPadMenu, EuiKeyPadMenuItem, EuiModalHeader, EuiModalHeaderTitle, EuiScreenReaderOnly, EuiSpacer, EuiTitle } from '@elastic/eui';
import { memoizeLast } from '../../legacy/memoize';
import { NewVisHelp } from './new_vis_help';
import { VisHelpText } from './vis_help_text';
import { VisTypeIcon } from './vis_type_icon';

var TypeSelection = /*#__PURE__*/function (_React$Component) {
  _inherits(TypeSelection, _React$Component);

  var _super = _createSuper(TypeSelection);

  function TypeSelection() {
    var _this;

    _classCallCheck(this, TypeSelection);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      highlightedType: null,
      query: ''
    });

    _defineProperty(_assertThisInitialized(_this), "getFilteredVisTypes", memoizeLast(_this.filteredVisTypes));

    _defineProperty(_assertThisInitialized(_this), "renderVisType", function (visType) {
      var stage = {};
      var highlightMsg;

      if (!('aliasPath' in visType) && visType.stage === 'experimental') {
        stage = {
          betaBadgeLabel: i18n.translate('visualizations.newVisWizard.experimentalTitle', {
            defaultMessage: 'Experimental'
          }),
          betaBadgeTooltipContent: i18n.translate('visualizations.newVisWizard.experimentalTooltip', {
            defaultMessage: 'This visualization might be changed or removed in a future release and is not subject to the support SLA.'
          })
        };
        highlightMsg = i18n.translate('visualizations.newVisWizard.experimentalDescription', {
          defaultMessage: 'This visualization is experimental. The design and implementation are less mature than stable visualizations and might be subject to change.'
        });
      } else if ('aliasPath' in visType) {
        if (visType.stage === 'beta') {
          var aliasDescription = i18n.translate('visualizations.newVisWizard.betaDescription', {
            defaultMessage: 'This visualization is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features'
          });
          stage = {
            betaBadgeLabel: i18n.translate('visualizations.newVisWizard.betaTitle', {
              defaultMessage: 'Beta'
            }),
            betaBadgeTooltipContent: aliasDescription // betaBadgeIconType: 'popout',

          };
          highlightMsg = aliasDescription;
        } else {
          var _aliasDescription = i18n.translate('visualizations.newVisWizard.visTypeAliasDescription', {
            defaultMessage: 'Opens a Kibana application that is outside of Visualize.'
          });

          stage = {
            betaBadgeLabel: i18n.translate('visualizations.newVisWizard.visTypeAliasTitle', {
              defaultMessage: 'Kibana application'
            }),
            betaBadgeTooltipContent: _aliasDescription,
            betaBadgeIconType: 'popout'
          };
          highlightMsg = _aliasDescription;
        }
      }

      var isDisabled = _this.state.query !== '' && !visType.highlighted;

      var onClick = function onClick() {
        return _this.props.onVisTypeSelected(visType);
      };

      var highlightedType = {
        title: visType.title,
        name: visType.name,
        description: visType.description,
        highlightMsg: highlightMsg
      };
      return /*#__PURE__*/React.createElement(EuiKeyPadMenuItem, _extends({
        key: visType.name,
        label: /*#__PURE__*/React.createElement("span", {
          "data-test-subj": "visTypeTitle"
        }, visType.title),
        onClick: onClick,
        onFocus: function onFocus() {
          return _this.setHighlightType(highlightedType);
        },
        onMouseEnter: function onMouseEnter() {
          return _this.setHighlightType(highlightedType);
        },
        onMouseLeave: function onMouseLeave() {
          return _this.setHighlightType(null);
        },
        onBlur: function onBlur() {
          return _this.setHighlightType(null);
        },
        className: "visNewVisDialog__type",
        "data-test-subj": "visType-".concat(visType.name),
        "data-vis-stage": !('aliasPath' in visType) ? visType.stage : 'alias',
        disabled: isDisabled,
        "aria-describedby": "visTypeDescription-".concat(visType.name),
        role: "menuitem"
      }, stage), /*#__PURE__*/React.createElement(VisTypeIcon, {
        icon: visType.icon,
        image: !('aliasPath' in visType) ? visType.image : undefined
      }));
    });

    _defineProperty(_assertThisInitialized(_this), "onQueryChange", function (ev) {
      _this.setState({
        query: ev.target.value
      });
    });

    return _this;
  }

  _createClass(TypeSelection, [{
    key: "render",
    value: function render() {
      var _this$state = this.state,
          query = _this$state.query,
          highlightedType = _this$state.highlightedType;
      var visTypes = this.getFilteredVisTypes(this.props.visTypesRegistry, query);
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiModalHeader, null, /*#__PURE__*/React.createElement(EuiModalHeaderTitle, null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "visualizations.newVisWizard.title",
        defaultMessage: "New Visualization"
      }))), /*#__PURE__*/React.createElement("div", {
        className: "visNewVisDialog__body"
      }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        gutterSize: "xl"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        className: "visNewVisDialog__list",
        direction: "column",
        gutterSize: "none",
        responsive: false
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false,
        className: "visNewVisDialog__searchWrapper"
      }, /*#__PURE__*/React.createElement(EuiFieldSearch, {
        placeholder: "Filter",
        value: query,
        onChange: this.onQueryChange,
        fullWidth: true,
        "data-test-subj": "filterVisType",
        "aria-label": i18n.translate('visualizations.newVisWizard.filterVisTypeAriaLabel', {
          defaultMessage: 'Filter for a visualization type'
        })
      })), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: 1,
        className: "visNewVisDialog__typesWrapper"
      }, /*#__PURE__*/React.createElement(EuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("span", {
        "aria-live": "polite"
      }, query && /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "visualizations.newVisWizard.resultsFound",
        defaultMessage: "{resultCount} {resultCount, plural, one {type} other {types} } found",
        values: {
          resultCount: visTypes.filter(function (type) {
            return type.highlighted;
          }).length
        }
      }))), /*#__PURE__*/React.createElement(EuiKeyPadMenu, {
        className: "visNewVisDialog__types",
        "data-test-subj": "visNewDialogTypes"
      }, visTypes.map(this.renderVisType))))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        className: "visNewVisDialog__description",
        grow: false
      }, highlightedType ? /*#__PURE__*/React.createElement(VisHelpText, highlightedType) : /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiTitle, {
        size: "s"
      }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "visualizations.newVisWizard.selectVisType",
        defaultMessage: "Select a visualization type"
      }))), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(NewVisHelp, {
        promotedTypes: visTypes.filter(function (t) {
          return t.promotion;
        }),
        onPromotionClicked: this.props.onVisTypeSelected
      }))))));
    }
  }, {
    key: "filteredVisTypes",
    value: function filteredVisTypes(visTypes, query) {
      var _this2 = this;

      var types = visTypes.all().filter(function (type) {
        // Filter out all lab visualizations if lab mode is not enabled
        if (!_this2.props.showExperimental && type.stage === 'experimental') {
          return false;
        } // Filter out hidden visualizations


        if (type.hidden) {
          return false;
        }

        return true;
      });
      var allTypes = [].concat(_toConsumableArray(types), _toConsumableArray(visTypes.getAliases()));
      var entries;

      if (!query) {
        entries = allTypes.map(function (type) {
          return _objectSpread(_objectSpread({}, type), {}, {
            highlighted: false
          });
        });
      } else {
        var q = query.toLowerCase();
        entries = allTypes.map(function (type) {
          var matchesQuery = type.name.toLowerCase().includes(q) || type.title.toLowerCase().includes(q) || typeof type.description === 'string' && type.description.toLowerCase().includes(q);
          return _objectSpread(_objectSpread({}, type), {}, {
            highlighted: matchesQuery
          });
        });
      }

      return orderBy(entries, ['highlighted', 'promotion', 'title'], ['desc', 'asc', 'asc']);
    }
  }, {
    key: "setHighlightType",
    value: function setHighlightType(highlightedType) {
      this.setState({
        highlightedType: highlightedType
      });
    }
  }]);

  return TypeSelection;
}(React.Component);

export { TypeSelection };