/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.norm;

import java.util.LinkedHashMap;
import org.apache.solr.ltr.norm.Normalizer;
import org.apache.solr.ltr.norm.NormalizerException;

public class StandardNormalizer
extends Normalizer {
    private float avg = 0.0f;
    private float std = 1.0f;

    public float getAvg() {
        return this.avg;
    }

    public void setAvg(float avg) {
        this.avg = avg;
    }

    public float getStd() {
        return this.std;
    }

    public void setStd(float std) {
        this.std = std;
    }

    public void setAvg(String avg) {
        this.avg = Float.parseFloat(avg);
    }

    public void setStd(String std) {
        this.std = Float.parseFloat(std);
    }

    @Override
    public float normalize(float value) {
        return (value - this.avg) / this.std;
    }

    @Override
    protected void validate() throws NormalizerException {
        if (this.std <= 0.0f) {
            throw new NormalizerException("Standard Normalizer standard deviation must be positive | avg = " + this.avg + ",std = " + this.std);
        }
    }

    @Override
    public LinkedHashMap<String, Object> paramsToMap() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(2, 1.0f);
        params.put("avg", Float.toString(this.avg));
        params.put("std", Float.toString(this.std));
        return params;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName()).append('(');
        sb.append("avg=").append(this.avg);
        sb.append(",std=").append(this.avg).append(')');
        return sb.toString();
    }
}

