/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.suggest.DictionaryFactory;
import org.apache.solr.spelling.suggest.LookupFactory;
import org.apache.solr.spelling.suggest.SuggesterOptions;
import org.apache.solr.spelling.suggest.SuggesterResult;
import org.apache.solr.update.SolrCoreState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSuggester
implements Accountable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_DICT_NAME = "default";
    public static final String LOCATION = "sourceLocation";
    public static final String LOOKUP_IMPL = "lookupImpl";
    public static final String DICTIONARY_IMPL = "dictionaryImpl";
    public static final String STORE_DIR = "storeDir";
    static SuggesterResult EMPTY_RESULT = new SuggesterResult();
    private String sourceLocation;
    private File storeDir;
    private Dictionary dictionary;
    private Lookup lookup;
    private String lookupImpl;
    private String dictionaryImpl;
    private String name;
    private LookupFactory factory;
    private DictionaryFactory dictionaryFactory;
    private Analyzer contextFilterQueryAnalyzer;

    public String init(NamedList<?> config, SolrCore core) {
        log.info("init: {}", config);
        this.name = config.get("name") != null ? (String)config.get("name") : DEFAULT_DICT_NAME;
        this.sourceLocation = (String)config.get(LOCATION);
        this.lookupImpl = (String)config.get(LOOKUP_IMPL);
        this.dictionaryImpl = (String)config.get(DICTIONARY_IMPL);
        String store = (String)config.get(STORE_DIR);
        if (this.lookupImpl == null) {
            this.lookupImpl = LookupFactory.DEFAULT_FILE_BASED_DICT;
            log.info("No {} parameter was provided falling back to {}", (Object)LOOKUP_IMPL, (Object)this.lookupImpl);
        }
        this.contextFilterQueryAnalyzer = new TokenizerChain((TokenizerFactory)new StandardTokenizerFactory(Collections.EMPTY_MAP), null);
        this.factory = core.getResourceLoader().newInstance(this.lookupImpl, LookupFactory.class);
        this.lookup = this.factory.create(config, core);
        if (this.lookup != null && this.lookup instanceof Closeable) {
            core.addCloseHook(new CloseHook(){

                @Override
                public void preClose(SolrCore core) {
                    try {
                        ((Closeable)SolrSuggester.this.lookup).close();
                    }
                    catch (IOException e) {
                        log.warn("Could not close the suggester lookup.", (Throwable)e);
                    }
                }

                @Override
                public void postClose(SolrCore core) {
                }
            });
        }
        if (store != null && !store.isEmpty()) {
            this.storeDir = new File(store);
            if (!this.storeDir.isAbsolute()) {
                this.storeDir = new File(core.getDataDir() + File.separator + this.storeDir);
            }
            if (!this.storeDir.exists()) {
                this.storeDir.mkdirs();
            } else if (this.getStoreFile().exists()) {
                if (log.isDebugEnabled()) {
                    log.debug("attempt reload of the stored lookup from file {}", (Object)this.getStoreFile());
                }
                try {
                    this.lookup.load((InputStream)new FileInputStream(this.getStoreFile()));
                }
                catch (IOException e) {
                    log.warn("Loading stored lookup data failed, possibly not cached yet");
                }
            }
        }
        if (this.dictionaryImpl == null) {
            this.dictionaryImpl = this.sourceLocation == null ? DictionaryFactory.DEFAULT_INDEX_BASED_DICT : DictionaryFactory.DEFAULT_FILE_BASED_DICT;
            log.info("No {} parameter was provided falling back to {}", (Object)DICTIONARY_IMPL, (Object)this.dictionaryImpl);
        }
        this.dictionaryFactory = core.getResourceLoader().newInstance(this.dictionaryImpl, DictionaryFactory.class);
        this.dictionaryFactory.setParams(config);
        log.info("Dictionary loaded with params: {}", config);
        return this.name;
    }

    public void build(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        log.info("SolrSuggester.build({})", (Object)this.name);
        this.dictionary = this.dictionaryFactory.create(core, searcher);
        try {
            this.lookup.build(this.dictionary);
        }
        catch (AlreadyClosedException e) {
            SolrCoreState.CoreIsClosedException e2 = new SolrCoreState.CoreIsClosedException("Suggester build has been interrupted by a core reload or shutdown.");
            ((Throwable)((Object)e2)).initCause(e);
            throw e2;
        }
        if (this.storeDir != null) {
            File target = this.getStoreFile();
            if (!this.lookup.store((OutputStream)new FileOutputStream(target))) {
                log.error("Store Lookup build failed");
            } else if (log.isInfoEnabled()) {
                log.info("Stored suggest data to: {}", (Object)target.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        block3: {
            block4: {
                FileInputStream is;
                block2: {
                    log.info("SolrSuggester.reload({})", (Object)this.name);
                    if (this.dictionary != null || this.storeDir == null) break block3;
                    File lookupFile = this.getStoreFile();
                    if (!lookupFile.exists()) break block4;
                    is = new FileInputStream(lookupFile);
                    try {
                        if (!this.lookup.load((InputStream)is)) break block2;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                    return;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                break block3;
            }
            log.info("lookup file doesn't exist");
        }
    }

    public File getStoreFile() {
        if (this.storeDir == null) {
            return null;
        }
        return new File(this.storeDir, this.factory.storeFileName());
    }

    public SuggesterResult getSuggestions(SuggesterOptions options) throws IOException {
        List suggestions;
        if (log.isDebugEnabled()) {
            log.debug("getSuggestions: {}", (Object)options.token);
        }
        if (this.lookup == null) {
            log.info("Lookup is null - invoke suggest.build first");
            return EMPTY_RESULT;
        }
        SuggesterResult res = new SuggesterResult();
        if (options.contextFilterQuery == null) {
            suggestions = this.lookup.lookup((CharSequence)options.token, false, options.count);
        } else {
            BooleanQuery query = this.parseContextFilterQuery(options.contextFilterQuery);
            suggestions = this.lookup.lookup((CharSequence)options.token, query, options.count, options.allTermsRequired, options.highlight);
            if (suggestions == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Context Filtering Query not supported by {}", this.lookup.getClass());
                }
                suggestions = this.lookup.lookup((CharSequence)options.token, false, options.count);
            }
        }
        res.add(this.getName(), options.token.toString(), suggestions);
        return res;
    }

    private BooleanQuery parseContextFilterQuery(String contextFilter) {
        if (contextFilter == null) {
            return null;
        }
        Query query = null;
        try {
            query = new StandardQueryParser(this.contextFilterQueryAnalyzer).parse(contextFilter, "contexts");
            if (query instanceof BooleanQuery) {
                return (BooleanQuery)query;
            }
            return new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).build();
        }
        catch (QueryNodeException e) {
            throw new IllegalArgumentException("Failed to parse query: " + query);
        }
    }

    public String getName() {
        return this.name;
    }

    public long ramBytesUsed() {
        return this.lookup.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        return this.lookup.getChildResources();
    }

    public String toString() {
        return "SolrSuggester [ name=" + this.name + ", sourceLocation=" + this.sourceLocation + ", storeDir=" + (this.storeDir == null ? "" : this.storeDir.getAbsoluteFile()) + ", lookupImpl=" + this.lookupImpl + ", dictionaryImpl=" + this.dictionaryImpl + ", sizeInBytes=" + (this.lookup != null ? String.valueOf(this.ramBytesUsed()) : "0") + " ]";
    }
}

