/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.exception;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.exception.JsonQueryException;

public class JsonQueryTypeException
extends JsonQueryException {
    private static final long serialVersionUID = -2719442463094461632L;
    private static final int MAX_JSON_STRING_LENGTH = 14;

    private static String truncate(String text, int len) {
        if (text.length() <= len) {
            return text;
        }
        return text.substring(0, len - 3) + "...";
    }

    public JsonQueryTypeException(JsonNode obj, String msg) {
        super(String.format("%s (%s) %s", obj.getNodeType().toString().toLowerCase(), JsonQueryTypeException.truncate(obj.toString(), 14), msg));
    }

    public JsonQueryTypeException(JsonNode obj1, JsonNode obj2, String msg) {
        super(String.format("%s (%s) and %s (%s) %s", obj1.getNodeType().toString().toLowerCase(), JsonQueryTypeException.truncate(obj1.toString(), 14), obj2.getNodeType().toString().toLowerCase(), JsonQueryTypeException.truncate(obj2.toString(), 14), msg));
    }
}

