/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class MultipleAddresses {
    public static final Duration DEFAULT_TIMEOUT = Duration.ofMillis(1000L);
    private Set<InetSocketAddress> addresses = MultipleAddresses.newConcurrentHashSet();
    private final Duration timeout;

    private static Set<InetSocketAddress> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public MultipleAddresses() {
        this(Collections.emptyList());
    }

    public MultipleAddresses(Collection<InetSocketAddress> addresses) {
        this(addresses, DEFAULT_TIMEOUT);
    }

    public MultipleAddresses(InetSocketAddress address) {
        this(Arrays.asList(address), DEFAULT_TIMEOUT);
    }

    public MultipleAddresses(Collection<InetSocketAddress> addresses, Duration timeout) {
        this.addresses.addAll(addresses);
        this.timeout = timeout;
    }

    public boolean isEmpty() {
        return this.addresses.isEmpty();
    }

    public Set<InetSocketAddress> getAllAddresses() {
        return Collections.unmodifiableSet(this.addresses);
    }

    public Set<InetSocketAddress> getWildcardAddresses() {
        return this.addresses.stream().map(a -> new InetSocketAddress(a.getPort())).collect(Collectors.toSet());
    }

    public List<Integer> getAllPorts() {
        return this.addresses.stream().map(InetSocketAddress::getPort).distinct().collect(Collectors.toList());
    }

    public List<String> getAllHostStrings() {
        return this.addresses.stream().map(InetSocketAddress::getHostString).distinct().collect(Collectors.toList());
    }

    public void addAddress(InetSocketAddress address) {
        this.addresses.add(address);
    }

    public InetSocketAddress getReachableAddress() throws NoRouteToHostException {
        return this.addresses.parallelStream().filter(this::checkIfAddressIsReachable).findAny().orElseThrow(() -> new NoRouteToHostException("No valid address among " + this.addresses));
    }

    public Set<InetSocketAddress> getAllReachableAddresses() {
        return this.addresses.parallelStream().filter(this::checkIfAddressIsReachable).collect(Collectors.toSet());
    }

    public Set<InetSocketAddress> getAllReachableAddressesOrAll() {
        if (this.addresses.size() == 1) {
            return this.getAllAddresses();
        }
        Set<InetSocketAddress> allReachable = this.getAllReachableAddresses();
        if (allReachable.isEmpty()) {
            return this.getAllAddresses();
        }
        return allReachable;
    }

    public InetSocketAddress getReachableOrOne() {
        InetSocketAddress address;
        if (this.addresses.size() == 1) {
            return this.getOne();
        }
        try {
            address = this.getReachableAddress();
        }
        catch (NoRouteToHostException e) {
            address = this.getOne();
        }
        return address;
    }

    public void recreateSocketAddresses() {
        this.addresses = this.addresses.parallelStream().map(this::recreateSocketAddress).collect(Collectors.toCollection(MultipleAddresses::newConcurrentHashSet));
    }

    public InetSocketAddress getOne() {
        return this.addresses.iterator().next();
    }

    public int size() {
        return this.addresses.size();
    }

    private boolean checkIfAddressIsReachable(InetSocketAddress address) {
        if (address.isUnresolved()) {
            return false;
        }
        try {
            if (address.getAddress().isReachable((int)this.timeout.toMillis())) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private InetSocketAddress recreateSocketAddress(InetSocketAddress address) {
        try {
            return new InetSocketAddress(InetAddress.getByName(address.getHostString()), address.getPort());
        }
        catch (UnknownHostException e) {
            return address;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleAddresses that = (MultipleAddresses)o;
        return Objects.equals(this.addresses, that.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.addresses);
    }

    public String toString() {
        return this.addresses.stream().map(InetSocketAddress::toString).collect(Collectors.joining("|"));
    }
}

