/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.plugin.AbstractProvisionCommand;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.xml.ProvisioningXmlParser;

public class ProvisionCommand
extends AbstractProvisionCommand {
    public ProvisionCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected String getDescription() {
        return "Provision an installation from a provisioning file";
    }

    @Override
    protected List<AbstractDynamicCommand.DynamicOption> getDynamicOptions(State state) throws Exception {
        ArrayList<AbstractDynamicCommand.DynamicOption> options = new ArrayList<AbstractDynamicCommand.DynamicOption>();
        String file = this.getFile();
        if (file == null) {
            return Collections.emptyList();
        }
        ProvisioningConfig config = ProvisioningXmlParser.parse(this.getAbsolutePath(file, this.pmSession.getAeshContext()));
        Set<ProvisioningOption> opts = this.pmSession.getResolver().get(null, PluginResolver.newResolver(this.pmSession, config)).getInstall();
        for (ProvisioningOption opt : opts) {
            AbstractDynamicCommand.DynamicOption dynOption = new AbstractDynamicCommand.DynamicOption(opt.getName(), opt.isRequired());
            options.add(dynOption);
        }
        return options;
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("").hasValue(true).description("File describing the desired provisioned state").type(String.class).optionType(OptionType.ARGUMENT).completer(FileOptionCompleter.class).build());
        return options;
    }

    @Override
    protected PmCommandActivator getActivator() {
        return null;
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
        String filePath = this.getFile();
        if (filePath != null) {
            try {
                if (!Files.exists(this.getAbsolutePath(filePath, invoc.getConfiguration().getAeshContext()), new LinkOption[0])) {
                    throw new CommandExecutionException(filePath + " doesn't exist");
                }
            }
            catch (IOException ex) {
                throw new CommandExecutionException(ex.getMessage());
            }
        }
    }

    private String getFile() {
        String file = (String)this.getValue("");
        if (file == null) {
            file = this.getArgumentValue();
        }
        return file;
    }

    @Override
    protected void doRunCommand(PmCommandInvocation invoc, Map<String, String> options) throws CommandExecutionException {
        String file = this.getFile();
        if (file == null) {
            throw new CommandExecutionException("No provisioning file provided.");
        }
        try {
            Path provisioningFile = this.getAbsolutePath(file, invoc.getConfiguration().getAeshContext());
            if (!Files.exists(provisioningFile, new LinkOption[0])) {
                throw new CommandExecutionException("Failed to locate provisioning file " + provisioningFile.toAbsolutePath());
            }
            this.getManager(invoc).provision(provisioningFile, options);
        }
        catch (IOException | ProvisioningException e) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.provisioningFailed(), e);
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }
}

