/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.CapabilityProvider;
import org.jboss.galleon.runtime.ConfigFeatureBranch;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedFeatureParam;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.runtime.SpecFeatures;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.type.FeatureParameterType;
import org.jboss.galleon.util.CollectionUtils;

public class ResolvedFeature
extends CapabilityProvider
implements ProvisionedFeature {
    private static final byte FREE = 0;
    private static final byte SCHEDULED = 1;
    private static final byte ORDERED = 2;
    final int includeNo;
    final ResolvedFeatureId id;
    final ResolvedFeatureSpec spec;
    Map<String, Object> params;
    Set<String> resetParams = Collections.emptySet();
    Set<String> unsetParams = Collections.emptySet();
    Map<ResolvedFeatureId, FeatureDependencySpec> deps;
    private byte orderingState = 0;
    private boolean batchStart;
    private boolean batchEnd;
    private boolean branchStart;
    private boolean branchEnd;
    private SpecFeatures specFeatures;
    ConfigFeatureBranch branch;
    List<ResolvedFeature> branchDependees;
    Map<ConfigFeatureBranch, Boolean> branchDeps = new HashMap<ConfigFeatureBranch, Boolean>();

    ResolvedFeature(ResolvedFeatureId id, ResolvedFeatureSpec spec, int includeNo) {
        this.includeNo = includeNo;
        this.id = id;
        this.spec = spec;
        this.params = id == null ? new HashMap<String, Object>() : new HashMap<String, Object>(id.params);
    }

    ResolvedFeature(ResolvedFeatureId id, ResolvedFeatureSpec spec, Map<String, Object> params, Map<ResolvedFeatureId, FeatureDependencySpec> resolvedDeps, int includeNo) throws ProvisioningException {
        this.includeNo = includeNo;
        this.id = id;
        this.spec = spec;
        this.deps = resolvedDeps;
        Map<String, Object> map = this.params = id == null ? new HashMap<String, Object>() : new HashMap<String, Object>(id.params);
        if (!params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                this.setParam(entry.getKey(), entry.getValue(), true);
            }
        }
    }

    ResolvedFeature copy(int includeNo) throws ProvisioningException {
        ResolvedFeature copy = new ResolvedFeature(this.id, this.spec, this.params.size() > 1 ? new HashMap<String, Object>(this.params) : this.params, this.deps.size() > 1 ? new LinkedHashMap<ResolvedFeatureId, FeatureDependencySpec>(this.deps) : this.deps, includeNo);
        if (!this.resetParams.isEmpty()) {
            copy.resetParams = CollectionUtils.clone(this.resetParams);
        }
        if (!this.unsetParams.isEmpty()) {
            copy.unsetParams = CollectionUtils.clone(this.unsetParams);
        }
        return copy;
    }

    void validate() throws ProvisioningDescriptionException {
        for (Map.Entry<String, ResolvedFeatureParam> entry : this.spec.getResolvedParams().entrySet()) {
            ResolvedFeatureParam param = entry.getValue();
            if (this.params.containsKey(entry.getKey())) continue;
            if (param.defaultValue == null || this.unsetParams.contains(entry.getKey())) {
                if (param.spec.isNillable()) continue;
                throw new ProvisioningDescriptionException(Errors.nonNillableParameterIsNull(this, entry.getKey()));
            }
            this.params.put(entry.getKey(), param.defaultValue);
        }
    }

    boolean isFree() {
        return this.orderingState == 0;
    }

    boolean isOrdered() {
        return this.orderingState == 2;
    }

    void schedule() {
        if (this.orderingState != 0) {
            throw new IllegalStateException();
        }
        this.orderingState = 1;
    }

    void ordered() throws ProvisioningDescriptionException {
        this.validate();
        if (this.orderingState != 1) {
            throw new IllegalStateException();
        }
        this.orderingState = (byte)2;
        this.provided(this.branch);
        this.spec.provided(this.branch);
    }

    void free() {
        this.orderingState = 0;
        this.branchDeps.clear();
    }

    void addBranchDep(ConfigFeatureBranch branchDep, boolean child) {
        Boolean prevChild = this.branchDeps.get(branchDep);
        if ((prevChild == null || !prevChild.booleanValue() && child) && this.branchDeps.put(branchDep, child) != null && this.branch != null) {
            this.branch.addBranchDep(branchDep);
        }
    }

    void addBranchDependee(ResolvedFeature feature) {
        if (this.branchDependees == null) {
            this.branchDependees = new ArrayList<ResolvedFeature>();
        }
        this.branchDependees.add(feature);
    }

    void setBranch(ConfigFeatureBranch branch) throws ProvisioningException {
        this.branch = branch;
        if (this.branchDeps.size() > 1 || !this.branchDeps.containsKey(branch)) {
            for (ConfigFeatureBranch branchDep : this.branchDeps.keySet()) {
                if (branch.id.equals(branchDep.id)) continue;
                branch.addBranchDep(branchDep);
            }
        }
        if (this.branchDependees != null) {
            for (ResolvedFeature branchDependee : this.branchDependees) {
                branchDependee.addBranchDep(branch, false);
            }
            this.branchDependees = null;
        }
        this.ordered();
    }

    void startBatch() {
        this.batchStart = true;
    }

    void endBatch() {
        this.batchEnd = true;
    }

    boolean isBatchStart() {
        return this.batchStart;
    }

    void clearBatchStart() {
        this.batchStart = false;
    }

    boolean isBatchEnd() {
        return this.batchEnd;
    }

    void clearBatchEnd() {
        this.batchEnd = false;
    }

    void startBranch() {
        this.branchStart = true;
    }

    void clearStartBranch() {
        this.branchStart = false;
    }

    void endBranch() {
        this.branchEnd = true;
    }

    void clearEndBranch() {
        this.branchEnd = false;
    }

    boolean isBranchStart() {
        return this.branchStart;
    }

    boolean isBranchEnd() {
        return this.branchEnd;
    }

    public void addDependency(ResolvedFeatureId id, FeatureDependencySpec depSpec) throws ProvisioningDescriptionException {
        if (this.deps.containsKey(id)) {
            throw new ProvisioningDescriptionException("Duplicate dependency on " + id + " from " + this.id);
        }
        this.deps = CollectionUtils.putLinked(this.deps, id, depSpec);
    }

    @Override
    public boolean hasId() {
        return this.id != null;
    }

    @Override
    public ResolvedFeatureId getId() {
        return this.id;
    }

    @Override
    public ResolvedSpecId getSpecId() {
        return this.spec.id;
    }

    @Override
    public boolean hasParams() {
        return !this.params.isEmpty();
    }

    @Override
    public Collection<String> getParamNames() {
        return this.params.keySet();
    }

    @Override
    public Object getResolvedParam(String name) {
        return this.params.get(name);
    }

    @Override
    public String getConfigParam(String name) throws ProvisioningException {
        return this.spec.paramToString(name, this.params.get(name));
    }

    @Override
    public Map<String, Object> getResolvedParams() {
        return this.params;
    }

    void setParam(String name, Object value, boolean overwrite) throws ProvisioningException {
        Object idValue;
        if (this.id != null && (idValue = this.id.params.get(name)) != null) {
            if (!idValue.equals(value)) {
                throw new ProvisioningDescriptionException("ID parameter " + name + "=" + idValue + " can't be reset to " + value);
            }
            return;
        }
        if (!this.spec.xmlSpec.hasParam(name)) {
            throw new ProvisioningDescriptionException(Errors.unknownFeatureParameter(this.spec.id, name));
        }
        if (this.unsetParams.contains(name)) {
            if (!overwrite) {
                return;
            }
            this.unsetParams = CollectionUtils.remove(this.unsetParams, name);
            this.params.put(name, value);
            return;
        }
        if (this.resetParams.contains(name)) {
            if (!overwrite) {
                return;
            }
            this.resetParams = CollectionUtils.remove(this.resetParams, name);
            this.params.put(name, value);
            return;
        }
        Object prevValue = this.params.get(name);
        if (prevValue == null) {
            this.params.put(name, value);
            return;
        }
        FeatureParameterType valueType = this.spec.getTypeForParameter(name);
        if (valueType.isMergeable()) {
            this.params.put(name, overwrite ? valueType.merge(prevValue, value) : valueType.merge(value, prevValue));
            return;
        }
        if (overwrite) {
            this.params.put(name, value);
        }
    }

    boolean isUnset(String name) {
        return this.unsetParams.contains(name);
    }

    void unsetParam(String name, boolean overwrite) throws ProvisioningDescriptionException {
        if (!this.spec.xmlSpec.hasParam(name)) {
            throw new ProvisioningDescriptionException(Errors.unknownFeatureParameter(this.spec.id, name));
        }
        if (this.id.params.containsKey(name)) {
            throw new ProvisioningDescriptionException(Errors.featureIdParameterCantBeUnset(this.id, name));
        }
        if (this.unsetParams.contains(name)) {
            return;
        }
        if (this.resetParams.contains(name)) {
            if (!overwrite) {
                return;
            }
            this.resetParams = CollectionUtils.remove(this.resetParams, name);
        } else if (overwrite) {
            this.params.remove(name);
        } else if (this.params.containsKey(name)) {
            return;
        }
        this.unsetParams = CollectionUtils.add(this.unsetParams, name);
    }

    void unsetAllParams(Set<String> names, boolean overwrite) throws ProvisioningDescriptionException {
        if (names.isEmpty()) {
            return;
        }
        for (String name : names) {
            this.unsetParam(name, overwrite);
        }
    }

    void resetParam(String name) throws ProvisioningDescriptionException {
        if (!this.spec.xmlSpec.hasParam(name)) {
            throw new ProvisioningDescriptionException(Errors.unknownFeatureParameter(this.spec.id, name));
        }
        if (this.id.params.containsKey(name)) {
            throw new ProvisioningDescriptionException(Errors.featureIdParameterCantBeReset(this.id, name));
        }
        if (this.resetParams.contains(name)) {
            return;
        }
        if (this.unsetParams.contains(name)) {
            this.unsetParams = CollectionUtils.remove(this.unsetParams, name);
        } else {
            this.params.remove(name);
        }
        this.resetParams = CollectionUtils.add(this.resetParams, name);
    }

    void resetAllParams(Set<String> names) throws ProvisioningDescriptionException {
        if (names.isEmpty()) {
            return;
        }
        for (String name : names) {
            this.resetParam(name);
        }
    }

    void merge(ResolvedFeature other, boolean overwriteParams) throws ProvisioningException {
        this.merge(other.deps, other.getResolvedParams(), overwriteParams);
        if (!other.unsetParams.isEmpty()) {
            this.unsetAllParams(other.unsetParams, overwriteParams);
        }
        if (overwriteParams && !other.resetParams.isEmpty()) {
            this.resetAllParams(other.resetParams);
        }
    }

    void merge(Map<ResolvedFeatureId, FeatureDependencySpec> deps, Map<String, Object> resolvedParams, boolean overwriteParams) throws ProvisioningException {
        if (!resolvedParams.isEmpty()) {
            for (Map.Entry<Object, Object> entry : resolvedParams.entrySet()) {
                this.setParam((String)entry.getKey(), entry.getValue(), overwriteParams);
            }
        }
        if (!deps.isEmpty()) {
            for (Map.Entry<Object, Object> entry : deps.entrySet()) {
                this.addDependency((ResolvedFeatureId)entry.getKey(), (FeatureDependencySpec)entry.getValue());
            }
        }
    }

    List<ResolvedFeatureId> resolveRefs() throws ProvisioningException {
        return this.spec.resolveRefs(this);
    }

    void setSpecFeatures(SpecFeatures specFeatures) {
        this.specFeatures = specFeatures;
    }

    SpecFeatures getSpecFeatures() {
        return this.specFeatures;
    }

    public String toString() {
        return "ResolvedFeature{includeNo=" + this.includeNo + ", id=" + this.id + ", spec=" + this.spec + ", params=" + this.params + ", deps=" + this.deps + ", orderingState=" + this.orderingState + '}';
    }
}

