/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.AbstractGroup;
import org.apache.catalina.users.MemoryUserDatabase;
import org.apache.tomcat.util.buf.StringUtils;

public class MemoryGroup
extends AbstractGroup {
    protected final MemoryUserDatabase database;
    protected final CopyOnWriteArrayList<Role> roles = new CopyOnWriteArrayList();

    MemoryGroup(MemoryUserDatabase database, String groupname, String description) {
        this.database = database;
        this.setGroupname(groupname);
        this.setDescription(description);
    }

    @Override
    public Iterator<Role> getRoles() {
        return this.roles.iterator();
    }

    @Override
    public UserDatabase getUserDatabase() {
        return this.database;
    }

    @Override
    public Iterator<User> getUsers() {
        ArrayList<User> results = new ArrayList<User>();
        Iterator<User> users = this.database.getUsers();
        while (users.hasNext()) {
            User user = users.next();
            if (!user.isInGroup(this)) continue;
            results.add(user);
        }
        return results.iterator();
    }

    @Override
    public void addRole(Role role) {
        this.roles.addIfAbsent(role);
    }

    @Override
    public boolean isInRole(Role role) {
        return this.roles.contains(role);
    }

    @Override
    public void removeRole(Role role) {
        this.roles.remove(role);
    }

    @Override
    public void removeRoles() {
        this.roles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("<group groupname=\"");
        sb.append(this.groupname);
        sb.append("\"");
        if (this.description != null) {
            sb.append(" description=\"");
            sb.append(this.description);
            sb.append("\"");
        }
        CopyOnWriteArrayList<Role> copyOnWriteArrayList = this.roles;
        synchronized (copyOnWriteArrayList) {
            if (this.roles.size() > 0) {
                sb.append(" roles=\"");
                StringUtils.join(this.roles, (char)',', Role::getRolename, (StringBuilder)sb);
                sb.append("\"");
            }
        }
        sb.append("/>");
        return sb.toString();
    }
}

