/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.olap4j.query.QueryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryEvent {
    private final QueryNode source;
    private final Type operation;
    private final Map<Integer, QueryNode> children;

    QueryEvent(Type operation, QueryNode source, QueryNode child, int index) {
        this.children = Collections.singletonMap(index, child);
        this.source = source;
        this.operation = operation;
    }

    QueryEvent(Type operation, QueryNode source, Map<Integer, QueryNode> children) {
        this.children = Collections.unmodifiableMap(new HashMap<Integer, QueryNode>(children));
        this.source = source;
        this.operation = operation;
    }

    QueryEvent(Type operation, QueryNode source) {
        this.children = null;
        this.source = source;
        this.operation = operation;
    }

    public QueryNode getSource() {
        return this.source;
    }

    public Type getOperation() {
        return this.operation;
    }

    public Map<Integer, QueryNode> getChildrens() {
        return this.children;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CHILDREN_REMOVED,
        CHILDREN_ADDED,
        SELECTION_CHANGED;

    }
}

