/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.opto.MachNode;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.JFloatField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class MachIfNode
extends MachNode {
    private static JFloatField probField;
    private static JFloatField fcntField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("MachIfNode");
        probField = type.getJFloatField("_prob");
        fcntField = type.getJFloatField("_fcnt");
    }

    float prob() {
        return probField.getValue(this.getAddress());
    }

    float cnt() {
        return fcntField.getValue(this.getAddress());
    }

    public MachIfNode(Address addr) {
        super(addr);
    }

    @Override
    public void dumpSpec(PrintStream out) {
        out.print("P=" + this.prob() + ", C=" + this.cnt());
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                MachIfNode.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

