# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2021 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.vmc.model.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata

class HostInstanceTypes(Enum):
    """
    

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    I3_METAL = None
    """


    """
    R5_METAL = None
    """


    """
    I3EN_METAL = None
    """


    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`HostInstanceTypes` instance.
        """
        Enum.__init__(string)

HostInstanceTypes._set_values([
    HostInstanceTypes('I3_METAL'),
    HostInstanceTypes('R5_METAL'),
    HostInstanceTypes('I3EN_METAL'),
])
HostInstanceTypes._set_binding_type(type.EnumType(
    'com.vmware.vmc.model.host_instance_types',
    HostInstanceTypes))



class OfferType(Enum):
    """
    

    .. note::
        This class represents an enumerated type in the interface language
        definition. The class contains class attributes which represent the
        values in the current version of the enumerated type. Newer versions of
        the enumerated type may contain new values. To use new values of the
        enumerated type in communication with a server that supports the newer
        version of the API, you instantiate this class. See :ref:`enumerated
        type description page <enumeration_description>`.
    """
    TERM = None
    """


    """
    ON_DEMAND = None
    """


    """

    def __init__(self, string):
        """
        :type  string: :class:`str`
        :param string: String value for the :class:`OfferType` instance.
        """
        Enum.__init__(string)

OfferType._set_values([
    OfferType('TERM'),
    OfferType('ON_DEMAND'),
])
OfferType._set_binding_type(type.EnumType(
    'com.vmware.vmc.model.offer_type',
    OfferType))




class AbstractEntity(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'updated': 'updated',
                            'user_id': 'user_id',
                            'updated_by_user_id': 'updated_by_user_id',
                            'created': 'created',
                            'version': 'version',
                            'updated_by_user_name': 'updated_by_user_name',
                            'user_name': 'user_name',
                            'id': 'id',
                            }

    def __init__(self,
                 updated=None,
                 user_id=None,
                 updated_by_user_id=None,
                 created=None,
                 version=None,
                 updated_by_user_name=None,
                 user_name=None,
                 id=None,
                ):
        """
        :type  updated: :class:`datetime.datetime`
        :param updated: 
        :type  user_id: :class:`str`
        :param user_id: User id that last updated this record
        :type  updated_by_user_id: :class:`str`
        :param updated_by_user_id: User id that last updated this record
        :type  created: :class:`datetime.datetime`
        :param created: 
        :type  version: :class:`long`
        :param version: Version of this entity format: int32
        :type  updated_by_user_name: :class:`str` or ``None``
        :param updated_by_user_name: User name that last updated this record
        :type  user_name: :class:`str`
        :param user_name: User name that last updated this record
        :type  id: :class:`str`
        :param id: Unique ID for this entity
        """
        self.updated = updated
        self.user_id = user_id
        self.updated_by_user_id = updated_by_user_id
        self.created = created
        self.version = version
        self.updated_by_user_name = updated_by_user_name
        self.user_name = user_name
        self.id = id
        VapiStruct.__init__(self)


AbstractEntity._set_binding_type(type.StructType(
    'com.vmware.vmc.model.abstract_entity', {
        'updated': type.DateTimeType(),
        'user_id': type.StringType(),
        'updated_by_user_id': type.StringType(),
        'created': type.DateTimeType(),
        'version': type.IntegerType(),
        'updated_by_user_name': type.OptionalType(type.StringType()),
        'user_name': type.StringType(),
        'id': type.StringType(),
    },
    AbstractEntity,
    False,
    None))



class AccountLinkConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'delay_account_link': 'delay_account_link',
                            }

    def __init__(self,
                 delay_account_link=None,
                ):
        """
        :type  delay_account_link: :class:`bool` or ``None``
        :param delay_account_link: Boolean flag identifying whether account linking should be delayed
            or not for the SDDC.
        """
        self.delay_account_link = delay_account_link
        VapiStruct.__init__(self)


AccountLinkConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.account_link_config', {
        'delay_account_link': type.OptionalType(type.BooleanType()),
    },
    AccountLinkConfig,
    False,
    None))



class AccountLinkSddcConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'customer_subnet_ids': 'customer_subnet_ids',
                            'connected_account_id': 'connected_account_id',
                            }

    def __init__(self,
                 customer_subnet_ids=None,
                 connected_account_id=None,
                ):
        """
        :type  customer_subnet_ids: :class:`list` of :class:`str` or ``None``
        :param customer_subnet_ids: 
        :type  connected_account_id: :class:`str` or ``None``
        :param connected_account_id: The ID of the customer connected account to work with.
        """
        self.customer_subnet_ids = customer_subnet_ids
        self.connected_account_id = connected_account_id
        VapiStruct.__init__(self)


AccountLinkSddcConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.account_link_sddc_config', {
        'customer_subnet_ids': type.OptionalType(type.ListType(type.StringType())),
        'connected_account_id': type.OptionalType(type.StringType()),
    },
    AccountLinkSddcConfig,
    False,
    None))



class Agent(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "Agent"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    AGENT_STATE_NOT_READY = "NOT_READY"
    """


    """
    AGENT_STATE_DEPLOYING = "DEPLOYING"
    """


    """
    AGENT_STATE_CUSTOMIZING = "CUSTOMIZING"
    """


    """
    AGENT_STATE_READY = "READY"
    """


    """
    AGENT_STATE_DELETING = "DELETING"
    """


    """
    AGENT_STATE_DELETED = "DELETED"
    """


    """
    AGENT_STATE_FAILED = "FAILED"
    """


    """



    _canonical_to_pep_names = {
                            'sddc_csp_oauth_client': 'sddc_csp_oauth_client',
                            'addresses': 'addresses',
                            'internal_ip': 'internal_ip',
                            'hostname_verifier_enabled': 'hostname_verifier_enabled',
                            'cert_enabled': 'cert_enabled',
                            'network_cidr': 'network_cidr',
                            'id': 'id',
                            'tenant_service_info': 'tenant_service_info',
                            'tinyproxy_whitelist': 'tinyproxy_whitelist',
                            'healthy': 'healthy',
                            'custom_properties': 'custom_properties',
                            'management_ip': 'management_ip',
                            'master': 'master',
                            'network_netmask': 'network_netmask',
                            'network_gateway': 'network_gateway',
                            'provider': 'provider',
                            'agent_url': 'agent_url',
                            'agent_state': 'agent_state',
                            }

    def __init__(self,
                 sddc_csp_oauth_client=None,
                 addresses=None,
                 internal_ip=None,
                 hostname_verifier_enabled=None,
                 cert_enabled=None,
                 network_cidr=None,
                 id=None,
                 tenant_service_info=None,
                 tinyproxy_whitelist=None,
                 healthy=None,
                 custom_properties=None,
                 management_ip=None,
                 master=None,
                 network_netmask=None,
                 network_gateway=None,
                 provider='Agent',
                 agent_url=None,
                 agent_state=None,
                ):
        """
        :type  sddc_csp_oauth_client: :class:`AgentCspOauthClient` or ``None``
        :param sddc_csp_oauth_client: CSP Oauth client credentials to access information from POP.
        :type  addresses: :class:`list` of :class:`str` or ``None``
        :param addresses: The addresses of the agent including its public IP and DNS names.
        :type  internal_ip: :class:`str` or ``None``
        :param internal_ip: The internal IP address of the agent which is provided by the
            underlying cloud provider
        :type  hostname_verifier_enabled: :class:`bool` or ``None``
        :param hostname_verifier_enabled: Boolean flag to indicate if the agent is using FQDN in the
            certificate
        :type  cert_enabled: :class:`bool` or ``None``
        :param cert_enabled: Boolean flag to indicate if the agent is using CA signed
            certificate
        :type  network_cidr: :class:`str` or ``None``
        :param network_cidr: Network CIDR of the agent
        :type  id: :class:`str` or ``None``
        :param id: The agent id
        :type  tenant_service_info: :class:`TenantServiceInfo` or ``None``
        :param tenant_service_info: Tenant service information that we will save as a part of agent
            data.
        :type  tinyproxy_whitelist: :class:`list` of :class:`str` or ``None``
        :param tinyproxy_whitelist: The list of white listed domains of the HTTP proxy.
        :type  healthy: :class:`bool` or ``None``
        :param healthy: Boolean flag to indicate if the agent is healthy.
        :type  custom_properties: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param custom_properties: 
        :type  management_ip: :class:`str` or ``None``
        :param management_ip: The internal management IP address of the agent exposed to the
            SDDC, which might be different from the internal IP
        :type  master: :class:`bool` or ``None``
        :param master: Boolean flag to indicate if the agent is the master, only the
            master Agent is accessible
        :type  network_netmask: :class:`str` or ``None``
        :param network_netmask: Network netmask of the agent
        :type  network_gateway: :class:`str` or ``None``
        :param network_gateway: Network gateway of the agent
        :type  provider: :class:`str`
        :param provider: The cloud provider
        :type  agent_url: :class:`str` or ``None``
        :param agent_url: The accessible URL of the agent service, it is resolved to public
            IP address from the Internet and private IP address within SDDC
        :type  agent_state: :class:`str` or ``None``
        :param agent_state: Possible values are: 
            
            * :attr:`Agent.AGENT_STATE_NOT_READY`
            * :attr:`Agent.AGENT_STATE_DEPLOYING`
            * :attr:`Agent.AGENT_STATE_CUSTOMIZING`
            * :attr:`Agent.AGENT_STATE_READY`
            * :attr:`Agent.AGENT_STATE_DELETING`
            * :attr:`Agent.AGENT_STATE_DELETED`
            * :attr:`Agent.AGENT_STATE_FAILED`
            
             Agent state
        """
        self.sddc_csp_oauth_client = sddc_csp_oauth_client
        self.addresses = addresses
        self.internal_ip = internal_ip
        self.hostname_verifier_enabled = hostname_verifier_enabled
        self.cert_enabled = cert_enabled
        self.network_cidr = network_cidr
        self.id = id
        self.tenant_service_info = tenant_service_info
        self.tinyproxy_whitelist = tinyproxy_whitelist
        self.healthy = healthy
        self.custom_properties = custom_properties
        self.management_ip = management_ip
        self.master = master
        self.network_netmask = network_netmask
        self.network_gateway = network_gateway
        self._provider = provider
        self.agent_url = agent_url
        self.agent_state = agent_state
        VapiStruct.__init__(self)

    @property
    def provider(self):
        """
        Return the discriminator value
        """
        return self._provider

Agent._set_binding_type(type.StructType(
    'com.vmware.vmc.model.agent', {
        'sddc_csp_oauth_client': type.OptionalType(type.ReferenceType(__name__, 'AgentCspOauthClient')),
        'addresses': type.OptionalType(type.ListType(type.StringType())),
        'internal_ip': type.OptionalType(type.StringType()),
        'hostname_verifier_enabled': type.OptionalType(type.BooleanType()),
        'cert_enabled': type.OptionalType(type.BooleanType()),
        'network_cidr': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'tenant_service_info': type.OptionalType(type.ReferenceType(__name__, 'TenantServiceInfo')),
        'tinyproxy_whitelist': type.OptionalType(type.ListType(type.StringType())),
        'healthy': type.OptionalType(type.BooleanType()),
        'custom_properties': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
        'management_ip': type.OptionalType(type.StringType()),
        'master': type.OptionalType(type.BooleanType()),
        'network_netmask': type.OptionalType(type.StringType()),
        'network_gateway': type.OptionalType(type.StringType()),
        'provider': type.StringType(),
        'agent_url': type.OptionalType(type.StringType()),
        'agent_state': type.OptionalType(type.StringType()),
    },
    Agent,
    False,
    None))



class AgentCspOauthClient(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'csp_oauth_client': 'csp_oauth_client',
                            'create_at': 'create_at',
                            }

    def __init__(self,
                 csp_oauth_client=None,
                 create_at=None,
                ):
        """
        :type  csp_oauth_client: :class:`AgentOauthClient`
        :param csp_oauth_client: Agent CSP Oauth client credentials.
        :type  create_at: :class:`datetime.datetime`
        :param create_at: The Oauth client creation time. format: date-time
        """
        self.csp_oauth_client = csp_oauth_client
        self.create_at = create_at
        VapiStruct.__init__(self)


AgentCspOauthClient._set_binding_type(type.StructType(
    'com.vmware.vmc.model.agent_csp_oauth_client', {
        'csp_oauth_client': type.ReferenceType(__name__, 'AgentOauthClient'),
        'create_at': type.DateTimeType(),
    },
    AgentCspOauthClient,
    False,
    None))



class AgentOauthClient(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'client_secret': 'client_secret',
                            'client_id': 'client_id',
                            }

    def __init__(self,
                 client_secret=None,
                 client_id=None,
                ):
        """
        :type  client_secret: :class:`str`
        :param client_secret: The Oauth client secret.
        :type  client_id: :class:`str`
        :param client_id: The Oauth client ID.
        """
        self.client_secret = client_secret
        self.client_id = client_id
        VapiStruct.__init__(self)


AgentOauthClient._set_binding_type(type.StructType(
    'com.vmware.vmc.model.agent_oauth_client', {
        'client_secret': type.StringType(),
        'client_id': type.StringType(),
    },
    AgentOauthClient,
    False,
    None))



class AmiInfo(VapiStruct):
    """
    the AmiInfo used for deploying esx of the sddc

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'instance_type': 'instance_type',
                            'region': 'region',
                            'id': 'id',
                            'name': 'name',
                            }

    def __init__(self,
                 instance_type=None,
                 region=None,
                 id=None,
                 name=None,
                ):
        """
        :type  instance_type: :class:`str` or ``None``
        :param instance_type: instance type of the esx ami
        :type  region: :class:`str` or ``None``
        :param region: the region of the esx ami
        :type  id: :class:`str` or ``None``
        :param id: the ami id for the esx
        :type  name: :class:`str` or ``None``
        :param name: the name of the esx ami
        """
        self.instance_type = instance_type
        self.region = region
        self.id = id
        self.name = name
        VapiStruct.__init__(self)


AmiInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.ami_info', {
        'instance_type': type.OptionalType(type.StringType()),
        'region': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
    },
    AmiInfo,
    False,
    None))



class AvailableZoneInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'subnets': 'subnets',
                            'id': 'id',
                            }

    def __init__(self,
                 subnets=None,
                 id=None,
                ):
        """
        :type  subnets: :class:`list` of :class:`Subnet` or ``None``
        :param subnets: 
        :type  id: :class:`str` or ``None``
        :param id: available zone id
        """
        self.subnets = subnets
        self.id = id
        VapiStruct.__init__(self)


AvailableZoneInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.available_zone_info', {
        'subnets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Subnet'))),
        'id': type.OptionalType(type.StringType()),
    },
    AvailableZoneInfo,
    False,
    None))



class AwsAgent(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AWS"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'instance_id': 'instance_id',
                            'availability_zone_info_id': 'availability_zone_info_id',
                            'instance_profile_info': 'instance_profile_info',
                            'key_pair': 'key_pair',
                            'default_eni_id': 'default_eni_id',
                            'sddc_csp_oauth_client': 'sddc_csp_oauth_client',
                            'addresses': 'addresses',
                            'internal_ip': 'internal_ip',
                            'hostname_verifier_enabled': 'hostname_verifier_enabled',
                            'cert_enabled': 'cert_enabled',
                            'network_cidr': 'network_cidr',
                            'id': 'id',
                            'tenant_service_info': 'tenant_service_info',
                            'tinyproxy_whitelist': 'tinyproxy_whitelist',
                            'healthy': 'healthy',
                            'custom_properties': 'custom_properties',
                            'management_ip': 'management_ip',
                            'master': 'master',
                            'network_netmask': 'network_netmask',
                            'network_gateway': 'network_gateway',
                            'provider': 'provider',
                            'agent_url': 'agent_url',
                            'agent_state': 'agent_state',
                            }

    def __init__(self,
                 instance_id=None,
                 availability_zone_info_id=None,
                 instance_profile_info=None,
                 key_pair=None,
                 default_eni_id=None,
                 sddc_csp_oauth_client=None,
                 addresses=None,
                 internal_ip=None,
                 hostname_verifier_enabled=None,
                 cert_enabled=None,
                 network_cidr=None,
                 id=None,
                 tenant_service_info=None,
                 tinyproxy_whitelist=None,
                 healthy=None,
                 custom_properties=None,
                 management_ip=None,
                 master=None,
                 network_netmask=None,
                 network_gateway=None,
                 provider='AWS',
                 agent_url=None,
                 agent_state=None,
                ):
        """
        :type  instance_id: :class:`str` or ``None``
        :param instance_id: 
        :type  availability_zone_info_id: :class:`str` or ``None``
        :param availability_zone_info_id: 
        :type  instance_profile_info: :class:`InstanceProfileInfo` or ``None``
        :param instance_profile_info: 
        :type  key_pair: :class:`AwsKeyPair` or ``None``
        :param key_pair: 
        :type  default_eni_id: :class:`str` or ``None``
        :param default_eni_id: 
        :type  sddc_csp_oauth_client: :class:`AgentCspOauthClient` or ``None``
        :param sddc_csp_oauth_client: CSP Oauth client credentials to access information from POP.
        :type  addresses: :class:`list` of :class:`str` or ``None``
        :param addresses: The addresses of the agent including its public IP and DNS names.
        :type  internal_ip: :class:`str` or ``None``
        :param internal_ip: The internal IP address of the agent which is provided by the
            underlying cloud provider
        :type  hostname_verifier_enabled: :class:`bool` or ``None``
        :param hostname_verifier_enabled: Boolean flag to indicate if the agent is using FQDN in the
            certificate
        :type  cert_enabled: :class:`bool` or ``None``
        :param cert_enabled: Boolean flag to indicate if the agent is using CA signed
            certificate
        :type  network_cidr: :class:`str` or ``None``
        :param network_cidr: Network CIDR of the agent
        :type  id: :class:`str` or ``None``
        :param id: The agent id
        :type  tenant_service_info: :class:`TenantServiceInfo` or ``None``
        :param tenant_service_info: Tenant service information that we will save as a part of agent
            data.
        :type  tinyproxy_whitelist: :class:`list` of :class:`str` or ``None``
        :param tinyproxy_whitelist: The list of white listed domains of the HTTP proxy.
        :type  healthy: :class:`bool` or ``None``
        :param healthy: Boolean flag to indicate if the agent is healthy.
        :type  custom_properties: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param custom_properties: 
        :type  management_ip: :class:`str` or ``None``
        :param management_ip: The internal management IP address of the agent exposed to the
            SDDC, which might be different from the internal IP
        :type  master: :class:`bool` or ``None``
        :param master: Boolean flag to indicate if the agent is the master, only the
            master Agent is accessible
        :type  network_netmask: :class:`str` or ``None``
        :param network_netmask: Network netmask of the agent
        :type  network_gateway: :class:`str` or ``None``
        :param network_gateway: Network gateway of the agent
        :type  provider: :class:`str`
        :param provider: The cloud provider
        :type  agent_url: :class:`str` or ``None``
        :param agent_url: The accessible URL of the agent service, it is resolved to public
            IP address from the Internet and private IP address within SDDC
        :type  agent_state: :class:`str` or ``None``
        :param agent_state: Possible values are: 
            
            * :attr:`Agent.AGENT_STATE_NOT_READY`
            * :attr:`Agent.AGENT_STATE_DEPLOYING`
            * :attr:`Agent.AGENT_STATE_CUSTOMIZING`
            * :attr:`Agent.AGENT_STATE_READY`
            * :attr:`Agent.AGENT_STATE_DELETING`
            * :attr:`Agent.AGENT_STATE_DELETED`
            * :attr:`Agent.AGENT_STATE_FAILED`
            
             Agent state
        """
        self.instance_id = instance_id
        self.availability_zone_info_id = availability_zone_info_id
        self.instance_profile_info = instance_profile_info
        self.key_pair = key_pair
        self.default_eni_id = default_eni_id
        self.sddc_csp_oauth_client = sddc_csp_oauth_client
        self.addresses = addresses
        self.internal_ip = internal_ip
        self.hostname_verifier_enabled = hostname_verifier_enabled
        self.cert_enabled = cert_enabled
        self.network_cidr = network_cidr
        self.id = id
        self.tenant_service_info = tenant_service_info
        self.tinyproxy_whitelist = tinyproxy_whitelist
        self.healthy = healthy
        self.custom_properties = custom_properties
        self.management_ip = management_ip
        self.master = master
        self.network_netmask = network_netmask
        self.network_gateway = network_gateway
        self._provider = provider
        self.agent_url = agent_url
        self.agent_state = agent_state
        VapiStruct.__init__(self)

    @property
    def provider(self):
        """
        Return the discriminator value
        """
        return self._provider

AwsAgent._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_agent', {
        'instance_id': type.OptionalType(type.StringType()),
        'availability_zone_info_id': type.OptionalType(type.StringType()),
        'instance_profile_info': type.OptionalType(type.ReferenceType(__name__, 'InstanceProfileInfo')),
        'key_pair': type.OptionalType(type.ReferenceType(__name__, 'AwsKeyPair')),
        'default_eni_id': type.OptionalType(type.StringType()),
        'sddc_csp_oauth_client': type.OptionalType(type.ReferenceType(__name__, 'AgentCspOauthClient')),
        'addresses': type.OptionalType(type.ListType(type.StringType())),
        'internal_ip': type.OptionalType(type.StringType()),
        'hostname_verifier_enabled': type.OptionalType(type.BooleanType()),
        'cert_enabled': type.OptionalType(type.BooleanType()),
        'network_cidr': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'tenant_service_info': type.OptionalType(type.ReferenceType(__name__, 'TenantServiceInfo')),
        'tinyproxy_whitelist': type.OptionalType(type.ListType(type.StringType())),
        'healthy': type.OptionalType(type.BooleanType()),
        'custom_properties': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
        'management_ip': type.OptionalType(type.StringType()),
        'master': type.OptionalType(type.BooleanType()),
        'network_netmask': type.OptionalType(type.StringType()),
        'network_gateway': type.OptionalType(type.StringType()),
        'provider': type.StringType(),
        'agent_url': type.OptionalType(type.StringType()),
        'agent_state': type.OptionalType(type.StringType()),
    },
    AwsAgent,
    False,
    None))



class AwsCloudProvider(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AWS"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'regions': 'regions',
                            'provider': 'provider',
                            }

    def __init__(self,
                 regions=None,
                 provider='AWS',
                ):
        """
        :type  regions: :class:`list` of :class:`str` or ``None``
        :param regions: 
        :type  provider: :class:`str`
        :param provider: Name of the Cloud Provider
        """
        self.regions = regions
        self._provider = provider
        VapiStruct.__init__(self)

    @property
    def provider(self):
        """
        Return the discriminator value
        """
        return self._provider

AwsCloudProvider._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_cloud_provider', {
        'regions': type.OptionalType(type.ListType(type.StringType())),
        'provider': type.StringType(),
    },
    AwsCloudProvider,
    False,
    None))



class AwsCompatibleSubnets(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'customer_available_zones': 'customer_available_zones',
                            'vpc_map': 'vpc_map',
                            }

    def __init__(self,
                 customer_available_zones=None,
                 vpc_map=None,
                ):
        """
        :type  customer_available_zones: :class:`list` of :class:`str` or ``None``
        :param customer_available_zones: 
        :type  vpc_map: (:class:`dict` of :class:`str` and :class:`VpcInfoSubnets`) or ``None``
        :param vpc_map: 
        """
        self.customer_available_zones = customer_available_zones
        self.vpc_map = vpc_map
        VapiStruct.__init__(self)


AwsCompatibleSubnets._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_compatible_subnets', {
        'customer_available_zones': type.OptionalType(type.ListType(type.StringType())),
        'vpc_map': type.OptionalType(type.MapType(type.StringType(), type.ReferenceType(__name__, 'VpcInfoSubnets'))),
    },
    AwsCompatibleSubnets,
    False,
    None))



class AwsCustomerConnectedAccount(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_ACTIVE = "ACTIVE"
    """


    """
    STATE_BROKEN = "BROKEN"
    """


    """
    STATE_DELETED = "DELETED"
    """


    """



    _canonical_to_pep_names = {
                            'updated': 'updated',
                            'user_id': 'user_id',
                            'updated_by_user_id': 'updated_by_user_id',
                            'created': 'created',
                            'version': 'version',
                            'updated_by_user_name': 'updated_by_user_name',
                            'user_name': 'user_name',
                            'id': 'id',
                            'policy_payer_arn': 'policy_payer_arn',
                            'region_to_az_to_shadow_mapping': 'region_to_az_to_shadow_mapping',
                            'org_id': 'org_id',
                            'cf_stack_name': 'cf_stack_name',
                            'state': 'state',
                            'account_number': 'account_number',
                            'policy_service_arn': 'policy_service_arn',
                            'policy_external_id': 'policy_external_id',
                            'policy_payer_linked_arn': 'policy_payer_linked_arn',
                            }

    def __init__(self,
                 updated=None,
                 user_id=None,
                 updated_by_user_id=None,
                 created=None,
                 version=None,
                 updated_by_user_name=None,
                 user_name=None,
                 id=None,
                 policy_payer_arn=None,
                 region_to_az_to_shadow_mapping=None,
                 org_id=None,
                 cf_stack_name=None,
                 state=None,
                 account_number=None,
                 policy_service_arn=None,
                 policy_external_id=None,
                 policy_payer_linked_arn=None,
                ):
        """
        :type  updated: :class:`datetime.datetime`
        :param updated: 
        :type  user_id: :class:`str`
        :param user_id: User id that last updated this record
        :type  updated_by_user_id: :class:`str`
        :param updated_by_user_id: User id that last updated this record
        :type  created: :class:`datetime.datetime`
        :param created: 
        :type  version: :class:`long`
        :param version: Version of this entity format: int32
        :type  updated_by_user_name: :class:`str` or ``None``
        :param updated_by_user_name: User name that last updated this record
        :type  user_name: :class:`str`
        :param user_name: User name that last updated this record
        :type  id: :class:`str`
        :param id: Unique ID for this entity
        :type  policy_payer_arn: :class:`str` or ``None``
        :param policy_payer_arn: 
        :type  region_to_az_to_shadow_mapping: (:class:`dict` of :class:`str` and (:class:`dict` of :class:`str` and :class:`str`)) or ``None``
        :param region_to_az_to_shadow_mapping: Provides a map of regions to availability zones from the shadow
            account's perspective
        :type  org_id: :class:`str` or ``None``
        :param org_id: 
        :type  cf_stack_name: :class:`str` or ``None``
        :param cf_stack_name: 
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`AwsCustomerConnectedAccount.STATE_ACTIVE`
            * :attr:`AwsCustomerConnectedAccount.STATE_BROKEN`
            * :attr:`AwsCustomerConnectedAccount.STATE_DELETED`
        :type  account_number: :class:`str` or ``None``
        :param account_number: 
        :type  policy_service_arn: :class:`str` or ``None``
        :param policy_service_arn: 
        :type  policy_external_id: :class:`str` or ``None``
        :param policy_external_id: 
        :type  policy_payer_linked_arn: :class:`str` or ``None``
        :param policy_payer_linked_arn: 
        """
        self.updated = updated
        self.user_id = user_id
        self.updated_by_user_id = updated_by_user_id
        self.created = created
        self.version = version
        self.updated_by_user_name = updated_by_user_name
        self.user_name = user_name
        self.id = id
        self.policy_payer_arn = policy_payer_arn
        self.region_to_az_to_shadow_mapping = region_to_az_to_shadow_mapping
        self.org_id = org_id
        self.cf_stack_name = cf_stack_name
        self.state = state
        self.account_number = account_number
        self.policy_service_arn = policy_service_arn
        self.policy_external_id = policy_external_id
        self.policy_payer_linked_arn = policy_payer_linked_arn
        VapiStruct.__init__(self)


AwsCustomerConnectedAccount._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_customer_connected_account', {
        'updated': type.DateTimeType(),
        'user_id': type.StringType(),
        'updated_by_user_id': type.StringType(),
        'created': type.DateTimeType(),
        'version': type.IntegerType(),
        'updated_by_user_name': type.OptionalType(type.StringType()),
        'user_name': type.StringType(),
        'id': type.StringType(),
        'policy_payer_arn': type.OptionalType(type.StringType()),
        'region_to_az_to_shadow_mapping': type.OptionalType(type.MapType(type.StringType(), type.MapType(type.StringType(), type.StringType()))),
        'org_id': type.OptionalType(type.StringType()),
        'cf_stack_name': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
        'account_number': type.OptionalType(type.StringType()),
        'policy_service_arn': type.OptionalType(type.StringType()),
        'policy_external_id': type.OptionalType(type.StringType()),
        'policy_payer_linked_arn': type.OptionalType(type.StringType()),
    },
    AwsCustomerConnectedAccount,
    False,
    None))



class AwsEsxHost(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AWS"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'eni_list': 'eni_list',
                            'internal_public_ip_pool': 'internal_public_ip_pool',
                            'xeni_info': 'xeni_info',
                            'partition_number': 'partition_number',
                            'name': 'name',
                            'availability_zone': 'availability_zone',
                            'esx_id': 'esx_id',
                            'hostname': 'hostname',
                            'provider': 'provider',
                            'instance_type': 'instance_type',
                            'mac_address': 'mac_address',
                            'esx_state': 'esx_state',
                            'custom_properties': 'custom_properties',
                            }

    def __init__(self,
                 eni_list=None,
                 internal_public_ip_pool=None,
                 xeni_info=None,
                 partition_number=None,
                 name=None,
                 availability_zone=None,
                 esx_id=None,
                 hostname=None,
                 provider='AWS',
                 instance_type=None,
                 mac_address=None,
                 esx_state=None,
                 custom_properties=None,
                ):
        """
        :type  eni_list: :class:`list` of :class:`EniInfo` or ``None``
        :param eni_list: 
        :type  internal_public_ip_pool: :class:`list` of :class:`SddcPublicIp` or ``None``
        :param internal_public_ip_pool: 
        :type  xeni_info: :class:`XEniInfo` or ``None``
        :param xeni_info: 
        :type  partition_number: :class:`long` or ``None``
        :param partition_number: Partition number alloted to host. format: int32
        :type  name: :class:`str` or ``None``
        :param name: 
        :type  availability_zone: :class:`str` or ``None``
        :param availability_zone: Availability zone where the host is provisioned.
        :type  esx_id: :class:`str` or ``None``
        :param esx_id: 
        :type  hostname: :class:`str` or ``None``
        :param hostname: 
        :type  provider: :class:`str`
        :param provider: 
        :type  instance_type: :class:`str` or ``None``
        :param instance_type: Backing cloud provider instance type for host.
        :type  mac_address: :class:`str` or ``None``
        :param mac_address: 
        :type  esx_state: :class:`str` or ``None``
        :param esx_state: Possible values are: 
            
            * :attr:`EsxHost.ESX_STATE_DEPLOYING`
            * :attr:`EsxHost.ESX_STATE_INITIALIZING`
            * :attr:`EsxHost.ESX_STATE_PROVISIONED`
            * :attr:`EsxHost.ESX_STATE_READY`
            * :attr:`EsxHost.ESX_STATE_DELETING`
            * :attr:`EsxHost.ESX_STATE_DELETED`
            * :attr:`EsxHost.ESX_STATE_FAILED`
            * :attr:`EsxHost.ESX_STATE_ADDING_TO_VCENTER`
            * :attr:`EsxHost.ESX_STATE_DELETING_FROM_VCENTER`
            * :attr:`EsxHost.ESX_STATE_PENDING_CLOUD_DELETION`
        :type  custom_properties: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param custom_properties: 
        """
        self.eni_list = eni_list
        self.internal_public_ip_pool = internal_public_ip_pool
        self.xeni_info = xeni_info
        self.partition_number = partition_number
        self.name = name
        self.availability_zone = availability_zone
        self.esx_id = esx_id
        self.hostname = hostname
        self._provider = provider
        self.instance_type = instance_type
        self.mac_address = mac_address
        self.esx_state = esx_state
        self.custom_properties = custom_properties
        VapiStruct.__init__(self)

    @property
    def provider(self):
        """
        Return the discriminator value
        """
        return self._provider

AwsEsxHost._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_esx_host', {
        'eni_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'EniInfo'))),
        'internal_public_ip_pool': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SddcPublicIp'))),
        'xeni_info': type.OptionalType(type.ReferenceType(__name__, 'XEniInfo')),
        'partition_number': type.OptionalType(type.IntegerType()),
        'name': type.OptionalType(type.StringType()),
        'availability_zone': type.OptionalType(type.StringType()),
        'esx_id': type.OptionalType(type.StringType()),
        'hostname': type.OptionalType(type.StringType()),
        'provider': type.StringType(),
        'instance_type': type.OptionalType(type.StringType()),
        'mac_address': type.OptionalType(type.StringType()),
        'esx_state': type.OptionalType(type.StringType()),
        'custom_properties': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
    },
    AwsEsxHost,
    False,
    None))



class AwsKeyPair(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'key_name': 'key_name',
                            'key_fingerprint': 'key_fingerprint',
                            'key_material': 'key_material',
                            }

    def __init__(self,
                 key_name=None,
                 key_fingerprint=None,
                 key_material=None,
                ):
        """
        :type  key_name: :class:`str` or ``None``
        :param key_name: 
        :type  key_fingerprint: :class:`str` or ``None``
        :param key_fingerprint: 
        :type  key_material: :class:`str` or ``None``
        :param key_material: 
        """
        self.key_name = key_name
        self.key_fingerprint = key_fingerprint
        self.key_material = key_material
        VapiStruct.__init__(self)


AwsKeyPair._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_key_pair', {
        'key_name': type.OptionalType(type.StringType()),
        'key_fingerprint': type.OptionalType(type.StringType()),
        'key_material': type.OptionalType(type.StringType()),
    },
    AwsKeyPair,
    False,
    None))



class AwsKmsInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'amazon_resource_name': 'amazon_resource_name',
                            }

    def __init__(self,
                 amazon_resource_name=None,
                ):
        """
        :type  amazon_resource_name: :class:`str`
        :param amazon_resource_name: The ARN associated with the customer master key for this cluster.
        """
        self.amazon_resource_name = amazon_resource_name
        VapiStruct.__init__(self)


AwsKmsInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_kms_info', {
        'amazon_resource_name': type.StringType(),
    },
    AwsKmsInfo,
    False,
    None))



class AwsSddcConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AWS"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'region': 'region',
                            'msft_license_config': 'msft_license_config',
                            'vpc_cidr': 'vpc_cidr',
                            'host_instance_type': 'host_instance_type',
                            'skip_creating_vxlan': 'skip_creating_vxlan',
                            'vxlan_subnet': 'vxlan_subnet',
                            'size': 'size',
                            'outpost_id': 'outpost_id',
                            'storage_capacity': 'storage_capacity',
                            'name': 'name',
                            'account_link_sddc_config': 'account_link_sddc_config',
                            'sddc_id': 'sddc_id',
                            'num_hosts': 'num_hosts',
                            'sddc_type': 'sddc_type',
                            'account_link_config': 'account_link_config',
                            'provider': 'provider',
                            'sso_domain': 'sso_domain',
                            'sddc_template_id': 'sddc_template_id',
                            'deployment_type': 'deployment_type',
                            }

    def __init__(self,
                 region=None,
                 msft_license_config=None,
                 vpc_cidr=None,
                 host_instance_type=None,
                 skip_creating_vxlan=None,
                 vxlan_subnet=None,
                 size=None,
                 outpost_id=None,
                 storage_capacity=None,
                 name=None,
                 account_link_sddc_config=None,
                 sddc_id=None,
                 num_hosts=None,
                 sddc_type=None,
                 account_link_config=None,
                 provider='AWS',
                 sso_domain=None,
                 sddc_template_id=None,
                 deployment_type=None,
                ):
        """
        :type  region: :class:`str`
        :param region: 
        :type  msft_license_config: :class:`MsftLicensingConfig` or ``None``
        :param msft_license_config: Indicates the desired licensing support, if any, of Microsoft
            software.
        :type  vpc_cidr: :class:`str` or ``None``
        :param vpc_cidr: AWS VPC IP range. Only prefix of 16 or 20 is currently supported.
        :type  host_instance_type: :class:`HostInstanceTypes` or ``None``
        :param host_instance_type: The instance type for the esx hosts in the primary cluster of the
            SDDC.
        :type  skip_creating_vxlan: :class:`bool` or ``None``
        :param skip_creating_vxlan: skip creating vxlan for compute gateway for SDDC provisioning
        :type  vxlan_subnet: :class:`str` or ``None``
        :param vxlan_subnet: VXLAN IP subnet in CIDR for compute gateway
        :type  size: :class:`str` or ``None``
        :param size: Possible values are: 
            
            * :attr:`SddcConfig.SIZE_NSX_SMALL`
            * :attr:`SddcConfig.SIZE_MEDIUM`
            * :attr:`SddcConfig.SIZE_LARGE`
            * :attr:`SddcConfig.SIZE_NSX_LARGE`
            
            The size of the vCenter and NSX appliances. \"large\" sddcSize
            corresponds to a 'large' vCenter appliance and 'large' NSX
            appliance. 'medium' sddcSize corresponds to 'medium' vCenter
            appliance and 'medium' NSX appliance. Value defaults to 'medium'.
        :type  outpost_id: :class:`str` or ``None``
        :param outpost_id: Outpost ID of the SDDC. Used only for outpost deployments.
        :type  storage_capacity: :class:`long` or ``None``
        :param storage_capacity: The storage capacity value to be requested for the sddc primary
            cluster, in GiBs. If provided, instead of using the direct-attached
            storage, a capacity value amount of seperable storage will be used.
            format: int64
        :type  name: :class:`str`
        :param name: 
        :type  account_link_sddc_config: :class:`list` of :class:`AccountLinkSddcConfig` or ``None``
        :param account_link_sddc_config: A list of the SDDC linking configurations to use.
        :type  sddc_id: :class:`str` or ``None``
        :param sddc_id: If provided, will be assigned as SDDC id of the provisioned SDDC.
            format: UUID
        :type  num_hosts: :class:`long`
        :param num_hosts: 
        :type  sddc_type: :class:`str` or ``None``
        :param sddc_type: Denotes the sddc type , if the value is null or empty, the type is
            considered as default.
        :type  account_link_config: :class:`AccountLinkConfig` or ``None``
        :param account_link_config: The account linking configuration, we will keep this one and remove
            accountLinkSddcConfig finally.
        :type  provider: :class:`str`
        :param provider: Possible values are: 
            
            * :attr:`SddcConfig.PROVIDER_AWS`
            * :attr:`SddcConfig.PROVIDER_ZEROCLOUD`
            
            Determines what additional properties are available based on cloud
            provider.
        :type  sso_domain: :class:`str` or ``None``
        :param sso_domain: The SSO domain name to use for vSphere users. If not specified,
            vmc.local will be used.
        :type  sddc_template_id: :class:`str` or ``None``
        :param sddc_template_id: If provided, configuration from the template will applied to the
            provisioned SDDC. format: UUID
        :type  deployment_type: :class:`str` or ``None``
        :param deployment_type: Possible values are: 
            
            * :attr:`SddcConfig.DEPLOYMENT_TYPE_SINGLEAZ`
            * :attr:`SddcConfig.DEPLOYMENT_TYPE_MULTIAZ`
            
            Denotes if request is for a SingleAZ or a MultiAZ SDDC. Default is
            SingleAZ.
        """
        self.region = region
        self.msft_license_config = msft_license_config
        self.vpc_cidr = vpc_cidr
        self.host_instance_type = host_instance_type
        self.skip_creating_vxlan = skip_creating_vxlan
        self.vxlan_subnet = vxlan_subnet
        self.size = size
        self.outpost_id = outpost_id
        self.storage_capacity = storage_capacity
        self.name = name
        self.account_link_sddc_config = account_link_sddc_config
        self.sddc_id = sddc_id
        self.num_hosts = num_hosts
        self.sddc_type = sddc_type
        self.account_link_config = account_link_config
        self._provider = provider
        self.sso_domain = sso_domain
        self.sddc_template_id = sddc_template_id
        self.deployment_type = deployment_type
        VapiStruct.__init__(self)

    @property
    def provider(self):
        """
        Return the discriminator value
        """
        return self._provider

AwsSddcConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_sddc_config', {
        'region': type.StringType(),
        'msft_license_config': type.OptionalType(type.ReferenceType(__name__, 'MsftLicensingConfig')),
        'vpc_cidr': type.OptionalType(type.StringType()),
        'host_instance_type': type.OptionalType(type.ReferenceType(__name__, 'HostInstanceTypes')),
        'skip_creating_vxlan': type.OptionalType(type.BooleanType()),
        'vxlan_subnet': type.OptionalType(type.StringType()),
        'size': type.OptionalType(type.StringType()),
        'outpost_id': type.OptionalType(type.StringType()),
        'storage_capacity': type.OptionalType(type.IntegerType()),
        'name': type.StringType(),
        'account_link_sddc_config': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AccountLinkSddcConfig'))),
        'sddc_id': type.OptionalType(type.StringType()),
        'num_hosts': type.IntegerType(),
        'sddc_type': type.OptionalType(type.StringType()),
        'account_link_config': type.OptionalType(type.ReferenceType(__name__, 'AccountLinkConfig')),
        'provider': type.StringType(),
        'sso_domain': type.OptionalType(type.StringType()),
        'sddc_template_id': type.OptionalType(type.StringType()),
        'deployment_type': type.OptionalType(type.StringType()),
    },
    AwsSddcConfig,
    False,
    None))



class AwsSddcConnection(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_ACTIVE = "ACTIVE"
    """


    """
    STATE_BROKEN = "BROKEN"
    """


    """
    STATE_DELETED = "DELETED"
    """


    """



    _canonical_to_pep_names = {
                            'updated': 'updated',
                            'user_id': 'user_id',
                            'updated_by_user_id': 'updated_by_user_id',
                            'created': 'created',
                            'version': 'version',
                            'updated_by_user_name': 'updated_by_user_name',
                            'user_name': 'user_name',
                            'id': 'id',
                            'cidr_block_subnet': 'cidr_block_subnet',
                            'connected_account_id': 'connected_account_id',
                            'eni_group': 'eni_group',
                            'subnet_id': 'subnet_id',
                            'cgw_present': 'cgw_present',
                            'org_id': 'org_id',
                            'sddc_id': 'sddc_id',
                            'cidr_block_vpc': 'cidr_block_vpc',
                            'connection_order': 'connection_order',
                            'state': 'state',
                            'subnet_availability_zone': 'subnet_availability_zone',
                            'vpc_id': 'vpc_id',
                            'customer_eni_infos': 'customer_eni_infos',
                            'default_route_table': 'default_route_table',
                            }

    def __init__(self,
                 updated=None,
                 user_id=None,
                 updated_by_user_id=None,
                 created=None,
                 version=None,
                 updated_by_user_name=None,
                 user_name=None,
                 id=None,
                 cidr_block_subnet=None,
                 connected_account_id=None,
                 eni_group=None,
                 subnet_id=None,
                 cgw_present=None,
                 org_id=None,
                 sddc_id=None,
                 cidr_block_vpc=None,
                 connection_order=None,
                 state=None,
                 subnet_availability_zone=None,
                 vpc_id=None,
                 customer_eni_infos=None,
                 default_route_table=None,
                ):
        """
        :type  updated: :class:`datetime.datetime`
        :param updated: 
        :type  user_id: :class:`str`
        :param user_id: User id that last updated this record
        :type  updated_by_user_id: :class:`str`
        :param updated_by_user_id: User id that last updated this record
        :type  created: :class:`datetime.datetime`
        :param created: 
        :type  version: :class:`long`
        :param version: Version of this entity format: int32
        :type  updated_by_user_name: :class:`str` or ``None``
        :param updated_by_user_name: User name that last updated this record
        :type  user_name: :class:`str`
        :param user_name: User name that last updated this record
        :type  id: :class:`str`
        :param id: Unique ID for this entity
        :type  cidr_block_subnet: :class:`str` or ``None``
        :param cidr_block_subnet: The CIDR block of the customer's subnet this link is in.
        :type  connected_account_id: :class:`str` or ``None``
        :param connected_account_id: The corresponding connected (customer) account UUID this connection
            is attached to.
        :type  eni_group: :class:`str` or ``None``
        :param eni_group: Which group the ENIs belongs to. (deprecated)
        :type  subnet_id: :class:`str` or ``None``
        :param subnet_id: The ID of the subnet this link is to.
        :type  cgw_present: :class:`bool` or ``None``
        :param cgw_present: Determines whether the CGW is present in this connection set or
            not. Used for multi-az deployments.
        :type  org_id: :class:`str` or ``None``
        :param org_id: The org this link belongs to.
        :type  sddc_id: :class:`str` or ``None``
        :param sddc_id: The SDDC this link is used for.
        :type  cidr_block_vpc: :class:`str` or ``None``
        :param cidr_block_vpc: The CIDR block of the customer's VPC.
        :type  connection_order: :class:`long` or ``None``
        :param connection_order: The order of the connection
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`AwsSddcConnection.STATE_ACTIVE`
            * :attr:`AwsSddcConnection.STATE_BROKEN`
            * :attr:`AwsSddcConnection.STATE_DELETED`
            
             The state of the connection.
        :type  subnet_availability_zone: :class:`str` or ``None``
        :param subnet_availability_zone: Which availability zone is this connection in?
        :type  vpc_id: :class:`str` or ``None``
        :param vpc_id: The VPC ID of the subnet this link is to.
        :type  customer_eni_infos: :class:`list` of :class:`CustomerEniInfo` or ``None``
        :param customer_eni_infos: A list of all ENIs used for this connection.
        :type  default_route_table: :class:`str` or ``None``
        :param default_route_table: The default routing table in the customer's VPC.
        """
        self.updated = updated
        self.user_id = user_id
        self.updated_by_user_id = updated_by_user_id
        self.created = created
        self.version = version
        self.updated_by_user_name = updated_by_user_name
        self.user_name = user_name
        self.id = id
        self.cidr_block_subnet = cidr_block_subnet
        self.connected_account_id = connected_account_id
        self.eni_group = eni_group
        self.subnet_id = subnet_id
        self.cgw_present = cgw_present
        self.org_id = org_id
        self.sddc_id = sddc_id
        self.cidr_block_vpc = cidr_block_vpc
        self.connection_order = connection_order
        self.state = state
        self.subnet_availability_zone = subnet_availability_zone
        self.vpc_id = vpc_id
        self.customer_eni_infos = customer_eni_infos
        self.default_route_table = default_route_table
        VapiStruct.__init__(self)


AwsSddcConnection._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_sddc_connection', {
        'updated': type.DateTimeType(),
        'user_id': type.StringType(),
        'updated_by_user_id': type.StringType(),
        'created': type.DateTimeType(),
        'version': type.IntegerType(),
        'updated_by_user_name': type.OptionalType(type.StringType()),
        'user_name': type.StringType(),
        'id': type.StringType(),
        'cidr_block_subnet': type.OptionalType(type.StringType()),
        'connected_account_id': type.OptionalType(type.StringType()),
        'eni_group': type.OptionalType(type.StringType()),
        'subnet_id': type.OptionalType(type.StringType()),
        'cgw_present': type.OptionalType(type.BooleanType()),
        'org_id': type.OptionalType(type.StringType()),
        'sddc_id': type.OptionalType(type.StringType()),
        'cidr_block_vpc': type.OptionalType(type.StringType()),
        'connection_order': type.OptionalType(type.IntegerType()),
        'state': type.OptionalType(type.StringType()),
        'subnet_availability_zone': type.OptionalType(type.StringType()),
        'vpc_id': type.OptionalType(type.StringType()),
        'customer_eni_infos': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CustomerEniInfo'))),
        'default_route_table': type.OptionalType(type.StringType()),
    },
    AwsSddcConnection,
    False,
    None))



class AwsSddcResourceConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AWS"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'backup_restore_bucket': 'backup_restore_bucket',
                            'public_ip_pool': 'public_ip_pool',
                            'vpc_info': 'vpc_info',
                            'kms_vpc_endpoint': 'kms_vpc_endpoint',
                            'max_num_public_ip': 'max_num_public_ip',
                            'account_link_sddc_config': 'account_link_sddc_config',
                            'vsan_encryption_config': 'vsan_encryption_config',
                            'esx_instance_profile': 'esx_instance_profile',
                            'vpc_info_peered_agent': 'vpc_info_peered_agent',
                            'mgmt_appliance_network_name': 'mgmt_appliance_network_name',
                            'mgw_id': 'mgw_id',
                            'nsx_mgr_url': 'nsx_mgr_url',
                            'skip_creating_vxlan': 'skip_creating_vxlan',
                            'nsx_cloud_audit_password': 'nsx_cloud_audit_password',
                            'management_ds': 'management_ds',
                            'nsx_api_public_endpoint_url': 'nsx_api_public_endpoint_url',
                            'sddc_networks': 'sddc_networks',
                            'clusters': 'clusters',
                            'deployment_type': 'deployment_type',
                            'nsx_mgr_management_ip': 'nsx_mgr_management_ip',
                            'nsx_cloud_audit': 'nsx_cloud_audit',
                            'esx_cluster_id': 'esx_cluster_id',
                            'vc_public_ip': 'vc_public_ip',
                            'vc_url': 'vc_url',
                            'esx_hosts': 'esx_hosts',
                            'vc_management_ip': 'vc_management_ip',
                            'management_rp': 'management_rp',
                            'witness_availability_zone': 'witness_availability_zone',
                            'sddc_desired_state': 'sddc_desired_state',
                            'sddc_size': 'sddc_size',
                            'cvds_enabled': 'cvds_enabled',
                            'nsx_controller_ips': 'nsx_controller_ips',
                            'two_hostname_vc_deployment': 'two_hostname_vc_deployment',
                            'esx_host_subnet': 'esx_host_subnet',
                            'sso_domain': 'sso_domain',
                            'msft_license_config': 'msft_license_config',
                            'region': 'region',
                            'outpost_config': 'outpost_config',
                            'nsxt': 'nsxt',
                            'psc_management_ip': 'psc_management_ip',
                            'psc_url': 'psc_url',
                            'cgws': 'cgws',
                            'availability_zones': 'availability_zones',
                            'custom_properties': 'custom_properties',
                            'cloud_password': 'cloud_password',
                            'provider': 'provider',
                            'nsx_cloud_admin_password': 'nsx_cloud_admin_password',
                            'cloud_username': 'cloud_username',
                            'vc_instance_id': 'vc_instance_id',
                            'cloud_user_group': 'cloud_user_group',
                            'vlcm_enabled': 'vlcm_enabled',
                            'sddc_manifest': 'sddc_manifest',
                            'vxlan_subnet': 'vxlan_subnet',
                            'sddc_security': 'sddc_security',
                            'sddc_id': 'sddc_id',
                            'pop_agent_xeni_connection': 'pop_agent_xeni_connection',
                            'nsx_mgr_login_url': 'nsx_mgr_login_url',
                            'dns_with_management_vm_private_ip': 'dns_with_management_vm_private_ip',
                            'nsx_cloud_admin': 'nsx_cloud_admin',
                            'nsxt_addons': 'nsxt_addons',
                            }

    def __init__(self,
                 backup_restore_bucket=None,
                 public_ip_pool=None,
                 vpc_info=None,
                 kms_vpc_endpoint=None,
                 max_num_public_ip=None,
                 account_link_sddc_config=None,
                 vsan_encryption_config=None,
                 esx_instance_profile=None,
                 vpc_info_peered_agent=None,
                 mgmt_appliance_network_name=None,
                 mgw_id=None,
                 nsx_mgr_url=None,
                 skip_creating_vxlan=None,
                 nsx_cloud_audit_password=None,
                 management_ds=None,
                 nsx_api_public_endpoint_url=None,
                 sddc_networks=None,
                 clusters=None,
                 deployment_type=None,
                 nsx_mgr_management_ip=None,
                 nsx_cloud_audit=None,
                 esx_cluster_id=None,
                 vc_public_ip=None,
                 vc_url=None,
                 esx_hosts=None,
                 vc_management_ip=None,
                 management_rp=None,
                 witness_availability_zone=None,
                 sddc_desired_state=None,
                 sddc_size=None,
                 cvds_enabled=None,
                 nsx_controller_ips=None,
                 two_hostname_vc_deployment=None,
                 esx_host_subnet=None,
                 sso_domain=None,
                 msft_license_config=None,
                 region=None,
                 outpost_config=None,
                 nsxt=None,
                 psc_management_ip=None,
                 psc_url=None,
                 cgws=None,
                 availability_zones=None,
                 custom_properties=None,
                 cloud_password=None,
                 provider='AWS',
                 nsx_cloud_admin_password=None,
                 cloud_username=None,
                 vc_instance_id=None,
                 cloud_user_group=None,
                 vlcm_enabled=None,
                 sddc_manifest=None,
                 vxlan_subnet=None,
                 sddc_security=None,
                 sddc_id=None,
                 pop_agent_xeni_connection=None,
                 nsx_mgr_login_url=None,
                 dns_with_management_vm_private_ip=None,
                 nsx_cloud_admin=None,
                 nsxt_addons=None,
                ):
        """
        :type  backup_restore_bucket: :class:`str` or ``None``
        :param backup_restore_bucket: 
        :type  public_ip_pool: :class:`list` of :class:`SddcPublicIp` or ``None``
        :param public_ip_pool: 
        :type  vpc_info: :class:`VpcInfo` or ``None``
        :param vpc_info: 
        :type  kms_vpc_endpoint: :class:`KmsVpcEndpoint` or ``None``
        :param kms_vpc_endpoint: 
        :type  max_num_public_ip: :class:`long` or ``None``
        :param max_num_public_ip: maximum number of public IP that user can allocate.
        :type  account_link_sddc_config: :class:`list` of :class:`SddcLinkConfig` or ``None``
        :param account_link_sddc_config: 
        :type  vsan_encryption_config: :class:`VsanEncryptionConfig` or ``None``
        :param vsan_encryption_config: 
        :type  esx_instance_profile: :class:`InstanceProfileInfo` or ``None``
        :param esx_instance_profile: 
        :type  vpc_info_peered_agent: :class:`VpcInfo` or ``None``
        :param vpc_info_peered_agent: 
        :type  mgmt_appliance_network_name: :class:`str` or ``None``
        :param mgmt_appliance_network_name: Name for management appliance network.
        :type  mgw_id: :class:`str` or ``None``
        :param mgw_id: Management Gateway Id
        :type  nsx_mgr_url: :class:`str` or ``None``
        :param nsx_mgr_url: URL of the NSX Manager
        :type  skip_creating_vxlan: :class:`bool` or ``None``
        :param skip_creating_vxlan: skip creating vxlan for compute gateway for SDDC provisioning
        :type  nsx_cloud_audit_password: :class:`str` or ``None``
        :param nsx_cloud_audit_password: NSX cloud audit Password
        :type  management_ds: :class:`str` or ``None``
        :param management_ds: The ManagedObjectReference of the management Datastore
        :type  nsx_api_public_endpoint_url: :class:`str` or ``None``
        :param nsx_api_public_endpoint_url: nsx api entire base url
        :type  sddc_networks: :class:`list` of :class:`str` or ``None``
        :param sddc_networks: 
        :type  clusters: :class:`list` of :class:`Cluster` or ``None``
        :param clusters: List of clusters in the SDDC.
        :type  deployment_type: :class:`str` or ``None``
        :param deployment_type: Possible values are: 
            
            * :attr:`SddcResourceConfig.DEPLOYMENT_TYPE_SINGLE_AZ`
            * :attr:`SddcResourceConfig.DEPLOYMENT_TYPE_MULTI_AZ`
            
             Denotes if this is a SingleAZ SDDC or a MultiAZ SDDC.
        :type  nsx_mgr_management_ip: :class:`str` or ``None``
        :param nsx_mgr_management_ip: NSX Manager internal management IP
        :type  nsx_cloud_audit: :class:`str` or ``None``
        :param nsx_cloud_audit: NSX cloud audit user name
        :type  esx_cluster_id: :class:`str` or ``None``
        :param esx_cluster_id: Cluster Id to add ESX workflow
        :type  vc_public_ip: :class:`str` or ``None``
        :param vc_public_ip: vCenter public IP
        :type  vc_url: :class:`str` or ``None``
        :param vc_url: URL of the vCenter server
        :type  esx_hosts: :class:`list` of :class:`AwsEsxHost` or ``None``
        :param esx_hosts: 
        :type  vc_management_ip: :class:`str` or ``None``
        :param vc_management_ip: vCenter internal management IP
        :type  management_rp: :class:`str` or ``None``
        :param management_rp: 
        :type  witness_availability_zone: :class:`str` or ``None``
        :param witness_availability_zone: Availability zone where the witness node is provisioned for a
            MultiAZ SDDC. This is null for a SingleAZ SDDC.
        :type  sddc_desired_state: :class:`bool` or ``None``
        :param sddc_desired_state: Whether this sddc is maintained by its desired state documents.
        :type  sddc_size: :class:`SddcSize` or ``None``
        :param sddc_size: 
        :type  cvds_enabled: :class:`bool` or ``None``
        :param cvds_enabled: This flag determines whether CVDS is enabled on this sddc or not.
        :type  nsx_controller_ips: :class:`list` of :class:`str` or ``None``
        :param nsx_controller_ips: List of Controller IPs
        :type  two_hostname_vc_deployment: :class:`bool` or ``None``
        :param two_hostname_vc_deployment: Marks that the SDDC VC should be deployed with two hostnames.
        :type  esx_host_subnet: :class:`str` or ``None``
        :param esx_host_subnet: ESX host subnet
        :type  sso_domain: :class:`str` or ``None``
        :param sso_domain: The SSO domain name to use for vSphere users
        :type  msft_license_config: :class:`MsftLicensingConfig` or ``None``
        :param msft_license_config: The Microsoft license status of this SDDC.
        :type  region: :class:`str` or ``None``
        :param region: region in which sddc is deployed
        :type  outpost_config: :class:`OutpostConfig` or ``None``
        :param outpost_config: Outpost configuration of this SDDC.
        :type  nsxt: :class:`bool` or ``None``
        :param nsxt: if true, NSX-T UI is enabled.
        :type  psc_management_ip: :class:`str` or ``None``
        :param psc_management_ip: PSC internal management IP
        :type  psc_url: :class:`str` or ``None``
        :param psc_url: URL of the PSC server
        :type  cgws: :class:`list` of :class:`str` or ``None``
        :param cgws: 
        :type  availability_zones: :class:`list` of :class:`str` or ``None``
        :param availability_zones: Availability zones over which esx hosts are provisioned. MultiAZ
            SDDCs will have hosts provisioned over two availability zones while
            SingleAZ SDDCs will provision over one.
        :type  custom_properties: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param custom_properties: 
        :type  cloud_password: :class:`str` or ``None``
        :param cloud_password: Password for vCenter SDDC administrator
        :type  provider: :class:`str`
        :param provider: Possible values are: 
            
            * :attr:`SddcResourceConfig.PROVIDER_AWS`
            * :attr:`SddcResourceConfig.PROVIDER_ZEROCLOUD`
            
             Discriminator for additional properties
        :type  nsx_cloud_admin_password: :class:`str` or ``None``
        :param nsx_cloud_admin_password: NSX cloud admin password
        :type  cloud_username: :class:`str` or ``None``
        :param cloud_username: Username for vCenter SDDC administrator
        :type  vc_instance_id: :class:`str` or ``None``
        :param vc_instance_id: unique id of the vCenter server
        :type  cloud_user_group: :class:`str` or ``None``
        :param cloud_user_group: Group name for vCenter SDDC administrator
        :type  vlcm_enabled: :class:`bool` or ``None``
        :param vlcm_enabled: This flag determines whether vLCM is enabled on this sddc or not.
        :type  sddc_manifest: :class:`SddcManifest` or ``None``
        :param sddc_manifest: 
        :type  vxlan_subnet: :class:`str` or ``None``
        :param vxlan_subnet: VXLAN IP subnet
        :type  sddc_security: :class:`SddcSecurity` or ``None``
        :param sddc_security: 
        :type  sddc_id: :class:`str` or ``None``
        :param sddc_id: sddc identifier
        :type  pop_agent_xeni_connection: :class:`PopAgentXeniConnection` or ``None``
        :param pop_agent_xeni_connection: 
        :type  nsx_mgr_login_url: :class:`str` or ``None``
        :param nsx_mgr_login_url: URL of the NSX Manager UI login for local user access
        :type  dns_with_management_vm_private_ip: :class:`bool` or ``None``
        :param dns_with_management_vm_private_ip: if true, use the private IP addresses to register DNS records for
            the management VMs
        :type  nsx_cloud_admin: :class:`str` or ``None``
        :param nsx_cloud_admin: NSX cloud admin user name
        :type  nsxt_addons: :class:`NsxtAddons` or ``None``
        :param nsxt_addons: 
        """
        self.backup_restore_bucket = backup_restore_bucket
        self.public_ip_pool = public_ip_pool
        self.vpc_info = vpc_info
        self.kms_vpc_endpoint = kms_vpc_endpoint
        self.max_num_public_ip = max_num_public_ip
        self.account_link_sddc_config = account_link_sddc_config
        self.vsan_encryption_config = vsan_encryption_config
        self.esx_instance_profile = esx_instance_profile
        self.vpc_info_peered_agent = vpc_info_peered_agent
        self.mgmt_appliance_network_name = mgmt_appliance_network_name
        self.mgw_id = mgw_id
        self.nsx_mgr_url = nsx_mgr_url
        self.skip_creating_vxlan = skip_creating_vxlan
        self.nsx_cloud_audit_password = nsx_cloud_audit_password
        self.management_ds = management_ds
        self.nsx_api_public_endpoint_url = nsx_api_public_endpoint_url
        self.sddc_networks = sddc_networks
        self.clusters = clusters
        self.deployment_type = deployment_type
        self.nsx_mgr_management_ip = nsx_mgr_management_ip
        self.nsx_cloud_audit = nsx_cloud_audit
        self.esx_cluster_id = esx_cluster_id
        self.vc_public_ip = vc_public_ip
        self.vc_url = vc_url
        self.esx_hosts = esx_hosts
        self.vc_management_ip = vc_management_ip
        self.management_rp = management_rp
        self.witness_availability_zone = witness_availability_zone
        self.sddc_desired_state = sddc_desired_state
        self.sddc_size = sddc_size
        self.cvds_enabled = cvds_enabled
        self.nsx_controller_ips = nsx_controller_ips
        self.two_hostname_vc_deployment = two_hostname_vc_deployment
        self.esx_host_subnet = esx_host_subnet
        self.sso_domain = sso_domain
        self.msft_license_config = msft_license_config
        self.region = region
        self.outpost_config = outpost_config
        self.nsxt = nsxt
        self.psc_management_ip = psc_management_ip
        self.psc_url = psc_url
        self.cgws = cgws
        self.availability_zones = availability_zones
        self.custom_properties = custom_properties
        self.cloud_password = cloud_password
        self._provider = provider
        self.nsx_cloud_admin_password = nsx_cloud_admin_password
        self.cloud_username = cloud_username
        self.vc_instance_id = vc_instance_id
        self.cloud_user_group = cloud_user_group
        self.vlcm_enabled = vlcm_enabled
        self.sddc_manifest = sddc_manifest
        self.vxlan_subnet = vxlan_subnet
        self.sddc_security = sddc_security
        self.sddc_id = sddc_id
        self.pop_agent_xeni_connection = pop_agent_xeni_connection
        self.nsx_mgr_login_url = nsx_mgr_login_url
        self.dns_with_management_vm_private_ip = dns_with_management_vm_private_ip
        self.nsx_cloud_admin = nsx_cloud_admin
        self.nsxt_addons = nsxt_addons
        VapiStruct.__init__(self)

    @property
    def provider(self):
        """
        Return the discriminator value
        """
        return self._provider

AwsSddcResourceConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_sddc_resource_config', {
        'backup_restore_bucket': type.OptionalType(type.StringType()),
        'public_ip_pool': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SddcPublicIp'))),
        'vpc_info': type.OptionalType(type.ReferenceType(__name__, 'VpcInfo')),
        'kms_vpc_endpoint': type.OptionalType(type.ReferenceType(__name__, 'KmsVpcEndpoint')),
        'max_num_public_ip': type.OptionalType(type.IntegerType()),
        'account_link_sddc_config': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SddcLinkConfig'))),
        'vsan_encryption_config': type.OptionalType(type.ReferenceType(__name__, 'VsanEncryptionConfig')),
        'esx_instance_profile': type.OptionalType(type.ReferenceType(__name__, 'InstanceProfileInfo')),
        'vpc_info_peered_agent': type.OptionalType(type.ReferenceType(__name__, 'VpcInfo')),
        'mgmt_appliance_network_name': type.OptionalType(type.StringType()),
        'mgw_id': type.OptionalType(type.StringType()),
        'nsx_mgr_url': type.OptionalType(type.StringType()),
        'skip_creating_vxlan': type.OptionalType(type.BooleanType()),
        'nsx_cloud_audit_password': type.OptionalType(type.StringType()),
        'management_ds': type.OptionalType(type.StringType()),
        'nsx_api_public_endpoint_url': type.OptionalType(type.StringType()),
        'sddc_networks': type.OptionalType(type.ListType(type.StringType())),
        'clusters': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Cluster'))),
        'deployment_type': type.OptionalType(type.StringType()),
        'nsx_mgr_management_ip': type.OptionalType(type.StringType()),
        'nsx_cloud_audit': type.OptionalType(type.StringType()),
        'esx_cluster_id': type.OptionalType(type.StringType()),
        'vc_public_ip': type.OptionalType(type.StringType()),
        'vc_url': type.OptionalType(type.StringType()),
        'esx_hosts': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AwsEsxHost'))),
        'vc_management_ip': type.OptionalType(type.StringType()),
        'management_rp': type.OptionalType(type.StringType()),
        'witness_availability_zone': type.OptionalType(type.StringType()),
        'sddc_desired_state': type.OptionalType(type.BooleanType()),
        'sddc_size': type.OptionalType(type.ReferenceType(__name__, 'SddcSize')),
        'cvds_enabled': type.OptionalType(type.BooleanType()),
        'nsx_controller_ips': type.OptionalType(type.ListType(type.StringType())),
        'two_hostname_vc_deployment': type.OptionalType(type.BooleanType()),
        'esx_host_subnet': type.OptionalType(type.StringType()),
        'sso_domain': type.OptionalType(type.StringType()),
        'msft_license_config': type.OptionalType(type.ReferenceType(__name__, 'MsftLicensingConfig')),
        'region': type.OptionalType(type.StringType()),
        'outpost_config': type.OptionalType(type.ReferenceType(__name__, 'OutpostConfig')),
        'nsxt': type.OptionalType(type.BooleanType()),
        'psc_management_ip': type.OptionalType(type.StringType()),
        'psc_url': type.OptionalType(type.StringType()),
        'cgws': type.OptionalType(type.ListType(type.StringType())),
        'availability_zones': type.OptionalType(type.ListType(type.StringType())),
        'custom_properties': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
        'cloud_password': type.OptionalType(type.StringType()),
        'provider': type.StringType(),
        'nsx_cloud_admin_password': type.OptionalType(type.StringType()),
        'cloud_username': type.OptionalType(type.StringType()),
        'vc_instance_id': type.OptionalType(type.StringType()),
        'cloud_user_group': type.OptionalType(type.StringType()),
        'vlcm_enabled': type.OptionalType(type.BooleanType()),
        'sddc_manifest': type.OptionalType(type.ReferenceType(__name__, 'SddcManifest')),
        'vxlan_subnet': type.OptionalType(type.StringType()),
        'sddc_security': type.OptionalType(type.ReferenceType(__name__, 'SddcSecurity')),
        'sddc_id': type.OptionalType(type.StringType()),
        'pop_agent_xeni_connection': type.OptionalType(type.ReferenceType(__name__, 'PopAgentXeniConnection')),
        'nsx_mgr_login_url': type.OptionalType(type.StringType()),
        'dns_with_management_vm_private_ip': type.OptionalType(type.BooleanType()),
        'nsx_cloud_admin': type.OptionalType(type.StringType()),
        'nsxt_addons': type.OptionalType(type.ReferenceType(__name__, 'NsxtAddons')),
    },
    AwsSddcResourceConfig,
    False,
    None))



class AwsSubnet(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'connected_account_id': 'connected_account_id',
                            'region_name': 'region_name',
                            'availability_zone': 'availability_zone',
                            'subnet_id': 'subnet_id',
                            'subnet_cidr_block': 'subnet_cidr_block',
                            'is_compatible': 'is_compatible',
                            'vpc_id': 'vpc_id',
                            'vpc_cidr_block': 'vpc_cidr_block',
                            'name': 'name',
                            }

    def __init__(self,
                 connected_account_id=None,
                 region_name=None,
                 availability_zone=None,
                 subnet_id=None,
                 subnet_cidr_block=None,
                 is_compatible=None,
                 vpc_id=None,
                 vpc_cidr_block=None,
                 name=None,
                ):
        """
        :type  connected_account_id: :class:`str` or ``None``
        :param connected_account_id: The connected account ID this subnet is accessible through. This is
            an internal ID formatted as a UUID specific to Skyscraper.
        :type  region_name: :class:`str` or ``None``
        :param region_name: The region this subnet is in, usually in the form of country code,
            general location, and a number (ex. us-west-2).
        :type  availability_zone: :class:`str` or ``None``
        :param availability_zone: The availability zone this subnet is in, which should be the region
            name plus one extra letter (ex. us-west-2a).
        :type  subnet_id: :class:`str` or ``None``
        :param subnet_id: The subnet ID in AWS, provided in the form 'subnet-######'.
        :type  subnet_cidr_block: :class:`str` or ``None``
        :param subnet_cidr_block: The CIDR block of the subnet, in the form of '#.#.#.#/#'.
        :type  is_compatible: :class:`bool` or ``None``
        :param is_compatible: Flag indicating whether this subnet is compatible. If true, this is
            a valid choice for the customer to deploy a SDDC in.
        :type  vpc_id: :class:`str` or ``None``
        :param vpc_id: The VPC ID the subnet resides in within AWS. Tends to be
            'vpc-#######'.
        :type  vpc_cidr_block: :class:`str` or ``None``
        :param vpc_cidr_block: The CIDR block of the VPC, in the form of '#.#.#.#/#'.
        :type  name: :class:`str` or ``None``
        :param name: Optional field (may not be provided by AWS), indicates the found
            name tag for the subnet.
        """
        self.connected_account_id = connected_account_id
        self.region_name = region_name
        self.availability_zone = availability_zone
        self.subnet_id = subnet_id
        self.subnet_cidr_block = subnet_cidr_block
        self.is_compatible = is_compatible
        self.vpc_id = vpc_id
        self.vpc_cidr_block = vpc_cidr_block
        self.name = name
        VapiStruct.__init__(self)


AwsSubnet._set_binding_type(type.StructType(
    'com.vmware.vmc.model.aws_subnet', {
        'connected_account_id': type.OptionalType(type.StringType()),
        'region_name': type.OptionalType(type.StringType()),
        'availability_zone': type.OptionalType(type.StringType()),
        'subnet_id': type.OptionalType(type.StringType()),
        'subnet_cidr_block': type.OptionalType(type.StringType()),
        'is_compatible': type.OptionalType(type.BooleanType()),
        'vpc_id': type.OptionalType(type.StringType()),
        'vpc_cidr_block': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
    },
    AwsSubnet,
    False,
    None))



class CloudProvider(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "CloudProvider"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'provider': 'provider',
                            }

    def __init__(self,
                 provider='CloudProvider',
                ):
        """
        :type  provider: :class:`str`
        :param provider: Name of the Cloud Provider
        """
        self._provider = provider
        VapiStruct.__init__(self)

    @property
    def provider(self):
        """
        Return the discriminator value
        """
        return self._provider

CloudProvider._set_binding_type(type.StructType(
    'com.vmware.vmc.model.cloud_provider', {
        'provider': type.StringType(),
    },
    CloudProvider,
    False,
    None))



class Cluster(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CLUSTER_STATE_DEPLOYING = "DEPLOYING"
    """


    """
    CLUSTER_STATE_ADDING_HOSTS = "ADDING_HOSTS"
    """


    """
    CLUSTER_STATE_READY = "READY"
    """


    """
    CLUSTER_STATE_FAILED = "FAILED"
    """


    """



    _canonical_to_pep_names = {
                            'esx_host_list': 'esx_host_list',
                            'wcp_details': 'wcp_details',
                            'msft_license_config': 'msft_license_config',
                            'cluster_state': 'cluster_state',
                            'esx_host_info': 'esx_host_info',
                            'host_cpu_cores_count': 'host_cpu_cores_count',
                            'partition_placement_group_info': 'partition_placement_group_info',
                            'cluster_id': 'cluster_id',
                            'cluster_name': 'cluster_name',
                            'aws_kms_info': 'aws_kms_info',
                            'cluster_capacity': 'cluster_capacity',
                            'hyper_threading_enabled': 'hyper_threading_enabled',
                            }

    def __init__(self,
                 esx_host_list=None,
                 wcp_details=None,
                 msft_license_config=None,
                 cluster_state=None,
                 esx_host_info=None,
                 host_cpu_cores_count=None,
                 partition_placement_group_info=None,
                 cluster_id=None,
                 cluster_name=None,
                 aws_kms_info=None,
                 cluster_capacity=None,
                 hyper_threading_enabled=None,
                ):
        """
        :type  esx_host_list: :class:`list` of :class:`AwsEsxHost` or ``None``
        :param esx_host_list: 
        :type  wcp_details: :class:`WcpDetails` or ``None``
        :param wcp_details: WCP details for a given cluster
        :type  msft_license_config: :class:`MsftLicensingConfig` or ``None``
        :param msft_license_config: The Microsoft license configuration of this cluster.
        :type  cluster_state: :class:`str` or ``None``
        :param cluster_state: Possible values are: 
            
            * :attr:`Cluster.CLUSTER_STATE_DEPLOYING`
            * :attr:`Cluster.CLUSTER_STATE_ADDING_HOSTS`
            * :attr:`Cluster.CLUSTER_STATE_READY`
            * :attr:`Cluster.CLUSTER_STATE_FAILED`
        :type  esx_host_info: :class:`EsxHostInfo` or ``None``
        :param esx_host_info: Information of the hosts added to this cluster
        :type  host_cpu_cores_count: :class:`long` or ``None``
        :param host_cpu_cores_count: Number of cores enabled on ESX hosts added to this cluster format:
            int32
        :type  partition_placement_group_info: :class:`list` of :class:`PartitionPlacementGroupInfo` or ``None``
        :param partition_placement_group_info: Partition placement group infos
        :type  cluster_id: :class:`str`
        :param cluster_id: 
        :type  cluster_name: :class:`str` or ``None``
        :param cluster_name: 
        :type  aws_kms_info: :class:`AwsKmsInfo` or ``None``
        :param aws_kms_info: AWS Key Management Service information associated with this cluster
        :type  cluster_capacity: :class:`EntityCapacity` or ``None``
        :param cluster_capacity: The capacity of this cluster.
        :type  hyper_threading_enabled: :class:`bool` or ``None``
        :param hyper_threading_enabled: Specifies whether hyperThreading is disabled/enabled explicitly
        """
        self.esx_host_list = esx_host_list
        self.wcp_details = wcp_details
        self.msft_license_config = msft_license_config
        self.cluster_state = cluster_state
        self.esx_host_info = esx_host_info
        self.host_cpu_cores_count = host_cpu_cores_count
        self.partition_placement_group_info = partition_placement_group_info
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.aws_kms_info = aws_kms_info
        self.cluster_capacity = cluster_capacity
        self.hyper_threading_enabled = hyper_threading_enabled
        VapiStruct.__init__(self)


Cluster._set_binding_type(type.StructType(
    'com.vmware.vmc.model.cluster', {
        'esx_host_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AwsEsxHost'))),
        'wcp_details': type.OptionalType(type.ReferenceType(__name__, 'WcpDetails')),
        'msft_license_config': type.OptionalType(type.ReferenceType(__name__, 'MsftLicensingConfig')),
        'cluster_state': type.OptionalType(type.StringType()),
        'esx_host_info': type.OptionalType(type.ReferenceType(__name__, 'EsxHostInfo')),
        'host_cpu_cores_count': type.OptionalType(type.IntegerType()),
        'partition_placement_group_info': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'PartitionPlacementGroupInfo'))),
        'cluster_id': type.StringType(),
        'cluster_name': type.OptionalType(type.StringType()),
        'aws_kms_info': type.OptionalType(type.ReferenceType(__name__, 'AwsKmsInfo')),
        'cluster_capacity': type.OptionalType(type.ReferenceType(__name__, 'EntityCapacity')),
        'hyper_threading_enabled': type.OptionalType(type.BooleanType()),
    },
    Cluster,
    False,
    None))



class ClusterConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'host_cpu_cores_count': 'host_cpu_cores_count',
                            'host_instance_type': 'host_instance_type',
                            'storage_capacity': 'storage_capacity',
                            'msft_license_config': 'msft_license_config',
                            'num_hosts': 'num_hosts',
                            }

    def __init__(self,
                 host_cpu_cores_count=None,
                 host_instance_type=None,
                 storage_capacity=None,
                 msft_license_config=None,
                 num_hosts=None,
                ):
        """
        :type  host_cpu_cores_count: :class:`long` or ``None``
        :param host_cpu_cores_count: Customize CPU cores on hosts in a cluster. Specify number of cores
            to be enabled on hosts in a cluster. format: int32
        :type  host_instance_type: :class:`HostInstanceTypes` or ``None``
        :param host_instance_type: The instance type for the esx hosts added to this cluster.
        :type  storage_capacity: :class:`long` or ``None``
        :param storage_capacity: For EBS-backed instances only, the requested storage capacity in
            GiB. format: int64
        :type  msft_license_config: :class:`MsftLicensingConfig` or ``None``
        :param msft_license_config: The desired Microsoft license status to apply to this cluster.
        :type  num_hosts: :class:`long`
        :param num_hosts: 
        """
        self.host_cpu_cores_count = host_cpu_cores_count
        self.host_instance_type = host_instance_type
        self.storage_capacity = storage_capacity
        self.msft_license_config = msft_license_config
        self.num_hosts = num_hosts
        VapiStruct.__init__(self)


ClusterConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.cluster_config', {
        'host_cpu_cores_count': type.OptionalType(type.IntegerType()),
        'host_instance_type': type.OptionalType(type.ReferenceType(__name__, 'HostInstanceTypes')),
        'storage_capacity': type.OptionalType(type.IntegerType()),
        'msft_license_config': type.OptionalType(type.ReferenceType(__name__, 'MsftLicensingConfig')),
        'num_hosts': type.IntegerType(),
    },
    ClusterConfig,
    False,
    None))



class ClusterReconfigureParams(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'storage_capacity': 'storage_capacity',
                            'bias': 'bias',
                            'num_hosts': 'num_hosts',
                            }

    def __init__(self,
                 storage_capacity=None,
                 bias=None,
                 num_hosts=None,
                ):
        """
        :type  storage_capacity: :class:`long` or ``None``
        :param storage_capacity: The final desired storage capacity after reconfiguring the cluster
            in GiB. format: int64
        :type  bias: :class:`str` or ``None``
        :param bias: Bias value as obtained from the storage constraints call.
        :type  num_hosts: :class:`long`
        :param num_hosts: Number of hosts in the cluster after reconfiguring. format: int32
        """
        self.storage_capacity = storage_capacity
        self.bias = bias
        self.num_hosts = num_hosts
        VapiStruct.__init__(self)


ClusterReconfigureParams._set_binding_type(type.StructType(
    'com.vmware.vmc.model.cluster_reconfigure_params', {
        'storage_capacity': type.OptionalType(type.IntegerType()),
        'bias': type.OptionalType(type.StringType()),
        'num_hosts': type.IntegerType(),
    },
    ClusterReconfigureParams,
    False,
    None))



class ComputeGatewayTemplate(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'public_ip': 'public_ip',
                            'primary_dns': 'primary_dns',
                            'secondary_dns': 'secondary_dns',
                            'firewall_rules': 'firewall_rules',
                            'vpns': 'vpns',
                            'logical_networks': 'logical_networks',
                            'nat_rules': 'nat_rules',
                            'l2_vpn': 'l2_vpn',
                            }

    def __init__(self,
                 public_ip=None,
                 primary_dns=None,
                 secondary_dns=None,
                 firewall_rules=None,
                 vpns=None,
                 logical_networks=None,
                 nat_rules=None,
                 l2_vpn=None,
                ):
        """
        :type  public_ip: :class:`SddcPublicIp` or ``None``
        :param public_ip: 
        :type  primary_dns: :class:`str` or ``None``
        :param primary_dns: 
        :type  secondary_dns: :class:`str` or ``None``
        :param secondary_dns: 
        :type  firewall_rules: :class:`list` of :class:`FirewallRule` or ``None``
        :param firewall_rules: 
        :type  vpns: :class:`list` of :class:`Vpn` or ``None``
        :param vpns: 
        :type  logical_networks: :class:`list` of :class:`LogicalNetwork` or ``None``
        :param logical_networks: 
        :type  nat_rules: :class:`list` of :class:`NatRule` or ``None``
        :param nat_rules: 
        :type  l2_vpn: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param l2_vpn: 
        """
        self.public_ip = public_ip
        self.primary_dns = primary_dns
        self.secondary_dns = secondary_dns
        self.firewall_rules = firewall_rules
        self.vpns = vpns
        self.logical_networks = logical_networks
        self.nat_rules = nat_rules
        self.l2_vpn = l2_vpn
        VapiStruct.__init__(self)


ComputeGatewayTemplate._set_binding_type(type.StructType(
    'com.vmware.vmc.model.compute_gateway_template', {
        'public_ip': type.OptionalType(type.ReferenceType(__name__, 'SddcPublicIp')),
        'primary_dns': type.OptionalType(type.StringType()),
        'secondary_dns': type.OptionalType(type.StringType()),
        'firewall_rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'FirewallRule'))),
        'vpns': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Vpn'))),
        'logical_networks': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'LogicalNetwork'))),
        'nat_rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'NatRule'))),
        'l2_vpn': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
    },
    ComputeGatewayTemplate,
    False,
    None))



class ConfigSpec(VapiStruct):
    """
    Represents a configuration spec for any sddc provision operation.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'powered_by_outpost_available': 'powered_by_outpost_available',
                            'expiry_in_days': 'expiry_in_days',
                            'sddc_sizes': 'sddc_sizes',
                            'availability': 'availability',
                            'powered_by': 'powered_by',
                            }

    def __init__(self,
                 powered_by_outpost_available=None,
                 expiry_in_days=None,
                 sddc_sizes=None,
                 availability=None,
                 powered_by=None,
                ):
        """
        :type  powered_by_outpost_available: :class:`bool` or ``None``
        :param powered_by_outpost_available: Indicates if this org supports deployments that are powered by VMC
            on outposts
        :type  expiry_in_days: :class:`long` or ``None``
        :param expiry_in_days: Indicates after how many days the sddc should expire
        :type  sddc_sizes: :class:`list` of :class:`str` or ``None``
        :param sddc_sizes: 
        :type  availability: (:class:`dict` of :class:`str` and :class:`list` of :class:`InstanceTypeConfig`) or ``None``
        :param availability: Map of region to instance types available in that region
        :type  powered_by: (:class:`dict` of :class:`str` and :class:`list` of :class:`PoweredByInstanceTypeConfig`) or ``None``
        :param powered_by: Map of region to instance types available for the powered by type.
        """
        self.powered_by_outpost_available = powered_by_outpost_available
        self.expiry_in_days = expiry_in_days
        self.sddc_sizes = sddc_sizes
        self.availability = availability
        self.powered_by = powered_by
        VapiStruct.__init__(self)


ConfigSpec._set_binding_type(type.StructType(
    'com.vmware.vmc.model.config_spec', {
        'powered_by_outpost_available': type.OptionalType(type.BooleanType()),
        'expiry_in_days': type.OptionalType(type.IntegerType()),
        'sddc_sizes': type.OptionalType(type.ListType(type.StringType())),
        'availability': type.OptionalType(type.MapType(type.StringType(), type.ListType(type.ReferenceType(__name__, 'InstanceTypeConfig')))),
        'powered_by': type.OptionalType(type.MapType(type.StringType(), type.ListType(type.ReferenceType(__name__, 'PoweredByInstanceTypeConfig')))),
    },
    ConfigSpec,
    False,
    None))



class ConnectivityAgentValidation(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SOURCE_VCENTER = "VCENTER"
    """


    """
    SOURCE_SRM = "SRM"
    """


    """
    SOURCE_VR = "VR"
    """


    """
    TYPE_PING = "PING"
    """


    """
    TYPE_TRACEROUTE = "TRACEROUTE"
    """


    """
    TYPE_DNS = "DNS"
    """


    """
    TYPE_CONNECTIVITY = "CONNECTIVITY"
    """


    """
    TYPE_CURL = "CURL"
    """


    """



    _canonical_to_pep_names = {
                            'source': 'source',
                            'path': 'path',
                            'type': 'type',
                            'ports': 'ports',
                            'pktsize': 'pktsize',
                            }

    def __init__(self,
                 source=None,
                 path=None,
                 type=None,
                 ports=None,
                 pktsize=None,
                ):
        """
        :type  source: :class:`str` or ``None``
        :param source: Possible values are: 
            
            * :attr:`ConnectivityAgentValidation.SOURCE_VCENTER`
            * :attr:`ConnectivityAgentValidation.SOURCE_SRM`
            * :attr:`ConnectivityAgentValidation.SOURCE_VR`
            
             source appliance of connectivity test, i.e. VCENTER, SRM, VR.
        :type  path: :class:`str` or ``None``
        :param path: URL path ONLY for CURL tests.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ConnectivityAgentValidation.TYPE_PING`
            * :attr:`ConnectivityAgentValidation.TYPE_TRACEROUTE`
            * :attr:`ConnectivityAgentValidation.TYPE_DNS`
            * :attr:`ConnectivityAgentValidation.TYPE_CONNECTIVITY`
            * :attr:`ConnectivityAgentValidation.TYPE_CURL`
            
            type of connectivity test, i.e. PING, TRACEROUTE, DNS,
            CONNECTIVITY, CURL. For CONNECTIVITY and CURL tests only, please
            specify the ports to be tested against.
        :type  ports: :class:`list` of :class:`str` or ``None``
        :param ports: TCP ports ONLY for CONNECTIVITY and CURL tests.
        :type  pktsize: :class:`str` or ``None``
        :param pktsize: Package size option used ONLY for PING tests.
        """
        self.source = source
        self.path = path
        self.type = type
        self.ports = ports
        self.pktsize = pktsize
        VapiStruct.__init__(self)


ConnectivityAgentValidation._set_binding_type(type.StructType(
    'com.vmware.vmc.model.connectivity_agent_validation', {
        'source': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
        'ports': type.OptionalType(type.ListType(type.StringType())),
        'pktsize': type.OptionalType(type.StringType()),
    },
    ConnectivityAgentValidation,
    False,
    None))



class ConnectivityValidationGroup(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ID_HLM = "HLM"
    """


    """
    ID_DRAAS = "DRAAS"
    """


    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'name': 'name',
                            'sub_groups': 'sub_groups',
                            }

    def __init__(self,
                 id=None,
                 name=None,
                 sub_groups=None,
                ):
        """
        :type  id: :class:`str` or ``None``
        :param id: Possible values are: 
            
            * :attr:`ConnectivityValidationGroup.ID_HLM`
            * :attr:`ConnectivityValidationGroup.ID_DRAAS`
            
             test group id, currently, only HLM.
        :type  name: :class:`str` or ``None``
        :param name: Name of the test group.
        :type  sub_groups: :class:`list` of :class:`ConnectivityValidationSubGroup` or ``None``
        :param sub_groups: List of sub groups.
        """
        self.id = id
        self.name = name
        self.sub_groups = sub_groups
        VapiStruct.__init__(self)


ConnectivityValidationGroup._set_binding_type(type.StructType(
    'com.vmware.vmc.model.connectivity_validation_group', {
        'id': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'sub_groups': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ConnectivityValidationSubGroup'))),
    },
    ConnectivityValidationGroup,
    False,
    None))



class ConnectivityValidationGroups(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'groups': 'groups',
                            }

    def __init__(self,
                 groups=None,
                ):
        """
        :type  groups: :class:`list` of :class:`ConnectivityValidationGroup` or ``None``
        :param groups: List of groups.
        """
        self.groups = groups
        VapiStruct.__init__(self)


ConnectivityValidationGroups._set_binding_type(type.StructType(
    'com.vmware.vmc.model.connectivity_validation_groups', {
        'groups': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ConnectivityValidationGroup'))),
    },
    ConnectivityValidationGroups,
    False,
    None))



class ConnectivityValidationInput(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ID_HOSTNAME = "HOSTNAME"
    """


    """
    ID_HOST_IP = "HOST_IP"
    """


    """
    ID_HOSTNAME_OR_IP = "HOSTNAME_OR_IP"
    """


    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'value': 'value',
                            'label': 'label',
                            }

    def __init__(self,
                 id=None,
                 value=None,
                 label=None,
                ):
        """
        :type  id: :class:`str` or ``None``
        :param id: Possible values are: 
            
            * :attr:`ConnectivityValidationInput.ID_HOSTNAME`
            * :attr:`ConnectivityValidationInput.ID_HOST_IP`
            * :attr:`ConnectivityValidationInput.ID_HOSTNAME_OR_IP`
            
            input value type, i.e. HOSTNAME_OR_IP, HOST_IP, HOSTNAME. Accept
            FQDN or IP address as input value when id = HOSTNAME_OR_IP, accept
            FQDN ONLY when id = HOSTNAME, accept IP address ONLY when id =
            HOST_IP.
        :type  value: :class:`str` or ``None``
        :param value: the FQDN or IP address to run the test against, use \\#primary-dns
            or \\#secondary-dns as the on-prem primary/secondary DNS server IP.
        :type  label: :class:`str` or ``None``
        :param label: (Optional, for UI display only) input value label.
        """
        self.id = id
        self.value = value
        self.label = label
        VapiStruct.__init__(self)


ConnectivityValidationInput._set_binding_type(type.StructType(
    'com.vmware.vmc.model.connectivity_validation_input', {
        'id': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.StringType()),
        'label': type.OptionalType(type.StringType()),
    },
    ConnectivityValidationInput,
    False,
    None))



class ConnectivityValidationSubGroup(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ID_PRIMARY_DNS = "PRIMARY_DNS"
    """


    """
    ID_SECONDARY_DNS = "SECONDARY_DNS"
    """


    """
    ID_ONPREM_VCENTER = "ONPREM_VCENTER"
    """


    """
    ID_ONPREM_PSC = "ONPREM_PSC"
    """


    """
    ID_ACTIVE_DIRECTORY = "ACTIVE_DIRECTORY"
    """


    """
    ID_ONPREM_ESX = "ONPREM_ESX"
    """


    """
    ID_DRAAS_ONPREM_VCENTER = "DRAAS_ONPREM_VCENTER"
    """


    """
    ID_DRAAS_ONPREM_PSC = "DRAAS_ONPREM_PSC"
    """


    """
    ID_DRAAS_ONPREM_SRM = "DRAAS_ONPREM_SRM"
    """


    """
    ID_DRAAS_ONPREM_VR = "DRAAS_ONPREM_VR"
    """


    """



    _canonical_to_pep_names = {
                            'inputs': 'inputs',
                            'tests': 'tests',
                            'label': 'label',
                            'help': 'help',
                            'id': 'id',
                            }

    def __init__(self,
                 inputs=None,
                 tests=None,
                 label=None,
                 help=None,
                 id=None,
                ):
        """
        :type  inputs: :class:`list` of :class:`ConnectivityValidationInput` or ``None``
        :param inputs: List of user inputs for the sub group.
        :type  tests: :class:`list` of :class:`ConnectivityAgentValidation` or ``None``
        :param tests: List of connectivity tests.
        :type  label: :class:`str` or ``None``
        :param label: Name of the sub-group.
        :type  help: :class:`str` or ``None``
        :param help: Help text.
        :type  id: :class:`str` or ``None``
        :param id: Possible values are: 
            
            * :attr:`ConnectivityValidationSubGroup.ID_PRIMARY_DNS`
            * :attr:`ConnectivityValidationSubGroup.ID_SECONDARY_DNS`
            * :attr:`ConnectivityValidationSubGroup.ID_ONPREM_VCENTER`
            * :attr:`ConnectivityValidationSubGroup.ID_ONPREM_PSC`
            * :attr:`ConnectivityValidationSubGroup.ID_ACTIVE_DIRECTORY`
            * :attr:`ConnectivityValidationSubGroup.ID_ONPREM_ESX`
            * :attr:`ConnectivityValidationSubGroup.ID_DRAAS_ONPREM_VCENTER`
            * :attr:`ConnectivityValidationSubGroup.ID_DRAAS_ONPREM_PSC`
            * :attr:`ConnectivityValidationSubGroup.ID_DRAAS_ONPREM_SRM`
            * :attr:`ConnectivityValidationSubGroup.ID_DRAAS_ONPREM_VR`
            
            subGroup id, i.e. PRIMARY_DNS, SECONDARY_DNS, ONPREM_VCENTER,
            ONPREM_PSC, ACTIVE_DIRECTORY, ONPREM_ESX, DRAAS_ONPREM_VCENTER,
            DRAAS_ONPREM_PSC, DRAAS_ONPREM_SRM and DRAAS_ONPREM_VR.
        """
        self.inputs = inputs
        self.tests = tests
        self.label = label
        self.help = help
        self.id = id
        VapiStruct.__init__(self)


ConnectivityValidationSubGroup._set_binding_type(type.StructType(
    'com.vmware.vmc.model.connectivity_validation_sub_group', {
        'inputs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ConnectivityValidationInput'))),
        'tests': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ConnectivityAgentValidation'))),
        'label': type.OptionalType(type.StringType()),
        'help': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
    },
    ConnectivityValidationSubGroup,
    False,
    None))



class CustomerEniInfo(VapiStruct):
    """
    Indicates a single cross-account ENI and its characteristics.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'secondary_ip_addresses': 'secondary_ip_addresses',
                            'eni_id': 'eni_id',
                            'primary_ip_address': 'primary_ip_address',
                            }

    def __init__(self,
                 secondary_ip_addresses=None,
                 eni_id=None,
                 primary_ip_address=None,
                ):
        """
        :type  secondary_ip_addresses: :class:`list` of :class:`str` or ``None``
        :param secondary_ip_addresses: Indicates list of secondary IP created for this ENI.
        :type  eni_id: :class:`str` or ``None``
        :param eni_id: Interface ID on customer account.
        :type  primary_ip_address: :class:`str` or ``None``
        :param primary_ip_address: Indicates primary address of the ENI.
        """
        self.secondary_ip_addresses = secondary_ip_addresses
        self.eni_id = eni_id
        self.primary_ip_address = primary_ip_address
        VapiStruct.__init__(self)


CustomerEniInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.customer_eni_info', {
        'secondary_ip_addresses': type.OptionalType(type.ListType(type.StringType())),
        'eni_id': type.OptionalType(type.StringType()),
        'primary_ip_address': type.OptionalType(type.StringType()),
    },
    CustomerEniInfo,
    False,
    None))



class EbsBackedVsanConfig(VapiStruct):
    """
    information for EBS-backed VSAN configuration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'instance_type': 'instance_type',
                            }

    def __init__(self,
                 instance_type=None,
                ):
        """
        :type  instance_type: :class:`str` or ``None``
        :param instance_type: instance type for EBS-backed VSAN configuration
        """
        self.instance_type = instance_type
        VapiStruct.__init__(self)


EbsBackedVsanConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.ebs_backed_vsan_config', {
        'instance_type': type.OptionalType(type.StringType()),
    },
    EbsBackedVsanConfig,
    False,
    None))



class EnablementInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'name': 'name',
                            }

    def __init__(self,
                 enabled=None,
                 name=None,
                ):
        """
        :type  enabled: :class:`bool`
        :param enabled: 
        :type  name: :class:`str`
        :param name: Add-on name, for example \"hcx\", \"drass\", skynet\". If it is
            \"default\", the value of enabled is for default settings of future
            add-ons.
        """
        self.enabled = enabled
        self.name = name
        VapiStruct.__init__(self)


EnablementInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.enablement_info', {
        'enabled': type.BooleanType(),
        'name': type.StringType(),
    },
    EnablementInfo,
    False,
    None))



class EniInfo(VapiStruct):
    """
    Information of the x-eni created.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'secondary_ips': 'secondary_ips',
                            'attachment_id': 'attachment_id',
                            'association_id': 'association_id',
                            'vmk_id': 'vmk_id',
                            'security_group_id': 'security_group_id',
                            'instance_id': 'instance_id',
                            'subnet_id': 'subnet_id',
                            'public_ips': 'public_ips',
                            'private_ip': 'private_ip',
                            'mac_address': 'mac_address',
                            'source_dest_check_false': 'source_dest_check_false',
                            'portgroup': 'portgroup',
                            'id': 'id',
                            }

    def __init__(self,
                 secondary_ips=None,
                 attachment_id=None,
                 association_id=None,
                 vmk_id=None,
                 security_group_id=None,
                 instance_id=None,
                 subnet_id=None,
                 public_ips=None,
                 private_ip=None,
                 mac_address=None,
                 source_dest_check_false=None,
                 portgroup=None,
                 id=None,
                ):
        """
        :type  secondary_ips: :class:`list` of :class:`str` or ``None``
        :param secondary_ips: secondary private ips to be assigned.
        :type  attachment_id: :class:`str` or ``None``
        :param attachment_id: Id of the attachment, it is used to detach eni from instance.
        :type  association_id: :class:`str` or ``None``
        :param association_id: Id of the association for branch ENI, it is used to disassociate
            branch eni from trunk eni.
        :type  vmk_id: :class:`str` or ``None``
        :param vmk_id: The vmknic id or null if the ENI does not mapped to a vmknic.
        :type  security_group_id: :class:`str` or ``None``
        :param security_group_id: Security Group of Eni.
        :type  instance_id: :class:`str` or ``None``
        :param instance_id: Id of the instance to be attached.
        :type  subnet_id: :class:`str` or ``None``
        :param subnet_id: Subnet it belongs to.
        :type  public_ips: :class:`list` of :class:`str` or ``None``
        :param public_ips: public ips to be associated with the secondary private ips.
        :type  private_ip: :class:`str` or ``None``
        :param private_ip: Private ip of eni.
        :type  mac_address: :class:`str` or ``None``
        :param mac_address: Mac address of nic.
        :type  source_dest_check_false: :class:`bool` or ``None``
        :param source_dest_check_false: Whether to set sourceDestCheck as false..
        :type  portgroup: :class:`str` or ``None``
        :param portgroup: The portgroup name or null if the ENI does not mapped to a
            portgroup.
        :type  id: :class:`str` or ``None``
        :param id: Interface ID.
        """
        self.secondary_ips = secondary_ips
        self.attachment_id = attachment_id
        self.association_id = association_id
        self.vmk_id = vmk_id
        self.security_group_id = security_group_id
        self.instance_id = instance_id
        self.subnet_id = subnet_id
        self.public_ips = public_ips
        self.private_ip = private_ip
        self.mac_address = mac_address
        self.source_dest_check_false = source_dest_check_false
        self.portgroup = portgroup
        self.id = id
        VapiStruct.__init__(self)


EniInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.eni_info', {
        'secondary_ips': type.OptionalType(type.ListType(type.StringType())),
        'attachment_id': type.OptionalType(type.StringType()),
        'association_id': type.OptionalType(type.StringType()),
        'vmk_id': type.OptionalType(type.StringType()),
        'security_group_id': type.OptionalType(type.StringType()),
        'instance_id': type.OptionalType(type.StringType()),
        'subnet_id': type.OptionalType(type.StringType()),
        'public_ips': type.OptionalType(type.ListType(type.StringType())),
        'private_ip': type.OptionalType(type.StringType()),
        'mac_address': type.OptionalType(type.StringType()),
        'source_dest_check_false': type.OptionalType(type.BooleanType()),
        'portgroup': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
    },
    EniInfo,
    False,
    None))



class EntityCapacity(VapiStruct):
    """
    Decribes the capacity of a given entity.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'storage_capacity_gib': 'storage_capacity_gib',
                            'memory_capacity_gib': 'memory_capacity_gib',
                            'total_number_of_cores': 'total_number_of_cores',
                            'number_of_ssds': 'number_of_ssds',
                            'cpu_capacity_ghz': 'cpu_capacity_ghz',
                            'number_of_sockets': 'number_of_sockets',
                            }

    def __init__(self,
                 storage_capacity_gib=None,
                 memory_capacity_gib=None,
                 total_number_of_cores=None,
                 number_of_ssds=None,
                 cpu_capacity_ghz=None,
                 number_of_sockets=None,
                ):
        """
        :type  storage_capacity_gib: :class:`long` or ``None``
        :param storage_capacity_gib: The storage capacity for the given entity in GiB.
        :type  memory_capacity_gib: :class:`long` or ``None``
        :param memory_capacity_gib: The memory capacity for the given entity in GiB.
        :type  total_number_of_cores: :class:`long` or ``None``
        :param total_number_of_cores: The number of CPU cores for the given entity.
        :type  number_of_ssds: :class:`long` or ``None``
        :param number_of_ssds: The number of SSDs for the given entity.
        :type  cpu_capacity_ghz: :class:`float` or ``None``
        :param cpu_capacity_ghz: The CPU capacity for the given entity in Ghz.
        :type  number_of_sockets: :class:`long` or ``None``
        :param number_of_sockets: The number of sockets for the given entity.
        """
        self.storage_capacity_gib = storage_capacity_gib
        self.memory_capacity_gib = memory_capacity_gib
        self.total_number_of_cores = total_number_of_cores
        self.number_of_ssds = number_of_ssds
        self.cpu_capacity_ghz = cpu_capacity_ghz
        self.number_of_sockets = number_of_sockets
        VapiStruct.__init__(self)


EntityCapacity._set_binding_type(type.StructType(
    'com.vmware.vmc.model.entity_capacity', {
        'storage_capacity_gib': type.OptionalType(type.IntegerType()),
        'memory_capacity_gib': type.OptionalType(type.IntegerType()),
        'total_number_of_cores': type.OptionalType(type.IntegerType()),
        'number_of_ssds': type.OptionalType(type.IntegerType()),
        'cpu_capacity_ghz': type.OptionalType(type.DoubleType()),
        'number_of_sockets': type.OptionalType(type.IntegerType()),
    },
    EntityCapacity,
    False,
    None))



class ErrorResponse(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'status': 'status',
                            'path': 'path',
                            'retryable': 'retryable',
                            'error_code': 'error_code',
                            'error_messages': 'error_messages',
                            }

    def __init__(self,
                 status=None,
                 path=None,
                 retryable=None,
                 error_code=None,
                 error_messages=None,
                ):
        """
        :type  status: :class:`long`
        :param status: HTTP status code
        :type  path: :class:`str`
        :param path: Originating request URI
        :type  retryable: :class:`bool`
        :param retryable: If true, client should retry operation
        :type  error_code: :class:`str`
        :param error_code: unique error code
        :type  error_messages: :class:`list` of :class:`str`
        :param error_messages: localized error messages
        """
        self.status = status
        self.path = path
        self.retryable = retryable
        self.error_code = error_code
        self.error_messages = error_messages
        VapiStruct.__init__(self)


ErrorResponse._set_binding_type(type.StructType(
    'com.vmware.vmc.model.error_response', {
        'status': type.IntegerType(),
        'path': type.StringType(),
        'retryable': type.BooleanType(),
        'error_code': type.StringType(),
        'error_messages': type.ListType(type.StringType()),
    },
    ErrorResponse,
    False,
    None))



class EsxConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'availability_zone': 'availability_zone',
                            'strict_placement': 'strict_placement',
                            'cluster_id': 'cluster_id',
                            'esxs': 'esxs',
                            'num_hosts': 'num_hosts',
                            }

    def __init__(self,
                 availability_zone=None,
                 strict_placement=None,
                 cluster_id=None,
                 esxs=None,
                 num_hosts=None,
                ):
        """
        :type  availability_zone: :class:`str` or ``None``
        :param availability_zone: Availability zone where the hosts should be provisioned. (Can be
            specified only for privileged host operations).
        :type  strict_placement: :class:`bool` or ``None``
        :param strict_placement: An option to indicate if the host needs to be strictly placed in a
            placement group. Fail the operation otherwise.
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: An optional cluster id if the esxs operation has to be on a
            specific cluster.
        :type  esxs: :class:`list` of :class:`str` or ``None``
        :param esxs: An optional list of ESX IDs to remove. format: UUID
        :type  num_hosts: :class:`long`
        :param num_hosts: 
        """
        self.availability_zone = availability_zone
        self.strict_placement = strict_placement
        self.cluster_id = cluster_id
        self.esxs = esxs
        self.num_hosts = num_hosts
        VapiStruct.__init__(self)


EsxConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.esx_config', {
        'availability_zone': type.OptionalType(type.StringType()),
        'strict_placement': type.OptionalType(type.BooleanType()),
        'cluster_id': type.OptionalType(type.StringType()),
        'esxs': type.OptionalType(type.ListType(type.StringType())),
        'num_hosts': type.IntegerType(),
    },
    EsxConfig,
    False,
    None))



class EsxHost(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "EsxHost"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    ESX_STATE_DEPLOYING = "DEPLOYING"
    """


    """
    ESX_STATE_INITIALIZING = "INITIALIZING"
    """


    """
    ESX_STATE_PROVISIONED = "PROVISIONED"
    """


    """
    ESX_STATE_READY = "READY"
    """


    """
    ESX_STATE_DELETING = "DELETING"
    """


    """
    ESX_STATE_DELETED = "DELETED"
    """


    """
    ESX_STATE_FAILED = "FAILED"
    """


    """
    ESX_STATE_ADDING_TO_VCENTER = "ADDING_TO_VCENTER"
    """


    """
    ESX_STATE_DELETING_FROM_VCENTER = "DELETING_FROM_VCENTER"
    """


    """
    ESX_STATE_PENDING_CLOUD_DELETION = "PENDING_CLOUD_DELETION"
    """


    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            'availability_zone': 'availability_zone',
                            'esx_id': 'esx_id',
                            'hostname': 'hostname',
                            'provider': 'provider',
                            'instance_type': 'instance_type',
                            'mac_address': 'mac_address',
                            'esx_state': 'esx_state',
                            'custom_properties': 'custom_properties',
                            }

    def __init__(self,
                 name=None,
                 availability_zone=None,
                 esx_id=None,
                 hostname=None,
                 provider='EsxHost',
                 instance_type=None,
                 mac_address=None,
                 esx_state=None,
                 custom_properties=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: 
        :type  availability_zone: :class:`str` or ``None``
        :param availability_zone: Availability zone where the host is provisioned.
        :type  esx_id: :class:`str` or ``None``
        :param esx_id: 
        :type  hostname: :class:`str` or ``None``
        :param hostname: 
        :type  provider: :class:`str`
        :param provider: 
        :type  instance_type: :class:`str` or ``None``
        :param instance_type: Backing cloud provider instance type for host.
        :type  mac_address: :class:`str` or ``None``
        :param mac_address: 
        :type  esx_state: :class:`str` or ``None``
        :param esx_state: Possible values are: 
            
            * :attr:`EsxHost.ESX_STATE_DEPLOYING`
            * :attr:`EsxHost.ESX_STATE_INITIALIZING`
            * :attr:`EsxHost.ESX_STATE_PROVISIONED`
            * :attr:`EsxHost.ESX_STATE_READY`
            * :attr:`EsxHost.ESX_STATE_DELETING`
            * :attr:`EsxHost.ESX_STATE_DELETED`
            * :attr:`EsxHost.ESX_STATE_FAILED`
            * :attr:`EsxHost.ESX_STATE_ADDING_TO_VCENTER`
            * :attr:`EsxHost.ESX_STATE_DELETING_FROM_VCENTER`
            * :attr:`EsxHost.ESX_STATE_PENDING_CLOUD_DELETION`
        :type  custom_properties: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param custom_properties: 
        """
        self.name = name
        self.availability_zone = availability_zone
        self.esx_id = esx_id
        self.hostname = hostname
        self._provider = provider
        self.instance_type = instance_type
        self.mac_address = mac_address
        self.esx_state = esx_state
        self.custom_properties = custom_properties
        VapiStruct.__init__(self)

    @property
    def provider(self):
        """
        Return the discriminator value
        """
        return self._provider

EsxHost._set_binding_type(type.StructType(
    'com.vmware.vmc.model.esx_host', {
        'name': type.OptionalType(type.StringType()),
        'availability_zone': type.OptionalType(type.StringType()),
        'esx_id': type.OptionalType(type.StringType()),
        'hostname': type.OptionalType(type.StringType()),
        'provider': type.StringType(),
        'instance_type': type.OptionalType(type.StringType()),
        'mac_address': type.OptionalType(type.StringType()),
        'esx_state': type.OptionalType(type.StringType()),
        'custom_properties': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
    },
    EsxHost,
    False,
    None))



class EsxHostInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'instance_type': 'instance_type',
                            }

    def __init__(self,
                 instance_type=None,
                ):
        """
        :type  instance_type: :class:`str` or ``None``
        :param instance_type: Backing cloud provider instance type for cluster.
        """
        self.instance_type = instance_type
        VapiStruct.__init__(self)


EsxHostInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.esx_host_info', {
        'instance_type': type.OptionalType(type.StringType()),
    },
    EsxHostInfo,
    False,
    None))



class FirewallRule(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RULE_TYPE_USER = "USER"
    """


    """
    RULE_TYPE_DEFAULT = "DEFAULT"
    """


    """
    ACTION_ALLOW = "ALLOW"
    """


    """
    ACTION_DENY = "DENY"
    """


    """



    _canonical_to_pep_names = {
                            'rule_type': 'rule_type',
                            'application_ids': 'application_ids',
                            'name': 'name',
                            'rule_interface': 'rule_interface',
                            'destination': 'destination',
                            'id': 'id',
                            'destination_scope': 'destination_scope',
                            'source': 'source',
                            'source_scope': 'source_scope',
                            'services': 'services',
                            'action': 'action',
                            'revision': 'revision',
                            }

    def __init__(self,
                 rule_type=None,
                 application_ids=None,
                 name=None,
                 rule_interface=None,
                 destination=None,
                 id=None,
                 destination_scope=None,
                 source=None,
                 source_scope=None,
                 services=None,
                 action=None,
                 revision=None,
                ):
        """
        :type  rule_type: :class:`str` or ``None``
        :param rule_type: Possible values are: 
            
            * :attr:`FirewallRule.RULE_TYPE_USER`
            * :attr:`FirewallRule.RULE_TYPE_DEFAULT`
        :type  application_ids: :class:`list` of :class:`str` or ``None``
        :param application_ids: 
        :type  name: :class:`str` or ``None``
        :param name: 
        :type  rule_interface: :class:`str` or ``None``
        :param rule_interface: Deprecated, left for backwards compatibility. Remove once UI stops
            using it.
        :type  destination: :class:`str` or ``None``
        :param destination: Optional. Possible formats are IP, IP1-IPn, CIDR or comma separated
            list of those entries. If not specified, defaults to 'any'.
        :type  id: :class:`str` or ``None``
        :param id: 
        :type  destination_scope: :class:`FirewallRuleScope` or ``None``
        :param destination_scope: 
        :type  source: :class:`str` or ``None``
        :param source: Optional. Possible formats are IP, IP1-IPn, CIDR or comma separated
            list of those entries. If not specified, defaults to 'any'.
        :type  source_scope: :class:`FirewallRuleScope` or ``None``
        :param source_scope: 
        :type  services: :class:`list` of :class:`FirewallService` or ``None``
        :param services: list of protocols and ports for this firewall rule
        :type  action: :class:`str` or ``None``
        :param action: Possible values are: 
            
            * :attr:`FirewallRule.ACTION_ALLOW`
            * :attr:`FirewallRule.ACTION_DENY`
        :type  revision: :class:`long` or ``None``
        :param revision: current revision of the list of firewall rules, used to protect
            against concurrent modification (first writer wins) format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.rule_type = rule_type
        self.application_ids = application_ids
        self.name = name
        self.rule_interface = rule_interface
        self.destination = destination
        self.id = id
        self.destination_scope = destination_scope
        self.source = source
        self.source_scope = source_scope
        self.services = services
        self.action = action
        self.revision = revision
        VapiStruct.__init__(self)


FirewallRule._set_binding_type(type.StructType(
    'com.vmware.vmc.model.firewall_rule', {
        'rule_type': type.OptionalType(type.StringType()),
        'application_ids': type.OptionalType(type.ListType(type.StringType())),
        'name': type.OptionalType(type.StringType()),
        'rule_interface': type.OptionalType(type.StringType()),
        'destination': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'destination_scope': type.OptionalType(type.ReferenceType(__name__, 'FirewallRuleScope')),
        'source': type.OptionalType(type.StringType()),
        'source_scope': type.OptionalType(type.ReferenceType(__name__, 'FirewallRuleScope')),
        'services': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'FirewallService'))),
        'action': type.OptionalType(type.StringType()),
        'revision': type.OptionalType(type.IntegerType()),
    },
    FirewallRule,
    False,
    None))



class FirewallRuleScope(VapiStruct):
    """
    Optional for FirewallRule. If not specified, defaults to 'any'.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    VNIC_GROUP_IDS_VSE = "vse"
    """


    """
    VNIC_GROUP_IDS_INTERNAL = "internal"
    """


    """
    VNIC_GROUP_IDS_EXTERNAL = "external"
    """


    """
    VNIC_GROUP_IDS_VNIC_INDEX_0 = "vnic-index-0"
    """


    """
    VNIC_GROUP_IDS_VNIC_INDEX_1 = "vnic-index-1"
    """


    """
    VNIC_GROUP_IDS_VNIC_INDEX_2 = "vnic-index-2"
    """


    """
    VNIC_GROUP_IDS_VNIC_INDEX_3 = "vnic-index-3"
    """


    """
    VNIC_GROUP_IDS_VNIC_INDEX_4 = "vnic-index-4"
    """


    """
    VNIC_GROUP_IDS_VNIC_INDEX_5 = "vnic-index-5"
    """


    """
    VNIC_GROUP_IDS_VNIC_INDEX_6 = "vnic-index-6"
    """


    """
    VNIC_GROUP_IDS_VNIC_INDEX_7 = "vnic-index-7"
    """


    """
    VNIC_GROUP_IDS_VNIC_INDEX_8 = "vnic-index-8"
    """


    """
    VNIC_GROUP_IDS_VNIC_INDEX_9 = "vnic-index-9"
    """


    """



    _canonical_to_pep_names = {
                            'grouping_object_ids': 'grouping_object_ids',
                            'vnic_group_ids': 'vnic_group_ids',
                            }

    def __init__(self,
                 grouping_object_ids=None,
                 vnic_group_ids=None,
                ):
        """
        :type  grouping_object_ids: :class:`list` of :class:`str` or ``None``
        :param grouping_object_ids: 
        :type  vnic_group_ids: :class:`list` of :class:`str` or ``None``
        :param vnic_group_ids: Possible values are: 
            
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VSE`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_INTERNAL`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_EXTERNAL`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VNIC_INDEX_0`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VNIC_INDEX_1`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VNIC_INDEX_2`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VNIC_INDEX_3`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VNIC_INDEX_4`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VNIC_INDEX_5`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VNIC_INDEX_6`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VNIC_INDEX_7`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VNIC_INDEX_8`
            * :attr:`FirewallRuleScope.VNIC_GROUP_IDS_VNIC_INDEX_9`
        """
        self.grouping_object_ids = grouping_object_ids
        self.vnic_group_ids = vnic_group_ids
        VapiStruct.__init__(self)


FirewallRuleScope._set_binding_type(type.StructType(
    'com.vmware.vmc.model.firewall_rule_scope', {
        'grouping_object_ids': type.OptionalType(type.ListType(type.StringType())),
        'vnic_group_ids': type.OptionalType(type.ListType(type.StringType())),
    },
    FirewallRuleScope,
    False,
    None))



class FirewallService(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'protocol': 'protocol',
                            'ports': 'ports',
                            }

    def __init__(self,
                 protocol=None,
                 ports=None,
                ):
        """
        :type  protocol: :class:`str` or ``None``
        :param protocol: protocol name, such as 'tcp', 'udp' etc.
        :type  ports: :class:`list` of :class:`str` or ``None``
        :param ports: a list of port numbers and port ranges, such as {80, 91-95, 99}. If
            not specified, defaults to 'any'.
        """
        self.protocol = protocol
        self.ports = ports
        VapiStruct.__init__(self)


FirewallService._set_binding_type(type.StructType(
    'com.vmware.vmc.model.firewall_service', {
        'protocol': type.OptionalType(type.StringType()),
        'ports': type.OptionalType(type.ListType(type.StringType())),
    },
    FirewallService,
    False,
    None))



class GatewayTemplate(VapiStruct):
    """
    Describes common properties for MGW and CGW configuration templates

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'public_ip': 'public_ip',
                            'primary_dns': 'primary_dns',
                            'secondary_dns': 'secondary_dns',
                            'firewall_rules': 'firewall_rules',
                            'vpns': 'vpns',
                            }

    def __init__(self,
                 public_ip=None,
                 primary_dns=None,
                 secondary_dns=None,
                 firewall_rules=None,
                 vpns=None,
                ):
        """
        :type  public_ip: :class:`SddcPublicIp` or ``None``
        :param public_ip: 
        :type  primary_dns: :class:`str` or ``None``
        :param primary_dns: 
        :type  secondary_dns: :class:`str` or ``None``
        :param secondary_dns: 
        :type  firewall_rules: :class:`list` of :class:`FirewallRule` or ``None``
        :param firewall_rules: 
        :type  vpns: :class:`list` of :class:`Vpn` or ``None``
        :param vpns: 
        """
        self.public_ip = public_ip
        self.primary_dns = primary_dns
        self.secondary_dns = secondary_dns
        self.firewall_rules = firewall_rules
        self.vpns = vpns
        VapiStruct.__init__(self)


GatewayTemplate._set_binding_type(type.StructType(
    'com.vmware.vmc.model.gateway_template', {
        'public_ip': type.OptionalType(type.ReferenceType(__name__, 'SddcPublicIp')),
        'primary_dns': type.OptionalType(type.StringType()),
        'secondary_dns': type.OptionalType(type.StringType()),
        'firewall_rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'FirewallRule'))),
        'vpns': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Vpn'))),
    },
    GatewayTemplate,
    False,
    None))



class GlcmBundle(VapiStruct):
    """
    the GlcmBundle used for deploying the sddc

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            's3Bucket': 's3_bucket',
                            'id': 'id',
                            }

    def __init__(self,
                 s3_bucket=None,
                 id=None,
                ):
        """
        :type  s3_bucket: :class:`str` or ``None``
        :param s3_bucket: the glcmbundle's s3 bucket
        :type  id: :class:`str` or ``None``
        :param id: the glcmbundle's id
        """
        self.s3_bucket = s3_bucket
        self.id = id
        VapiStruct.__init__(self)


GlcmBundle._set_binding_type(type.StructType(
    'com.vmware.vmc.model.glcm_bundle', {
        's3Bucket': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
    },
    GlcmBundle,
    False,
    None))



class InstanceProfileInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'role_name': 'role_name',
                            'instance_profile_name': 'instance_profile_name',
                            'policy_name': 'policy_name',
                            }

    def __init__(self,
                 role_name=None,
                 instance_profile_name=None,
                 policy_name=None,
                ):
        """
        :type  role_name: :class:`str` or ``None``
        :param role_name: 
        :type  instance_profile_name: :class:`str` or ``None``
        :param instance_profile_name: 
        :type  policy_name: :class:`str` or ``None``
        :param policy_name: 
        """
        self.role_name = role_name
        self.instance_profile_name = instance_profile_name
        self.policy_name = policy_name
        VapiStruct.__init__(self)


InstanceProfileInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.instance_profile_info', {
        'role_name': type.OptionalType(type.StringType()),
        'instance_profile_name': type.OptionalType(type.StringType()),
        'policy_name': type.OptionalType(type.StringType()),
    },
    InstanceProfileInfo,
    False,
    None))



class InstanceTypeBasicConfig(VapiStruct):
    """
    Represents a structure for basic instance type config.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'instance_type': 'instance_type',
                            'label': 'label',
                            'display_name': 'display_name',
                            'description': 'description',
                            'entity_capacity': 'entity_capacity',
                            }

    def __init__(self,
                 instance_type=None,
                 label=None,
                 display_name=None,
                 description=None,
                 entity_capacity=None,
                ):
        """
        :type  instance_type: :class:`str` or ``None``
        :param instance_type: Instance type name.
        :type  label: :class:`str` or ``None``
        :param label: Label for instance_type.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name of instance_type.
        :type  description: :class:`str` or ``None``
        :param description: Description of the instance_type.
        :type  entity_capacity: :class:`EntityCapacity` or ``None``
        :param entity_capacity: The capacity of the given instance type.
        """
        self.instance_type = instance_type
        self.label = label
        self.display_name = display_name
        self.description = description
        self.entity_capacity = entity_capacity
        VapiStruct.__init__(self)


InstanceTypeBasicConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.instance_type_basic_config', {
        'instance_type': type.OptionalType(type.StringType()),
        'label': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'description': type.OptionalType(type.StringType()),
        'entity_capacity': type.OptionalType(type.ReferenceType(__name__, 'EntityCapacity')),
    },
    InstanceTypeBasicConfig,
    False,
    None))



class InstanceTypeConfig(VapiStruct):
    """
    Represents a structure for instance type config

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'instance_type': 'instance_type',
                            'label': 'label',
                            'display_name': 'display_name',
                            'description': 'description',
                            'entity_capacity': 'entity_capacity',
                            'hyper_threading_supported': 'hyper_threading_supported',
                            'hosts': 'hosts',
                            'cpu_cores': 'cpu_cores',
                            'instanceProvisioningErrorCause': 'instance_provisioning_error_cause',
                            }

    def __init__(self,
                 instance_type=None,
                 label=None,
                 display_name=None,
                 description=None,
                 entity_capacity=None,
                 hyper_threading_supported=None,
                 hosts=None,
                 cpu_cores=None,
                 instance_provisioning_error_cause=None,
                ):
        """
        :type  instance_type: :class:`str` or ``None``
        :param instance_type: Instance type name.
        :type  label: :class:`str` or ``None``
        :param label: Label for instance_type.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name of instance_type.
        :type  description: :class:`str` or ``None``
        :param description: Description of the instance_type.
        :type  entity_capacity: :class:`EntityCapacity` or ``None``
        :param entity_capacity: The capacity of the given instance type.
        :type  hyper_threading_supported: :class:`bool` or ``None``
        :param hyper_threading_supported: Boolean to indicate whether hyperThreading is supported for an
            instance type.
        :type  hosts: :class:`list` of :class:`long` or ``None``
        :param hosts: Array of number of hosts allowed for this operation. Range of hosts
            user can select for sddc provision
        :type  cpu_cores: :class:`list` of :class:`long` or ``None``
        :param cpu_cores: Array of valid cpu cores values for the given instance type.
        :type  instance_provisioning_error_cause: :class:`str` or ``None``
        :param instance_provisioning_error_cause: Error message for instance provisioning.
        """
        self.instance_type = instance_type
        self.label = label
        self.display_name = display_name
        self.description = description
        self.entity_capacity = entity_capacity
        self.hyper_threading_supported = hyper_threading_supported
        self.hosts = hosts
        self.cpu_cores = cpu_cores
        self.instance_provisioning_error_cause = instance_provisioning_error_cause
        VapiStruct.__init__(self)


InstanceTypeConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.instance_type_config', {
        'instance_type': type.OptionalType(type.StringType()),
        'label': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'description': type.OptionalType(type.StringType()),
        'entity_capacity': type.OptionalType(type.ReferenceType(__name__, 'EntityCapacity')),
        'hyper_threading_supported': type.OptionalType(type.BooleanType()),
        'hosts': type.OptionalType(type.ListType(type.IntegerType())),
        'cpu_cores': type.OptionalType(type.ListType(type.IntegerType())),
        'instanceProvisioningErrorCause': type.OptionalType(type.StringType()),
    },
    InstanceTypeConfig,
    False,
    None))



class KmsVpcEndpoint(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'vpc_endpoint_id': 'vpc_endpoint_id',
                            'network_interface_ids': 'network_interface_ids',
                            }

    def __init__(self,
                 vpc_endpoint_id=None,
                 network_interface_ids=None,
                ):
        """
        :type  vpc_endpoint_id: :class:`str` or ``None``
        :param vpc_endpoint_id: The identifier of the VPC endpoint created to AWS Key Management
            Service
        :type  network_interface_ids: :class:`list` of :class:`str` or ``None``
        :param network_interface_ids: 
        """
        self.vpc_endpoint_id = vpc_endpoint_id
        self.network_interface_ids = network_interface_ids
        VapiStruct.__init__(self)


KmsVpcEndpoint._set_binding_type(type.StructType(
    'com.vmware.vmc.model.kms_vpc_endpoint', {
        'vpc_endpoint_id': type.OptionalType(type.StringType()),
        'network_interface_ids': type.OptionalType(type.ListType(type.StringType())),
    },
    KmsVpcEndpoint,
    False,
    None))



class L2Vpn(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'sites': 'sites',
                            'listener_ip': 'listener_ip',
                            }

    def __init__(self,
                 enabled=None,
                 sites=None,
                 listener_ip=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable (true) or disable (false) L2 VPN.
        :type  sites: :class:`list` of :class:`Site`
        :param sites: Array of L2 vpn site config.
        :type  listener_ip: :class:`str` or ``None``
        :param listener_ip: Public uplink ip address. IP of external interface on which L2VPN
            service listens to.
        """
        self.enabled = enabled
        self.sites = sites
        self.listener_ip = listener_ip
        VapiStruct.__init__(self)


L2Vpn._set_binding_type(type.StructType(
    'com.vmware.vmc.model.l2_vpn', {
        'enabled': type.OptionalType(type.BooleanType()),
        'sites': type.ListType(type.ReferenceType(__name__, 'Site')),
        'listener_ip': type.OptionalType(type.StringType()),
    },
    L2Vpn,
    False,
    None))



class LogicalNetwork(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    NETWORK_TYPE_HOSTED = "HOSTED"
    """


    """
    NETWORK_TYPE_ROUTED = "ROUTED"
    """


    """
    NETWORK_TYPE_EXTENDED = "EXTENDED"
    """


    """



    _canonical_to_pep_names = {
                            'subnet_cidr': 'subnet_cidr',
                            'name': 'name',
                            'gatewayIp': 'gateway_ip',
                            'dhcp_enabled': 'dhcp_enabled',
                            'dhcp_ip_range': 'dhcp_ip_range',
                            'tunnel_id': 'tunnel_id',
                            'id': 'id',
                            'network_type': 'network_type',
                            }

    def __init__(self,
                 subnet_cidr=None,
                 name=None,
                 gateway_ip=None,
                 dhcp_enabled=None,
                 dhcp_ip_range=None,
                 tunnel_id=None,
                 id=None,
                 network_type=None,
                ):
        """
        :type  subnet_cidr: :class:`str` or ``None``
        :param subnet_cidr: the subnet cidr
        :type  name: :class:`str` or ``None``
        :param name: name of the network
        :type  gateway_ip: :class:`str` or ``None``
        :param gateway_ip: gateway ip of the logical network
        :type  dhcp_enabled: :class:`str` or ``None``
        :param dhcp_enabled: if 'true' - enabled; if 'false' - disabled
        :type  dhcp_ip_range: :class:`str` or ``None``
        :param dhcp_ip_range: ip range within the subnet mask, range delimiter is '-' (example
            10.118.10.130-10.118.10.140)
        :type  tunnel_id: :class:`long` or ``None``
        :param tunnel_id: tunnel id of extended network format: int32
        :type  id: :class:`str` or ``None``
        :param id: 
        :type  network_type: :class:`str` or ``None``
        :param network_type: Possible values are: 
            
            * :attr:`LogicalNetwork.NETWORK_TYPE_HOSTED`
            * :attr:`LogicalNetwork.NETWORK_TYPE_ROUTED`
            * :attr:`LogicalNetwork.NETWORK_TYPE_EXTENDED`
        """
        self.subnet_cidr = subnet_cidr
        self.name = name
        self.gateway_ip = gateway_ip
        self.dhcp_enabled = dhcp_enabled
        self.dhcp_ip_range = dhcp_ip_range
        self.tunnel_id = tunnel_id
        self.id = id
        self.network_type = network_type
        VapiStruct.__init__(self)


LogicalNetwork._set_binding_type(type.StructType(
    'com.vmware.vmc.model.logical_network', {
        'subnet_cidr': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'gatewayIp': type.OptionalType(type.StringType()),
        'dhcp_enabled': type.OptionalType(type.StringType()),
        'dhcp_ip_range': type.OptionalType(type.StringType()),
        'tunnel_id': type.OptionalType(type.IntegerType()),
        'id': type.OptionalType(type.StringType()),
        'network_type': type.OptionalType(type.StringType()),
    },
    LogicalNetwork,
    False,
    None))



class MaintenanceWindow(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DAY_OF_WEEK_SUNDAY = "SUNDAY"
    """


    """
    DAY_OF_WEEK_MONDAY = "MONDAY"
    """


    """
    DAY_OF_WEEK_TUESDAY = "TUESDAY"
    """


    """
    DAY_OF_WEEK_WEDNESDAY = "WEDNESDAY"
    """


    """
    DAY_OF_WEEK_THURSDAY = "THURSDAY"
    """


    """
    DAY_OF_WEEK_FRIDAY = "FRIDAY"
    """


    """
    DAY_OF_WEEK_SATURDAY = "SATURDAY"
    """


    """



    _canonical_to_pep_names = {
                            'day_of_week': 'day_of_week',
                            'hour_of_day': 'hour_of_day',
                            }

    def __init__(self,
                 day_of_week=None,
                 hour_of_day=None,
                ):
        """
        :type  day_of_week: :class:`str` or ``None``
        :param day_of_week: Possible values are: 
            
            * :attr:`MaintenanceWindow.DAY_OF_WEEK_SUNDAY`
            * :attr:`MaintenanceWindow.DAY_OF_WEEK_MONDAY`
            * :attr:`MaintenanceWindow.DAY_OF_WEEK_TUESDAY`
            * :attr:`MaintenanceWindow.DAY_OF_WEEK_WEDNESDAY`
            * :attr:`MaintenanceWindow.DAY_OF_WEEK_THURSDAY`
            * :attr:`MaintenanceWindow.DAY_OF_WEEK_FRIDAY`
            * :attr:`MaintenanceWindow.DAY_OF_WEEK_SATURDAY`
        :type  hour_of_day: :class:`long` or ``None``
        :param hour_of_day: 
        """
        self.day_of_week = day_of_week
        self.hour_of_day = hour_of_day
        VapiStruct.__init__(self)


MaintenanceWindow._set_binding_type(type.StructType(
    'com.vmware.vmc.model.maintenance_window', {
        'day_of_week': type.OptionalType(type.StringType()),
        'hour_of_day': type.OptionalType(type.IntegerType()),
    },
    MaintenanceWindow,
    False,
    None))



class MaintenanceWindowEntry(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'in_maintenance_window': 'in_maintenance_window',
                            'reservation_schedule': 'reservation_schedule',
                            'reservation_id': 'reservation_id',
                            'in_maintenance_mode': 'in_maintenance_mode',
                            'sddc_id': 'sddc_id',
                            }

    def __init__(self,
                 in_maintenance_window=None,
                 reservation_schedule=None,
                 reservation_id=None,
                 in_maintenance_mode=None,
                 sddc_id=None,
                ):
        """
        :type  in_maintenance_window: :class:`bool` or ``None``
        :param in_maintenance_window: true if the SDDC is in the defined Mainentance Window
        :type  reservation_schedule: :class:`ReservationSchedule` or ``None``
        :param reservation_schedule: 
        :type  reservation_id: :class:`str` or ``None``
        :param reservation_id: ID for reservation format: uuid
        :type  in_maintenance_mode: :class:`bool` or ``None``
        :param in_maintenance_mode: true if the SDDC is currently undergoing maintenance
        :type  sddc_id: :class:`str` or ``None``
        :param sddc_id: SDDC ID for this reservation format: uuid
        """
        self.in_maintenance_window = in_maintenance_window
        self.reservation_schedule = reservation_schedule
        self.reservation_id = reservation_id
        self.in_maintenance_mode = in_maintenance_mode
        self.sddc_id = sddc_id
        VapiStruct.__init__(self)


MaintenanceWindowEntry._set_binding_type(type.StructType(
    'com.vmware.vmc.model.maintenance_window_entry', {
        'in_maintenance_window': type.OptionalType(type.BooleanType()),
        'reservation_schedule': type.OptionalType(type.ReferenceType(__name__, 'ReservationSchedule')),
        'reservation_id': type.OptionalType(type.StringType()),
        'in_maintenance_mode': type.OptionalType(type.BooleanType()),
        'sddc_id': type.OptionalType(type.StringType()),
    },
    MaintenanceWindowEntry,
    False,
    None))



class MaintenanceWindowGet(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DAY_OF_WEEK_SUNDAY = "SUNDAY"
    """


    """
    DAY_OF_WEEK_MONDAY = "MONDAY"
    """


    """
    DAY_OF_WEEK_TUESDAY = "TUESDAY"
    """


    """
    DAY_OF_WEEK_WEDNESDAY = "WEDNESDAY"
    """


    """
    DAY_OF_WEEK_THURSDAY = "THURSDAY"
    """


    """
    DAY_OF_WEEK_FRIDAY = "FRIDAY"
    """


    """
    DAY_OF_WEEK_SATURDAY = "SATURDAY"
    """


    """



    _canonical_to_pep_names = {
                            'day_of_week': 'day_of_week',
                            'hour_of_day': 'hour_of_day',
                            'duration_min': 'duration_min',
                            'version': 'version',
                            }

    def __init__(self,
                 day_of_week=None,
                 hour_of_day=None,
                 duration_min=None,
                 version=None,
                ):
        """
        :type  day_of_week: :class:`str` or ``None``
        :param day_of_week: Possible values are: 
            
            * :attr:`MaintenanceWindowGet.DAY_OF_WEEK_SUNDAY`
            * :attr:`MaintenanceWindowGet.DAY_OF_WEEK_MONDAY`
            * :attr:`MaintenanceWindowGet.DAY_OF_WEEK_TUESDAY`
            * :attr:`MaintenanceWindowGet.DAY_OF_WEEK_WEDNESDAY`
            * :attr:`MaintenanceWindowGet.DAY_OF_WEEK_THURSDAY`
            * :attr:`MaintenanceWindowGet.DAY_OF_WEEK_FRIDAY`
            * :attr:`MaintenanceWindowGet.DAY_OF_WEEK_SATURDAY`
        :type  hour_of_day: :class:`long` or ``None``
        :param hour_of_day: 
        :type  duration_min: :class:`long` or ``None``
        :param duration_min: 
        :type  version: :class:`long` or ``None``
        :param version: 
        """
        self.day_of_week = day_of_week
        self.hour_of_day = hour_of_day
        self.duration_min = duration_min
        self.version = version
        VapiStruct.__init__(self)


MaintenanceWindowGet._set_binding_type(type.StructType(
    'com.vmware.vmc.model.maintenance_window_get', {
        'day_of_week': type.OptionalType(type.StringType()),
        'hour_of_day': type.OptionalType(type.IntegerType()),
        'duration_min': type.OptionalType(type.IntegerType()),
        'version': type.OptionalType(type.IntegerType()),
    },
    MaintenanceWindowGet,
    False,
    None))



class ManagementGatewayTemplate(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'public_ip': 'public_ip',
                            'primary_dns': 'primary_dns',
                            'secondary_dns': 'secondary_dns',
                            'firewall_rules': 'firewall_rules',
                            'vpns': 'vpns',
                            'subnet_cidr': 'subnet_cidr',
                            }

    def __init__(self,
                 public_ip=None,
                 primary_dns=None,
                 secondary_dns=None,
                 firewall_rules=None,
                 vpns=None,
                 subnet_cidr=None,
                ):
        """
        :type  public_ip: :class:`SddcPublicIp` or ``None``
        :param public_ip: 
        :type  primary_dns: :class:`str` or ``None``
        :param primary_dns: 
        :type  secondary_dns: :class:`str` or ``None``
        :param secondary_dns: 
        :type  firewall_rules: :class:`list` of :class:`FirewallRule` or ``None``
        :param firewall_rules: 
        :type  vpns: :class:`list` of :class:`Vpn` or ``None``
        :param vpns: 
        :type  subnet_cidr: :class:`str` or ``None``
        :param subnet_cidr: mgw network subnet cidr
        """
        self.public_ip = public_ip
        self.primary_dns = primary_dns
        self.secondary_dns = secondary_dns
        self.firewall_rules = firewall_rules
        self.vpns = vpns
        self.subnet_cidr = subnet_cidr
        VapiStruct.__init__(self)


ManagementGatewayTemplate._set_binding_type(type.StructType(
    'com.vmware.vmc.model.management_gateway_template', {
        'public_ip': type.OptionalType(type.ReferenceType(__name__, 'SddcPublicIp')),
        'primary_dns': type.OptionalType(type.StringType()),
        'secondary_dns': type.OptionalType(type.StringType()),
        'firewall_rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'FirewallRule'))),
        'vpns': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Vpn'))),
        'subnet_cidr': type.OptionalType(type.StringType()),
    },
    ManagementGatewayTemplate,
    False,
    None))



class MapZonesRequest(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'connected_account_id': 'connected_account_id',
                            'org_id': 'org_id',
                            'petronas_regions_to_map': 'petronas_regions_to_map',
                            }

    def __init__(self,
                 connected_account_id=None,
                 org_id=None,
                 petronas_regions_to_map=None,
                ):
        """
        :type  connected_account_id: :class:`str` or ``None``
        :param connected_account_id: The connected account ID to remap. This is a standard UUID.
        :type  org_id: :class:`str` or ``None``
        :param org_id: The org ID to remap in. This is a standard UUID.
        :type  petronas_regions_to_map: :class:`list` of :class:`str` or ``None``
        :param petronas_regions_to_map: A list of Petronas regions to map.
        """
        self.connected_account_id = connected_account_id
        self.org_id = org_id
        self.petronas_regions_to_map = petronas_regions_to_map
        VapiStruct.__init__(self)


MapZonesRequest._set_binding_type(type.StructType(
    'com.vmware.vmc.model.map_zones_request', {
        'connected_account_id': type.OptionalType(type.StringType()),
        'org_id': type.OptionalType(type.StringType()),
        'petronas_regions_to_map': type.OptionalType(type.ListType(type.StringType())),
    },
    MapZonesRequest,
    False,
    None))



class Metadata(VapiStruct):
    """
    metadata of the sddc manifest

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'timestamp': 'timestamp',
                            'cycle_id': 'cycle_id',
                            }

    def __init__(self,
                 timestamp=None,
                 cycle_id=None,
                ):
        """
        :type  timestamp: :class:`str` or ``None``
        :param timestamp: the timestamp for the bundle
        :type  cycle_id: :class:`str` or ``None``
        :param cycle_id: the cycle id
        """
        self.timestamp = timestamp
        self.cycle_id = cycle_id
        VapiStruct.__init__(self)


Metadata._set_binding_type(type.StructType(
    'com.vmware.vmc.model.metadata', {
        'timestamp': type.OptionalType(type.StringType()),
        'cycle_id': type.OptionalType(type.StringType()),
    },
    Metadata,
    False,
    None))



class MsftLicensingConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MSSQL_LICENSING_DISABLED = "DISABLED"
    """


    """
    MSSQL_LICENSING_CUSTOMER_SUPPLIED = "CUSTOMER_SUPPLIED"
    """


    """
    MSSQL_LICENSING_ENABLED = "ENABLED"
    """


    """
    WINDOWS_LICENSING_DISABLED = "DISABLED"
    """


    """
    WINDOWS_LICENSING_CUSTOMER_SUPPLIED = "CUSTOMER_SUPPLIED"
    """


    """
    WINDOWS_LICENSING_ENABLED = "ENABLED"
    """


    """



    _canonical_to_pep_names = {
                            'mssql_licensing': 'mssql_licensing',
                            'academic_license': 'academic_license',
                            'windows_licensing': 'windows_licensing',
                            }

    def __init__(self,
                 mssql_licensing=None,
                 academic_license=None,
                 windows_licensing=None,
                ):
        """
        :type  mssql_licensing: :class:`str` or ``None``
        :param mssql_licensing: Possible values are: 
            
            * :attr:`MsftLicensingConfig.MSSQL_LICENSING_DISABLED`
            * :attr:`MsftLicensingConfig.MSSQL_LICENSING_CUSTOMER_SUPPLIED`
            * :attr:`MsftLicensingConfig.MSSQL_LICENSING_ENABLED`
            
             The status MSSQL licensing for this SDDC's clusters.
        :type  academic_license: :class:`bool` or ``None``
        :param academic_license: Flag to identify if it is Academic Standard or Commercial Standard
            License.
        :type  windows_licensing: :class:`str` or ``None``
        :param windows_licensing: Possible values are: 
            
            * :attr:`MsftLicensingConfig.WINDOWS_LICENSING_DISABLED`
            * :attr:`MsftLicensingConfig.WINDOWS_LICENSING_CUSTOMER_SUPPLIED`
            * :attr:`MsftLicensingConfig.WINDOWS_LICENSING_ENABLED`
            
            The status of Windows licensing for this SDDC's clusters. Can be
            enabled, disabled, or customer's.
        """
        self.mssql_licensing = mssql_licensing
        self.academic_license = academic_license
        self.windows_licensing = windows_licensing
        VapiStruct.__init__(self)


MsftLicensingConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.msft_licensing_config', {
        'mssql_licensing': type.OptionalType(type.StringType()),
        'academic_license': type.OptionalType(type.BooleanType()),
        'windows_licensing': type.OptionalType(type.StringType()),
    },
    MsftLicensingConfig,
    False,
    None))



class NatRule(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACTION_DNAT = "dnat"
    """


    """
    ACTION_SNAT = "snat"
    """


    """



    _canonical_to_pep_names = {
                            'rule_type': 'rule_type',
                            'protocol': 'protocol',
                            'name': 'name',
                            'internal_ports': 'internal_ports',
                            'public_ports': 'public_ports',
                            'public_ip': 'public_ip',
                            'internal_ip': 'internal_ip',
                            'action': 'action',
                            'id': 'id',
                            'revision': 'revision',
                            }

    def __init__(self,
                 rule_type=None,
                 protocol=None,
                 name=None,
                 internal_ports=None,
                 public_ports=None,
                 public_ip=None,
                 internal_ip=None,
                 action=None,
                 id=None,
                 revision=None,
                ):
        """
        :type  rule_type: :class:`str` or ``None``
        :param rule_type: 
        :type  protocol: :class:`str` or ``None``
        :param protocol: 
        :type  name: :class:`str` or ``None``
        :param name: 
        :type  internal_ports: :class:`str` or ``None``
        :param internal_ports: 
        :type  public_ports: :class:`str` or ``None``
        :param public_ports: 
        :type  public_ip: :class:`str` or ``None``
        :param public_ip: 
        :type  internal_ip: :class:`str` or ``None``
        :param internal_ip: 
        :type  action: :class:`str` or ``None``
        :param action: Possible values are: 
            
            * :attr:`NatRule.ACTION_DNAT`
            * :attr:`NatRule.ACTION_SNAT`
        :type  id: :class:`str` or ``None``
        :param id: 
        :type  revision: :class:`long` or ``None``
        :param revision: current revision of the list of nat rules, used to protect against
            concurrent modification (first writer wins) format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.rule_type = rule_type
        self.protocol = protocol
        self.name = name
        self.internal_ports = internal_ports
        self.public_ports = public_ports
        self.public_ip = public_ip
        self.internal_ip = internal_ip
        self.action = action
        self.id = id
        self.revision = revision
        VapiStruct.__init__(self)


NatRule._set_binding_type(type.StructType(
    'com.vmware.vmc.model.nat_rule', {
        'rule_type': type.OptionalType(type.StringType()),
        'protocol': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'internal_ports': type.OptionalType(type.StringType()),
        'public_ports': type.OptionalType(type.StringType()),
        'public_ip': type.OptionalType(type.StringType()),
        'internal_ip': type.OptionalType(type.StringType()),
        'action': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'revision': type.OptionalType(type.IntegerType()),
    },
    NatRule,
    False,
    None))



class NetworkTemplate(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'management_gateway_templates': 'management_gateway_templates',
                            'compute_gateway_templates': 'compute_gateway_templates',
                            }

    def __init__(self,
                 management_gateway_templates=None,
                 compute_gateway_templates=None,
                ):
        """
        :type  management_gateway_templates: :class:`list` of :class:`ManagementGatewayTemplate` or ``None``
        :param management_gateway_templates: 
        :type  compute_gateway_templates: :class:`list` of :class:`ComputeGatewayTemplate` or ``None``
        :param compute_gateway_templates: 
        """
        self.management_gateway_templates = management_gateway_templates
        self.compute_gateway_templates = compute_gateway_templates
        VapiStruct.__init__(self)


NetworkTemplate._set_binding_type(type.StructType(
    'com.vmware.vmc.model.network_template', {
        'management_gateway_templates': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ManagementGatewayTemplate'))),
        'compute_gateway_templates': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComputeGatewayTemplate'))),
    },
    NetworkTemplate,
    False,
    None))



class NewCredentials(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'username': 'username',
                            'password': 'password',
                            'name': 'name',
                            }

    def __init__(self,
                 username=None,
                 password=None,
                 name=None,
                ):
        """
        :type  username: :class:`str`
        :param username: Username of the credentials
        :type  password: :class:`str`
        :param password: Password associated with the credentials
        :type  name: :class:`str`
        :param name: Name of the credentials
        """
        self.username = username
        self.password = password
        self.name = name
        VapiStruct.__init__(self)


NewCredentials._set_binding_type(type.StructType(
    'com.vmware.vmc.model.new_credentials', {
        'username': type.StringType(),
        'password': type.StringType(),
        'name': type.StringType(),
    },
    NewCredentials,
    False,
    None))



class NsxtAddons(VapiStruct):
    """
    Details the state of different NSX add-ons.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enable_nsx_advanced_addon': 'enable_nsx_advanced_addon',
                            }

    def __init__(self,
                 enable_nsx_advanced_addon=None,
                ):
        """
        :type  enable_nsx_advanced_addon: :class:`bool` or ``None``
        :param enable_nsx_advanced_addon: Indicates whether NSX Advanced addon is enabled or disabled.
        """
        self.enable_nsx_advanced_addon = enable_nsx_advanced_addon
        VapiStruct.__init__(self)


NsxtAddons._set_binding_type(type.StructType(
    'com.vmware.vmc.model.nsxt_addons', {
        'enable_nsx_advanced_addon': type.OptionalType(type.BooleanType()),
    },
    NsxtAddons,
    False,
    None))



class OfferInstancesHolder(VapiStruct):
    """
    Holder for the offer instances.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'on_demand': 'on_demand',
                            'offers': 'offers',
                            }

    def __init__(self,
                 on_demand=None,
                 offers=None,
                ):
        """
        :type  on_demand: :class:`OnDemandOfferInstance`
        :param on_demand: 
        :type  offers: :class:`list` of :class:`TermOfferInstance`
        :param offers: 
        """
        self.on_demand = on_demand
        self.offers = offers
        VapiStruct.__init__(self)


OfferInstancesHolder._set_binding_type(type.StructType(
    'com.vmware.vmc.model.offer_instances_holder', {
        'on_demand': type.ReferenceType(__name__, 'OnDemandOfferInstance'),
        'offers': type.ListType(type.ReferenceType(__name__, 'TermOfferInstance')),
    },
    OfferInstancesHolder,
    False,
    None))



class OnDemandOfferInstance(VapiStruct):
    """
    Holder for the on-demand offer instance.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'product': 'product',
                            'product_type': 'product_type',
                            'name': 'name',
                            'currency': 'currency',
                            'region': 'region',
                            'unit_price': 'unit_price',
                            'monthly_cost': 'monthly_cost',
                            'version': 'version',
                            'type': 'type',
                            'description': 'description',
                            }

    def __init__(self,
                 product=None,
                 product_type=None,
                 name=None,
                 currency=None,
                 region=None,
                 unit_price=None,
                 monthly_cost=None,
                 version=None,
                 type=None,
                 description=None,
                ):
        """
        :type  product: :class:`str`
        :param product: 
        :type  product_type: :class:`str` or ``None``
        :param product_type: Deprecated. Please use product and type fields instead.
        :type  name: :class:`str`
        :param name: 
        :type  currency: :class:`str`
        :param currency: 
        :type  region: :class:`str`
        :param region: 
        :type  unit_price: :class:`str`
        :param unit_price: 
        :type  monthly_cost: :class:`str`
        :param monthly_cost: 
        :type  version: :class:`str`
        :param version: 
        :type  type: :class:`str`
        :param type: 
        :type  description: :class:`str`
        :param description: 
        """
        self.product = product
        self.product_type = product_type
        self.name = name
        self.currency = currency
        self.region = region
        self.unit_price = unit_price
        self.monthly_cost = monthly_cost
        self.version = version
        self.type = type
        self.description = description
        VapiStruct.__init__(self)


OnDemandOfferInstance._set_binding_type(type.StructType(
    'com.vmware.vmc.model.on_demand_offer_instance', {
        'product': type.StringType(),
        'product_type': type.OptionalType(type.StringType()),
        'name': type.StringType(),
        'currency': type.StringType(),
        'region': type.StringType(),
        'unit_price': type.StringType(),
        'monthly_cost': type.StringType(),
        'version': type.StringType(),
        'type': type.StringType(),
        'description': type.StringType(),
    },
    OnDemandOfferInstance,
    False,
    None))



class OrgProperties(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'values': 'values',
                            }

    def __init__(self,
                 values=None,
                ):
        """
        :type  values: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param values: A map of string properties to values.
        """
        self.values = values
        VapiStruct.__init__(self)


OrgProperties._set_binding_type(type.StructType(
    'com.vmware.vmc.model.org_properties', {
        'values': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
    },
    OrgProperties,
    False,
    None))



class OrgSellerInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'seller_account_id': 'seller_account_id',
                            'seller': 'seller',
                            }

    def __init__(self,
                 seller_account_id=None,
                 seller=None,
                ):
        """
        :type  seller_account_id: :class:`str` or ``None``
        :param seller_account_id: The accountid for this org for the seller-of-record. NILLABLE.
        :type  seller: :class:`str` or ``None``
        :param seller: The seller-of-record for the current organization. For example AWS
            or VMWARE
        """
        self.seller_account_id = seller_account_id
        self.seller = seller
        VapiStruct.__init__(self)


OrgSellerInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.org_seller_info', {
        'seller_account_id': type.OptionalType(type.StringType()),
        'seller': type.OptionalType(type.StringType()),
    },
    OrgSellerInfo,
    False,
    None))



class Organization(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    PROJECT_STATE_CREATED = "CREATED"
    """


    """
    PROJECT_STATE_DELETED = "DELETED"
    """


    """



    _canonical_to_pep_names = {
                            'updated': 'updated',
                            'user_id': 'user_id',
                            'updated_by_user_id': 'updated_by_user_id',
                            'created': 'created',
                            'version': 'version',
                            'updated_by_user_name': 'updated_by_user_name',
                            'user_name': 'user_name',
                            'id': 'id',
                            'org_type': 'org_type',
                            'display_name': 'display_name',
                            'name': 'name',
                            'org_seller_info': 'org_seller_info',
                            'project_state': 'project_state',
                            'properties': 'properties',
                            }

    def __init__(self,
                 updated=None,
                 user_id=None,
                 updated_by_user_id=None,
                 created=None,
                 version=None,
                 updated_by_user_name=None,
                 user_name=None,
                 id=None,
                 org_type=None,
                 display_name=None,
                 name=None,
                 org_seller_info=None,
                 project_state=None,
                 properties=None,
                ):
        """
        :type  updated: :class:`datetime.datetime`
        :param updated: 
        :type  user_id: :class:`str`
        :param user_id: User id that last updated this record
        :type  updated_by_user_id: :class:`str`
        :param updated_by_user_id: User id that last updated this record
        :type  created: :class:`datetime.datetime`
        :param created: 
        :type  version: :class:`long`
        :param version: Version of this entity format: int32
        :type  updated_by_user_name: :class:`str` or ``None``
        :param updated_by_user_name: User name that last updated this record
        :type  user_name: :class:`str`
        :param user_name: User name that last updated this record
        :type  id: :class:`str`
        :param id: Unique ID for this entity
        :type  org_type: :class:`str` or ``None``
        :param org_type: ORG_TYPE to be associated with the org
        :type  display_name: :class:`str` or ``None``
        :param display_name: 
        :type  name: :class:`str` or ``None``
        :param name: 
        :type  org_seller_info: :class:`OrgSellerInfo` or ``None``
        :param org_seller_info: 
        :type  project_state: :class:`str` or ``None``
        :param project_state: Possible values are: 
            
            * :attr:`Organization.PROJECT_STATE_CREATED`
            * :attr:`Organization.PROJECT_STATE_DELETED`
        :type  properties: :class:`OrgProperties` or ``None``
        :param properties: 
        """
        self.updated = updated
        self.user_id = user_id
        self.updated_by_user_id = updated_by_user_id
        self.created = created
        self.version = version
        self.updated_by_user_name = updated_by_user_name
        self.user_name = user_name
        self.id = id
        self.org_type = org_type
        self.display_name = display_name
        self.name = name
        self.org_seller_info = org_seller_info
        self.project_state = project_state
        self.properties = properties
        VapiStruct.__init__(self)


Organization._set_binding_type(type.StructType(
    'com.vmware.vmc.model.organization', {
        'updated': type.DateTimeType(),
        'user_id': type.StringType(),
        'updated_by_user_id': type.StringType(),
        'created': type.DateTimeType(),
        'version': type.IntegerType(),
        'updated_by_user_name': type.OptionalType(type.StringType()),
        'user_name': type.StringType(),
        'id': type.StringType(),
        'org_type': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'org_seller_info': type.OptionalType(type.ReferenceType(__name__, 'OrgSellerInfo')),
        'project_state': type.OptionalType(type.StringType()),
        'properties': type.OptionalType(type.ReferenceType(__name__, 'OrgProperties')),
    },
    Organization,
    False,
    None))



class OutpostConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'outpost_id': 'outpost_id',
                            'mocked': 'mocked',
                            }

    def __init__(self,
                 outpost_id=None,
                 mocked=None,
                ):
        """
        :type  outpost_id: :class:`str` or ``None``
        :param outpost_id: Outpost ID
        :type  mocked: :class:`bool` or ``None``
        :param mocked: Whether the Outposts is mocked.
        """
        self.outpost_id = outpost_id
        self.mocked = mocked
        VapiStruct.__init__(self)


OutpostConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.outpost_config', {
        'outpost_id': type.OptionalType(type.StringType()),
        'mocked': type.OptionalType(type.BooleanType()),
    },
    OutpostConfig,
    False,
    None))



class PartitionPlacementGroupInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'partition_group_names': 'partition_group_names',
                            'availability_zone': 'availability_zone',
                            }

    def __init__(self,
                 partition_group_names=None,
                 availability_zone=None,
                ):
        """
        :type  partition_group_names: :class:`list` of :class:`str` or ``None``
        :param partition_group_names: 
        :type  availability_zone: :class:`str` or ``None``
        :param availability_zone: The availability zone of the placement group.
        """
        self.partition_group_names = partition_group_names
        self.availability_zone = availability_zone
        VapiStruct.__init__(self)


PartitionPlacementGroupInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.partition_placement_group_info', {
        'partition_group_names': type.OptionalType(type.ListType(type.StringType())),
        'availability_zone': type.OptionalType(type.StringType()),
    },
    PartitionPlacementGroupInfo,
    False,
    None))



class PaymentMethodInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'type': 'type',
                            'default_flag': 'default_flag',
                            'payment_method_id': 'payment_method_id',
                            }

    def __init__(self,
                 type=None,
                 default_flag=None,
                 payment_method_id=None,
                ):
        """
        :type  type: :class:`str` or ``None``
        :param type: 
        :type  default_flag: :class:`bool` or ``None``
        :param default_flag: 
        :type  payment_method_id: :class:`str` or ``None``
        :param payment_method_id: 
        """
        self.type = type
        self.default_flag = default_flag
        self.payment_method_id = payment_method_id
        VapiStruct.__init__(self)


PaymentMethodInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.payment_method_info', {
        'type': type.OptionalType(type.StringType()),
        'default_flag': type.OptionalType(type.BooleanType()),
        'payment_method_id': type.OptionalType(type.StringType()),
    },
    PaymentMethodInfo,
    False,
    None))



class PopAgentXeniConnection(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'default_subnet_route': 'default_subnet_route',
                            'eni_info': 'eni_info',
                            }

    def __init__(self,
                 default_subnet_route=None,
                 eni_info=None,
                ):
        """
        :type  default_subnet_route: :class:`str` or ``None``
        :param default_subnet_route: The gateway route ip fo the subnet.
        :type  eni_info: :class:`EniInfo` or ``None``
        :param eni_info: 
        """
        self.default_subnet_route = default_subnet_route
        self.eni_info = eni_info
        VapiStruct.__init__(self)


PopAgentXeniConnection._set_binding_type(type.StructType(
    'com.vmware.vmc.model.pop_agent_xeni_connection', {
        'default_subnet_route': type.OptionalType(type.StringType()),
        'eni_info': type.OptionalType(type.ReferenceType(__name__, 'EniInfo')),
    },
    PopAgentXeniConnection,
    False,
    None))



class PopAmiInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_CENTOS = "CENTOS"
    """


    """
    TYPE_POP = "POP"
    """


    """



    _canonical_to_pep_names = {
                            'instance_type': 'instance_type',
                            'region': 'region',
                            'id': 'id',
                            'name': 'name',
                            'type': 'type',
                            }

    def __init__(self,
                 instance_type=None,
                 region=None,
                 id=None,
                 name=None,
                 type=None,
                ):
        """
        :type  instance_type: :class:`str` or ``None``
        :param instance_type: instance type of the esx ami
        :type  region: :class:`str` or ``None``
        :param region: the region of the esx ami
        :type  id: :class:`str` or ``None``
        :param id: the ami id for the esx
        :type  name: :class:`str` or ``None``
        :param name: the name of the esx ami
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`PopAmiInfo.TYPE_CENTOS`
            * :attr:`PopAmiInfo.TYPE_POP`
            
             PoP AMI type. CENTOS: a Centos AMI; POP: a PoP AMI.
        """
        self.instance_type = instance_type
        self.region = region
        self.id = id
        self.name = name
        self.type = type
        VapiStruct.__init__(self)


PopAmiInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.pop_ami_info', {
        'instance_type': type.OptionalType(type.StringType()),
        'region': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    PopAmiInfo,
    False,
    None))



class PopInfo(VapiStruct):
    """
    Present a SDDC PoP information.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ami_infos': 'ami_infos',
                            'created_at': 'created_at',
                            'service_infos': 'service_infos',
                            'id': 'id',
                            'manifest_version': 'manifest_version',
                            }

    def __init__(self,
                 ami_infos=None,
                 created_at=None,
                 service_infos=None,
                 id=None,
                 manifest_version=None,
                ):
        """
        :type  ami_infos: :class:`dict` of :class:`str` and :class:`PopAmiInfo`
        :param ami_infos: A map of [region name of PoP / PoP-AMI]:[PopAmiInfo].
        :type  created_at: :class:`datetime.datetime` or ``None``
        :param created_at: The PopInfo (or PoP AMI) created time. Using ISO 8601 date-time
            pattern. format: date-time
        :type  service_infos: (:class:`dict` of :class:`str` and :class:`PopServiceInfo`) or ``None``
        :param service_infos: A map of [service type]:[PopServiceInfo]
        :type  id: :class:`str` or ``None``
        :param id: UUID of the PopInfo format: UUID
        :type  manifest_version: :class:`str` or ``None``
        :param manifest_version: version of the manifest.
        """
        self.ami_infos = ami_infos
        self.created_at = created_at
        self.service_infos = service_infos
        self.id = id
        self.manifest_version = manifest_version
        VapiStruct.__init__(self)


PopInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.pop_info', {
        'ami_infos': type.MapType(type.StringType(), type.ReferenceType(__name__, 'PopAmiInfo')),
        'created_at': type.OptionalType(type.DateTimeType()),
        'service_infos': type.OptionalType(type.MapType(type.StringType(), type.ReferenceType(__name__, 'PopServiceInfo'))),
        'id': type.OptionalType(type.StringType()),
        'manifest_version': type.OptionalType(type.StringType()),
    },
    PopInfo,
    False,
    None))



class PopServiceInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SERVICE_OS = "OS"
    """


    """
    SERVICE_AGENT = "AGENT"
    """


    """
    SERVICE_GLCM = "GLCM"
    """


    """
    SERVICE_S3_ADAPTER = "S3_ADAPTER"
    """


    """
    SERVICE_JRE = "JRE"
    """


    """
    SERVICE_DOCKER = "DOCKER"
    """


    """
    SERVICE_AIDE = "AIDE"
    """


    """
    SERVICE_RTS = "RTS"
    """


    """
    SERVICE_FM_LOG_COLLECTOR = "FM_LOG_COLLECTOR"
    """


    """
    SERVICE_FM_METRICS_COLLECTOR = "FM_METRICS_COLLECTOR"
    """


    """
    SERVICE_BRE = "BRE"
    """


    """
    SERVICE_BRF = "BRF"
    """


    """
    SERVICE_REVERSE_PROXY = "REVERSE_PROXY"
    """


    """
    SERVICE_FORWARD_PROXY = "FORWARD_PROXY"
    """


    """
    SERVICE_DNS = "DNS"
    """


    """
    SERVICE_NTP = "NTP"
    """


    """
    SERVICE_LOGZ_LOG_COLLECTOR = "LOGZ_LOG_COLLECTOR"
    """


    """



    _canonical_to_pep_names = {
                            'cln': 'cln',
                            'version': 'version',
                            'build': 'build',
                            'service': 'service',
                            }

    def __init__(self,
                 cln=None,
                 version=None,
                 build=None,
                 service=None,
                ):
        """
        :type  cln: :class:`str` or ``None``
        :param cln: The service change set number.
        :type  version: :class:`str` or ``None``
        :param version: The service API version.
        :type  build: :class:`str` or ``None``
        :param build: The service build number.
        :type  service: :class:`str` or ``None``
        :param service: Possible values are: 
            
            * :attr:`PopServiceInfo.SERVICE_OS`
            * :attr:`PopServiceInfo.SERVICE_AGENT`
            * :attr:`PopServiceInfo.SERVICE_GLCM`
            * :attr:`PopServiceInfo.SERVICE_S3_ADAPTER`
            * :attr:`PopServiceInfo.SERVICE_JRE`
            * :attr:`PopServiceInfo.SERVICE_DOCKER`
            * :attr:`PopServiceInfo.SERVICE_AIDE`
            * :attr:`PopServiceInfo.SERVICE_RTS`
            * :attr:`PopServiceInfo.SERVICE_FM_LOG_COLLECTOR`
            * :attr:`PopServiceInfo.SERVICE_FM_METRICS_COLLECTOR`
            * :attr:`PopServiceInfo.SERVICE_BRE`
            * :attr:`PopServiceInfo.SERVICE_BRF`
            * :attr:`PopServiceInfo.SERVICE_REVERSE_PROXY`
            * :attr:`PopServiceInfo.SERVICE_FORWARD_PROXY`
            * :attr:`PopServiceInfo.SERVICE_DNS`
            * :attr:`PopServiceInfo.SERVICE_NTP`
            * :attr:`PopServiceInfo.SERVICE_LOGZ_LOG_COLLECTOR`
            
             An enum of PoP related services (including os platform and JRE).
        """
        self.cln = cln
        self.version = version
        self.build = build
        self.service = service
        VapiStruct.__init__(self)


PopServiceInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.pop_service_info', {
        'cln': type.OptionalType(type.StringType()),
        'version': type.OptionalType(type.StringType()),
        'build': type.OptionalType(type.StringType()),
        'service': type.OptionalType(type.StringType()),
    },
    PopServiceInfo,
    False,
    None))



class PoweredByInstanceTypeConfig(VapiStruct):
    """
    Represents a structure for powered by instance type configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    POWERED_BY_TYPE_OUTPOST = "OUTPOST"
    """


    """



    _canonical_to_pep_names = {
                            'instance_type': 'instance_type',
                            'label': 'label',
                            'display_name': 'display_name',
                            'description': 'description',
                            'entity_capacity': 'entity_capacity',
                            'hyper_threading_supported': 'hyper_threading_supported',
                            'hosts': 'hosts',
                            'cpu_cores': 'cpu_cores',
                            'instanceProvisioningErrorCause': 'instance_provisioning_error_cause',
                            'powered_by_id': 'powered_by_id',
                            'powered_by_type': 'powered_by_type',
                            }

    def __init__(self,
                 instance_type=None,
                 label=None,
                 display_name=None,
                 description=None,
                 entity_capacity=None,
                 hyper_threading_supported=None,
                 hosts=None,
                 cpu_cores=None,
                 instance_provisioning_error_cause=None,
                 powered_by_id=None,
                 powered_by_type=None,
                ):
        """
        :type  instance_type: :class:`str` or ``None``
        :param instance_type: Instance type name.
        :type  label: :class:`str` or ``None``
        :param label: Label for instance_type.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name of instance_type.
        :type  description: :class:`str` or ``None``
        :param description: Description of the instance_type.
        :type  entity_capacity: :class:`EntityCapacity` or ``None``
        :param entity_capacity: The capacity of the given instance type.
        :type  hyper_threading_supported: :class:`bool` or ``None``
        :param hyper_threading_supported: Boolean to indicate whether hyperThreading is supported for an
            instance type.
        :type  hosts: :class:`list` of :class:`long` or ``None``
        :param hosts: Array of number of hosts allowed for this operation. Range of hosts
            user can select for sddc provision
        :type  cpu_cores: :class:`list` of :class:`long` or ``None``
        :param cpu_cores: Array of valid cpu cores values for the given instance type.
        :type  instance_provisioning_error_cause: :class:`str` or ``None``
        :param instance_provisioning_error_cause: Error message for instance provisioning.
        :type  powered_by_id: :class:`str` or ``None``
        :param powered_by_id: ID of the powered by configuration.
        :type  powered_by_type: :class:`str` or ``None``
        :param powered_by_type: Possible values are: 
            
            * :attr:`PoweredByInstanceTypeConfig.POWERED_BY_TYPE_OUTPOST`
            
             Represents the type of powered by instance type configuration.
        """
        self.instance_type = instance_type
        self.label = label
        self.display_name = display_name
        self.description = description
        self.entity_capacity = entity_capacity
        self.hyper_threading_supported = hyper_threading_supported
        self.hosts = hosts
        self.cpu_cores = cpu_cores
        self.instance_provisioning_error_cause = instance_provisioning_error_cause
        self.powered_by_id = powered_by_id
        self.powered_by_type = powered_by_type
        VapiStruct.__init__(self)


PoweredByInstanceTypeConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.powered_by_instance_type_config', {
        'instance_type': type.OptionalType(type.StringType()),
        'label': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'description': type.OptionalType(type.StringType()),
        'entity_capacity': type.OptionalType(type.ReferenceType(__name__, 'EntityCapacity')),
        'hyper_threading_supported': type.OptionalType(type.BooleanType()),
        'hosts': type.OptionalType(type.ListType(type.IntegerType())),
        'cpu_cores': type.OptionalType(type.ListType(type.IntegerType())),
        'instanceProvisioningErrorCause': type.OptionalType(type.StringType()),
        'powered_by_id': type.OptionalType(type.StringType()),
        'powered_by_type': type.OptionalType(type.StringType()),
    },
    PoweredByInstanceTypeConfig,
    False,
    None))



class ProvisionSpec(VapiStruct):
    """
    Represents a provisioning spec for a sddc

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'provider': 'provider',
                            }

    def __init__(self,
                 provider=None,
                ):
        """
        :type  provider: (:class:`dict` of :class:`str` and :class:`SddcConfigSpec`) or ``None``
        :param provider: Map of provider to sddc config spec
        """
        self.provider = provider
        VapiStruct.__init__(self)


ProvisionSpec._set_binding_type(type.StructType(
    'com.vmware.vmc.model.provision_spec', {
        'provider': type.OptionalType(type.MapType(type.StringType(), type.ReferenceType(__name__, 'SddcConfigSpec'))),
    },
    ProvisionSpec,
    False,
    None))



class RequestDetail(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DETAIL_STATUS_NEW = "NEW"
    """


    """
    DETAIL_STATUS_PENDINGSUBMIT = "PENDINGSUBMIT"
    """


    """
    DETAIL_STATUS_SUBMITTED = "SUBMITTED"
    """


    """
    DETAIL_STATUS_PENDINGVERFICATION = "PENDINGVERFICATION"
    """


    """
    DETAIL_STATUS_RESOLVED = "RESOLVED"
    """


    """
    DETAIL_STATUS_DENIED = "DENIED"
    """


    """
    DETAIL_STATUS_ERROR = "ERROR"
    """


    """



    _canonical_to_pep_names = {
                            'aws_quota_request_id': 'aws_quota_request_id',
                            'detail_status': 'detail_status',
                            'resolved_at': 'resolved_at',
                            'desired_value': 'desired_value',
                            'aws_support_case_status': 'aws_support_case_status',
                            'aws_support_case_id': 'aws_support_case_id',
                            }

    def __init__(self,
                 aws_quota_request_id=None,
                 detail_status=None,
                 resolved_at=None,
                 desired_value=None,
                 aws_support_case_status=None,
                 aws_support_case_id=None,
                ):
        """
        :type  aws_quota_request_id: :class:`str` or ``None``
        :param aws_quota_request_id: AWS quota increase request id
        :type  detail_status: :class:`str` or ``None``
        :param detail_status: Possible values are: 
            
            * :attr:`RequestDetail.DETAIL_STATUS_NEW`
            * :attr:`RequestDetail.DETAIL_STATUS_PENDINGSUBMIT`
            * :attr:`RequestDetail.DETAIL_STATUS_SUBMITTED`
            * :attr:`RequestDetail.DETAIL_STATUS_PENDINGVERFICATION`
            * :attr:`RequestDetail.DETAIL_STATUS_RESOLVED`
            * :attr:`RequestDetail.DETAIL_STATUS_DENIED`
            * :attr:`RequestDetail.DETAIL_STATUS_ERROR`
        :type  resolved_at: :class:`datetime.datetime` or ``None``
        :param resolved_at: 
        :type  desired_value: :class:`long` or ``None``
        :param desired_value: desired value for the quota increase request
        :type  aws_support_case_status: :class:`str` or ``None``
        :param aws_support_case_status: AWS support case status
        :type  aws_support_case_id: :class:`str` or ``None``
        :param aws_support_case_id: AWS support caes id
        """
        self.aws_quota_request_id = aws_quota_request_id
        self.detail_status = detail_status
        self.resolved_at = resolved_at
        self.desired_value = desired_value
        self.aws_support_case_status = aws_support_case_status
        self.aws_support_case_id = aws_support_case_id
        VapiStruct.__init__(self)


RequestDetail._set_binding_type(type.StructType(
    'com.vmware.vmc.model.request_detail', {
        'aws_quota_request_id': type.OptionalType(type.StringType()),
        'detail_status': type.OptionalType(type.StringType()),
        'resolved_at': type.OptionalType(type.DateTimeType()),
        'desired_value': type.OptionalType(type.IntegerType()),
        'aws_support_case_status': type.OptionalType(type.StringType()),
        'aws_support_case_id': type.OptionalType(type.StringType()),
    },
    RequestDetail,
    False,
    None))



class Reservation(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'duration': 'duration',
                            'rid': 'rid',
                            'create_time': 'create_time',
                            'start_time': 'start_time',
                            'metadata': 'metadata',
                            }

    def __init__(self,
                 duration=None,
                 rid=None,
                 create_time=None,
                 start_time=None,
                 metadata=None,
                ):
        """
        :type  duration: :class:`long` or ``None``
        :param duration: Duration - required for reservation in maintenance window format:
            int64
        :type  rid: :class:`str` or ``None``
        :param rid: Reservation ID format: uuid
        :type  create_time: :class:`str` or ``None``
        :param create_time: Optional
        :type  start_time: :class:`datetime.datetime` or ``None``
        :param start_time: Start time of a reservation format: date-time
        :type  metadata: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param metadata: Optional
        """
        self.duration = duration
        self.rid = rid
        self.create_time = create_time
        self.start_time = start_time
        self.metadata = metadata
        VapiStruct.__init__(self)


Reservation._set_binding_type(type.StructType(
    'com.vmware.vmc.model.reservation', {
        'duration': type.OptionalType(type.IntegerType()),
        'rid': type.OptionalType(type.StringType()),
        'create_time': type.OptionalType(type.StringType()),
        'start_time': type.OptionalType(type.DateTimeType()),
        'metadata': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
    },
    Reservation,
    False,
    None))



class ReservationInMw(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rid': 'rid',
                            'week_of': 'week_of',
                            'create_time': 'create_time',
                            'metadata': 'metadata',
                            }

    def __init__(self,
                 rid=None,
                 week_of=None,
                 create_time=None,
                 metadata=None,
                ):
        """
        :type  rid: :class:`str` or ``None``
        :param rid: Reservation ID format: uuid
        :type  week_of: :class:`str` or ``None``
        :param week_of: SUNDAY of the week that maintenance is scheduled, ISO format date
        :type  create_time: :class:`datetime.datetime` or ``None``
        :param create_time: Optional format: date-time
        :type  metadata: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param metadata: Optional
        """
        self.rid = rid
        self.week_of = week_of
        self.create_time = create_time
        self.metadata = metadata
        VapiStruct.__init__(self)


ReservationInMw._set_binding_type(type.StructType(
    'com.vmware.vmc.model.reservation_in_mw', {
        'rid': type.OptionalType(type.StringType()),
        'week_of': type.OptionalType(type.StringType()),
        'create_time': type.OptionalType(type.DateTimeType()),
        'metadata': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
    },
    ReservationInMw,
    False,
    None))



class ReservationSchedule(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DAY_OF_WEEK_SUNDAY = "SUNDAY"
    """


    """
    DAY_OF_WEEK_MONDAY = "MONDAY"
    """


    """
    DAY_OF_WEEK_TUESDAY = "TUESDAY"
    """


    """
    DAY_OF_WEEK_WEDNESDAY = "WEDNESDAY"
    """


    """
    DAY_OF_WEEK_THURSDAY = "THURSDAY"
    """


    """
    DAY_OF_WEEK_FRIDAY = "FRIDAY"
    """


    """
    DAY_OF_WEEK_SATURDAY = "SATURDAY"
    """


    """



    _canonical_to_pep_names = {
                            'day_of_week': 'day_of_week',
                            'hour_of_day': 'hour_of_day',
                            'duration_min': 'duration_min',
                            'version': 'version',
                            'reservations': 'reservations',
                            'reservations_mw': 'reservations_mw',
                            }

    def __init__(self,
                 day_of_week=None,
                 hour_of_day=None,
                 duration_min=None,
                 version=None,
                 reservations=None,
                 reservations_mw=None,
                ):
        """
        :type  day_of_week: :class:`str` or ``None``
        :param day_of_week: Possible values are: 
            
            * :attr:`ReservationSchedule.DAY_OF_WEEK_SUNDAY`
            * :attr:`ReservationSchedule.DAY_OF_WEEK_MONDAY`
            * :attr:`ReservationSchedule.DAY_OF_WEEK_TUESDAY`
            * :attr:`ReservationSchedule.DAY_OF_WEEK_WEDNESDAY`
            * :attr:`ReservationSchedule.DAY_OF_WEEK_THURSDAY`
            * :attr:`ReservationSchedule.DAY_OF_WEEK_FRIDAY`
            * :attr:`ReservationSchedule.DAY_OF_WEEK_SATURDAY`
        :type  hour_of_day: :class:`long` or ``None``
        :param hour_of_day: 
        :type  duration_min: :class:`long` or ``None``
        :param duration_min: 
        :type  version: :class:`long` or ``None``
        :param version: 
        :type  reservations: :class:`list` of :class:`Reservation` or ``None``
        :param reservations: 
        :type  reservations_mw: :class:`list` of :class:`ReservationInMw` or ``None``
        :param reservations_mw: 
        """
        self.day_of_week = day_of_week
        self.hour_of_day = hour_of_day
        self.duration_min = duration_min
        self.version = version
        self.reservations = reservations
        self.reservations_mw = reservations_mw
        VapiStruct.__init__(self)


ReservationSchedule._set_binding_type(type.StructType(
    'com.vmware.vmc.model.reservation_schedule', {
        'day_of_week': type.OptionalType(type.StringType()),
        'hour_of_day': type.OptionalType(type.IntegerType()),
        'duration_min': type.OptionalType(type.IntegerType()),
        'version': type.OptionalType(type.IntegerType()),
        'reservations': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Reservation'))),
        'reservations_mw': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ReservationInMw'))),
    },
    ReservationSchedule,
    False,
    None))



class ReservationWindow(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RESERVATION_STATE_SCHEDULED = "SCHEDULED"
    """


    """
    RESERVATION_STATE_RUNNING = "RUNNING"
    """


    """
    RESERVATION_STATE_CANCELED = "CANCELED"
    """


    """
    RESERVATION_STATE_COMPLETED = "COMPLETED"
    """


    """
    RESERVATION_STATE_TERMINATED = "TERMINATED"
    """


    """



    _canonical_to_pep_names = {
                            'duration_hours': 'duration_hours',
                            'estimated_duration_hours_minimum': 'estimated_duration_hours_minimum',
                            'reservation_state': 'reservation_state',
                            'emergency': 'emergency',
                            'maintenance_properties': 'maintenance_properties',
                            'manifest_id': 'manifest_id',
                            'start_hour': 'start_hour',
                            'sddc_id': 'sddc_id',
                            'start_date': 'start_date',
                            'estimated_duration_hours_maximum': 'estimated_duration_hours_maximum',
                            'reserve_id': 'reserve_id',
                            'metadata': 'metadata',
                            }

    def __init__(self,
                 duration_hours=None,
                 estimated_duration_hours_minimum=None,
                 reservation_state=None,
                 emergency=None,
                 maintenance_properties=None,
                 manifest_id=None,
                 start_hour=None,
                 sddc_id=None,
                 start_date=None,
                 estimated_duration_hours_maximum=None,
                 reserve_id=None,
                 metadata=None,
                ):
        """
        :type  duration_hours: :class:`long` or ``None``
        :param duration_hours: 
        :type  estimated_duration_hours_minimum: :class:`long` or ``None``
        :param estimated_duration_hours_minimum: 
        :type  reservation_state: :class:`str` or ``None``
        :param reservation_state: Possible values are: 
            
            * :attr:`ReservationWindow.RESERVATION_STATE_SCHEDULED`
            * :attr:`ReservationWindow.RESERVATION_STATE_RUNNING`
            * :attr:`ReservationWindow.RESERVATION_STATE_CANCELED`
            * :attr:`ReservationWindow.RESERVATION_STATE_COMPLETED`
            * :attr:`ReservationWindow.RESERVATION_STATE_TERMINATED`
        :type  emergency: :class:`bool` or ``None``
        :param emergency: 
        :type  maintenance_properties: :class:`ReservationWindowMaintenanceProperties` or ``None``
        :param maintenance_properties: 
        :type  manifest_id: :class:`str` or ``None``
        :param manifest_id: 
        :type  start_hour: :class:`long` or ``None``
        :param start_hour: 
        :type  sddc_id: :class:`str` or ``None``
        :param sddc_id: 
        :type  start_date: :class:`str` or ``None``
        :param start_date: 
        :type  estimated_duration_hours_maximum: :class:`long` or ``None``
        :param estimated_duration_hours_maximum: 
        :type  reserve_id: :class:`str` or ``None``
        :param reserve_id: 
        :type  metadata: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param metadata: Metadata for reservation window, in key-value form
        """
        self.duration_hours = duration_hours
        self.estimated_duration_hours_minimum = estimated_duration_hours_minimum
        self.reservation_state = reservation_state
        self.emergency = emergency
        self.maintenance_properties = maintenance_properties
        self.manifest_id = manifest_id
        self.start_hour = start_hour
        self.sddc_id = sddc_id
        self.start_date = start_date
        self.estimated_duration_hours_maximum = estimated_duration_hours_maximum
        self.reserve_id = reserve_id
        self.metadata = metadata
        VapiStruct.__init__(self)


ReservationWindow._set_binding_type(type.StructType(
    'com.vmware.vmc.model.reservation_window', {
        'duration_hours': type.OptionalType(type.IntegerType()),
        'estimated_duration_hours_minimum': type.OptionalType(type.IntegerType()),
        'reservation_state': type.OptionalType(type.StringType()),
        'emergency': type.OptionalType(type.BooleanType()),
        'maintenance_properties': type.OptionalType(type.ReferenceType(__name__, 'ReservationWindowMaintenanceProperties')),
        'manifest_id': type.OptionalType(type.StringType()),
        'start_hour': type.OptionalType(type.IntegerType()),
        'sddc_id': type.OptionalType(type.StringType()),
        'start_date': type.OptionalType(type.StringType()),
        'estimated_duration_hours_maximum': type.OptionalType(type.IntegerType()),
        'reserve_id': type.OptionalType(type.StringType()),
        'metadata': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
    },
    ReservationWindow,
    False,
    None))



class ReservationWindowMaintenanceProperties(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'status': 'status',
                            }

    def __init__(self,
                 status=None,
                ):
        """
        :type  status: :class:`str` or ``None``
        :param status: Status of upgrade, if any
        """
        self.status = status
        VapiStruct.__init__(self)


ReservationWindowMaintenanceProperties._set_binding_type(type.StructType(
    'com.vmware.vmc.model.reservation_window_maintenance_properties', {
        'status': type.OptionalType(type.StringType()),
    },
    ReservationWindowMaintenanceProperties,
    False,
    None))



class RouteTableInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            'id': 'id',
                            }

    def __init__(self,
                 name=None,
                 id=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: route table name
        :type  id: :class:`str` or ``None``
        :param id: route table id
        """
        self.name = name
        self.id = id
        VapiStruct.__init__(self)


RouteTableInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.route_table_info', {
        'name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
    },
    RouteTableInfo,
    False,
    None))



class Sddc(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SDDC_STATE_DEPLOYING = "DEPLOYING"
    """


    """
    SDDC_STATE_READY = "READY"
    """


    """
    SDDC_STATE_DELETING = "DELETING"
    """


    """
    SDDC_STATE_DELETED = "DELETED"
    """


    """
    SDDC_STATE_FAILED = "FAILED"
    """


    """
    SDDC_STATE_CANCELED = "CANCELED"
    """


    """
    SDDC_STATE_READY_FOR_GLCM_BRINGUP = "READY_FOR_GLCM_BRINGUP"
    """


    """
    PROVIDER_AWS = "AWS"
    """


    """
    PROVIDER_ZEROCLOUD = "ZEROCLOUD"
    """


    """
    ACCOUNT_LINK_STATE_DELAYED = "DELAYED"
    """


    """
    ACCOUNT_LINK_STATE_LINKED = "LINKED"
    """


    """
    ACCOUNT_LINK_STATE_UNLINKED = "UNLINKED"
    """


    """



    _canonical_to_pep_names = {
                            'updated': 'updated',
                            'user_id': 'user_id',
                            'updated_by_user_id': 'updated_by_user_id',
                            'created': 'created',
                            'version': 'version',
                            'updated_by_user_name': 'updated_by_user_name',
                            'user_name': 'user_name',
                            'id': 'id',
                            'name': 'name',
                            'sddc_state': 'sddc_state',
                            'expiration_date': 'expiration_date',
                            'org_id': 'org_id',
                            'sddc_type': 'sddc_type',
                            'provider': 'provider',
                            'account_link_state': 'account_link_state',
                            'sddc_access_state': 'sddc_access_state',
                            'resource_config': 'resource_config',
                            }

    def __init__(self,
                 updated=None,
                 user_id=None,
                 updated_by_user_id=None,
                 created=None,
                 version=None,
                 updated_by_user_name=None,
                 user_name=None,
                 id=None,
                 name=None,
                 sddc_state=None,
                 expiration_date=None,
                 org_id=None,
                 sddc_type=None,
                 provider=None,
                 account_link_state=None,
                 sddc_access_state=None,
                 resource_config=None,
                ):
        """
        :type  updated: :class:`datetime.datetime`
        :param updated: 
        :type  user_id: :class:`str`
        :param user_id: User id that last updated this record
        :type  updated_by_user_id: :class:`str`
        :param updated_by_user_id: User id that last updated this record
        :type  created: :class:`datetime.datetime`
        :param created: 
        :type  version: :class:`long`
        :param version: Version of this entity format: int32
        :type  updated_by_user_name: :class:`str` or ``None``
        :param updated_by_user_name: User name that last updated this record
        :type  user_name: :class:`str`
        :param user_name: User name that last updated this record
        :type  id: :class:`str`
        :param id: Unique ID for this entity
        :type  name: :class:`str` or ``None``
        :param name: name for SDDC
        :type  sddc_state: :class:`str` or ``None``
        :param sddc_state: Possible values are: 
            
            * :attr:`Sddc.SDDC_STATE_DEPLOYING`
            * :attr:`Sddc.SDDC_STATE_READY`
            * :attr:`Sddc.SDDC_STATE_DELETING`
            * :attr:`Sddc.SDDC_STATE_DELETED`
            * :attr:`Sddc.SDDC_STATE_FAILED`
            * :attr:`Sddc.SDDC_STATE_CANCELED`
            * :attr:`Sddc.SDDC_STATE_READY_FOR_GLCM_BRINGUP`
        :type  expiration_date: :class:`datetime.datetime` or ``None``
        :param expiration_date: Expiration date of a sddc in UTC (will be set if its applicable)
            format: date-time
        :type  org_id: :class:`str` or ``None``
        :param org_id: 
        :type  sddc_type: :class:`str` or ``None``
        :param sddc_type: Type of the sddc
        :type  provider: :class:`str` or ``None``
        :param provider: Possible values are: 
            
            * :attr:`Sddc.PROVIDER_AWS`
            * :attr:`Sddc.PROVIDER_ZEROCLOUD`
        :type  account_link_state: :class:`str` or ``None``
        :param account_link_state: Possible values are: 
            
            * :attr:`Sddc.ACCOUNT_LINK_STATE_DELAYED`
            * :attr:`Sddc.ACCOUNT_LINK_STATE_LINKED`
            * :attr:`Sddc.ACCOUNT_LINK_STATE_UNLINKED`
            
             Account linking state of the sddc
        :type  sddc_access_state: :class:`str` or ``None``
        :param sddc_access_state: Describes the access state of sddc, valid state is DISABLED or
            ENABLED
        :type  resource_config: :class:`AwsSddcResourceConfig` or ``None``
        :param resource_config: 
        """
        self.updated = updated
        self.user_id = user_id
        self.updated_by_user_id = updated_by_user_id
        self.created = created
        self.version = version
        self.updated_by_user_name = updated_by_user_name
        self.user_name = user_name
        self.id = id
        self.name = name
        self.sddc_state = sddc_state
        self.expiration_date = expiration_date
        self.org_id = org_id
        self.sddc_type = sddc_type
        self.provider = provider
        self.account_link_state = account_link_state
        self.sddc_access_state = sddc_access_state
        self.resource_config = resource_config
        VapiStruct.__init__(self)


Sddc._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc', {
        'updated': type.DateTimeType(),
        'user_id': type.StringType(),
        'updated_by_user_id': type.StringType(),
        'created': type.DateTimeType(),
        'version': type.IntegerType(),
        'updated_by_user_name': type.OptionalType(type.StringType()),
        'user_name': type.StringType(),
        'id': type.StringType(),
        'name': type.OptionalType(type.StringType()),
        'sddc_state': type.OptionalType(type.StringType()),
        'expiration_date': type.OptionalType(type.DateTimeType()),
        'org_id': type.OptionalType(type.StringType()),
        'sddc_type': type.OptionalType(type.StringType()),
        'provider': type.OptionalType(type.StringType()),
        'account_link_state': type.OptionalType(type.StringType()),
        'sddc_access_state': type.OptionalType(type.StringType()),
        'resource_config': type.OptionalType(type.ReferenceType(__name__, 'AwsSddcResourceConfig')),
    },
    Sddc,
    False,
    None))



class SddcChoice(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'displayText': 'display_text',
                            'value': 'value',
                            }

    def __init__(self,
                 display_text=None,
                 value=None,
                ):
        """
        :type  display_text: :class:`str` or ``None``
        :param display_text: SDDC display name
        :type  value: :class:`str` or ``None``
        :param value: SDDC id
        """
        self.display_text = display_text
        self.value = value
        VapiStruct.__init__(self)


SddcChoice._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_choice', {
        'displayText': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.StringType()),
    },
    SddcChoice,
    False,
    None))



class SddcConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "SddcConfig"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    SIZE_NSX_SMALL = "nsx_small"
    """


    """
    SIZE_MEDIUM = "medium"
    """


    """
    SIZE_LARGE = "large"
    """


    """
    SIZE_NSX_LARGE = "nsx_large"
    """


    """
    PROVIDER_AWS = "AWS"
    """


    """
    PROVIDER_ZEROCLOUD = "ZEROCLOUD"
    """


    """
    DEPLOYMENT_TYPE_SINGLEAZ = "SingleAZ"
    """


    """
    DEPLOYMENT_TYPE_MULTIAZ = "MultiAZ"
    """


    """



    _canonical_to_pep_names = {
                            'msft_license_config': 'msft_license_config',
                            'vpc_cidr': 'vpc_cidr',
                            'host_instance_type': 'host_instance_type',
                            'skip_creating_vxlan': 'skip_creating_vxlan',
                            'vxlan_subnet': 'vxlan_subnet',
                            'size': 'size',
                            'outpost_id': 'outpost_id',
                            'storage_capacity': 'storage_capacity',
                            'name': 'name',
                            'account_link_sddc_config': 'account_link_sddc_config',
                            'sddc_id': 'sddc_id',
                            'num_hosts': 'num_hosts',
                            'sddc_type': 'sddc_type',
                            'account_link_config': 'account_link_config',
                            'provider': 'provider',
                            'sso_domain': 'sso_domain',
                            'sddc_template_id': 'sddc_template_id',
                            'deployment_type': 'deployment_type',
                            }

    def __init__(self,
                 msft_license_config=None,
                 vpc_cidr=None,
                 host_instance_type=None,
                 skip_creating_vxlan=None,
                 vxlan_subnet=None,
                 size=None,
                 outpost_id=None,
                 storage_capacity=None,
                 name=None,
                 account_link_sddc_config=None,
                 sddc_id=None,
                 num_hosts=None,
                 sddc_type=None,
                 account_link_config=None,
                 provider='SddcConfig',
                 sso_domain=None,
                 sddc_template_id=None,
                 deployment_type=None,
                ):
        """
        :type  msft_license_config: :class:`MsftLicensingConfig` or ``None``
        :param msft_license_config: Indicates the desired licensing support, if any, of Microsoft
            software.
        :type  vpc_cidr: :class:`str` or ``None``
        :param vpc_cidr: AWS VPC IP range. Only prefix of 16 or 20 is currently supported.
        :type  host_instance_type: :class:`HostInstanceTypes` or ``None``
        :param host_instance_type: The instance type for the esx hosts in the primary cluster of the
            SDDC.
        :type  skip_creating_vxlan: :class:`bool` or ``None``
        :param skip_creating_vxlan: skip creating vxlan for compute gateway for SDDC provisioning
        :type  vxlan_subnet: :class:`str` or ``None``
        :param vxlan_subnet: VXLAN IP subnet in CIDR for compute gateway
        :type  size: :class:`str` or ``None``
        :param size: Possible values are: 
            
            * :attr:`SddcConfig.SIZE_NSX_SMALL`
            * :attr:`SddcConfig.SIZE_MEDIUM`
            * :attr:`SddcConfig.SIZE_LARGE`
            * :attr:`SddcConfig.SIZE_NSX_LARGE`
            
            The size of the vCenter and NSX appliances. \"large\" sddcSize
            corresponds to a 'large' vCenter appliance and 'large' NSX
            appliance. 'medium' sddcSize corresponds to 'medium' vCenter
            appliance and 'medium' NSX appliance. Value defaults to 'medium'.
        :type  outpost_id: :class:`str` or ``None``
        :param outpost_id: Outpost ID of the SDDC. Used only for outpost deployments.
        :type  storage_capacity: :class:`long` or ``None``
        :param storage_capacity: The storage capacity value to be requested for the sddc primary
            cluster, in GiBs. If provided, instead of using the direct-attached
            storage, a capacity value amount of seperable storage will be used.
            format: int64
        :type  name: :class:`str`
        :param name: 
        :type  account_link_sddc_config: :class:`list` of :class:`AccountLinkSddcConfig` or ``None``
        :param account_link_sddc_config: A list of the SDDC linking configurations to use.
        :type  sddc_id: :class:`str` or ``None``
        :param sddc_id: If provided, will be assigned as SDDC id of the provisioned SDDC.
            format: UUID
        :type  num_hosts: :class:`long`
        :param num_hosts: 
        :type  sddc_type: :class:`str` or ``None``
        :param sddc_type: Denotes the sddc type , if the value is null or empty, the type is
            considered as default.
        :type  account_link_config: :class:`AccountLinkConfig` or ``None``
        :param account_link_config: The account linking configuration, we will keep this one and remove
            accountLinkSddcConfig finally.
        :type  provider: :class:`str`
        :param provider: Possible values are: 
            
            * :attr:`SddcConfig.PROVIDER_AWS`
            * :attr:`SddcConfig.PROVIDER_ZEROCLOUD`
            
            Determines what additional properties are available based on cloud
            provider.
        :type  sso_domain: :class:`str` or ``None``
        :param sso_domain: The SSO domain name to use for vSphere users. If not specified,
            vmc.local will be used.
        :type  sddc_template_id: :class:`str` or ``None``
        :param sddc_template_id: If provided, configuration from the template will applied to the
            provisioned SDDC. format: UUID
        :type  deployment_type: :class:`str` or ``None``
        :param deployment_type: Possible values are: 
            
            * :attr:`SddcConfig.DEPLOYMENT_TYPE_SINGLEAZ`
            * :attr:`SddcConfig.DEPLOYMENT_TYPE_MULTIAZ`
            
            Denotes if request is for a SingleAZ or a MultiAZ SDDC. Default is
            SingleAZ.
        """
        self.msft_license_config = msft_license_config
        self.vpc_cidr = vpc_cidr
        self.host_instance_type = host_instance_type
        self.skip_creating_vxlan = skip_creating_vxlan
        self.vxlan_subnet = vxlan_subnet
        self.size = size
        self.outpost_id = outpost_id
        self.storage_capacity = storage_capacity
        self.name = name
        self.account_link_sddc_config = account_link_sddc_config
        self.sddc_id = sddc_id
        self.num_hosts = num_hosts
        self.sddc_type = sddc_type
        self.account_link_config = account_link_config
        self._provider = provider
        self.sso_domain = sso_domain
        self.sddc_template_id = sddc_template_id
        self.deployment_type = deployment_type
        VapiStruct.__init__(self)

    @property
    def provider(self):
        """
        Return the discriminator value
        """
        return self._provider

SddcConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_config', {
        'msft_license_config': type.OptionalType(type.ReferenceType(__name__, 'MsftLicensingConfig')),
        'vpc_cidr': type.OptionalType(type.StringType()),
        'host_instance_type': type.OptionalType(type.ReferenceType(__name__, 'HostInstanceTypes')),
        'skip_creating_vxlan': type.OptionalType(type.BooleanType()),
        'vxlan_subnet': type.OptionalType(type.StringType()),
        'size': type.OptionalType(type.StringType()),
        'outpost_id': type.OptionalType(type.StringType()),
        'storage_capacity': type.OptionalType(type.IntegerType()),
        'name': type.StringType(),
        'account_link_sddc_config': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AccountLinkSddcConfig'))),
        'sddc_id': type.OptionalType(type.StringType()),
        'num_hosts': type.IntegerType(),
        'sddc_type': type.OptionalType(type.StringType()),
        'account_link_config': type.OptionalType(type.ReferenceType(__name__, 'AccountLinkConfig')),
        'provider': type.StringType(),
        'sso_domain': type.OptionalType(type.StringType()),
        'sddc_template_id': type.OptionalType(type.StringType()),
        'deployment_type': type.OptionalType(type.StringType()),
    },
    SddcConfig,
    False,
    None))



class SddcConfigSpec(VapiStruct):
    """
    Represents a configuration spec for a sddc

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'sddc_type_config_spec': 'sddc_type_config_spec',
                            'region_display_names': 'region_display_names',
                            }

    def __init__(self,
                 sddc_type_config_spec=None,
                 region_display_names=None,
                ):
        """
        :type  sddc_type_config_spec: (:class:`dict` of :class:`str` and :class:`ConfigSpec`) or ``None``
        :param sddc_type_config_spec: Map of sddc type to config spec
        :type  region_display_names: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param region_display_names: The region name to display names mapping
        """
        self.sddc_type_config_spec = sddc_type_config_spec
        self.region_display_names = region_display_names
        VapiStruct.__init__(self)


SddcConfigSpec._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_config_spec', {
        'sddc_type_config_spec': type.OptionalType(type.MapType(type.StringType(), type.ReferenceType(__name__, 'ConfigSpec'))),
        'region_display_names': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
    },
    SddcConfigSpec,
    False,
    None))



class SddcConvertRequest(VapiStruct):
    """
    Convert request body for SDDC

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'num_hosts': 'num_hosts',
                            }

    def __init__(self,
                 num_hosts=None,
                ):
        """
        :type  num_hosts: :class:`long` or ``None``
        :param num_hosts: The total number of hosts in the SDDC after conversion.
        """
        self.num_hosts = num_hosts
        VapiStruct.__init__(self)


SddcConvertRequest._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_convert_request', {
        'num_hosts': type.OptionalType(type.IntegerType()),
    },
    SddcConvertRequest,
    False,
    None))



class SddcId(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'sddc_id': 'sddc_id',
                            }

    def __init__(self,
                 sddc_id=None,
                ):
        """
        :type  sddc_id: :class:`str` or ``None``
        :param sddc_id: Sddc ID
        """
        self.sddc_id = sddc_id
        VapiStruct.__init__(self)


SddcId._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_id', {
        'sddc_id': type.OptionalType(type.StringType()),
    },
    SddcId,
    False,
    None))



class SddcInput(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'inputs': 'inputs',
                            }

    def __init__(self,
                 inputs=None,
                ):
        """
        :type  inputs: :class:`list` of :class:`SddcList`
        :param inputs: 
        """
        self.inputs = inputs
        VapiStruct.__init__(self)


SddcInput._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_input', {
        'inputs': type.ListType(type.ReferenceType(__name__, 'SddcList')),
    },
    SddcInput,
    False,
    None))



class SddcLinkConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'customer_subnet_ids': 'customer_subnet_ids',
                            'connected_account_id': 'connected_account_id',
                            }

    def __init__(self,
                 customer_subnet_ids=None,
                 connected_account_id=None,
                ):
        """
        :type  customer_subnet_ids: :class:`list` of :class:`str` or ``None``
        :param customer_subnet_ids: 
        :type  connected_account_id: :class:`str` or ``None``
        :param connected_account_id: Determines which connected customer account to link to
        """
        self.customer_subnet_ids = customer_subnet_ids
        self.connected_account_id = connected_account_id
        VapiStruct.__init__(self)


SddcLinkConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_link_config', {
        'customer_subnet_ids': type.OptionalType(type.ListType(type.StringType())),
        'connected_account_id': type.OptionalType(type.StringType()),
    },
    SddcLinkConfig,
    False,
    None))



class SddcList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'label': 'label',
                            'required': 'required',
                            'placeholder': 'placeholder',
                            'name': 'name',
                            'choice': 'choice',
                            }

    def __init__(self,
                 label=None,
                 required=None,
                 placeholder=None,
                 name=None,
                 choice=None,
                ):
        """
        :type  label: :class:`str` or ``None``
        :param label: 
        :type  required: :class:`bool` or ``None``
        :param required: 
        :type  placeholder: :class:`str` or ``None``
        :param placeholder: 
        :type  name: :class:`str` or ``None``
        :param name: 
        :type  choice: :class:`list` of :class:`SddcChoice` or ``None``
        :param choice: 
        """
        self.label = label
        self.required = required
        self.placeholder = placeholder
        self.name = name
        self.choice = choice
        VapiStruct.__init__(self)


SddcList._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_list', {
        'label': type.OptionalType(type.StringType()),
        'required': type.OptionalType(type.BooleanType()),
        'placeholder': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'choice': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SddcChoice'))),
    },
    SddcList,
    False,
    None))



class SddcManifest(VapiStruct):
    """
    Describes software components of the installed SDDC

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'vmc_version': 'vmc_version',
                            'glcm_bundle': 'glcm_bundle',
                            'pop_info': 'pop_info',
                            'vmc_internal_version': 'vmc_internal_version',
                            'ebs_backed_vsan_config': 'ebs_backed_vsan_config',
                            'vsan_witness_ami': 'vsan_witness_ami',
                            'esx_ami': 'esx_ami',
                            'esx_nsxt_ami': 'esx_nsxt_ami',
                            'metadata': 'metadata',
                            }

    def __init__(self,
                 vmc_version=None,
                 glcm_bundle=None,
                 pop_info=None,
                 vmc_internal_version=None,
                 ebs_backed_vsan_config=None,
                 vsan_witness_ami=None,
                 esx_ami=None,
                 esx_nsxt_ami=None,
                 metadata=None,
                ):
        """
        :type  vmc_version: :class:`str` or ``None``
        :param vmc_version: the vmcVersion of the sddc for display
        :type  glcm_bundle: :class:`GlcmBundle` or ``None``
        :param glcm_bundle: 
        :type  pop_info: :class:`PopInfo` or ``None``
        :param pop_info: 
        :type  vmc_internal_version: :class:`str` or ``None``
        :param vmc_internal_version: the vmcInternalVersion of the sddc for internal use
        :type  ebs_backed_vsan_config: :class:`EbsBackedVsanConfig` or ``None``
        :param ebs_backed_vsan_config: 
        :type  vsan_witness_ami: :class:`AmiInfo` or ``None``
        :param vsan_witness_ami: 
        :type  esx_ami: :class:`AmiInfo` or ``None``
        :param esx_ami: 
        :type  esx_nsxt_ami: :class:`AmiInfo` or ``None``
        :param esx_nsxt_ami: 
        :type  metadata: :class:`Metadata` or ``None``
        :param metadata: 
        """
        self.vmc_version = vmc_version
        self.glcm_bundle = glcm_bundle
        self.pop_info = pop_info
        self.vmc_internal_version = vmc_internal_version
        self.ebs_backed_vsan_config = ebs_backed_vsan_config
        self.vsan_witness_ami = vsan_witness_ami
        self.esx_ami = esx_ami
        self.esx_nsxt_ami = esx_nsxt_ami
        self.metadata = metadata
        VapiStruct.__init__(self)


SddcManifest._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_manifest', {
        'vmc_version': type.OptionalType(type.StringType()),
        'glcm_bundle': type.OptionalType(type.ReferenceType(__name__, 'GlcmBundle')),
        'pop_info': type.OptionalType(type.ReferenceType(__name__, 'PopInfo')),
        'vmc_internal_version': type.OptionalType(type.StringType()),
        'ebs_backed_vsan_config': type.OptionalType(type.ReferenceType(__name__, 'EbsBackedVsanConfig')),
        'vsan_witness_ami': type.OptionalType(type.ReferenceType(__name__, 'AmiInfo')),
        'esx_ami': type.OptionalType(type.ReferenceType(__name__, 'AmiInfo')),
        'esx_nsxt_ami': type.OptionalType(type.ReferenceType(__name__, 'AmiInfo')),
        'metadata': type.OptionalType(type.ReferenceType(__name__, 'Metadata')),
    },
    SddcManifest,
    False,
    None))



class SddcPatchRequest(VapiStruct):
    """
    Patch request body for SDDC

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            }

    def __init__(self,
                 name=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: The new name of the SDDC to be changed to.
        """
        self.name = name
        VapiStruct.__init__(self)


SddcPatchRequest._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_patch_request', {
        'name': type.OptionalType(type.StringType()),
    },
    SddcPatchRequest,
    False,
    None))



class SddcPublicIp(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'public_ip': 'public_ip',
                            'name': 'name',
                            'allocation_id': 'allocation_id',
                            'dnat_rule_id': 'dnat_rule_id',
                            'associated_private_ip': 'associated_private_ip',
                            'snat_rule_id': 'snat_rule_id',
                            }

    def __init__(self,
                 public_ip=None,
                 name=None,
                 allocation_id=None,
                 dnat_rule_id=None,
                 associated_private_ip=None,
                 snat_rule_id=None,
                ):
        """
        :type  public_ip: :class:`str`
        :param public_ip: 
        :type  name: :class:`str` or ``None``
        :param name: 
        :type  allocation_id: :class:`str` or ``None``
        :param allocation_id: 
        :type  dnat_rule_id: :class:`str` or ``None``
        :param dnat_rule_id: 
        :type  associated_private_ip: :class:`str` or ``None``
        :param associated_private_ip: 
        :type  snat_rule_id: :class:`str` or ``None``
        :param snat_rule_id: 
        """
        self.public_ip = public_ip
        self.name = name
        self.allocation_id = allocation_id
        self.dnat_rule_id = dnat_rule_id
        self.associated_private_ip = associated_private_ip
        self.snat_rule_id = snat_rule_id
        VapiStruct.__init__(self)


SddcPublicIp._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_public_ip', {
        'public_ip': type.StringType(),
        'name': type.OptionalType(type.StringType()),
        'allocation_id': type.OptionalType(type.StringType()),
        'dnat_rule_id': type.OptionalType(type.StringType()),
        'associated_private_ip': type.OptionalType(type.StringType()),
        'snat_rule_id': type.OptionalType(type.StringType()),
    },
    SddcPublicIp,
    False,
    None))



class SddcResourceConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "SddcResourceConfig"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    DEPLOYMENT_TYPE_SINGLE_AZ = "SINGLE_AZ"
    """


    """
    DEPLOYMENT_TYPE_MULTI_AZ = "MULTI_AZ"
    """


    """
    PROVIDER_AWS = "AWS"
    """


    """
    PROVIDER_ZEROCLOUD = "ZEROCLOUD"
    """


    """



    _canonical_to_pep_names = {
                            'mgmt_appliance_network_name': 'mgmt_appliance_network_name',
                            'mgw_id': 'mgw_id',
                            'nsx_mgr_url': 'nsx_mgr_url',
                            'skip_creating_vxlan': 'skip_creating_vxlan',
                            'nsx_cloud_audit_password': 'nsx_cloud_audit_password',
                            'management_ds': 'management_ds',
                            'nsx_api_public_endpoint_url': 'nsx_api_public_endpoint_url',
                            'sddc_networks': 'sddc_networks',
                            'clusters': 'clusters',
                            'deployment_type': 'deployment_type',
                            'nsx_mgr_management_ip': 'nsx_mgr_management_ip',
                            'nsx_cloud_audit': 'nsx_cloud_audit',
                            'esx_cluster_id': 'esx_cluster_id',
                            'vc_public_ip': 'vc_public_ip',
                            'vc_url': 'vc_url',
                            'esx_hosts': 'esx_hosts',
                            'vc_management_ip': 'vc_management_ip',
                            'management_rp': 'management_rp',
                            'witness_availability_zone': 'witness_availability_zone',
                            'sddc_desired_state': 'sddc_desired_state',
                            'sddc_size': 'sddc_size',
                            'cvds_enabled': 'cvds_enabled',
                            'nsx_controller_ips': 'nsx_controller_ips',
                            'two_hostname_vc_deployment': 'two_hostname_vc_deployment',
                            'esx_host_subnet': 'esx_host_subnet',
                            'sso_domain': 'sso_domain',
                            'msft_license_config': 'msft_license_config',
                            'region': 'region',
                            'outpost_config': 'outpost_config',
                            'nsxt': 'nsxt',
                            'psc_management_ip': 'psc_management_ip',
                            'psc_url': 'psc_url',
                            'cgws': 'cgws',
                            'availability_zones': 'availability_zones',
                            'custom_properties': 'custom_properties',
                            'cloud_password': 'cloud_password',
                            'provider': 'provider',
                            'nsx_cloud_admin_password': 'nsx_cloud_admin_password',
                            'cloud_username': 'cloud_username',
                            'vc_instance_id': 'vc_instance_id',
                            'cloud_user_group': 'cloud_user_group',
                            'vlcm_enabled': 'vlcm_enabled',
                            'sddc_manifest': 'sddc_manifest',
                            'vxlan_subnet': 'vxlan_subnet',
                            'sddc_security': 'sddc_security',
                            'sddc_id': 'sddc_id',
                            'pop_agent_xeni_connection': 'pop_agent_xeni_connection',
                            'nsx_mgr_login_url': 'nsx_mgr_login_url',
                            'dns_with_management_vm_private_ip': 'dns_with_management_vm_private_ip',
                            'nsx_cloud_admin': 'nsx_cloud_admin',
                            'nsxt_addons': 'nsxt_addons',
                            }

    def __init__(self,
                 mgmt_appliance_network_name=None,
                 mgw_id=None,
                 nsx_mgr_url=None,
                 skip_creating_vxlan=None,
                 nsx_cloud_audit_password=None,
                 management_ds=None,
                 nsx_api_public_endpoint_url=None,
                 sddc_networks=None,
                 clusters=None,
                 deployment_type=None,
                 nsx_mgr_management_ip=None,
                 nsx_cloud_audit=None,
                 esx_cluster_id=None,
                 vc_public_ip=None,
                 vc_url=None,
                 esx_hosts=None,
                 vc_management_ip=None,
                 management_rp=None,
                 witness_availability_zone=None,
                 sddc_desired_state=None,
                 sddc_size=None,
                 cvds_enabled=None,
                 nsx_controller_ips=None,
                 two_hostname_vc_deployment=None,
                 esx_host_subnet=None,
                 sso_domain=None,
                 msft_license_config=None,
                 region=None,
                 outpost_config=None,
                 nsxt=None,
                 psc_management_ip=None,
                 psc_url=None,
                 cgws=None,
                 availability_zones=None,
                 custom_properties=None,
                 cloud_password=None,
                 provider='SddcResourceConfig',
                 nsx_cloud_admin_password=None,
                 cloud_username=None,
                 vc_instance_id=None,
                 cloud_user_group=None,
                 vlcm_enabled=None,
                 sddc_manifest=None,
                 vxlan_subnet=None,
                 sddc_security=None,
                 sddc_id=None,
                 pop_agent_xeni_connection=None,
                 nsx_mgr_login_url=None,
                 dns_with_management_vm_private_ip=None,
                 nsx_cloud_admin=None,
                 nsxt_addons=None,
                ):
        """
        :type  mgmt_appliance_network_name: :class:`str` or ``None``
        :param mgmt_appliance_network_name: Name for management appliance network.
        :type  mgw_id: :class:`str` or ``None``
        :param mgw_id: Management Gateway Id
        :type  nsx_mgr_url: :class:`str` or ``None``
        :param nsx_mgr_url: URL of the NSX Manager
        :type  skip_creating_vxlan: :class:`bool` or ``None``
        :param skip_creating_vxlan: skip creating vxlan for compute gateway for SDDC provisioning
        :type  nsx_cloud_audit_password: :class:`str` or ``None``
        :param nsx_cloud_audit_password: NSX cloud audit Password
        :type  management_ds: :class:`str` or ``None``
        :param management_ds: The ManagedObjectReference of the management Datastore
        :type  nsx_api_public_endpoint_url: :class:`str` or ``None``
        :param nsx_api_public_endpoint_url: nsx api entire base url
        :type  sddc_networks: :class:`list` of :class:`str` or ``None``
        :param sddc_networks: 
        :type  clusters: :class:`list` of :class:`Cluster` or ``None``
        :param clusters: List of clusters in the SDDC.
        :type  deployment_type: :class:`str` or ``None``
        :param deployment_type: Possible values are: 
            
            * :attr:`SddcResourceConfig.DEPLOYMENT_TYPE_SINGLE_AZ`
            * :attr:`SddcResourceConfig.DEPLOYMENT_TYPE_MULTI_AZ`
            
             Denotes if this is a SingleAZ SDDC or a MultiAZ SDDC.
        :type  nsx_mgr_management_ip: :class:`str` or ``None``
        :param nsx_mgr_management_ip: NSX Manager internal management IP
        :type  nsx_cloud_audit: :class:`str` or ``None``
        :param nsx_cloud_audit: NSX cloud audit user name
        :type  esx_cluster_id: :class:`str` or ``None``
        :param esx_cluster_id: Cluster Id to add ESX workflow
        :type  vc_public_ip: :class:`str` or ``None``
        :param vc_public_ip: vCenter public IP
        :type  vc_url: :class:`str` or ``None``
        :param vc_url: URL of the vCenter server
        :type  esx_hosts: :class:`list` of :class:`AwsEsxHost` or ``None``
        :param esx_hosts: 
        :type  vc_management_ip: :class:`str` or ``None``
        :param vc_management_ip: vCenter internal management IP
        :type  management_rp: :class:`str` or ``None``
        :param management_rp: 
        :type  witness_availability_zone: :class:`str` or ``None``
        :param witness_availability_zone: Availability zone where the witness node is provisioned for a
            MultiAZ SDDC. This is null for a SingleAZ SDDC.
        :type  sddc_desired_state: :class:`bool` or ``None``
        :param sddc_desired_state: Whether this sddc is maintained by its desired state documents.
        :type  sddc_size: :class:`SddcSize` or ``None``
        :param sddc_size: 
        :type  cvds_enabled: :class:`bool` or ``None``
        :param cvds_enabled: This flag determines whether CVDS is enabled on this sddc or not.
        :type  nsx_controller_ips: :class:`list` of :class:`str` or ``None``
        :param nsx_controller_ips: List of Controller IPs
        :type  two_hostname_vc_deployment: :class:`bool` or ``None``
        :param two_hostname_vc_deployment: Marks that the SDDC VC should be deployed with two hostnames.
        :type  esx_host_subnet: :class:`str` or ``None``
        :param esx_host_subnet: ESX host subnet
        :type  sso_domain: :class:`str` or ``None``
        :param sso_domain: The SSO domain name to use for vSphere users
        :type  msft_license_config: :class:`MsftLicensingConfig` or ``None``
        :param msft_license_config: The Microsoft license status of this SDDC.
        :type  region: :class:`str` or ``None``
        :param region: region in which sddc is deployed
        :type  outpost_config: :class:`OutpostConfig` or ``None``
        :param outpost_config: Outpost configuration of this SDDC.
        :type  nsxt: :class:`bool` or ``None``
        :param nsxt: if true, NSX-T UI is enabled.
        :type  psc_management_ip: :class:`str` or ``None``
        :param psc_management_ip: PSC internal management IP
        :type  psc_url: :class:`str` or ``None``
        :param psc_url: URL of the PSC server
        :type  cgws: :class:`list` of :class:`str` or ``None``
        :param cgws: 
        :type  availability_zones: :class:`list` of :class:`str` or ``None``
        :param availability_zones: Availability zones over which esx hosts are provisioned. MultiAZ
            SDDCs will have hosts provisioned over two availability zones while
            SingleAZ SDDCs will provision over one.
        :type  custom_properties: (:class:`dict` of :class:`str` and :class:`str`) or ``None``
        :param custom_properties: 
        :type  cloud_password: :class:`str` or ``None``
        :param cloud_password: Password for vCenter SDDC administrator
        :type  provider: :class:`str`
        :param provider: Possible values are: 
            
            * :attr:`SddcResourceConfig.PROVIDER_AWS`
            * :attr:`SddcResourceConfig.PROVIDER_ZEROCLOUD`
            
             Discriminator for additional properties
        :type  nsx_cloud_admin_password: :class:`str` or ``None``
        :param nsx_cloud_admin_password: NSX cloud admin password
        :type  cloud_username: :class:`str` or ``None``
        :param cloud_username: Username for vCenter SDDC administrator
        :type  vc_instance_id: :class:`str` or ``None``
        :param vc_instance_id: unique id of the vCenter server
        :type  cloud_user_group: :class:`str` or ``None``
        :param cloud_user_group: Group name for vCenter SDDC administrator
        :type  vlcm_enabled: :class:`bool` or ``None``
        :param vlcm_enabled: This flag determines whether vLCM is enabled on this sddc or not.
        :type  sddc_manifest: :class:`SddcManifest` or ``None``
        :param sddc_manifest: 
        :type  vxlan_subnet: :class:`str` or ``None``
        :param vxlan_subnet: VXLAN IP subnet
        :type  sddc_security: :class:`SddcSecurity` or ``None``
        :param sddc_security: 
        :type  sddc_id: :class:`str` or ``None``
        :param sddc_id: sddc identifier
        :type  pop_agent_xeni_connection: :class:`PopAgentXeniConnection` or ``None``
        :param pop_agent_xeni_connection: 
        :type  nsx_mgr_login_url: :class:`str` or ``None``
        :param nsx_mgr_login_url: URL of the NSX Manager UI login for local user access
        :type  dns_with_management_vm_private_ip: :class:`bool` or ``None``
        :param dns_with_management_vm_private_ip: if true, use the private IP addresses to register DNS records for
            the management VMs
        :type  nsx_cloud_admin: :class:`str` or ``None``
        :param nsx_cloud_admin: NSX cloud admin user name
        :type  nsxt_addons: :class:`NsxtAddons` or ``None``
        :param nsxt_addons: 
        """
        self.mgmt_appliance_network_name = mgmt_appliance_network_name
        self.mgw_id = mgw_id
        self.nsx_mgr_url = nsx_mgr_url
        self.skip_creating_vxlan = skip_creating_vxlan
        self.nsx_cloud_audit_password = nsx_cloud_audit_password
        self.management_ds = management_ds
        self.nsx_api_public_endpoint_url = nsx_api_public_endpoint_url
        self.sddc_networks = sddc_networks
        self.clusters = clusters
        self.deployment_type = deployment_type
        self.nsx_mgr_management_ip = nsx_mgr_management_ip
        self.nsx_cloud_audit = nsx_cloud_audit
        self.esx_cluster_id = esx_cluster_id
        self.vc_public_ip = vc_public_ip
        self.vc_url = vc_url
        self.esx_hosts = esx_hosts
        self.vc_management_ip = vc_management_ip
        self.management_rp = management_rp
        self.witness_availability_zone = witness_availability_zone
        self.sddc_desired_state = sddc_desired_state
        self.sddc_size = sddc_size
        self.cvds_enabled = cvds_enabled
        self.nsx_controller_ips = nsx_controller_ips
        self.two_hostname_vc_deployment = two_hostname_vc_deployment
        self.esx_host_subnet = esx_host_subnet
        self.sso_domain = sso_domain
        self.msft_license_config = msft_license_config
        self.region = region
        self.outpost_config = outpost_config
        self.nsxt = nsxt
        self.psc_management_ip = psc_management_ip
        self.psc_url = psc_url
        self.cgws = cgws
        self.availability_zones = availability_zones
        self.custom_properties = custom_properties
        self.cloud_password = cloud_password
        self._provider = provider
        self.nsx_cloud_admin_password = nsx_cloud_admin_password
        self.cloud_username = cloud_username
        self.vc_instance_id = vc_instance_id
        self.cloud_user_group = cloud_user_group
        self.vlcm_enabled = vlcm_enabled
        self.sddc_manifest = sddc_manifest
        self.vxlan_subnet = vxlan_subnet
        self.sddc_security = sddc_security
        self.sddc_id = sddc_id
        self.pop_agent_xeni_connection = pop_agent_xeni_connection
        self.nsx_mgr_login_url = nsx_mgr_login_url
        self.dns_with_management_vm_private_ip = dns_with_management_vm_private_ip
        self.nsx_cloud_admin = nsx_cloud_admin
        self.nsxt_addons = nsxt_addons
        VapiStruct.__init__(self)

    @property
    def provider(self):
        """
        Return the discriminator value
        """
        return self._provider

SddcResourceConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_resource_config', {
        'mgmt_appliance_network_name': type.OptionalType(type.StringType()),
        'mgw_id': type.OptionalType(type.StringType()),
        'nsx_mgr_url': type.OptionalType(type.StringType()),
        'skip_creating_vxlan': type.OptionalType(type.BooleanType()),
        'nsx_cloud_audit_password': type.OptionalType(type.StringType()),
        'management_ds': type.OptionalType(type.StringType()),
        'nsx_api_public_endpoint_url': type.OptionalType(type.StringType()),
        'sddc_networks': type.OptionalType(type.ListType(type.StringType())),
        'clusters': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Cluster'))),
        'deployment_type': type.OptionalType(type.StringType()),
        'nsx_mgr_management_ip': type.OptionalType(type.StringType()),
        'nsx_cloud_audit': type.OptionalType(type.StringType()),
        'esx_cluster_id': type.OptionalType(type.StringType()),
        'vc_public_ip': type.OptionalType(type.StringType()),
        'vc_url': type.OptionalType(type.StringType()),
        'esx_hosts': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AwsEsxHost'))),
        'vc_management_ip': type.OptionalType(type.StringType()),
        'management_rp': type.OptionalType(type.StringType()),
        'witness_availability_zone': type.OptionalType(type.StringType()),
        'sddc_desired_state': type.OptionalType(type.BooleanType()),
        'sddc_size': type.OptionalType(type.ReferenceType(__name__, 'SddcSize')),
        'cvds_enabled': type.OptionalType(type.BooleanType()),
        'nsx_controller_ips': type.OptionalType(type.ListType(type.StringType())),
        'two_hostname_vc_deployment': type.OptionalType(type.BooleanType()),
        'esx_host_subnet': type.OptionalType(type.StringType()),
        'sso_domain': type.OptionalType(type.StringType()),
        'msft_license_config': type.OptionalType(type.ReferenceType(__name__, 'MsftLicensingConfig')),
        'region': type.OptionalType(type.StringType()),
        'outpost_config': type.OptionalType(type.ReferenceType(__name__, 'OutpostConfig')),
        'nsxt': type.OptionalType(type.BooleanType()),
        'psc_management_ip': type.OptionalType(type.StringType()),
        'psc_url': type.OptionalType(type.StringType()),
        'cgws': type.OptionalType(type.ListType(type.StringType())),
        'availability_zones': type.OptionalType(type.ListType(type.StringType())),
        'custom_properties': type.OptionalType(type.MapType(type.StringType(), type.StringType())),
        'cloud_password': type.OptionalType(type.StringType()),
        'provider': type.StringType(),
        'nsx_cloud_admin_password': type.OptionalType(type.StringType()),
        'cloud_username': type.OptionalType(type.StringType()),
        'vc_instance_id': type.OptionalType(type.StringType()),
        'cloud_user_group': type.OptionalType(type.StringType()),
        'vlcm_enabled': type.OptionalType(type.BooleanType()),
        'sddc_manifest': type.OptionalType(type.ReferenceType(__name__, 'SddcManifest')),
        'vxlan_subnet': type.OptionalType(type.StringType()),
        'sddc_security': type.OptionalType(type.ReferenceType(__name__, 'SddcSecurity')),
        'sddc_id': type.OptionalType(type.StringType()),
        'pop_agent_xeni_connection': type.OptionalType(type.ReferenceType(__name__, 'PopAgentXeniConnection')),
        'nsx_mgr_login_url': type.OptionalType(type.StringType()),
        'dns_with_management_vm_private_ip': type.OptionalType(type.BooleanType()),
        'nsx_cloud_admin': type.OptionalType(type.StringType()),
        'nsxt_addons': type.OptionalType(type.ReferenceType(__name__, 'NsxtAddons')),
    },
    SddcResourceConfig,
    False,
    None))



class SddcSecurity(VapiStruct):
    """
    Details the sddc securtity profiles and Harden state.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    PROFILE_DEFAULT = "PROFILE_DEFAULT"
    """


    """
    PROFILE_PCI_COMMERCIAL = "PROFILE_PCI_COMMERCIAL"
    """


    """



    _canonical_to_pep_names = {
                            'profile': 'profile',
                            'hardened': 'hardened',
                            }

    def __init__(self,
                 profile=None,
                 hardened=None,
                ):
        """
        :type  profile: :class:`str` or ``None``
        :param profile: Possible values are: 
            
            * :attr:`SddcSecurity.PROFILE_DEFAULT`
            * :attr:`SddcSecurity.PROFILE_PCI_COMMERCIAL`
            
             Security Profiles for SDDC Hardening.
        :type  hardened: :class:`bool` or ``None``
        :param hardened: Indicates whether SDDC is hardened or not.
        """
        self.profile = profile
        self.hardened = hardened
        VapiStruct.__init__(self)


SddcSecurity._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_security', {
        'profile': type.OptionalType(type.StringType()),
        'hardened': type.OptionalType(type.BooleanType()),
    },
    SddcSecurity,
    False,
    None))



class SddcSize(VapiStruct):
    """
    Size of the SDDC

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    VC_SIZE_MEDIUM = "medium"
    """


    """
    VC_SIZE_LARGE = "large"
    """


    """
    NSX_SIZE_SMALL = "small"
    """


    """
    NSX_SIZE_MEDIUM = "medium"
    """


    """
    NSX_SIZE_LARGE = "large"
    """


    """
    SIZE_NSX_SMALL = "NSX_SMALL"
    """


    """
    SIZE_MEDIUM = "MEDIUM"
    """


    """
    SIZE_LARGE = "LARGE"
    """


    """
    SIZE_NSX_LARGE = "NSX_LARGE"
    """


    """



    _canonical_to_pep_names = {
                            'vc_size': 'vc_size',
                            'nsx_size': 'nsx_size',
                            'size': 'size',
                            }

    def __init__(self,
                 vc_size=None,
                 nsx_size=None,
                 size=None,
                ):
        """
        :type  vc_size: :class:`str` or ``None``
        :param vc_size: Possible values are: 
            
            * :attr:`SddcSize.VC_SIZE_MEDIUM`
            * :attr:`SddcSize.VC_SIZE_LARGE`
        :type  nsx_size: :class:`str` or ``None``
        :param nsx_size: Possible values are: 
            
            * :attr:`SddcSize.NSX_SIZE_SMALL`
            * :attr:`SddcSize.NSX_SIZE_MEDIUM`
            * :attr:`SddcSize.NSX_SIZE_LARGE`
        :type  size: :class:`str` or ``None``
        :param size: Possible values are: 
            
            * :attr:`SddcSize.SIZE_NSX_SMALL`
            * :attr:`SddcSize.SIZE_MEDIUM`
            * :attr:`SddcSize.SIZE_LARGE`
            * :attr:`SddcSize.SIZE_NSX_LARGE`
        """
        self.vc_size = vc_size
        self.nsx_size = nsx_size
        self.size = size
        VapiStruct.__init__(self)


SddcSize._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_size', {
        'vc_size': type.OptionalType(type.StringType()),
        'nsx_size': type.OptionalType(type.StringType()),
        'size': type.OptionalType(type.StringType()),
    },
    SddcSize,
    False,
    None))



class SddcStateRequest(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATES_SCHEDULED = "SCHEDULED"
    """


    """
    STATES_RUNNING = "RUNNING"
    """


    """
    STATES_CANCELED = "CANCELED"
    """


    """
    STATES_COMPLETED = "COMPLETED"
    """


    """



    _canonical_to_pep_names = {
                            'sddcs': 'sddcs',
                            'states': 'states',
                            }

    def __init__(self,
                 sddcs=None,
                 states=None,
                ):
        """
        :type  sddcs: :class:`list` of :class:`str` or ``None``
        :param sddcs: 
        :type  states: :class:`list` of :class:`str` or ``None``
        :param states: Possible values are: 
            
            * :attr:`SddcStateRequest.STATES_SCHEDULED`
            * :attr:`SddcStateRequest.STATES_RUNNING`
            * :attr:`SddcStateRequest.STATES_CANCELED`
            * :attr:`SddcStateRequest.STATES_COMPLETED`
        """
        self.sddcs = sddcs
        self.states = states
        VapiStruct.__init__(self)


SddcStateRequest._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_state_request', {
        'sddcs': type.OptionalType(type.ListType(type.StringType())),
        'states': type.OptionalType(type.ListType(type.StringType())),
    },
    SddcStateRequest,
    False,
    None))



class SddcTemplate(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_INITIALIZATION = "INITIALIZATION"
    """


    """
    STATE_AVAILABLE = "AVAILABLE"
    """


    """
    STATE_INUSE = "INUSE"
    """


    """
    STATE_APPLIED = "APPLIED"
    """


    """
    STATE_DELETING = "DELETING"
    """


    """
    STATE_DELETED = "DELETED"
    """


    """
    STATE_FAILED = "FAILED"
    """


    """



    _canonical_to_pep_names = {
                            'updated': 'updated',
                            'user_id': 'user_id',
                            'updated_by_user_id': 'updated_by_user_id',
                            'created': 'created',
                            'version': 'version',
                            'updated_by_user_name': 'updated_by_user_name',
                            'user_name': 'user_name',
                            'id': 'id',
                            'account_link_sddc_configs': 'account_link_sddc_configs',
                            'state': 'state',
                            'network_template': 'network_template',
                            'name': 'name',
                            'source_sddc_id': 'source_sddc_id',
                            'org_id': 'org_id',
                            'sddc': 'sddc',
                            }

    def __init__(self,
                 updated=None,
                 user_id=None,
                 updated_by_user_id=None,
                 created=None,
                 version=None,
                 updated_by_user_name=None,
                 user_name=None,
                 id=None,
                 account_link_sddc_configs=None,
                 state=None,
                 network_template=None,
                 name=None,
                 source_sddc_id=None,
                 org_id=None,
                 sddc=None,
                ):
        """
        :type  updated: :class:`datetime.datetime`
        :param updated: 
        :type  user_id: :class:`str`
        :param user_id: User id that last updated this record
        :type  updated_by_user_id: :class:`str`
        :param updated_by_user_id: User id that last updated this record
        :type  created: :class:`datetime.datetime`
        :param created: 
        :type  version: :class:`long`
        :param version: Version of this entity format: int32
        :type  updated_by_user_name: :class:`str` or ``None``
        :param updated_by_user_name: User name that last updated this record
        :type  user_name: :class:`str`
        :param user_name: User name that last updated this record
        :type  id: :class:`str`
        :param id: Unique ID for this entity
        :type  account_link_sddc_configs: :class:`list` of :class:`AccountLinkSddcConfig` or ``None``
        :param account_link_sddc_configs: A list of the SDDC linking configurations to use.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`SddcTemplate.STATE_INITIALIZATION`
            * :attr:`SddcTemplate.STATE_AVAILABLE`
            * :attr:`SddcTemplate.STATE_INUSE`
            * :attr:`SddcTemplate.STATE_APPLIED`
            * :attr:`SddcTemplate.STATE_DELETING`
            * :attr:`SddcTemplate.STATE_DELETED`
            * :attr:`SddcTemplate.STATE_FAILED`
        :type  network_template: :class:`NetworkTemplate` or ``None``
        :param network_template: 
        :type  name: :class:`str` or ``None``
        :param name: name for SDDC configuration template
        :type  source_sddc_id: :class:`str` or ``None``
        :param source_sddc_id: 
        :type  org_id: :class:`str` or ``None``
        :param org_id: 
        :type  sddc: :class:`Sddc` or ``None``
        :param sddc: 
        """
        self.updated = updated
        self.user_id = user_id
        self.updated_by_user_id = updated_by_user_id
        self.created = created
        self.version = version
        self.updated_by_user_name = updated_by_user_name
        self.user_name = user_name
        self.id = id
        self.account_link_sddc_configs = account_link_sddc_configs
        self.state = state
        self.network_template = network_template
        self.name = name
        self.source_sddc_id = source_sddc_id
        self.org_id = org_id
        self.sddc = sddc
        VapiStruct.__init__(self)


SddcTemplate._set_binding_type(type.StructType(
    'com.vmware.vmc.model.sddc_template', {
        'updated': type.DateTimeType(),
        'user_id': type.StringType(),
        'updated_by_user_id': type.StringType(),
        'created': type.DateTimeType(),
        'version': type.IntegerType(),
        'updated_by_user_name': type.OptionalType(type.StringType()),
        'user_name': type.StringType(),
        'id': type.StringType(),
        'account_link_sddc_configs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AccountLinkSddcConfig'))),
        'state': type.OptionalType(type.StringType()),
        'network_template': type.OptionalType(type.ReferenceType(__name__, 'NetworkTemplate')),
        'name': type.OptionalType(type.StringType()),
        'source_sddc_id': type.OptionalType(type.StringType()),
        'org_id': type.OptionalType(type.StringType()),
        'sddc': type.OptionalType(type.ReferenceType(__name__, 'Sddc')),
    },
    SddcTemplate,
    False,
    None))



class ServiceError(VapiStruct):
    """
    Detailed service errors associated with a task.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'default_message': 'default_message',
                            'original_service': 'original_service',
                            'localized_message': 'localized_message',
                            'original_service_error_code': 'original_service_error_code',
                            }

    def __init__(self,
                 default_message=None,
                 original_service=None,
                 localized_message=None,
                 original_service_error_code=None,
                ):
        """
        :type  default_message: :class:`str` or ``None``
        :param default_message: Error message in English.
        :type  original_service: :class:`str` or ``None``
        :param original_service: The original service name of the error.
        :type  localized_message: :class:`str` or ``None``
        :param localized_message: The localized message.
        :type  original_service_error_code: :class:`str` or ``None``
        :param original_service_error_code: The original error code of the service.
        """
        self.default_message = default_message
        self.original_service = original_service
        self.localized_message = localized_message
        self.original_service_error_code = original_service_error_code
        VapiStruct.__init__(self)


ServiceError._set_binding_type(type.StructType(
    'com.vmware.vmc.model.service_error', {
        'default_message': type.OptionalType(type.StringType()),
        'original_service': type.OptionalType(type.StringType()),
        'localized_message': type.OptionalType(type.StringType()),
        'original_service_error_code': type.OptionalType(type.StringType()),
    },
    ServiceError,
    False,
    None))



class ServiceQuotaRequest(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    REQUEST_STATUS_NEW = "NEW"
    """


    """
    REQUEST_STATUS_PENDING = "PENDING"
    """


    """
    REQUEST_STATUS_RESOLVED = "RESOLVED"
    """


    """
    REQUEST_STATUS_DENIED = "DENIED"
    """


    """
    REQUEST_STATUS_ERROR = "ERROR"
    """


    """



    _canonical_to_pep_names = {
                            'updated': 'updated',
                            'user_id': 'user_id',
                            'updated_by_user_id': 'updated_by_user_id',
                            'created': 'created',
                            'version': 'version',
                            'updated_by_user_name': 'updated_by_user_name',
                            'user_name': 'user_name',
                            'id': 'id',
                            'requester_email': 'requester_email',
                            'task_id': 'task_id',
                            'region': 'region',
                            'aws_account_number': 'aws_account_number',
                            'org_id': 'org_id',
                            'reason': 'reason',
                            'request_status': 'request_status',
                            'request_details': 'request_details',
                            }

    def __init__(self,
                 updated=None,
                 user_id=None,
                 updated_by_user_id=None,
                 created=None,
                 version=None,
                 updated_by_user_name=None,
                 user_name=None,
                 id=None,
                 requester_email=None,
                 task_id=None,
                 region=None,
                 aws_account_number=None,
                 org_id=None,
                 reason=None,
                 request_status=None,
                 request_details=None,
                ):
        """
        :type  updated: :class:`datetime.datetime`
        :param updated: 
        :type  user_id: :class:`str`
        :param user_id: User id that last updated this record
        :type  updated_by_user_id: :class:`str`
        :param updated_by_user_id: User id that last updated this record
        :type  created: :class:`datetime.datetime`
        :param created: 
        :type  version: :class:`long`
        :param version: Version of this entity format: int32
        :type  updated_by_user_name: :class:`str` or ``None``
        :param updated_by_user_name: User name that last updated this record
        :type  user_name: :class:`str`
        :param user_name: User name that last updated this record
        :type  id: :class:`str`
        :param id: Unique ID for this entity
        :type  requester_email: :class:`str` or ``None``
        :param requester_email: 
        :type  task_id: :class:`str` or ``None``
        :param task_id: The task for running the service quota request.
        :type  region: :class:`str` or ``None``
        :param region: Region for the service quota
        :type  aws_account_number: :class:`str` or ``None``
        :param aws_account_number: 
        :type  org_id: :class:`str` or ``None``
        :param org_id: The org ID for this request. This is a standard UUID.
        :type  reason: :class:`str` or ``None``
        :param reason: Reason for this quota increase
        :type  request_status: :class:`str` or ``None``
        :param request_status: Possible values are: 
            
            * :attr:`ServiceQuotaRequest.REQUEST_STATUS_NEW`
            * :attr:`ServiceQuotaRequest.REQUEST_STATUS_PENDING`
            * :attr:`ServiceQuotaRequest.REQUEST_STATUS_RESOLVED`
            * :attr:`ServiceQuotaRequest.REQUEST_STATUS_DENIED`
            * :attr:`ServiceQuotaRequest.REQUEST_STATUS_ERROR`
        :type  request_details: (:class:`dict` of :class:`str` and :class:`RequestDetail`) or ``None``
        :param request_details: service quota request item details
        """
        self.updated = updated
        self.user_id = user_id
        self.updated_by_user_id = updated_by_user_id
        self.created = created
        self.version = version
        self.updated_by_user_name = updated_by_user_name
        self.user_name = user_name
        self.id = id
        self.requester_email = requester_email
        self.task_id = task_id
        self.region = region
        self.aws_account_number = aws_account_number
        self.org_id = org_id
        self.reason = reason
        self.request_status = request_status
        self.request_details = request_details
        VapiStruct.__init__(self)


ServiceQuotaRequest._set_binding_type(type.StructType(
    'com.vmware.vmc.model.service_quota_request', {
        'updated': type.DateTimeType(),
        'user_id': type.StringType(),
        'updated_by_user_id': type.StringType(),
        'created': type.DateTimeType(),
        'version': type.IntegerType(),
        'updated_by_user_name': type.OptionalType(type.StringType()),
        'user_name': type.StringType(),
        'id': type.StringType(),
        'requester_email': type.OptionalType(type.StringType()),
        'task_id': type.OptionalType(type.StringType()),
        'region': type.OptionalType(type.StringType()),
        'aws_account_number': type.OptionalType(type.StringType()),
        'org_id': type.OptionalType(type.StringType()),
        'reason': type.OptionalType(type.StringType()),
        'request_status': type.OptionalType(type.StringType()),
        'request_details': type.OptionalType(type.MapType(type.StringType(), type.ReferenceType(__name__, 'RequestDetail'))),
    },
    ServiceQuotaRequest,
    False,
    None))



class Site(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TUNNEL_STATUS_CONNECTED = "CONNECTED"
    """


    """
    TUNNEL_STATUS_DISCONNECTED = "DISCONNECTED"
    """


    """
    TUNNEL_STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'password': 'password',
                            'user_id': 'user_id',
                            'name': 'name',
                            'rx_bytes_on_local_subnet': 'rx_bytes_on_local_subnet',
                            'secure_traffic': 'secure_traffic',
                            'established_date': 'established_date',
                            'failure_message': 'failure_message',
                            'dropped_tx_packets': 'dropped_tx_packets',
                            'dropped_rx_packets': 'dropped_rx_packets',
                            'tunnel_status': 'tunnel_status',
                            'tx_bytes_from_local_subnet': 'tx_bytes_from_local_subnet',
                            }

    def __init__(self,
                 password=None,
                 user_id=None,
                 name=None,
                 rx_bytes_on_local_subnet=None,
                 secure_traffic=None,
                 established_date=None,
                 failure_message=None,
                 dropped_tx_packets=None,
                 dropped_rx_packets=None,
                 tunnel_status=None,
                 tx_bytes_from_local_subnet=None,
                ):
        """
        :type  password: :class:`str` or ``None``
        :param password: Site password.
        :type  user_id: :class:`str` or ``None``
        :param user_id: Site user id.
        :type  name: :class:`str` or ``None``
        :param name: Unique name for the site getting configured.
        :type  rx_bytes_on_local_subnet: :class:`long` or ``None``
        :param rx_bytes_on_local_subnet: Bytes received on local network. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  secure_traffic: :class:`bool` or ``None``
        :param secure_traffic: Enable/disable encription.
        :type  established_date: :class:`str` or ``None``
        :param established_date: Date tunnel was established.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: failure message.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  dropped_tx_packets: :class:`str` or ``None``
        :param dropped_tx_packets: Number of transmitted packets dropped.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  dropped_rx_packets: :class:`str` or ``None``
        :param dropped_rx_packets: Number of received packets dropped.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  tunnel_status: :class:`str` or ``None``
        :param tunnel_status: Possible values are: 
            
            * :attr:`Site.TUNNEL_STATUS_CONNECTED`
            * :attr:`Site.TUNNEL_STATUS_DISCONNECTED`
            * :attr:`Site.TUNNEL_STATUS_UNKNOWN`
            
             Site tunnel status.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  tx_bytes_from_local_subnet: :class:`long` or ``None``
        :param tx_bytes_from_local_subnet: Bytes transmitted from local subnet. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.password = password
        self.user_id = user_id
        self.name = name
        self.rx_bytes_on_local_subnet = rx_bytes_on_local_subnet
        self.secure_traffic = secure_traffic
        self.established_date = established_date
        self.failure_message = failure_message
        self.dropped_tx_packets = dropped_tx_packets
        self.dropped_rx_packets = dropped_rx_packets
        self.tunnel_status = tunnel_status
        self.tx_bytes_from_local_subnet = tx_bytes_from_local_subnet
        VapiStruct.__init__(self)


Site._set_binding_type(type.StructType(
    'com.vmware.vmc.model.site', {
        'password': type.OptionalType(type.StringType()),
        'user_id': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'rx_bytes_on_local_subnet': type.OptionalType(type.IntegerType()),
        'secure_traffic': type.OptionalType(type.BooleanType()),
        'established_date': type.OptionalType(type.StringType()),
        'failure_message': type.OptionalType(type.StringType()),
        'dropped_tx_packets': type.OptionalType(type.StringType()),
        'dropped_rx_packets': type.OptionalType(type.StringType()),
        'tunnel_status': type.OptionalType(type.StringType()),
        'tx_bytes_from_local_subnet': type.OptionalType(type.IntegerType()),
    },
    Site,
    False,
    None))



class Subnet(VapiStruct):
    """
    (as there's already one SubnetInfo, use Subnet instead)

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'subnet_id': 'subnet_id',
                            'name': 'name',
                            'route_tables': 'route_tables',
                            }

    def __init__(self,
                 subnet_id=None,
                 name=None,
                 route_tables=None,
                ):
        """
        :type  subnet_id: :class:`str` or ``None``
        :param subnet_id: subnet id
        :type  name: :class:`str` or ``None``
        :param name: subnet name
        :type  route_tables: :class:`list` of :class:`SubnetRouteTableInfo` or ``None``
        :param route_tables: 
        """
        self.subnet_id = subnet_id
        self.name = name
        self.route_tables = route_tables
        VapiStruct.__init__(self)


Subnet._set_binding_type(type.StructType(
    'com.vmware.vmc.model.subnet', {
        'subnet_id': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'route_tables': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SubnetRouteTableInfo'))),
    },
    Subnet,
    False,
    None))



class SubnetInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'compatible': 'compatible',
                            'connected_account_id': 'connected_account_id',
                            'region_name': 'region_name',
                            'availability_zone': 'availability_zone',
                            'subnet_id': 'subnet_id',
                            'availability_zone_id': 'availability_zone_id',
                            'subnet_cidr_block': 'subnet_cidr_block',
                            'note': 'note',
                            'vpc_id': 'vpc_id',
                            'vpc_cidr_block': 'vpc_cidr_block',
                            'name': 'name',
                            }

    def __init__(self,
                 compatible=None,
                 connected_account_id=None,
                 region_name=None,
                 availability_zone=None,
                 subnet_id=None,
                 availability_zone_id=None,
                 subnet_cidr_block=None,
                 note=None,
                 vpc_id=None,
                 vpc_cidr_block=None,
                 name=None,
                ):
        """
        :type  compatible: :class:`bool` or ``None``
        :param compatible: Is this customer subnet compatible with the SDDC?
        :type  connected_account_id: :class:`str` or ``None``
        :param connected_account_id: The ID of the connected account this subnet is from.
        :type  region_name: :class:`str` or ``None``
        :param region_name: The region this subnet is from.
        :type  availability_zone: :class:`str` or ``None``
        :param availability_zone: The availability zone (customer-centric) this subnet is in.
        :type  subnet_id: :class:`str` or ``None``
        :param subnet_id: The ID of the subnet.
        :type  availability_zone_id: :class:`str` or ``None``
        :param availability_zone_id: The availability zone id (customer-centric) this subnet is in.
        :type  subnet_cidr_block: :class:`str` or ``None``
        :param subnet_cidr_block: The CIDR block of the subnet.
        :type  note: :class:`str` or ``None``
        :param note: Why a subnet is marked as not compatible. May be blank if
            compatible.
        :type  vpc_id: :class:`str` or ``None``
        :param vpc_id: The ID of the VPC this subnet resides in.
        :type  vpc_cidr_block: :class:`str` or ``None``
        :param vpc_cidr_block: The CIDR block of the VPC containing this subnet.
        :type  name: :class:`str` or ``None``
        :param name: The name of the subnet. This is either the tagged name or the
            default AWS id it was given.
        """
        self.compatible = compatible
        self.connected_account_id = connected_account_id
        self.region_name = region_name
        self.availability_zone = availability_zone
        self.subnet_id = subnet_id
        self.availability_zone_id = availability_zone_id
        self.subnet_cidr_block = subnet_cidr_block
        self.note = note
        self.vpc_id = vpc_id
        self.vpc_cidr_block = vpc_cidr_block
        self.name = name
        VapiStruct.__init__(self)


SubnetInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.subnet_info', {
        'compatible': type.OptionalType(type.BooleanType()),
        'connected_account_id': type.OptionalType(type.StringType()),
        'region_name': type.OptionalType(type.StringType()),
        'availability_zone': type.OptionalType(type.StringType()),
        'subnet_id': type.OptionalType(type.StringType()),
        'availability_zone_id': type.OptionalType(type.StringType()),
        'subnet_cidr_block': type.OptionalType(type.StringType()),
        'note': type.OptionalType(type.StringType()),
        'vpc_id': type.OptionalType(type.StringType()),
        'vpc_cidr_block': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
    },
    SubnetInfo,
    False,
    None))



class SubnetRouteTableInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'subnet_id': 'subnet_id',
                            'association_id': 'association_id',
                            'routetable_id': 'routetable_id',
                            }

    def __init__(self,
                 subnet_id=None,
                 association_id=None,
                 routetable_id=None,
                ):
        """
        :type  subnet_id: :class:`str` or ``None``
        :param subnet_id: subnet id
        :type  association_id: :class:`str` or ``None``
        :param association_id: subnet - route table association id
        :type  routetable_id: :class:`str` or ``None``
        :param routetable_id: route table id
        """
        self.subnet_id = subnet_id
        self.association_id = association_id
        self.routetable_id = routetable_id
        VapiStruct.__init__(self)


SubnetRouteTableInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.subnet_route_table_info', {
        'subnet_id': type.OptionalType(type.StringType()),
        'association_id': type.OptionalType(type.StringType()),
        'routetable_id': type.OptionalType(type.StringType()),
    },
    SubnetRouteTableInfo,
    False,
    None))



class SubscriptionDetails(VapiStruct):
    """
    details of a subscription

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_CREATED = "CREATED"
    """


    """
    STATUS_ACTIVATED = "ACTIVATED"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_CANCELLED = "CANCELLED"
    """


    """
    STATUS_EXPIRED = "EXPIRED"
    """


    """
    STATUS_PENDING_PROVISIONING = "PENDING_PROVISIONING"
    """


    """
    STATUS_ORDER_SUBMITTED = "ORDER_SUBMITTED"
    """


    """
    STATUS_SUSPENDED = "SUSPENDED"
    """


    """
    STATUS_TERMINATED = "TERMINATED"
    """


    """
    STATUS_UKNOWN = "UKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'status': 'status',
                            'anniversary_billing_date': 'anniversary_billing_date',
                            'end_date': 'end_date',
                            'billing_frequency': 'billing_frequency',
                            'auto_renewed_allowed': 'auto_renewed_allowed',
                            'commitment_term': 'commitment_term',
                            'csp_subscription_id': 'csp_subscription_id',
                            'billing_subscription_id': 'billing_subscription_id',
                            'offer_version': 'offer_version',
                            'offer_type': 'offer_type',
                            'description': 'description',
                            'product_id': 'product_id',
                            'region': 'region',
                            'product_name': 'product_name',
                            'offer_name': 'offer_name',
                            'commitment_term_uom': 'commitment_term_uom',
                            'start_date': 'start_date',
                            'quantity': 'quantity',
                            }

    def __init__(self,
                 status=None,
                 anniversary_billing_date=None,
                 end_date=None,
                 billing_frequency=None,
                 auto_renewed_allowed=None,
                 commitment_term=None,
                 csp_subscription_id=None,
                 billing_subscription_id=None,
                 offer_version=None,
                 offer_type=None,
                 description=None,
                 product_id=None,
                 region=None,
                 product_name=None,
                 offer_name=None,
                 commitment_term_uom=None,
                 start_date=None,
                 quantity=None,
                ):
        """
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`SubscriptionDetails.STATUS_CREATED`
            * :attr:`SubscriptionDetails.STATUS_ACTIVATED`
            * :attr:`SubscriptionDetails.STATUS_FAILED`
            * :attr:`SubscriptionDetails.STATUS_CANCELLED`
            * :attr:`SubscriptionDetails.STATUS_EXPIRED`
            * :attr:`SubscriptionDetails.STATUS_PENDING_PROVISIONING`
            * :attr:`SubscriptionDetails.STATUS_ORDER_SUBMITTED`
            * :attr:`SubscriptionDetails.STATUS_SUSPENDED`
            * :attr:`SubscriptionDetails.STATUS_TERMINATED`
            * :attr:`SubscriptionDetails.STATUS_UKNOWN`
        :type  anniversary_billing_date: :class:`str` or ``None``
        :param anniversary_billing_date: 
        :type  end_date: :class:`str` or ``None``
        :param end_date: 
        :type  billing_frequency: :class:`str` or ``None``
        :param billing_frequency: The frequency at which the customer is billed. Currently supported
            values are \"Upfront\" and \"Monthly\"
        :type  auto_renewed_allowed: :class:`str` or ``None``
        :param auto_renewed_allowed: 
        :type  commitment_term: :class:`str` or ``None``
        :param commitment_term: 
        :type  csp_subscription_id: :class:`str` or ``None``
        :param csp_subscription_id: 
        :type  billing_subscription_id: :class:`str` or ``None``
        :param billing_subscription_id: 
        :type  offer_version: :class:`str` or ``None``
        :param offer_version: 
        :type  offer_type: :class:`OfferType` or ``None``
        :param offer_type: 
        :type  description: :class:`str` or ``None``
        :param description: 
        :type  product_id: :class:`str` or ``None``
        :param product_id: 
        :type  region: :class:`str` or ``None``
        :param region: 
        :type  product_name: :class:`str` or ``None``
        :param product_name: 
        :type  offer_name: :class:`str` or ``None``
        :param offer_name: 
        :type  commitment_term_uom: :class:`str` or ``None``
        :param commitment_term_uom: unit of measurment for commitment term
        :type  start_date: :class:`str` or ``None``
        :param start_date: 
        :type  quantity: :class:`str` or ``None``
        :param quantity: 
        """
        self.status = status
        self.anniversary_billing_date = anniversary_billing_date
        self.end_date = end_date
        self.billing_frequency = billing_frequency
        self.auto_renewed_allowed = auto_renewed_allowed
        self.commitment_term = commitment_term
        self.csp_subscription_id = csp_subscription_id
        self.billing_subscription_id = billing_subscription_id
        self.offer_version = offer_version
        self.offer_type = offer_type
        self.description = description
        self.product_id = product_id
        self.region = region
        self.product_name = product_name
        self.offer_name = offer_name
        self.commitment_term_uom = commitment_term_uom
        self.start_date = start_date
        self.quantity = quantity
        VapiStruct.__init__(self)


SubscriptionDetails._set_binding_type(type.StructType(
    'com.vmware.vmc.model.subscription_details', {
        'status': type.OptionalType(type.StringType()),
        'anniversary_billing_date': type.OptionalType(type.StringType()),
        'end_date': type.OptionalType(type.StringType()),
        'billing_frequency': type.OptionalType(type.StringType()),
        'auto_renewed_allowed': type.OptionalType(type.StringType()),
        'commitment_term': type.OptionalType(type.StringType()),
        'csp_subscription_id': type.OptionalType(type.StringType()),
        'billing_subscription_id': type.OptionalType(type.StringType()),
        'offer_version': type.OptionalType(type.StringType()),
        'offer_type': type.OptionalType(type.ReferenceType(__name__, 'OfferType')),
        'description': type.OptionalType(type.StringType()),
        'product_id': type.OptionalType(type.StringType()),
        'region': type.OptionalType(type.StringType()),
        'product_name': type.OptionalType(type.StringType()),
        'offer_name': type.OptionalType(type.StringType()),
        'commitment_term_uom': type.OptionalType(type.StringType()),
        'start_date': type.OptionalType(type.StringType()),
        'quantity': type.OptionalType(type.StringType()),
    },
    SubscriptionDetails,
    False,
    None))



class SubscriptionProducts(VapiStruct):
    """
    Details of products that are available for purchase.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'product': 'product',
                            'types': 'types',
                            }

    def __init__(self,
                 product=None,
                 types=None,
                ):
        """
        :type  product: :class:`str` or ``None``
        :param product: The name of the product
        :type  types: :class:`list` of :class:`str` or ``None``
        :param types: A list of different types/version for the product.
        """
        self.product = product
        self.types = types
        VapiStruct.__init__(self)


SubscriptionProducts._set_binding_type(type.StructType(
    'com.vmware.vmc.model.subscription_products', {
        'product': type.OptionalType(type.StringType()),
        'types': type.OptionalType(type.ListType(type.StringType())),
    },
    SubscriptionProducts,
    False,
    None))



class SubscriptionRequest(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'product': 'product',
                            'product_type': 'product_type',
                            'product_id': 'product_id',
                            'billing_frequency': 'billing_frequency',
                            'region': 'region',
                            'commitment_term': 'commitment_term',
                            'offer_context_id': 'offer_context_id',
                            'offer_version': 'offer_version',
                            'offer_name': 'offer_name',
                            'quantity': 'quantity',
                            'type': 'type',
                            'price': 'price',
                            'product_charge_id': 'product_charge_id',
                            }

    def __init__(self,
                 product=None,
                 product_type=None,
                 product_id=None,
                 billing_frequency=None,
                 region=None,
                 commitment_term=None,
                 offer_context_id=None,
                 offer_version=None,
                 offer_name=None,
                 quantity=None,
                 type=None,
                 price=None,
                 product_charge_id=None,
                ):
        """
        :type  product: :class:`str` or ``None``
        :param product: The product for which subscription needs to be created. Refer
            /vmc/api/orgs/{orgId}/products.
        :type  product_type: :class:`str`
        :param product_type: Old identifier for product. \*Deprecarted\*. See product and type
        :type  product_id: :class:`str` or ``None``
        :param product_id: 
        :type  billing_frequency: :class:`str` or ``None``
        :param billing_frequency: Frequency of the billing.
        :type  region: :class:`str`
        :param region: 
        :type  commitment_term: :class:`str`
        :param commitment_term: 
        :type  offer_context_id: :class:`str` or ``None``
        :param offer_context_id: 
        :type  offer_version: :class:`str`
        :param offer_version: 
        :type  offer_name: :class:`str`
        :param offer_name: 
        :type  quantity: :class:`long`
        :param quantity: 
        :type  type: :class:`str` or ``None``
        :param type: The type of the product for which the subscription needs to be
            created.
        :type  price: :class:`long` or ``None``
        :param price: 
        :type  product_charge_id: :class:`str` or ``None``
        :param product_charge_id: 
        """
        self.product = product
        self.product_type = product_type
        self.product_id = product_id
        self.billing_frequency = billing_frequency
        self.region = region
        self.commitment_term = commitment_term
        self.offer_context_id = offer_context_id
        self.offer_version = offer_version
        self.offer_name = offer_name
        self.quantity = quantity
        self.type = type
        self.price = price
        self.product_charge_id = product_charge_id
        VapiStruct.__init__(self)


SubscriptionRequest._set_binding_type(type.StructType(
    'com.vmware.vmc.model.subscription_request', {
        'product': type.OptionalType(type.StringType()),
        'product_type': type.StringType(),
        'product_id': type.OptionalType(type.StringType()),
        'billing_frequency': type.OptionalType(type.StringType()),
        'region': type.StringType(),
        'commitment_term': type.StringType(),
        'offer_context_id': type.OptionalType(type.StringType()),
        'offer_version': type.StringType(),
        'offer_name': type.StringType(),
        'quantity': type.IntegerType(),
        'type': type.OptionalType(type.StringType()),
        'price': type.OptionalType(type.IntegerType()),
        'product_charge_id': type.OptionalType(type.StringType()),
    },
    SubscriptionRequest,
    False,
    None))



class SupportWindow(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    START_DAY_MONDAY = "MONDAY"
    """


    """
    START_DAY_TUESDAY = "TUESDAY"
    """


    """
    START_DAY_WEDNESDAY = "WEDNESDAY"
    """


    """
    START_DAY_THURSDAY = "THURSDAY"
    """


    """
    START_DAY_FRIDAY = "FRIDAY"
    """


    """
    START_DAY_SATURDAY = "SATURDAY"
    """


    """
    START_DAY_SUNDAY = "SUNDAY"
    """


    """



    _canonical_to_pep_names = {
                            'start_day': 'start_day',
                            'seats': 'seats',
                            'sddcs': 'sddcs',
                            'duration_hours': 'duration_hours',
                            'start_hour': 'start_hour',
                            'support_window_id': 'support_window_id',
                            'metadata': 'metadata',
                            }

    def __init__(self,
                 start_day=None,
                 seats=None,
                 sddcs=None,
                 duration_hours=None,
                 start_hour=None,
                 support_window_id=None,
                 metadata=None,
                ):
        """
        :type  start_day: :class:`str` or ``None``
        :param start_day: Possible values are: 
            
            * :attr:`SupportWindow.START_DAY_MONDAY`
            * :attr:`SupportWindow.START_DAY_TUESDAY`
            * :attr:`SupportWindow.START_DAY_WEDNESDAY`
            * :attr:`SupportWindow.START_DAY_THURSDAY`
            * :attr:`SupportWindow.START_DAY_FRIDAY`
            * :attr:`SupportWindow.START_DAY_SATURDAY`
            * :attr:`SupportWindow.START_DAY_SUNDAY`
        :type  seats: :class:`long` or ``None``
        :param seats: 
        :type  sddcs: :class:`list` of :class:`str` or ``None``
        :param sddcs: SDDCs in this window format: UUID
        :type  duration_hours: :class:`long` or ``None``
        :param duration_hours: 
        :type  start_hour: :class:`long` or ``None``
        :param start_hour: 
        :type  support_window_id: :class:`str` or ``None``
        :param support_window_id: 
        :type  metadata: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param metadata: 
        """
        self.start_day = start_day
        self.seats = seats
        self.sddcs = sddcs
        self.duration_hours = duration_hours
        self.start_hour = start_hour
        self.support_window_id = support_window_id
        self.metadata = metadata
        VapiStruct.__init__(self)


SupportWindow._set_binding_type(type.StructType(
    'com.vmware.vmc.model.support_window', {
        'start_day': type.OptionalType(type.StringType()),
        'seats': type.OptionalType(type.IntegerType()),
        'sddcs': type.OptionalType(type.ListType(type.StringType())),
        'duration_hours': type.OptionalType(type.IntegerType()),
        'start_hour': type.OptionalType(type.IntegerType()),
        'support_window_id': type.OptionalType(type.StringType()),
        'metadata': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
    },
    SupportWindow,
    False,
    None))



class SupportWindowId(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'window_id': 'window_id',
                            }

    def __init__(self,
                 window_id=None,
                ):
        """
        :type  window_id: :class:`str` or ``None``
        :param window_id: Support Window ID
        """
        self.window_id = window_id
        VapiStruct.__init__(self)


SupportWindowId._set_binding_type(type.StructType(
    'com.vmware.vmc.model.support_window_id', {
        'window_id': type.OptionalType(type.StringType()),
    },
    SupportWindowId,
    False,
    None))



class Task(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_STARTED = "STARTED"
    """


    """
    STATUS_CANCELING = "CANCELING"
    """


    """
    STATUS_FINISHED = "FINISHED"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_CANCELED = "CANCELED"
    """


    """



    _canonical_to_pep_names = {
                            'updated': 'updated',
                            'user_id': 'user_id',
                            'updated_by_user_id': 'updated_by_user_id',
                            'created': 'created',
                            'version': 'version',
                            'updated_by_user_name': 'updated_by_user_name',
                            'user_name': 'user_name',
                            'id': 'id',
                            'status': 'status',
                            'localized_error_message': 'localized_error_message',
                            'resource_id': 'resource_id',
                            'parent_task_id': 'parent_task_id',
                            'task_version': 'task_version',
                            'correlation_id': 'correlation_id',
                            'start_resource_entity_version': 'start_resource_entity_version',
                            'customer_error_message': 'customer_error_message',
                            'sub_status': 'sub_status',
                            'task_type': 'task_type',
                            'start_time': 'start_time',
                            'task_progress_phases': 'task_progress_phases',
                            'error_message': 'error_message',
                            'org_id': 'org_id',
                            'end_resource_entity_version': 'end_resource_entity_version',
                            'service_errors': 'service_errors',
                            'org_type': 'org_type',
                            'estimated_remaining_minutes': 'estimated_remaining_minutes',
                            'params': 'params',
                            'progress_percent': 'progress_percent',
                            'phase_in_progress': 'phase_in_progress',
                            'resource_type': 'resource_type',
                            'end_time': 'end_time',
                            }

    def __init__(self,
                 updated=None,
                 user_id=None,
                 updated_by_user_id=None,
                 created=None,
                 version=None,
                 updated_by_user_name=None,
                 user_name=None,
                 id=None,
                 status=None,
                 localized_error_message=None,
                 resource_id=None,
                 parent_task_id=None,
                 task_version=None,
                 correlation_id=None,
                 start_resource_entity_version=None,
                 customer_error_message=None,
                 sub_status=None,
                 task_type=None,
                 start_time=None,
                 task_progress_phases=None,
                 error_message=None,
                 org_id=None,
                 end_resource_entity_version=None,
                 service_errors=None,
                 org_type=None,
                 estimated_remaining_minutes=None,
                 params=None,
                 progress_percent=None,
                 phase_in_progress=None,
                 resource_type=None,
                 end_time=None,
                ):
        """
        :type  updated: :class:`datetime.datetime`
        :param updated: 
        :type  user_id: :class:`str`
        :param user_id: User id that last updated this record
        :type  updated_by_user_id: :class:`str`
        :param updated_by_user_id: User id that last updated this record
        :type  created: :class:`datetime.datetime`
        :param created: 
        :type  version: :class:`long`
        :param version: Version of this entity format: int32
        :type  updated_by_user_name: :class:`str` or ``None``
        :param updated_by_user_name: User name that last updated this record
        :type  user_name: :class:`str`
        :param user_name: User name that last updated this record
        :type  id: :class:`str`
        :param id: Unique ID for this entity
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`Task.STATUS_STARTED`
            * :attr:`Task.STATUS_CANCELING`
            * :attr:`Task.STATUS_FINISHED`
            * :attr:`Task.STATUS_FAILED`
            * :attr:`Task.STATUS_CANCELED`
        :type  localized_error_message: :class:`str` or ``None``
        :param localized_error_message: 
        :type  resource_id: :class:`str` or ``None``
        :param resource_id: UUID of the resource the task is acting upon
        :type  parent_task_id: :class:`str` or ``None``
        :param parent_task_id: If this task was created by another task - this provides the
            linkage. Mostly for debugging.
        :type  task_version: :class:`str` or ``None``
        :param task_version: 
        :type  correlation_id: :class:`str` or ``None``
        :param correlation_id: (Optional) Client provided uniqifier to make task creation
            idempotent. Be aware not all tasks support this. For tasks that do
            - supplying the same correlation Id, for the same task type, within
            a predefined window will ensure the operation happens at most once.
        :type  start_resource_entity_version: :class:`long` or ``None``
        :param start_resource_entity_version: Entity version of the resource at the start of the task. This is
            only set for some task types. format: int32
        :type  customer_error_message: :class:`str` or ``None``
        :param customer_error_message: 
        :type  sub_status: :class:`str` or ``None``
        :param sub_status: 
        :type  task_type: :class:`str` or ``None``
        :param task_type: 
        :type  start_time: :class:`datetime.datetime` or ``None``
        :param start_time: 
        :type  task_progress_phases: :class:`list` of :class:`TaskProgressPhase` or ``None``
        :param task_progress_phases: Task progress phases involved in current task execution
        :type  error_message: :class:`str` or ``None``
        :param error_message: 
        :type  org_id: :class:`str` or ``None``
        :param org_id: 
        :type  end_resource_entity_version: :class:`long` or ``None``
        :param end_resource_entity_version: Entity version of the resource at the end of the task. This is only
            set for some task types. format: int32
        :type  service_errors: :class:`list` of :class:`ServiceError` or ``None``
        :param service_errors: Service errors returned from SDDC services.
        :type  org_type: :class:`str` or ``None``
        :param org_type: 
        :type  estimated_remaining_minutes: :class:`long` or ``None``
        :param estimated_remaining_minutes: Estimated remaining time in minute of the task execution, < 0 means
            no estimation for the task. format: int32
        :type  params: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param params: 
        :type  progress_percent: :class:`long` or ``None``
        :param progress_percent: Estimated progress percentage the task executed format: int32
        :type  phase_in_progress: :class:`str` or ``None``
        :param phase_in_progress: The current in progress phase ID in the task execution, if none in
            progress, empty string returned.
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: Type of resource being acted upon
        :type  end_time: :class:`datetime.datetime` or ``None``
        :param end_time: 
        """
        self.updated = updated
        self.user_id = user_id
        self.updated_by_user_id = updated_by_user_id
        self.created = created
        self.version = version
        self.updated_by_user_name = updated_by_user_name
        self.user_name = user_name
        self.id = id
        self.status = status
        self.localized_error_message = localized_error_message
        self.resource_id = resource_id
        self.parent_task_id = parent_task_id
        self.task_version = task_version
        self.correlation_id = correlation_id
        self.start_resource_entity_version = start_resource_entity_version
        self.customer_error_message = customer_error_message
        self.sub_status = sub_status
        self.task_type = task_type
        self.start_time = start_time
        self.task_progress_phases = task_progress_phases
        self.error_message = error_message
        self.org_id = org_id
        self.end_resource_entity_version = end_resource_entity_version
        self.service_errors = service_errors
        self.org_type = org_type
        self.estimated_remaining_minutes = estimated_remaining_minutes
        self.params = params
        self.progress_percent = progress_percent
        self.phase_in_progress = phase_in_progress
        self.resource_type = resource_type
        self.end_time = end_time
        VapiStruct.__init__(self)


Task._set_binding_type(type.StructType(
    'com.vmware.vmc.model.task', {
        'updated': type.DateTimeType(),
        'user_id': type.StringType(),
        'updated_by_user_id': type.StringType(),
        'created': type.DateTimeType(),
        'version': type.IntegerType(),
        'updated_by_user_name': type.OptionalType(type.StringType()),
        'user_name': type.StringType(),
        'id': type.StringType(),
        'status': type.OptionalType(type.StringType()),
        'localized_error_message': type.OptionalType(type.StringType()),
        'resource_id': type.OptionalType(type.StringType()),
        'parent_task_id': type.OptionalType(type.StringType()),
        'task_version': type.OptionalType(type.StringType()),
        'correlation_id': type.OptionalType(type.StringType()),
        'start_resource_entity_version': type.OptionalType(type.IntegerType()),
        'customer_error_message': type.OptionalType(type.StringType()),
        'sub_status': type.OptionalType(type.StringType()),
        'task_type': type.OptionalType(type.StringType()),
        'start_time': type.OptionalType(type.DateTimeType()),
        'task_progress_phases': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'TaskProgressPhase'))),
        'error_message': type.OptionalType(type.StringType()),
        'org_id': type.OptionalType(type.StringType()),
        'end_resource_entity_version': type.OptionalType(type.IntegerType()),
        'service_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ServiceError'))),
        'org_type': type.OptionalType(type.StringType()),
        'estimated_remaining_minutes': type.OptionalType(type.IntegerType()),
        'params': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'progress_percent': type.OptionalType(type.IntegerType()),
        'phase_in_progress': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'end_time': type.OptionalType(type.DateTimeType()),
    },
    Task,
    False,
    None))



class TaskProgressPhase(VapiStruct):
    """
    A task progress can be (but does NOT have to be) divided to more meaningful
    progress phases.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'name': 'name',
                            'progress_percent': 'progress_percent',
                            }

    def __init__(self,
                 id=None,
                 name=None,
                 progress_percent=None,
                ):
        """
        :type  id: :class:`str`
        :param id: The identifier of the task progress phase
        :type  name: :class:`str`
        :param name: The display name of the task progress phase
        :type  progress_percent: :class:`long`
        :param progress_percent: The percentage of the phase that has completed format: int32
        """
        self.id = id
        self.name = name
        self.progress_percent = progress_percent
        VapiStruct.__init__(self)


TaskProgressPhase._set_binding_type(type.StructType(
    'com.vmware.vmc.model.task_progress_phase', {
        'id': type.StringType(),
        'name': type.StringType(),
        'progress_percent': type.IntegerType(),
    },
    TaskProgressPhase,
    False,
    None))



class TenantServiceInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            's3_log_bucket_arn': 's3_log_bucket_arn',
                            }

    def __init__(self,
                 s3_log_bucket_arn=None,
                ):
        """
        :type  s3_log_bucket_arn: :class:`str` or ``None``
        :param s3_log_bucket_arn: S3 bucket arn used by log forwarder.
        """
        self.s3_log_bucket_arn = s3_log_bucket_arn
        VapiStruct.__init__(self)


TenantServiceInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.tenant_service_info', {
        's3_log_bucket_arn': type.OptionalType(type.StringType()),
    },
    TenantServiceInfo,
    False,
    None))



class TermBillingOptions(VapiStruct):
    """
    Holder for term billing options.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'unit_price': 'unit_price',
                            'billing_frequency': 'billing_frequency',
                            }

    def __init__(self,
                 unit_price=None,
                 billing_frequency=None,
                ):
        """
        :type  unit_price: :class:`str` or ``None``
        :param unit_price: 
        :type  billing_frequency: :class:`str` or ``None``
        :param billing_frequency: 
        """
        self.unit_price = unit_price
        self.billing_frequency = billing_frequency
        VapiStruct.__init__(self)


TermBillingOptions._set_binding_type(type.StructType(
    'com.vmware.vmc.model.term_billing_options', {
        'unit_price': type.OptionalType(type.StringType()),
        'billing_frequency': type.OptionalType(type.StringType()),
    },
    TermBillingOptions,
    False,
    None))



class TermOfferInstance(VapiStruct):
    """
    Holder for the term offer instances.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'description': 'description',
                            'product': 'product',
                            'product_type': 'product_type',
                            'name': 'name',
                            'currency': 'currency',
                            'region': 'region',
                            'commitment_term': 'commitment_term',
                            'unit_price': 'unit_price',
                            'billing_options': 'billing_options',
                            'version': 'version',
                            'offer_context_id': 'offer_context_id',
                            'product_charge_id': 'product_charge_id',
                            'type': 'type',
                            'product_id': 'product_id',
                            }

    def __init__(self,
                 description=None,
                 product=None,
                 product_type=None,
                 name=None,
                 currency=None,
                 region=None,
                 commitment_term=None,
                 unit_price=None,
                 billing_options=None,
                 version=None,
                 offer_context_id=None,
                 product_charge_id=None,
                 type=None,
                 product_id=None,
                ):
        """
        :type  description: :class:`str`
        :param description: 
        :type  product: :class:`str`
        :param product: 
        :type  product_type: :class:`str` or ``None``
        :param product_type: Deprecated. Please use product and type fields instead.
        :type  name: :class:`str`
        :param name: 
        :type  currency: :class:`str`
        :param currency: 
        :type  region: :class:`str`
        :param region: 
        :type  commitment_term: :class:`long`
        :param commitment_term: 
        :type  unit_price: :class:`str`
        :param unit_price: (deprecated. unit_price is moved into TermBillingOptions. For
            backward compatibility, this field reflect \"Prepaid\" price at the
            offer level.)
        :type  billing_options: :class:`list` of :class:`TermBillingOptions` or ``None``
        :param billing_options: 
        :type  version: :class:`str`
        :param version: 
        :type  offer_context_id: :class:`str` or ``None``
        :param offer_context_id: 
        :type  product_charge_id: :class:`str` or ``None``
        :param product_charge_id: 
        :type  type: :class:`str`
        :param type: 
        :type  product_id: :class:`str` or ``None``
        :param product_id: 
        """
        self.description = description
        self.product = product
        self.product_type = product_type
        self.name = name
        self.currency = currency
        self.region = region
        self.commitment_term = commitment_term
        self.unit_price = unit_price
        self.billing_options = billing_options
        self.version = version
        self.offer_context_id = offer_context_id
        self.product_charge_id = product_charge_id
        self.type = type
        self.product_id = product_id
        VapiStruct.__init__(self)


TermOfferInstance._set_binding_type(type.StructType(
    'com.vmware.vmc.model.term_offer_instance', {
        'description': type.StringType(),
        'product': type.StringType(),
        'product_type': type.OptionalType(type.StringType()),
        'name': type.StringType(),
        'currency': type.StringType(),
        'region': type.StringType(),
        'commitment_term': type.IntegerType(),
        'unit_price': type.StringType(),
        'billing_options': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'TermBillingOptions'))),
        'version': type.StringType(),
        'offer_context_id': type.OptionalType(type.StringType()),
        'product_charge_id': type.OptionalType(type.StringType()),
        'type': type.StringType(),
        'product_id': type.OptionalType(type.StringType()),
    },
    TermOfferInstance,
    False,
    None))



class TermsOfServiceResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'terms_id': 'terms_id',
                            'signed': 'signed',
                            }

    def __init__(self,
                 terms_id=None,
                 signed=None,
                ):
        """
        :type  terms_id: :class:`str` or ``None``
        :param terms_id: The terms of service ID requested.
        :type  signed: :class:`bool` or ``None``
        :param signed: Whether or not the terms requested have been signed.
        """
        self.terms_id = terms_id
        self.signed = signed
        VapiStruct.__init__(self)


TermsOfServiceResult._set_binding_type(type.StructType(
    'com.vmware.vmc.model.terms_of_service_result', {
        'terms_id': type.OptionalType(type.StringType()),
        'signed': type.OptionalType(type.BooleanType()),
    },
    TermsOfServiceResult,
    False,
    None))



class UpdateCredentials(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'username': 'username',
                            'password': 'password',
                            }

    def __init__(self,
                 username=None,
                 password=None,
                ):
        """
        :type  username: :class:`str`
        :param username: Username of the credentials
        :type  password: :class:`str`
        :param password: Password associated with the credentials
        """
        self.username = username
        self.password = password
        VapiStruct.__init__(self)


UpdateCredentials._set_binding_type(type.StructType(
    'com.vmware.vmc.model.update_credentials', {
        'username': type.StringType(),
        'password': type.StringType(),
    },
    UpdateCredentials,
    False,
    None))



class VmcLocale(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'locale': 'locale',
                            }

    def __init__(self,
                 locale=None,
                ):
        """
        :type  locale: :class:`str` or ``None``
        :param locale: The locale to be used for translating responses for the session
        """
        self.locale = locale
        VapiStruct.__init__(self)


VmcLocale._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vmc_locale', {
        'locale': type.OptionalType(type.StringType()),
    },
    VmcLocale,
    False,
    None))



class VpcInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'esx_security_group_id': 'esx_security_group_id',
                            'vpc_cidr': 'vpc_cidr',
                            'vgw_id': 'vgw_id',
                            'esx_public_security_group_id': 'esx_public_security_group_id',
                            'vif_ids': 'vif_ids',
                            'vm_security_group_id': 'vm_security_group_id',
                            'route_table_id': 'route_table_id',
                            'edge_subnet_id': 'edge_subnet_id',
                            'id': 'id',
                            'api_association_id': 'api_association_id',
                            'api_subnet_id': 'api_subnet_id',
                            'private_subnet_id': 'private_subnet_id',
                            'private_association_id': 'private_association_id',
                            'vcdr_enis': 'vcdr_enis',
                            'subnet_id': 'subnet_id',
                            'internet_gateway_id': 'internet_gateway_id',
                            'security_group_id': 'security_group_id',
                            'association_id': 'association_id',
                            'vgw_route_table_id': 'vgw_route_table_id',
                            'traffic_group_edge_vm_ips': 'traffic_group_edge_vm_ips',
                            'edge_association_id': 'edge_association_id',
                            'provider': 'provider',
                            'tgw_ips': 'tgw_ips',
                            'peering_connection_id': 'peering_connection_id',
                            'network_type': 'network_type',
                            'available_zones': 'available_zones',
                            'routetables': 'routetables',
                            }

    def __init__(self,
                 esx_security_group_id=None,
                 vpc_cidr=None,
                 vgw_id=None,
                 esx_public_security_group_id=None,
                 vif_ids=None,
                 vm_security_group_id=None,
                 route_table_id=None,
                 edge_subnet_id=None,
                 id=None,
                 api_association_id=None,
                 api_subnet_id=None,
                 private_subnet_id=None,
                 private_association_id=None,
                 vcdr_enis=None,
                 subnet_id=None,
                 internet_gateway_id=None,
                 security_group_id=None,
                 association_id=None,
                 vgw_route_table_id=None,
                 traffic_group_edge_vm_ips=None,
                 edge_association_id=None,
                 provider=None,
                 tgw_ips=None,
                 peering_connection_id=None,
                 network_type=None,
                 available_zones=None,
                 routetables=None,
                ):
        """
        :type  esx_security_group_id: :class:`str` or ``None``
        :param esx_security_group_id: 
        :type  vpc_cidr: :class:`str` or ``None``
        :param vpc_cidr: 
        :type  vgw_id: :class:`str` or ``None``
        :param vgw_id: 
        :type  esx_public_security_group_id: :class:`str` or ``None``
        :param esx_public_security_group_id: 
        :type  vif_ids: :class:`list` of :class:`str` or ``None``
        :param vif_ids: set of virtual interfaces attached to the sddc
        :type  vm_security_group_id: :class:`str` or ``None``
        :param vm_security_group_id: 
        :type  route_table_id: :class:`str` or ``None``
        :param route_table_id: (deprecated)
        :type  edge_subnet_id: :class:`str` or ``None``
        :param edge_subnet_id: Id of the NSX edge associated with this VPC (deprecated)
        :type  id: :class:`str` or ``None``
        :param id: vpc id
        :type  api_association_id: :class:`str` or ``None``
        :param api_association_id: Id of the association between subnet and route-table (deprecated)
        :type  api_subnet_id: :class:`str` or ``None``
        :param api_subnet_id: Id associated with this VPC (deprecated)
        :type  private_subnet_id: :class:`str` or ``None``
        :param private_subnet_id: (deprecated)
        :type  private_association_id: :class:`str` or ``None``
        :param private_association_id: (deprecated)
        :type  vcdr_enis: :class:`list` of :class:`EniInfo` or ``None``
        :param vcdr_enis: Set of VCDR (VMware Cloud Disaster Recovery) ENIs
        :type  subnet_id: :class:`str` or ``None``
        :param subnet_id: (deprecated)
        :type  internet_gateway_id: :class:`str` or ``None``
        :param internet_gateway_id: 
        :type  security_group_id: :class:`str` or ``None``
        :param security_group_id: 
        :type  association_id: :class:`str` or ``None``
        :param association_id: (deprecated)
        :type  vgw_route_table_id: :class:`str` or ``None``
        :param vgw_route_table_id: Route table which contains the route to VGW (deprecated)
        :type  traffic_group_edge_vm_ips: :class:`list` of :class:`str` or ``None``
        :param traffic_group_edge_vm_ips: List of edge vm Ips of traffic gourps added during scale-out
        :type  edge_association_id: :class:`str` or ``None``
        :param edge_association_id: Id of the association between edge subnet and route-table
            (deprecated)
        :type  provider: :class:`str` or ``None``
        :param provider: 
        :type  tgw_ips: (:class:`dict` of :class:`str` and :class:`list` of :class:`str`) or ``None``
        :param tgw_ips: Mapping from AZ to a list of IP addresses assigned to TGW ENI
            that's connected with Vpc
        :type  peering_connection_id: :class:`str` or ``None``
        :param peering_connection_id: (deprecated)
        :type  network_type: :class:`str` or ``None``
        :param network_type: 
        :type  available_zones: :class:`list` of :class:`AvailableZoneInfo` or ``None``
        :param available_zones: 
        :type  routetables: (:class:`dict` of :class:`str` and :class:`RouteTableInfo`) or ``None``
        :param routetables: map from routeTableName to routeTableInfo
        """
        self.esx_security_group_id = esx_security_group_id
        self.vpc_cidr = vpc_cidr
        self.vgw_id = vgw_id
        self.esx_public_security_group_id = esx_public_security_group_id
        self.vif_ids = vif_ids
        self.vm_security_group_id = vm_security_group_id
        self.route_table_id = route_table_id
        self.edge_subnet_id = edge_subnet_id
        self.id = id
        self.api_association_id = api_association_id
        self.api_subnet_id = api_subnet_id
        self.private_subnet_id = private_subnet_id
        self.private_association_id = private_association_id
        self.vcdr_enis = vcdr_enis
        self.subnet_id = subnet_id
        self.internet_gateway_id = internet_gateway_id
        self.security_group_id = security_group_id
        self.association_id = association_id
        self.vgw_route_table_id = vgw_route_table_id
        self.traffic_group_edge_vm_ips = traffic_group_edge_vm_ips
        self.edge_association_id = edge_association_id
        self.provider = provider
        self.tgw_ips = tgw_ips
        self.peering_connection_id = peering_connection_id
        self.network_type = network_type
        self.available_zones = available_zones
        self.routetables = routetables
        VapiStruct.__init__(self)


VpcInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vpc_info', {
        'esx_security_group_id': type.OptionalType(type.StringType()),
        'vpc_cidr': type.OptionalType(type.StringType()),
        'vgw_id': type.OptionalType(type.StringType()),
        'esx_public_security_group_id': type.OptionalType(type.StringType()),
        'vif_ids': type.OptionalType(type.ListType(type.StringType())),
        'vm_security_group_id': type.OptionalType(type.StringType()),
        'route_table_id': type.OptionalType(type.StringType()),
        'edge_subnet_id': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'api_association_id': type.OptionalType(type.StringType()),
        'api_subnet_id': type.OptionalType(type.StringType()),
        'private_subnet_id': type.OptionalType(type.StringType()),
        'private_association_id': type.OptionalType(type.StringType()),
        'vcdr_enis': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'EniInfo'))),
        'subnet_id': type.OptionalType(type.StringType()),
        'internet_gateway_id': type.OptionalType(type.StringType()),
        'security_group_id': type.OptionalType(type.StringType()),
        'association_id': type.OptionalType(type.StringType()),
        'vgw_route_table_id': type.OptionalType(type.StringType()),
        'traffic_group_edge_vm_ips': type.OptionalType(type.ListType(type.StringType())),
        'edge_association_id': type.OptionalType(type.StringType()),
        'provider': type.OptionalType(type.StringType()),
        'tgw_ips': type.OptionalType(type.MapType(type.StringType(), type.ListType(type.StringType()))),
        'peering_connection_id': type.OptionalType(type.StringType()),
        'network_type': type.OptionalType(type.StringType()),
        'available_zones': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AvailableZoneInfo'))),
        'routetables': type.OptionalType(type.MapType(type.StringType(), type.ReferenceType(__name__, 'RouteTableInfo'))),
    },
    VpcInfo,
    False,
    None))



class VpcInfoSubnets(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'vpc_id': 'vpc_id',
                            'cidr_block': 'cidr_block',
                            'description': 'description',
                            'subnets': 'subnets',
                            }

    def __init__(self,
                 vpc_id=None,
                 cidr_block=None,
                 description=None,
                 subnets=None,
                ):
        """
        :type  vpc_id: :class:`str` or ``None``
        :param vpc_id: The ID of the VPC these subnets belong to.
        :type  cidr_block: :class:`str` or ``None``
        :param cidr_block: The overall CIDR block of the VPC. This is the AWS primary CIDR
            block.
        :type  description: :class:`str` or ``None``
        :param description: The description of the VPC; usually it's name or id.
        :type  subnets: :class:`list` of :class:`SubnetInfo` or ``None``
        :param subnets: 
        """
        self.vpc_id = vpc_id
        self.cidr_block = cidr_block
        self.description = description
        self.subnets = subnets
        VapiStruct.__init__(self)


VpcInfoSubnets._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vpc_info_subnets', {
        'vpc_id': type.OptionalType(type.StringType()),
        'cidr_block': type.OptionalType(type.StringType()),
        'description': type.OptionalType(type.StringType()),
        'subnets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SubnetInfo'))),
    },
    VpcInfoSubnets,
    False,
    None))



class Vpn(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ENCRYPTION_AES = "AES"
    """


    """
    ENCRYPTION_AES256 = "AES256"
    """


    """
    ENCRYPTION_AES_GCM = "AES_GCM"
    """


    """
    ENCRYPTION_TRIPLE_DES = "TRIPLE_DES"
    """


    """
    ENCRYPTION_UNKNOWN = "UNKNOWN"
    """


    """
    STATE_CONNECTED = "CONNECTED"
    """


    """
    STATE_DISCONNECTED = "DISCONNECTED"
    """


    """
    STATE_PARTIALLY_CONNECTED = "PARTIALLY_CONNECTED"
    """


    """
    STATE_UNKNOWN = "UNKNOWN"
    """


    """
    DH_GROUP_DH2 = "DH2"
    """


    """
    DH_GROUP_DH5 = "DH5"
    """


    """
    DH_GROUP_DH14 = "DH14"
    """


    """
    DH_GROUP_DH15 = "DH15"
    """


    """
    DH_GROUP_DH16 = "DH16"
    """


    """
    DH_GROUP_UNKNOWN = "UNKNOWN"
    """


    """
    AUTHENTICATION_PSK = "PSK"
    """


    """
    AUTHENTICATION_UNKNOWN = "UNKNOWN"
    """


    """
    IKE_OPTION_IKEV1 = "IKEV1"
    """


    """
    IKE_OPTION_IKEV2 = "IKEV2"
    """


    """
    DIGEST_ALGORITHM_SHA1 = "SHA1"
    """


    """
    DIGEST_ALGORITHM_SHA_256 = "SHA_256"
    """


    """



    _canonical_to_pep_names = {
                            'version': 'version',
                            'on_prem_gateway_ip': 'on_prem_gateway_ip',
                            'on_prem_network_cidr': 'on_prem_network_cidr',
                            'pfs_enabled': 'pfs_enabled',
                            'id': 'id',
                            'channel_status': 'channel_status',
                            'on_prem_nat_ip': 'on_prem_nat_ip',
                            'name': 'name',
                            'internal_network_ids': 'internal_network_ids',
                            'tunnel_statuses': 'tunnel_statuses',
                            'encryption': 'encryption',
                            'enabled': 'enabled',
                            'state': 'state',
                            'dh_group': 'dh_group',
                            'authentication': 'authentication',
                            'pre_shared_key': 'pre_shared_key',
                            'ike_option': 'ike_option',
                            'digest_algorithm': 'digest_algorithm',
                            }

    def __init__(self,
                 version=None,
                 on_prem_gateway_ip=None,
                 on_prem_network_cidr=None,
                 pfs_enabled=None,
                 id=None,
                 channel_status=None,
                 on_prem_nat_ip=None,
                 name=None,
                 internal_network_ids=None,
                 tunnel_statuses=None,
                 encryption=None,
                 enabled=None,
                 state=None,
                 dh_group=None,
                 authentication=None,
                 pre_shared_key=None,
                 ike_option=None,
                 digest_algorithm=None,
                ):
        """
        :type  version: :class:`str` or ``None``
        :param version: 
        :type  on_prem_gateway_ip: :class:`str` or ``None``
        :param on_prem_gateway_ip: 
        :type  on_prem_network_cidr: :class:`str` or ``None``
        :param on_prem_network_cidr: 
        :type  pfs_enabled: :class:`bool` or ``None``
        :param pfs_enabled: 
        :type  id: :class:`str` or ``None``
        :param id: 
        :type  channel_status: :class:`VpnChannelStatus` or ``None``
        :param channel_status: 
        :type  on_prem_nat_ip: :class:`str` or ``None``
        :param on_prem_nat_ip: 
        :type  name: :class:`str` or ``None``
        :param name: 
        :type  internal_network_ids: :class:`list` of :class:`str` or ``None``
        :param internal_network_ids: 
        :type  tunnel_statuses: :class:`list` of :class:`VpnTunnelStatus` or ``None``
        :param tunnel_statuses: 
        :type  encryption: :class:`str` or ``None``
        :param encryption: Possible values are: 
            
            * :attr:`Vpn.ENCRYPTION_AES`
            * :attr:`Vpn.ENCRYPTION_AES256`
            * :attr:`Vpn.ENCRYPTION_AES_GCM`
            * :attr:`Vpn.ENCRYPTION_TRIPLE_DES`
            * :attr:`Vpn.ENCRYPTION_UNKNOWN`
        :type  enabled: :class:`bool` or ``None``
        :param enabled: 
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`Vpn.STATE_CONNECTED`
            * :attr:`Vpn.STATE_DISCONNECTED`
            * :attr:`Vpn.STATE_PARTIALLY_CONNECTED`
            * :attr:`Vpn.STATE_UNKNOWN`
        :type  dh_group: :class:`str` or ``None``
        :param dh_group: Possible values are: 
            
            * :attr:`Vpn.DH_GROUP_DH2`
            * :attr:`Vpn.DH_GROUP_DH5`
            * :attr:`Vpn.DH_GROUP_DH14`
            * :attr:`Vpn.DH_GROUP_DH15`
            * :attr:`Vpn.DH_GROUP_DH16`
            * :attr:`Vpn.DH_GROUP_UNKNOWN`
        :type  authentication: :class:`str` or ``None``
        :param authentication: Possible values are: 
            
            * :attr:`Vpn.AUTHENTICATION_PSK`
            * :attr:`Vpn.AUTHENTICATION_UNKNOWN`
        :type  pre_shared_key: :class:`str` or ``None``
        :param pre_shared_key: 
        :type  ike_option: :class:`str` or ``None``
        :param ike_option: Possible values are: 
            
            * :attr:`Vpn.IKE_OPTION_IKEV1`
            * :attr:`Vpn.IKE_OPTION_IKEV2`
        :type  digest_algorithm: :class:`str` or ``None``
        :param digest_algorithm: Possible values are: 
            
            * :attr:`Vpn.DIGEST_ALGORITHM_SHA1`
            * :attr:`Vpn.DIGEST_ALGORITHM_SHA_256`
        """
        self.version = version
        self.on_prem_gateway_ip = on_prem_gateway_ip
        self.on_prem_network_cidr = on_prem_network_cidr
        self.pfs_enabled = pfs_enabled
        self.id = id
        self.channel_status = channel_status
        self.on_prem_nat_ip = on_prem_nat_ip
        self.name = name
        self.internal_network_ids = internal_network_ids
        self.tunnel_statuses = tunnel_statuses
        self.encryption = encryption
        self.enabled = enabled
        self.state = state
        self.dh_group = dh_group
        self.authentication = authentication
        self.pre_shared_key = pre_shared_key
        self.ike_option = ike_option
        self.digest_algorithm = digest_algorithm
        VapiStruct.__init__(self)


Vpn._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vpn', {
        'version': type.OptionalType(type.StringType()),
        'on_prem_gateway_ip': type.OptionalType(type.StringType()),
        'on_prem_network_cidr': type.OptionalType(type.StringType()),
        'pfs_enabled': type.OptionalType(type.BooleanType()),
        'id': type.OptionalType(type.StringType()),
        'channel_status': type.OptionalType(type.ReferenceType(__name__, 'VpnChannelStatus')),
        'on_prem_nat_ip': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'internal_network_ids': type.OptionalType(type.ListType(type.StringType())),
        'tunnel_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'VpnTunnelStatus'))),
        'encryption': type.OptionalType(type.StringType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'state': type.OptionalType(type.StringType()),
        'dh_group': type.OptionalType(type.StringType()),
        'authentication': type.OptionalType(type.StringType()),
        'pre_shared_key': type.OptionalType(type.StringType()),
        'ike_option': type.OptionalType(type.StringType()),
        'digest_algorithm': type.OptionalType(type.StringType()),
    },
    Vpn,
    False,
    None))



class VpnChannelStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CHANNEL_STATUS_CONNECTED = "CONNECTED"
    """


    """
    CHANNEL_STATUS_DISCONNECTED = "DISCONNECTED"
    """


    """
    CHANNEL_STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'channel_status': 'channel_status',
                            'channel_state': 'channel_state',
                            'last_info_message': 'last_info_message',
                            'failure_message': 'failure_message',
                            }

    def __init__(self,
                 channel_status=None,
                 channel_state=None,
                 last_info_message=None,
                 failure_message=None,
                ):
        """
        :type  channel_status: :class:`str` or ``None``
        :param channel_status: Possible values are: 
            
            * :attr:`VpnChannelStatus.CHANNEL_STATUS_CONNECTED`
            * :attr:`VpnChannelStatus.CHANNEL_STATUS_DISCONNECTED`
            * :attr:`VpnChannelStatus.CHANNEL_STATUS_UNKNOWN`
        :type  channel_state: :class:`str` or ``None``
        :param channel_state: 
        :type  last_info_message: :class:`str` or ``None``
        :param last_info_message: 
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: 
        """
        self.channel_status = channel_status
        self.channel_state = channel_state
        self.last_info_message = last_info_message
        self.failure_message = failure_message
        VapiStruct.__init__(self)


VpnChannelStatus._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vpn_channel_status', {
        'channel_status': type.OptionalType(type.StringType()),
        'channel_state': type.OptionalType(type.StringType()),
        'last_info_message': type.OptionalType(type.StringType()),
        'failure_message': type.OptionalType(type.StringType()),
    },
    VpnChannelStatus,
    False,
    None))



class VpnTunnelStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TUNNEL_STATUS_CONNECTED = "CONNECTED"
    """


    """
    TUNNEL_STATUS_DISCONNECTED = "DISCONNECTED"
    """


    """
    TUNNEL_STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'on_prem_subnet': 'on_prem_subnet',
                            'traffic_stats': 'traffic_stats',
                            'last_info_message': 'last_info_message',
                            'local_subnet': 'local_subnet',
                            'tunnel_state': 'tunnel_state',
                            'failure_message': 'failure_message',
                            'tunnel_status': 'tunnel_status',
                            }

    def __init__(self,
                 on_prem_subnet=None,
                 traffic_stats=None,
                 last_info_message=None,
                 local_subnet=None,
                 tunnel_state=None,
                 failure_message=None,
                 tunnel_status=None,
                ):
        """
        :type  on_prem_subnet: :class:`str` or ``None``
        :param on_prem_subnet: 
        :type  traffic_stats: :class:`VpnTunnelTrafficStats` or ``None``
        :param traffic_stats: 
        :type  last_info_message: :class:`str` or ``None``
        :param last_info_message: 
        :type  local_subnet: :class:`str` or ``None``
        :param local_subnet: 
        :type  tunnel_state: :class:`str` or ``None``
        :param tunnel_state: 
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: 
        :type  tunnel_status: :class:`str` or ``None``
        :param tunnel_status: Possible values are: 
            
            * :attr:`VpnTunnelStatus.TUNNEL_STATUS_CONNECTED`
            * :attr:`VpnTunnelStatus.TUNNEL_STATUS_DISCONNECTED`
            * :attr:`VpnTunnelStatus.TUNNEL_STATUS_UNKNOWN`
        """
        self.on_prem_subnet = on_prem_subnet
        self.traffic_stats = traffic_stats
        self.last_info_message = last_info_message
        self.local_subnet = local_subnet
        self.tunnel_state = tunnel_state
        self.failure_message = failure_message
        self.tunnel_status = tunnel_status
        VapiStruct.__init__(self)


VpnTunnelStatus._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vpn_tunnel_status', {
        'on_prem_subnet': type.OptionalType(type.StringType()),
        'traffic_stats': type.OptionalType(type.ReferenceType(__name__, 'VpnTunnelTrafficStats')),
        'last_info_message': type.OptionalType(type.StringType()),
        'local_subnet': type.OptionalType(type.StringType()),
        'tunnel_state': type.OptionalType(type.StringType()),
        'failure_message': type.OptionalType(type.StringType()),
        'tunnel_status': type.OptionalType(type.StringType()),
    },
    VpnTunnelStatus,
    False,
    None))



class VpnTunnelTrafficStats(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'packets_out': 'packets_out',
                            'packet_received_errors': 'packet_received_errors',
                            'rx_bytes_on_local_subnet': 'rx_bytes_on_local_subnet',
                            'replay_errors': 'replay_errors',
                            'sequence_number_over_flow_errors': 'sequence_number_over_flow_errors',
                            'encryption_failures': 'encryption_failures',
                            'integrity_errors': 'integrity_errors',
                            'packet_sent_errors': 'packet_sent_errors',
                            'decryption_failures': 'decryption_failures',
                            'packets_in': 'packets_in',
                            'tx_bytes_from_local_subnet': 'tx_bytes_from_local_subnet',
                            }

    def __init__(self,
                 packets_out=None,
                 packet_received_errors=None,
                 rx_bytes_on_local_subnet=None,
                 replay_errors=None,
                 sequence_number_over_flow_errors=None,
                 encryption_failures=None,
                 integrity_errors=None,
                 packet_sent_errors=None,
                 decryption_failures=None,
                 packets_in=None,
                 tx_bytes_from_local_subnet=None,
                ):
        """
        :type  packets_out: :class:`str` or ``None``
        :param packets_out: 
        :type  packet_received_errors: :class:`str` or ``None``
        :param packet_received_errors: 
        :type  rx_bytes_on_local_subnet: :class:`str` or ``None``
        :param rx_bytes_on_local_subnet: 
        :type  replay_errors: :class:`str` or ``None``
        :param replay_errors: 
        :type  sequence_number_over_flow_errors: :class:`str` or ``None``
        :param sequence_number_over_flow_errors: 
        :type  encryption_failures: :class:`str` or ``None``
        :param encryption_failures: 
        :type  integrity_errors: :class:`str` or ``None``
        :param integrity_errors: 
        :type  packet_sent_errors: :class:`str` or ``None``
        :param packet_sent_errors: 
        :type  decryption_failures: :class:`str` or ``None``
        :param decryption_failures: 
        :type  packets_in: :class:`str` or ``None``
        :param packets_in: 
        :type  tx_bytes_from_local_subnet: :class:`str` or ``None``
        :param tx_bytes_from_local_subnet: 
        """
        self.packets_out = packets_out
        self.packet_received_errors = packet_received_errors
        self.rx_bytes_on_local_subnet = rx_bytes_on_local_subnet
        self.replay_errors = replay_errors
        self.sequence_number_over_flow_errors = sequence_number_over_flow_errors
        self.encryption_failures = encryption_failures
        self.integrity_errors = integrity_errors
        self.packet_sent_errors = packet_sent_errors
        self.decryption_failures = decryption_failures
        self.packets_in = packets_in
        self.tx_bytes_from_local_subnet = tx_bytes_from_local_subnet
        VapiStruct.__init__(self)


VpnTunnelTrafficStats._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vpn_tunnel_traffic_stats', {
        'packets_out': type.OptionalType(type.StringType()),
        'packet_received_errors': type.OptionalType(type.StringType()),
        'rx_bytes_on_local_subnet': type.OptionalType(type.StringType()),
        'replay_errors': type.OptionalType(type.StringType()),
        'sequence_number_over_flow_errors': type.OptionalType(type.StringType()),
        'encryption_failures': type.OptionalType(type.StringType()),
        'integrity_errors': type.OptionalType(type.StringType()),
        'packet_sent_errors': type.OptionalType(type.StringType()),
        'decryption_failures': type.OptionalType(type.StringType()),
        'packets_in': type.OptionalType(type.StringType()),
        'tx_bytes_from_local_subnet': type.OptionalType(type.StringType()),
    },
    VpnTunnelTrafficStats,
    False,
    None))



class VsanAvailableCapacity(VapiStruct):
    """
    Infomation about an available vSAN capacity in a cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cost': 'cost',
                            'quality': 'quality',
                            'size': 'size',
                            }

    def __init__(self,
                 cost=None,
                 quality=None,
                 size=None,
                ):
        """
        :type  cost: :class:`str`
        :param cost: 
        :type  quality: :class:`str`
        :param quality: 
        :type  size: :class:`long`
        :param size: 
        """
        self.cost = cost
        self.quality = quality
        self.size = size
        VapiStruct.__init__(self)


VsanAvailableCapacity._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vsan_available_capacity', {
        'cost': type.StringType(),
        'quality': type.StringType(),
        'size': type.IntegerType(),
    },
    VsanAvailableCapacity,
    False,
    None))



class VsanClusterReconfigBias(VapiStruct):
    """
    Bias for reconfiguring vSAN in a cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'short_description': 'short_description',
                            'full_description': 'full_description',
                            'id': 'id',
                            }

    def __init__(self,
                 short_description=None,
                 full_description=None,
                 id=None,
                ):
        """
        :type  short_description: :class:`str`
        :param short_description: 
        :type  full_description: :class:`str`
        :param full_description: 
        :type  id: :class:`str`
        :param id: 
        """
        self.short_description = short_description
        self.full_description = full_description
        self.id = id
        VapiStruct.__init__(self)


VsanClusterReconfigBias._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vsan_cluster_reconfig_bias', {
        'short_description': type.StringType(),
        'full_description': type.StringType(),
        'id': type.StringType(),
    },
    VsanClusterReconfigBias,
    False,
    None))



class VsanClusterReconfigConstraints(VapiStruct):
    """
    Storage constraint information for reconfiguring vSAN in existing cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'reconfig_biases': 'reconfig_biases',
                            'available_capacities': 'available_capacities',
                            'default_capacities': 'default_capacities',
                            'hosts': 'hosts',
                            'default_reconfig_bias_id': 'default_reconfig_bias_id',
                            }

    def __init__(self,
                 reconfig_biases=None,
                 available_capacities=None,
                 default_capacities=None,
                 hosts=None,
                 default_reconfig_bias_id=None,
                ):
        """
        :type  reconfig_biases: :class:`list` of :class:`VsanClusterReconfigBias`
        :param reconfig_biases: Biases to reconfigure vSAN in an existing cluster.
        :type  available_capacities: :class:`dict` of :class:`str` and :class:`list` of :class:`VsanAvailableCapacity`
        :param available_capacities: A map of VsanClusterReconfigBias id to the list of
            VsanAvailableCapacity. It gives all of available vSAN capacities
            for each of reconfiguration biases.
        :type  default_capacities: :class:`dict` of :class:`str` and :class:`VsanAvailableCapacity`
        :param default_capacities: A map of VsanClusterReconfigBias id to a VsanAvailableCapacity. It
            gives the default VsanAvailableCapacity for each of reconfiguration
            biases.
        :type  hosts: :class:`long`
        :param hosts: The number of hosts in a cluster for the constraints. format: int32
        :type  default_reconfig_bias_id: :class:`str`
        :param default_reconfig_bias_id: The id of default VsanClusterReconfigBias for this constraints.
        """
        self.reconfig_biases = reconfig_biases
        self.available_capacities = available_capacities
        self.default_capacities = default_capacities
        self.hosts = hosts
        self.default_reconfig_bias_id = default_reconfig_bias_id
        VapiStruct.__init__(self)


VsanClusterReconfigConstraints._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vsan_cluster_reconfig_constraints', {
        'reconfig_biases': type.ListType(type.ReferenceType(__name__, 'VsanClusterReconfigBias')),
        'available_capacities': type.MapType(type.StringType(), type.ListType(type.ReferenceType(__name__, 'VsanAvailableCapacity'))),
        'default_capacities': type.MapType(type.StringType(), type.ReferenceType(__name__, 'VsanAvailableCapacity')),
        'hosts': type.IntegerType(),
        'default_reconfig_bias_id': type.StringType(),
    },
    VsanClusterReconfigConstraints,
    False,
    None))



class VsanConfigConstraints(VapiStruct):
    """
    This describes the possible physical storage capacity choices for use with
    a given VsanStorageDesigner implementation. These choices are specific to a
    customer-defined number of hosts per cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'max_capacity': 'max_capacity',
                            'recommended_capacities': 'recommended_capacities',
                            'supported_capacity_increment': 'supported_capacity_increment',
                            'min_capacity': 'min_capacity',
                            'num_hosts': 'num_hosts',
                            }

    def __init__(self,
                 max_capacity=None,
                 recommended_capacities=None,
                 supported_capacity_increment=None,
                 min_capacity=None,
                 num_hosts=None,
                ):
        """
        :type  max_capacity: :class:`long`
        :param max_capacity: Maximum capacity supported for cluster (GiB). format: int64
        :type  recommended_capacities: :class:`list` of :class:`long`
        :param recommended_capacities: List of supported capacities which may offer preferable performance
            (GiB). format: int64
        :type  supported_capacity_increment: :class:`long` or ``None``
        :param supported_capacity_increment: Increment to be added to min_capacity to result in a supported
            capacity (GiB). format: int64
        :type  min_capacity: :class:`long`
        :param min_capacity: Minimum capacity supported for cluster (GiB). format: int64
        :type  num_hosts: :class:`long`
        :param num_hosts: Number of hosts in cluster. format: int64
        """
        self.max_capacity = max_capacity
        self.recommended_capacities = recommended_capacities
        self.supported_capacity_increment = supported_capacity_increment
        self.min_capacity = min_capacity
        self.num_hosts = num_hosts
        VapiStruct.__init__(self)


VsanConfigConstraints._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vsan_config_constraints', {
        'max_capacity': type.IntegerType(),
        'recommended_capacities': type.ListType(type.IntegerType()),
        'supported_capacity_increment': type.OptionalType(type.IntegerType()),
        'min_capacity': type.IntegerType(),
        'num_hosts': type.IntegerType(),
    },
    VsanConfigConstraints,
    False,
    None))



class VsanDiskgroupMapping(VapiStruct):
    """
    Polymorphic object representing host storage spec.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MAPPING_TYPE_SERIAL = "SERIAL"
    """


    """
    MAPPING_TYPE_CANONICAL = "CANONICAL"
    """


    """
    MAPPING_TYPE_SYMMETRIC = "SYMMETRIC"
    """


    """



    _canonical_to_pep_names = {
                            'mapping_type': 'mapping_type',
                            }

    def __init__(self,
                 mapping_type=None,
                ):
        """
        :type  mapping_type: :class:`str`
        :param mapping_type: Possible values are: 
            
            * :attr:`VsanDiskgroupMapping.MAPPING_TYPE_SERIAL`
            * :attr:`VsanDiskgroupMapping.MAPPING_TYPE_CANONICAL`
            * :attr:`VsanDiskgroupMapping.MAPPING_TYPE_SYMMETRIC`
        """
        self.mapping_type = mapping_type
        VapiStruct.__init__(self)


VsanDiskgroupMapping._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vsan_diskgroup_mapping', {
        'mapping_type': type.StringType(),
    },
    VsanDiskgroupMapping,
    False,
    None))



class VsanEncryptionConfig(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'port': 'port',
                            'certificate': 'certificate',
                            }

    def __init__(self,
                 port=None,
                 certificate=None,
                ):
        """
        :type  port: :class:`long` or ``None``
        :param port: Port to connect to AWS Key Management Service
        :type  certificate: :class:`str` or ``None``
        :param certificate: Public certificate used to connect to AWS Key Management Service
        """
        self.port = port
        self.certificate = certificate
        VapiStruct.__init__(self)


VsanEncryptionConfig._set_binding_type(type.StructType(
    'com.vmware.vmc.model.vsan_encryption_config', {
        'port': type.OptionalType(type.IntegerType()),
        'certificate': type.OptionalType(type.StringType()),
    },
    VsanEncryptionConfig,
    False,
    None))



class WcpDetails(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    WCP_STATUS_CERTIFICATE_REVOKE_FAILED = "CERTIFICATE_REVOKE_FAILED"
    """


    """
    WCP_STATUS_CERTIFICATE_REVOKE_IN_PROGRESS = "CERTIFICATE_REVOKE_IN_PROGRESS"
    """


    """
    WCP_STATUS_CERTIFICATE_UPDATE_FAILED = "CERTIFICATE_UPDATE_FAILED"
    """


    """
    WCP_STATUS_CERTIFICATE_UPDATE_IN_PROGRESS = "CERTIFICATE_UPDATE_IN_PROGRESS"
    """


    """
    WCP_STATUS_CERTIFICATE_UPDATE_PENDING = "CERTIFICATE_UPDATE_PENDING"
    """


    """
    WCP_STATUS_DISABLED = "DISABLED"
    """


    """
    WCP_STATUS_DISABLE_FAILED = "DISABLE_FAILED"
    """


    """
    WCP_STATUS_DISABLE_IN_PROGRESS = "DISABLE_IN_PROGRESS"
    """


    """
    WCP_STATUS_DISABLE_PENDING = "DISABLE_PENDING"
    """


    """
    WCP_STATUS_ENABLED = "ENABLED"
    """


    """
    WCP_STATUS_ENABLE_FAILED = "ENABLE_FAILED"
    """


    """
    WCP_STATUS_ENABLE_IN_PROGRESS = "ENABLE_IN_PROGRESS"
    """


    """
    WCP_STATUS_ENABLE_PENDING = "ENABLE_PENDING"
    """


    """



    _canonical_to_pep_names = {
                            'pod_cidr': 'pod_cidr',
                            'egress_cidr': 'egress_cidr',
                            'ingress_cidr': 'ingress_cidr',
                            'service_cidr': 'service_cidr',
                            'wcp_status': 'wcp_status',
                            }

    def __init__(self,
                 pod_cidr=None,
                 egress_cidr=None,
                 ingress_cidr=None,
                 service_cidr=None,
                 wcp_status=None,
                ):
        """
        :type  pod_cidr: :class:`str` or ``None``
        :param pod_cidr: POD CIDR. optional field.
        :type  egress_cidr: :class:`str` or ``None``
        :param egress_cidr: Egress CIDR
        :type  ingress_cidr: :class:`str` or ``None``
        :param ingress_cidr: Ingress CIDR
        :type  service_cidr: :class:`str` or ``None``
        :param service_cidr: Service CIDR
        :type  wcp_status: :class:`str` or ``None``
        :param wcp_status: Possible values are: 
            
            * :attr:`WcpDetails.WCP_STATUS_CERTIFICATE_REVOKE_FAILED`
            * :attr:`WcpDetails.WCP_STATUS_CERTIFICATE_REVOKE_IN_PROGRESS`
            * :attr:`WcpDetails.WCP_STATUS_CERTIFICATE_UPDATE_FAILED`
            * :attr:`WcpDetails.WCP_STATUS_CERTIFICATE_UPDATE_IN_PROGRESS`
            * :attr:`WcpDetails.WCP_STATUS_CERTIFICATE_UPDATE_PENDING`
            * :attr:`WcpDetails.WCP_STATUS_DISABLED`
            * :attr:`WcpDetails.WCP_STATUS_DISABLE_FAILED`
            * :attr:`WcpDetails.WCP_STATUS_DISABLE_IN_PROGRESS`
            * :attr:`WcpDetails.WCP_STATUS_DISABLE_PENDING`
            * :attr:`WcpDetails.WCP_STATUS_ENABLED`
            * :attr:`WcpDetails.WCP_STATUS_ENABLE_FAILED`
            * :attr:`WcpDetails.WCP_STATUS_ENABLE_IN_PROGRESS`
            * :attr:`WcpDetails.WCP_STATUS_ENABLE_PENDING`
        """
        self.pod_cidr = pod_cidr
        self.egress_cidr = egress_cidr
        self.ingress_cidr = ingress_cidr
        self.service_cidr = service_cidr
        self.wcp_status = wcp_status
        VapiStruct.__init__(self)


WcpDetails._set_binding_type(type.StructType(
    'com.vmware.vmc.model.wcp_details', {
        'pod_cidr': type.OptionalType(type.StringType()),
        'egress_cidr': type.OptionalType(type.StringType()),
        'ingress_cidr': type.OptionalType(type.StringType()),
        'service_cidr': type.OptionalType(type.StringType()),
        'wcp_status': type.OptionalType(type.StringType()),
    },
    WcpDetails,
    False,
    None))



class XEniInfo(VapiStruct):
    """
    This class represent a mapping between eniId created on customer account to
    the associationId and trunkEniId of ESX.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'association_id': 'association_id',
                            'trunk_eni_id': 'trunk_eni_id',
                            'x_eni_id': 'x_eni_id',
                            }

    def __init__(self,
                 association_id=None,
                 trunk_eni_id=None,
                 x_eni_id=None,
                ):
        """
        :type  association_id: :class:`str` or ``None``
        :param association_id: Field represent X-ENI associationId (On Shadow account).
        :type  trunk_eni_id: :class:`str` or ``None``
        :param trunk_eni_id: Field represent one of the eniId of ESX host (used as
            trunkInterfaceId) during X-ENI association.
        :type  x_eni_id: :class:`str` or ``None``
        :param x_eni_id: Field represent eniId which is created on customer account
            (X-ENI-ID).
        """
        self.association_id = association_id
        self.trunk_eni_id = trunk_eni_id
        self.x_eni_id = x_eni_id
        VapiStruct.__init__(self)


XEniInfo._set_binding_type(type.StructType(
    'com.vmware.vmc.model.X_eni_info', {
        'association_id': type.OptionalType(type.StringType()),
        'trunk_eni_id': type.OptionalType(type.StringType()),
        'x_eni_id': type.OptionalType(type.StringType()),
    },
    XEniInfo,
    False,
    None))




class StubFactory(StubFactoryBase):
    _attrs = {
    }

