/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.exceptions.BadAttributeValueException;
import com.thaiopensource.relaxng.exceptions.ImpossibleAttributeIgnoredException;
import com.thaiopensource.relaxng.exceptions.OnlyTextNotAllowedException;
import com.thaiopensource.relaxng.exceptions.OutOfContextElementException;
import com.thaiopensource.relaxng.exceptions.RequiredAttributesMissingException;
import com.thaiopensource.relaxng.exceptions.RequiredAttributesMissingOneOfException;
import com.thaiopensource.relaxng.exceptions.RequiredElementsMissingException;
import com.thaiopensource.relaxng.exceptions.RequiredElementsMissingOneOfException;
import com.thaiopensource.relaxng.exceptions.StringNotAllowedException;
import com.thaiopensource.relaxng.exceptions.TextNotAllowedException;
import com.thaiopensource.relaxng.exceptions.UnfinishedElementException;
import com.thaiopensource.relaxng.exceptions.UnfinishedElementOneOfException;
import com.thaiopensource.relaxng.exceptions.UnknownElementException;
import com.thaiopensource.relaxng.impl.ApplyAfterFunction;
import com.thaiopensource.relaxng.impl.EmptyPattern;
import com.thaiopensource.relaxng.impl.FindElementFunction;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RequiredContent;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.parse.sax.DtdContext;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext2;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PatternValidator
extends DtdContext
implements Validator,
ContentHandler,
DTDHandler,
ValidationContext2 {
    private final ValidatorPatternBuilder builder;
    private final Pattern start;
    private final ErrorHandler eh;
    private Map recoverPatternTable;
    private PatternMemo memo;
    private boolean hadError;
    private boolean collectingCharacters;
    private final StringBuffer charBuf = new StringBuffer();
    private PrefixMapping prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
    private Locator locator;
    private final Map datatypeErrors = new HashMap();
    private Name[] stack = null;
    private int stackLen = 0;
    private int suppressDepth = 0;

    private void startCollectingCharacters() {
        if (!this.collectingCharacters) {
            this.collectingCharacters = true;
            this.charBuf.setLength(0);
        }
    }

    private void flushCharacters() throws SAXException {
        this.collectingCharacters = false;
        int n = this.charBuf.length();
        block3: for (int i = 0; i < n; ++i) {
            switch (this.charBuf.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.text();
                    return;
                }
            }
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        Name name;
        if (this.collectingCharacters) {
            this.flushCharacters();
        }
        if (this.suppressDepth > 0) {
            ++this.suppressDepth;
        }
        if (!this.setMemo(this.memo.startTagOpenDeriv(name = new Name(string, string2)))) {
            PatternMemo patternMemo = this.memo.startTagOpenRecoverDeriv(name);
            if (!patternMemo.isNotAllowed()) {
                Pattern pattern = RequiredContent.getRequiredFrontierContent(this.builder, this.memo.getPattern());
                object = new NameRecordingVisitor();
                pattern.accept((PatternVisitor)object);
                if (((NameRecordingVisitor)object).hasChoice()) {
                    this.error(new RequiredElementsMissingOneOfException(this.locator, name, ((NameRecordingVisitor)object).getElements(), this.peek()));
                } else if (((NameRecordingVisitor)object).getElements().size() > 0) {
                    for (String string4 : ((NameRecordingVisitor)object).getElements()) {
                        this.error(new RequiredElementsMissingException(this.locator, name, string4, this.peek()));
                    }
                } else {
                    this.error(new RequiredElementsMissingException(this.locator, name, null, this.peek()));
                }
            } else {
                patternMemo = this.builder.getPatternMemo(this.builder.makeAfter(this.findElement(name), this.memo.getPattern()));
                if (patternMemo.isNotAllowed()) {
                    this.error(new UnknownElementException(this.locator, name, this.peek()));
                } else {
                    this.error(new OutOfContextElementException(this.locator, name, this.peek()));
                }
                if (this.suppressDepth == 0) {
                    this.suppressDepth = 1;
                }
            }
            this.memo = patternMemo;
        }
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            object = new Name(attributes.getURI(i), attributes.getLocalName(i));
            Iterator<String> iterator = attributes.getValue(i);
            this.datatypeErrors.clear();
            if (!this.setMemo(this.memo.startAttributeDeriv((Name)object))) {
                this.error(new ImpossibleAttributeIgnoredException(this.locator, name, this.peek(), (Name)object));
                continue;
            }
            if (this.setMemo(this.memo.dataDeriv((String)((Object)iterator), this))) continue;
            this.error(new BadAttributeValueException(this.locator, name, this.peek(), (Name)object, (String)((Object)iterator), this.datatypeErrors));
            this.memo = this.memo.recoverAfter();
        }
        if (!this.setMemo(this.memo.endAttributes())) {
            Pattern pattern = RequiredContent.getRequiredAttributes(this.builder, this.memo.getPattern());
            object = new NameRecordingVisitor();
            pattern.accept((PatternVisitor)object);
            if (((NameRecordingVisitor)object).hasChoice()) {
                this.error(new RequiredAttributesMissingOneOfException(this.locator, name, ((NameRecordingVisitor)object).getAttributes(), this.peek()));
            } else {
                for (String string4 : ((NameRecordingVisitor)object).getAttributes()) {
                    this.error(new RequiredAttributesMissingException(this.locator, name, string4, this.peek()));
                }
            }
            this.memo = this.memo.ignoreMissingAttributes();
        }
        if (this.memo.getPattern().getContentType() == 3) {
            this.startCollectingCharacters();
        }
        this.push(name);
    }

    private PatternMemo fixAfter(PatternMemo patternMemo) {
        return this.builder.getPatternMemo(patternMemo.getPattern().applyForPattern(new ApplyAfterFunction(this.builder){

            @Override
            Pattern apply(Pattern pattern) {
                return PatternValidator.this.builder.makeEmpty();
            }
        }));
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Name name = this.pop();
        if (this.collectingCharacters) {
            this.collectingCharacters = false;
            if (!this.setMemo(this.memo.textOnly())) {
                this.error(new OnlyTextNotAllowedException(this.locator, name, this.peek()));
                this.memo = this.memo.recoverAfter();
                return;
            }
            String string4 = this.charBuf.toString();
            if (!this.setMemo(this.memo.dataDeriv(string4, this))) {
                PatternMemo patternMemo = this.memo.recoverAfter();
                this.datatypeErrors.clear();
                if (!(this.memo.isNotAllowed() || patternMemo.isNotAllowed() && !this.fixAfter(this.memo).dataDeriv(string4, this).isNotAllowed())) {
                    this.error(new StringNotAllowedException(this.locator, name, this.peek(), string4, this.datatypeErrors));
                }
                this.memo = patternMemo;
            }
        } else if (!this.setMemo(this.memo.endTagDeriv())) {
            PatternMemo patternMemo = this.memo.recoverAfter();
            if (!(this.memo.isNotAllowed() || patternMemo.isNotAllowed() && !this.fixAfter(this.memo).endTagDeriv().isNotAllowed())) {
                Pattern pattern = RequiredContent.getRequiredContent(this.builder, this.memo.getPattern());
                NameRecordingVisitor nameRecordingVisitor = new NameRecordingVisitor();
                pattern.accept(nameRecordingVisitor);
                if (nameRecordingVisitor.hasChoice()) {
                    this.error(new UnfinishedElementOneOfException(this.locator, name, nameRecordingVisitor.getElements(), this.peek()));
                } else {
                    for (String string5 : nameRecordingVisitor.getElements()) {
                        this.error(new UnfinishedElementException(this.locator, name, string5, this.peek()));
                    }
                }
            }
            this.memo = patternMemo;
        }
        if (this.suppressDepth > 0) {
            --this.suppressDepth;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.collectingCharacters) {
            this.charBuf.append(cArray, n, n2);
            return;
        }
        block3: for (int i = 0; i < n2; ++i) {
            switch (cArray[n + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.text();
                    return;
                }
            }
        }
    }

    private void text() throws SAXException {
        if (!this.setMemo(this.memo.mixedTextDeriv())) {
            this.error(new TextNotAllowedException(this.locator, this.peek()));
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack = new Name[48];
        this.stackLen = 0;
        this.suppressDepth = 0;
        if (this.memo.isNotAllowed()) {
            this.error("schema_allows_nothing");
        }
    }

    @Override
    public void processingInstruction(String string, String string2) {
    }

    @Override
    public void skippedEntity(String string) {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        this.prefixMapping = new PrefixMapping(string, string2, this.prefixMapping);
    }

    @Override
    public void endPrefixMapping(String string) {
        this.prefixMapping = this.prefixMapping.getPrevious();
    }

    public PatternValidator(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder, ErrorHandler errorHandler) {
        this.start = pattern;
        this.builder = validatorPatternBuilder;
        this.eh = errorHandler;
        this.reset();
    }

    @Override
    public void reset() {
        this.hadError = false;
        this.collectingCharacters = false;
        this.locator = null;
        this.memo = this.builder.getPatternMemo(this.start);
        this.prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
        this.clearDtdContext();
        this.charBuf.setLength(0);
        this.datatypeErrors.clear();
        this.stack = null;
        this.recoverPatternTable = null;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this;
    }

    private void error(String string) throws SAXException {
        if (this.suppressDepth > 0 || this.hadError && this.memo.isNotAllowed()) {
            return;
        }
        this.hadError = true;
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string), this.locator));
    }

    private void error(SAXParseException sAXParseException) throws SAXException {
        if (this.suppressDepth > 0 || this.hadError && this.memo.isNotAllowed()) {
            return;
        }
        this.hadError = true;
        this.eh.error(sAXParseException);
    }

    private boolean setMemo(PatternMemo patternMemo) {
        if (patternMemo.isNotAllowed()) {
            return false;
        }
        this.memo = patternMemo;
        return true;
    }

    private Pattern findElement(Name name) {
        Pattern pattern;
        if (this.recoverPatternTable == null) {
            this.recoverPatternTable = new HashMap();
        }
        if ((pattern = (Pattern)this.recoverPatternTable.get(name)) == null) {
            pattern = FindElementFunction.findElement(this.builder, name, this.start);
            this.recoverPatternTable.put(name, pattern);
        }
        return pattern;
    }

    @Override
    public String resolveNamespacePrefix(String string) {
        PrefixMapping prefixMapping = this.prefixMapping;
        do {
            if (!prefixMapping.prefix.equals(string)) continue;
            return prefixMapping.namespaceURI;
        } while ((prefixMapping = prefixMapping.previous) != null);
        return null;
    }

    @Override
    public String getBaseUri() {
        return null;
    }

    public final void addDatatypeError(String string, DatatypeException datatypeException) {
        this.datatypeErrors.put(string, datatypeException);
    }

    private final void push(Name name) {
        if (this.stackLen == this.stack.length) {
            Name[] nameArray = new Name[this.stackLen + (this.stackLen >> 1)];
            System.arraycopy(this.stack, 0, nameArray, 0, this.stackLen);
            this.stack = nameArray;
        }
        this.stack[this.stackLen] = name;
        ++this.stackLen;
    }

    private final Name pop() {
        --this.stackLen;
        return this.stack[this.stackLen];
    }

    private final Name peek() {
        if (this.stackLen == 0) {
            return null;
        }
        return this.stack[this.stackLen - 1];
    }

    @Override
    public Locator getLocator() {
        return this.locator;
    }

    private static class NameRecordingVisitor
    implements PatternVisitor,
    NameClassVisitor {
        private String nameRecord = null;
        private Set<String> attributes = new TreeSet<String>();
        private Set<String> elements = new TreeSet<String>();
        private boolean visitedChoice;

        public Set<String> getAttributes() {
            return this.attributes;
        }

        public Set<String> getElements() {
            return this.elements;
        }

        public boolean hasChoice() {
            return this.visitedChoice;
        }

        @Override
        public void visitEmpty() {
        }

        @Override
        public void visitNotAllowed() {
        }

        @Override
        public void visitError() {
        }

        @Override
        public void visitGroup(Pattern pattern, Pattern pattern2) {
            if (pattern instanceof EmptyPattern && pattern2 instanceof EmptyPattern) {
                return;
            }
            if (pattern instanceof EmptyPattern) {
                pattern2.accept(this);
                return;
            }
            if (pattern2 instanceof EmptyPattern) {
                pattern.accept(this);
                return;
            }
            pattern.accept(this);
            pattern2.accept(this);
        }

        @Override
        public void visitInterleave(Pattern pattern, Pattern pattern2) {
            if (pattern instanceof EmptyPattern && pattern2 instanceof EmptyPattern) {
                return;
            }
            if (pattern instanceof EmptyPattern) {
                pattern2.accept(this);
                return;
            }
            if (pattern2 instanceof EmptyPattern) {
                pattern.accept(this);
                return;
            }
            pattern.accept(this);
            pattern2.accept(this);
        }

        @Override
        public void visitChoice(Pattern pattern, Pattern pattern2) {
            if (pattern instanceof EmptyPattern && pattern2 instanceof EmptyPattern) {
                return;
            }
            pattern.accept(this);
            pattern2.accept(this);
            this.visitedChoice = true;
        }

        @Override
        public void visitOneOrMore(Pattern pattern) {
            if (!(pattern instanceof EmptyPattern)) {
                pattern.accept(this);
            }
        }

        @Override
        public void visitElement(NameClass nameClass, Pattern pattern) {
            nameClass.accept(this);
            this.elements.add(this.nameRecord);
        }

        @Override
        public void visitAttribute(NameClass nameClass, Pattern pattern) {
            nameClass.accept(this);
            this.attributes.add(this.nameRecord);
        }

        @Override
        public void visitData(Datatype datatype) {
        }

        @Override
        public void visitDataExcept(Datatype datatype, Pattern pattern) {
        }

        @Override
        public void visitValue(Datatype datatype, Object object) {
        }

        @Override
        public void visitText() {
        }

        @Override
        public void visitList(Pattern pattern) {
            pattern.accept(this);
        }

        @Override
        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(this);
        }

        @Override
        public void visitNsName(String string) {
        }

        @Override
        public void visitNsNameExcept(String string, NameClass nameClass) {
            nameClass.accept(this);
        }

        @Override
        public void visitAnyName() {
        }

        @Override
        public void visitAnyNameExcept(NameClass nameClass) {
            nameClass.accept(this);
        }

        @Override
        public void visitName(Name name) {
            this.nameRecord = name.getLocalName();
        }

        @Override
        public void visitNull() {
        }
    }

    private static final class PrefixMapping {
        private final String prefix;
        private final String namespaceURI;
        private final PrefixMapping previous;

        PrefixMapping(String string, String string2, PrefixMapping prefixMapping) {
            this.prefix = string;
            this.namespaceURI = string2;
            this.previous = prefixMapping;
        }

        PrefixMapping getPrevious() {
            return this.previous;
        }
    }
}

